/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class FigureJavaComponentListener
implements AncestorListener {
    public static final int MIN_CONSTRAINT = 0;
    public static final int NORTH_CONSTRAINT = 0;
    public static final int SOUTH_CONSTRAINT = 1;
    public static final int EAST_CONSTRAINT = 2;
    public static final int WEST_CONSTRAINT = 3;
    public static final int MAX_CONSTRAINT = 3;
    private static final int ARRAY_SIZE = 4;
    private JComponent fComp = null;
    int type = -1;
    private FigureJavaComponentSizeListener fComponentSizeListener;

    public FigureJavaComponentListener(int n, FigureJavaComponentSizeListener figureJavaComponentSizeListener) {
        this.type = n;
        this.fComponentSizeListener = figureJavaComponentSizeListener;
    }

    public static Component[] createComponentArray() {
        return new Component[4];
    }

    public static Dimension[] createDimensionArray() {
        return new Dimension[4];
    }

    public static FigureJavaComponentListener[] createComponentListeners(FigureJavaComponentSizeListener figureJavaComponentSizeListener) {
        FigureJavaComponentListener[] figureJavaComponentListenerArray = new FigureJavaComponentListener[4];
        for (int i = 0; i <= 3; ++i) {
            figureJavaComponentListenerArray[i] = new FigureJavaComponentListener(i, figureJavaComponentSizeListener);
        }
        return figureJavaComponentListenerArray;
    }

    public void setTarget(Component component) {
        if (component == null) {
            this.fComp = null;
            return;
        }
        if (component instanceof JComponent) {
            this.fComp = (JComponent)component;
        } else assert (false);
    }

    public static int getComponentMargin(Component[] componentArray, Dimension[] dimensionArray, int n) {
        return FigureJavaComponentListener.getComponentMargin(componentArray, dimensionArray, n, false);
    }

    public static int getComponentMargin(Component[] componentArray, Dimension[] dimensionArray, int n, boolean bl) {
        Component component;
        int n2 = 0;
        if (componentArray != null && dimensionArray != null && n >= 0 && n <= 3 && (component = componentArray[n]) != null && (component.isVisible() || bl)) {
            n2 = FigureJavaComponentListener.getMarginFromComponent(n, component, dimensionArray[n]);
        }
        return n2;
    }

    public static int getMarginFromComponent(int n, Component component, Dimension dimension) {
        int n2 = 0;
        if (null == dimension || dimension.width == 0 || dimension.height == 0) {
            dimension = component.getPreferredSize();
        }
        switch (n) {
            case 0: 
            case 1: {
                n2 = (int)dimension.getHeight();
                break;
            }
            case 2: 
            case 3: {
                n2 = (int)dimension.getWidth();
                break;
            }
            default: {
                throw new AssertionError(n);
            }
        }
        return n2;
    }

    public static int getComponentIndexFromConstraint(String string) {
        int n = -1;
        if (string.equals("North")) {
            n = 0;
        } else if (string.equals("West")) {
            n = 3;
        } else if (string.equals("South")) {
            n = 1;
        } else if (string.equals("East")) {
            n = 2;
        } else assert (false);
        if (n == -1) {
            throw new AssertionError(n);
        }
        return n;
    }

    public static String getString(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = "North";
                break;
            }
            case 1: {
                string = "South";
                break;
            }
            case 2: {
                string = "East";
                break;
            }
            case 3: {
                string = "West";
                break;
            }
            default: {
                throw new Error("Unrecognized component type");
            }
        }
        return string;
    }

    public static int getComponentIndex(Component component, Component[] componentArray) {
        int n = -1;
        if (componentArray != null && component != null) {
            for (int i = 0; i <= 3; ++i) {
                if (component != componentArray[i]) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    private void doResize(boolean bl) {
        int n = FigureJavaComponentListener.getMarginFromComponent(this.type, this.fComp, this.fComp.getSize());
        this.fComponentSizeListener.componentChanged(bl, this.type, n);
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.doResize(true);
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        this.doResize(false);
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    public static interface FigureJavaComponentSizeListener {
        public void componentChanged(boolean var1, int var2, int var3);
    }
}

