/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.CDataGrabber;
import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.GLEventListenerWithReset;
import com.mathworks.hg.peer.JavaSceneServerPeerAdapter;
import com.mathworks.hg.peer.JavaSceneServerPeerInterface;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.swing.SwingUtilities;

public class GLEventListenerHandler {
    private JavaSceneServerPeerInterface fJSSP;
    private GLAutoDrawable fGLAutoDrawable;
    private GLEventListenerWithReset fGLEventListener;

    public GLEventListenerHandler(GLAutoDrawable gLAutoDrawable, JavaSceneServerPeerInterface javaSceneServerPeerInterface) {
        Object object;
        this.fGLAutoDrawable = gLAutoDrawable;
        if (javaSceneServerPeerInterface == null) {
            javaSceneServerPeerInterface = new JavaSceneServerPeerAdapter();
        }
        this.fJSSP = javaSceneServerPeerInterface;
        boolean bl = false;
        if (gLAutoDrawable instanceof CDataGrabber.CDataGrabberProvider) {
            object = ((CDataGrabber.CDataGrabberProvider)gLAutoDrawable).getCDataGrabber();
            bl = object.getGrabCData();
        }
        object = new GLEventListenerWithReset(bl, this.fJSSP);
        if (this.fGLAutoDrawable != null) {
            this.fGLAutoDrawable.addGLEventListener((GLEventListener)object);
        }
        this.fGLEventListener = object;
    }

    public void resetListener() {
        DebugUtilities.logMessage(32768, "resetListener", this);
        assert (SwingUtilities.isEventDispatchThread());
        try {
            this.fGLEventListener.reset();
            this.fGLAutoDrawable.display();
        }
        catch (GLException gLException) {
            this.fJSSP.reportGLException(gLException);
        }
    }

    public void readyListener() {
        this.fGLEventListener.setReady();
    }

    public void setGrabCData(boolean bl) {
        this.fGLEventListener.setWantToGrabCData(bl);
    }

    public void repaintImmediately() {
        if (this.fGLAutoDrawable != null) {
            this.fGLAutoDrawable.display();
        }
    }

    public boolean isReady() {
        return this.fGLEventListener != null && this.fGLEventListener.isReady();
    }
}

