/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.FigureClient;
import com.mathworks.hg.peer.FigureFrameProxyBase;
import com.mathworks.hg.peer.FigureFrameProxyBaseAdapter;
import com.mathworks.hg.peer.FigureMoveResizeNotification;
import com.mathworks.hg.peer.FigurePeer;
import com.mathworks.hg.peer.PositionEventType;
import com.mathworks.hg.peer.WindowRectHandler;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.util.PlatformInfo;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class HG1WindowRectHandler
implements WindowRectHandler {
    private static int sMenuBarMargin;
    private static int sToolBarMargin;
    private static Dimension sMinimumSize;
    private static Insets sDefaultInsets;
    private static Insets sRealInsets;
    private static Insets sRealInsetsNonRes;
    private static FigureAttributesChanging sInsetsChanging;
    private Insets fDefaultInsets = (Insets)sDefaultInsets.clone();
    private boolean fHonorClientRect = true;
    private boolean fUseDockedMargins = false;
    private boolean fResizable = true;
    private boolean fResizableChanged = false;
    private int fMenuBarHeight = 0;
    private int fToolBarHeight = 0;
    private Insets fOldInsets = null;
    private int fJavaCompNorth;
    private int fJavaCompSouth;
    private int fJavaCompWest;
    private int fJavaCompEast;
    private boolean fDocked = false;
    private boolean fDockPending = false;
    private boolean fFrameShowing = false;
    private FigureFrameProxyBase fFrameProxy = new FigureFrameProxyBaseAdapter();
    private JComponent fClientComponent;
    private boolean fFigureClientSet = false;
    private boolean fFrameProxySet = false;
    private FigureClient fFigureClient = null;
    private LocationSizeSetHandler fLocationSizeSetHandler = new LocationSizeSetHandler();

    @Override
    public boolean setResizable(boolean bl) {
        boolean bl2 = false;
        boolean bl3 = this.fResizable;
        if (bl != bl3) {
            this.fResizableChanged = true;
        }
        if (this.fResizableChanged && SwingUtilities.isEventDispatchThread()) {
            this.fResizableChanged = false;
            this.update(new ResizableChanging(bl));
        }
        return bl2;
    }

    @Override
    public void setFigureClient(FigureClient figureClient) {
        if (null == figureClient) {
            return;
        }
        assert (!this.fFigureClientSet);
        this.fFigureClient = figureClient;
        this.fFigureClientSet = true;
        this.fClientComponent = figureClient.getContentPane();
    }

    @Override
    public void setActivePositionMode(boolean bl) {
        this.fHonorClientRect = bl;
    }

    private boolean isUsingDockedMargins() {
        return this.fDocked;
    }

    @Override
    public void setDocked(boolean bl) {
        this.fDocked = bl;
        this.fDockPending = false;
    }

    @Override
    public void setDockedPending() {
        this.fDockPending = true;
    }

    @Override
    public void windowOpened() {
        this.updateInsets();
        this.update(sInsetsChanging);
    }

    private void update(FigureAttributesChanging figureAttributesChanging) {
        assert (figureAttributesChanging != null);
        if (this.fFigureClient.isClientDocked()) {
            return;
        }
        if (this.fHonorClientRect && !this.fFigureClient.isClientMaximized()) {
            Rectangle rectangle = this.fFigureClient.getCachedClientRectangle();
            Rectangle rectangle2 = this.getClientRectFromOuterRect(rectangle);
            figureAttributesChanging.attributeChanged();
            boolean bl = this.updateCachedInsets();
            this.setBounds(rectangle2);
            if (bl && figureAttributesChanging instanceof ResizableChanging) {
                this.fireMoveResizeEvent(PositionEventType.RESIZED);
            }
        } else {
            figureAttributesChanging.attributeChanged();
            this.updateCachedInsets();
            this.fireMoveResizeEvent(PositionEventType.MOVED);
        }
    }

    private boolean isShowing() {
        boolean bl;
        this.fFrameShowing = bl = this.fFrameProxySet && this.fFrameProxy.isShowing();
        return bl;
    }

    @Override
    public void moveContainerPointToClientPoint(Point point, Point point2) {
        this._movePoint(point, point2, true);
    }

    @Override
    public void presetBounds(Rectangle rectangle) {
        Rectangle rectangle2 = this.getOuterRectFromClientRect(rectangle);
        this.presetOuterBounds(rectangle2);
    }

    @Override
    public boolean setBounds(Rectangle rectangle) {
        Rectangle rectangle2 = this.getOuterRectFromClientRect(rectangle);
        return this.setOuterBounds(rectangle2);
    }

    private Rectangle adjustOuterBoundsForScreenLimits(Rectangle rectangle) {
        if (PlatformInfo.isWindows() && !this.fDocked) {
            if (rectangle.width > FigurePeer.sCXMaxTrack) {
                rectangle.width = FigurePeer.sCXMaxTrack;
            } else if (rectangle.width < FigurePeer.sCXMin) {
                rectangle.width = FigurePeer.sCXMin;
            }
            if (rectangle.height > FigurePeer.sCYMaxTrack) {
                rectangle.y += rectangle.height - FigurePeer.sCYMaxTrack;
                rectangle.height = FigurePeer.sCYMaxTrack;
            } else if (rectangle.height < FigurePeer.sCYMin) {
                rectangle.height = FigurePeer.sCYMin;
            }
        }
        return rectangle;
    }

    @Override
    public void presetOuterBounds(Rectangle rectangle) {
        rectangle = this.adjustOuterBoundsForScreenLimits(rectangle);
        this.fLocationSizeSetHandler.setAllPending();
        this.fFigureClient.setCachedClientRectangle(rectangle);
        this.recheckPendingLocationOrSizeOnEDT();
    }

    @Override
    public boolean setOuterBounds(Rectangle rectangle) {
        rectangle = this.adjustOuterBoundsForScreenLimits(rectangle);
        this.fLocationSizeSetHandler.setAllPending();
        this.fFigureClient.setClientRectangle(rectangle);
        this.recheckPendingLocationOrSizeOnEDT();
        return rectangle.equals(this.fFigureClient.getClientRectangle());
    }

    @Override
    public PositionEventType isWaitingForResize() {
        Rectangle rectangle;
        Rectangle rectangle2 = this.fFigureClient.getCachedClientRectangle();
        if (rectangle2.equals(rectangle = this.fFigureClient.getClientRectangle())) {
            return PositionEventType.NONE;
        }
        if (rectangle2.width == rectangle.width && rectangle2.height == rectangle.height) {
            return PositionEventType.MOVED;
        }
        return PositionEventType.RESIZED;
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds(false);
    }

    @Override
    public Rectangle getBounds(boolean bl) {
        Rectangle rectangle = this.getOuterBounds(bl);
        Rectangle rectangle2 = this.getClientRectFromOuterRect(rectangle);
        return rectangle2;
    }

    @Override
    public Rectangle getOuterBounds() {
        return this.getOuterBounds(false);
    }

    @Override
    public Rectangle getOuterBounds(boolean bl) {
        Rectangle rectangle = this.fDocked || bl ? this.fFigureClient.getClientRectangle() : this.fFigureClient.getCachedClientRectangle();
        assert (rectangle != null);
        return rectangle;
    }

    Dimension getSize() {
        Rectangle rectangle = this.getBounds();
        return rectangle.getSize();
    }

    private Rectangle getClientRectFromOuterRect(Rectangle rectangle) {
        MarginHelper marginHelper = new MarginHelper();
        Rectangle rectangle2 = new Rectangle(rectangle.x + marginHelper.xCorrection, rectangle.y + marginHelper.yCorrection, rectangle.width - marginHelper.widthCorrection, rectangle.height - marginHelper.heightCorrection);
        if (rectangle2.width < 0) {
            rectangle2.width = 1;
        }
        if (rectangle2.height < 0) {
            rectangle2.height = 1;
        }
        return rectangle2;
    }

    public Rectangle getOuterRectFromClientRect(Rectangle rectangle) {
        this.updateCachedInsets();
        MarginHelper marginHelper = new MarginHelper();
        Rectangle rectangle2 = new Rectangle(rectangle.x - marginHelper.xCorrection, rectangle.y - marginHelper.yCorrection, rectangle.width + marginHelper.widthCorrection, rectangle.height + marginHelper.heightCorrection);
        return rectangle2;
    }

    public Rectangle getMargins() {
        MarginHelper marginHelper = new MarginHelper();
        return new Rectangle(marginHelper.xCorrection, marginHelper.yCorrection, marginHelper.widthCorrection, marginHelper.heightCorrection);
    }

    public String toString() {
        return new String("Insets  " + this.getInsets() + "\n" + "Toolbar " + this.fToolBarHeight + "\n" + "Menubar " + this.fMenuBarHeight);
    }

    private Dimension getMinimumSize() {
        return sMinimumSize;
    }

    @Override
    public void setFrameProxy(FigureFrameProxyBase figureFrameProxyBase) {
        this.fFrameProxy = figureFrameProxyBase;
        assert (!this.fFrameProxySet);
        this.fFrameProxySet = true;
    }

    @Override
    public void componentChanged(boolean bl, int n, int n2) {
        int n3;
        int n4 = n3 = bl ? n2 : 0;
        if (!this.fDockPending || n3 == 0 && this.fDockPending) {
            this.update(new JavaComponentChanging(n3, n));
        }
    }

    @Override
    public void setCachedMenuBarHeight(int n) {
        if (n != this.fMenuBarHeight) {
            this.update(new MenuBarHeightChanging(n));
        }
    }

    @Override
    public void setToolbarContainerHeight(int n) {
        if (this.fToolBarHeight != n) {
            this.update(new ToolBarHeightChanging(n));
        }
    }

    private void qeSetRealInsets(Insets insets) {
        sRealInsets = insets;
    }

    private void clampOuterRectToScreen(Rectangle rectangle) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = this.getMinimumSize().width;
        int n2 = this.getMinimumSize().height;
        rectangle.width = Math.max(n, rectangle.width);
        rectangle.height = Math.max(n2, rectangle.height);
        rectangle.width = Math.min(dimension.width, rectangle.width);
        rectangle.height = Math.min(dimension.height, rectangle.height);
        rectangle.x = Math.max(0, rectangle.x);
        rectangle.y = Math.max(0, rectangle.y);
        rectangle.x = Math.min(dimension.width - rectangle.width, rectangle.x);
        rectangle.y = Math.min(dimension.height - rectangle.height, rectangle.y);
    }

    private void _movePoint(Point point, Point point2, boolean bl) {
        MarginHelper marginHelper = new MarginHelper();
        int n = marginHelper.xCorrection;
        int n2 = marginHelper.yCorrection;
        int n3 = 1;
        if (bl) {
            n3 = -1;
        }
        point2.translate(n3 * point.x, n3 * point.y);
        point2.translate(n3 * n, n3 * n2);
    }

    private Insets getCachedInsets() {
        Insets insets = null;
        if (this.fResizable) {
            if (sRealInsets == null) {
                sRealInsets = this.getFrameInsets();
            }
            if (sRealInsets == null) {
                sRealInsets = MJFrame.getCachedInsets((boolean)this.fResizable);
            }
            if (sRealInsets != null) {
                insets = (Insets)sRealInsets.clone();
            }
        } else {
            if (sRealInsetsNonRes == null) {
                sRealInsetsNonRes = this.getFrameInsets();
            }
            if (sRealInsetsNonRes == null) {
                sRealInsetsNonRes = MJFrame.getCachedInsets((boolean)this.fResizable);
            }
            if (sRealInsetsNonRes != null) {
                insets = (Insets)sRealInsetsNonRes.clone();
            }
        }
        return insets;
    }

    private Insets getFrameInsets() {
        if (this.fFrameProxy.isShowing()) {
            return this.fFrameProxy.getInsets();
        }
        return null;
    }

    @Override
    public void updateInsets() {
        Insets insets = this.getFrameInsets();
        if (insets != null) {
            if (this.fResizable) {
                sRealInsets = insets;
            } else {
                sRealInsetsNonRes = insets;
            }
        }
    }

    private Insets getInsets() {
        Insets insets;
        Insets insets2 = this.getCachedInsets();
        if (insets2 != null && PlatformInfo.isWindows() && insets2.top == 0 && insets2.bottom == 0 && insets2.left == 0 && insets2.right == 0) {
            insets2 = null;
        }
        if (insets2 == null) {
            insets = (Insets)this.fDefaultInsets.clone();
            if (PlatformInfo.isWindows() && !this.fResizable) {
                --insets.top;
                --insets.bottom;
                --insets.left;
                --insets.right;
            }
        } else {
            insets = (Insets)insets2.clone();
        }
        if (this.fOldInsets == null) {
            this.fOldInsets = (Insets)insets.clone();
        }
        return insets;
    }

    private boolean updateCachedInsets() {
        boolean bl = false;
        Insets insets = this.getInsets();
        if (!this.fOldInsets.equals(insets)) {
            this.fOldInsets = (Insets)insets.clone();
            bl = true;
        }
        return bl;
    }

    private static void setupDefaultMargins() {
        sDefaultInsets = new Insets(30, 4, 4, 4);
        sMenuBarMargin = 21;
        sToolBarMargin = 27;
        int n = 105;
        if (PlatformInfo.isWindowsXP() && PlatformInfo.useWindowsXPAppearance()) {
            n = 115;
        } else if (PlatformInfo.isWindows2000() || PlatformInfo.isWindowsXP() && !PlatformInfo.useWindowsXPAppearance()) {
            sMenuBarMargin = 21;
            sToolBarMargin = 27;
            HG1WindowRectHandler.sDefaultInsets.top = 23;
        } else if (PlatformInfo.isSolaris()) {
            sDefaultInsets = new Insets(30, 6, 6, 6);
            sMenuBarMargin = 27;
            sToolBarMargin = 29;
        } else if (PlatformInfo.isUnix()) {
            sMenuBarMargin = 27;
            sToolBarMargin = 29;
            HG1WindowRectHandler.sDefaultInsets.top = 23;
        } else if (PlatformInfo.isMacintosh()) {
            sMenuBarMargin = 22;
            sToolBarMargin = 29;
            sDefaultInsets = new Insets(22, 0, 22, 0);
        }
        sMinimumSize = new Dimension(HG1WindowRectHandler.sDefaultInsets.left + HG1WindowRectHandler.sDefaultInsets.right + n, HG1WindowRectHandler.sDefaultInsets.top + HG1WindowRectHandler.sDefaultInsets.bottom);
    }

    @Override
    public boolean isSizeLocationPending() {
        return this.fLocationSizeSetHandler.isSizeSetPending() || this.fLocationSizeSetHandler.isLocationSetPending();
    }

    @Override
    public void releaseSizeLocationPending() {
        this.fLocationSizeSetHandler.releaseAllPending();
    }

    @Override
    public void recheckPendingLocationOrSizeOnEDT() {
        if (this.fFigureClient.isShowing()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    HG1WindowRectHandler.this.recheckPendingLocationOrSize();
                }
            };
            FigurePeer.runOnEDT(runnable);
        }
    }

    private void recheckPendingLocationOrSize() {
        if (this.fLocationSizeSetHandler.isSizeSetPending() || this.fLocationSizeSetHandler.isLocationSetPending()) {
            if (this.fDocked || !this.isShowing()) {
                this.fLocationSizeSetHandler.releaseAllPending();
                return;
            }
            Rectangle rectangle = this.fFrameProxy.getBounds();
            Rectangle rectangle2 = this.getOuterBounds();
            if (rectangle.width == rectangle2.width && rectangle.height == rectangle2.height) {
                this.fLocationSizeSetHandler.setSizeSetPending(false);
            }
            if (rectangle.x == rectangle2.x && rectangle.y == rectangle2.y) {
                this.fLocationSizeSetHandler.setLocationSetPending(false);
            }
        }
    }

    private void fireMoveResizeEvent(PositionEventType positionEventType) {
        FigureMoveResizeNotification figureMoveResizeNotification = new FigureMoveResizeNotification(positionEventType == PositionEventType.MOVED);
        this.fFigureClient.handleNotification(figureMoveResizeNotification);
    }

    static {
        sDefaultInsets = new Insets(0, 0, 0, 0);
        sRealInsets = null;
        sRealInsetsNonRes = null;
        sInsetsChanging = null;
        sInsetsChanging = new FigureAttributesChanging();
        HG1WindowRectHandler.setupDefaultMargins();
    }

    private class LocationSizeSetHandler {
        private boolean fLocationSetPending = false;
        private boolean fSizeSetPending = false;

        private LocationSizeSetHandler() {
        }

        void setLocationSetPending(boolean bl) {
            this.fLocationSetPending = bl;
        }

        public boolean isLocationSetPending() {
            return this.fLocationSetPending;
        }

        public void setSizeSetPending(boolean bl) {
            this.fSizeSetPending = bl;
        }

        public boolean isSizeSetPending() {
            return this.fSizeSetPending;
        }

        void setAllPending() {
            this.setLocationSetPending(true);
            this.setSizeSetPending(true);
        }

        public void releaseAllPending() {
            this.setLocationSetPending(false);
            this.setSizeSetPending(false);
        }
    }

    private static class FigureAttributesChanging {
        private FigureAttributesChanging() {
        }

        void attributeChanged() {
        }
    }

    private class ToolBarHeightChanging
    extends FigureAttributesChanging {
        int fToolBarHeight = 0;

        ToolBarHeightChanging(int n) {
            assert (n >= 0);
            this.fToolBarHeight = n;
        }

        @Override
        public void attributeChanged() {
            HG1WindowRectHandler.this.fToolBarHeight = this.fToolBarHeight;
        }
    }

    private class MenuBarHeightChanging
    extends FigureAttributesChanging {
        int fMenuBarHeight = 0;

        MenuBarHeightChanging(int n) {
            assert (n >= 0);
            this.fMenuBarHeight = n;
        }

        @Override
        public void attributeChanged() {
            HG1WindowRectHandler.this.fMenuBarHeight = this.fMenuBarHeight;
        }
    }

    private class JavaComponentChanging
    extends FigureAttributesChanging {
        int fMargin = 0;
        int fType = 0;

        JavaComponentChanging(int n, int n2) {
            this.fMargin = n;
            this.fType = n2;
        }

        @Override
        public void attributeChanged() {
            switch (this.fType) {
                case 0: {
                    HG1WindowRectHandler.this.fJavaCompNorth = this.fMargin;
                    break;
                }
                case 1: {
                    HG1WindowRectHandler.this.fJavaCompSouth = this.fMargin;
                    break;
                }
                case 3: {
                    HG1WindowRectHandler.this.fJavaCompWest = this.fMargin;
                    break;
                }
                case 2: {
                    HG1WindowRectHandler.this.fJavaCompEast = this.fMargin;
                    break;
                }
                default: {
                    throw new AssertionError(this.fType);
                }
            }
        }
    }

    private class MarginHelper {
        public int xCorrection;
        public int yCorrection;
        public int widthCorrection;
        public int heightCorrection;
        private boolean fShowing;

        private MarginHelper() {
            this.calculateMargins();
        }

        public void calculateMargins() {
            boolean bl = HG1WindowRectHandler.this.isUsingDockedMargins();
            Insets insets = this.determineInsets(bl);
            this.xCorrection = insets.left + HG1WindowRectHandler.this.fJavaCompWest;
            this.yCorrection = insets.top + HG1WindowRectHandler.this.fJavaCompNorth + this.toolbarMenubarCorrection(bl);
            this.widthCorrection = this.xCorrection + insets.right + HG1WindowRectHandler.this.fJavaCompEast;
            this.heightCorrection = this.yCorrection + insets.bottom + HG1WindowRectHandler.this.fJavaCompSouth;
        }

        private Insets determineInsets(boolean bl) {
            Insets insets = new Insets(0, 0, 0, 0);
            insets = bl ? HG1WindowRectHandler.this.fFigureClient.getDockedClientInsets() : (HG1WindowRectHandler.this.fOldInsets == null ? HG1WindowRectHandler.this.getInsets() : HG1WindowRectHandler.this.fOldInsets);
            return insets;
        }

        private int toolbarMenubarCorrection(boolean bl) {
            int n = 0;
            if (!bl) {
                n = HG1WindowRectHandler.this.fToolBarHeight + HG1WindowRectHandler.this.fMenuBarHeight;
            }
            return n;
        }
    }

    private class ResizableChanging
    extends FigureAttributesChanging {
        boolean fResizable = true;

        ResizableChanging(boolean bl) {
            this.fResizable = bl;
        }

        @Override
        public void attributeChanged() {
            HG1WindowRectHandler.this.fResizable = this.fResizable;
        }
    }
}

