/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.jgoodies.looks.plastic.PlasticButtonUI;
import com.mathworks.hg.peer.AbstractButtonPeer;
import com.mathworks.hg.peer.MotifIconFactory;
import com.mathworks.mwswing.GraphicsUtils;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.plaf.PlafUtils;
import com.mathworks.util.PlatformInfo;
import com.sun.java.swing.plaf.motif.MotifBorders;
import com.sun.java.swing.plaf.motif.MotifButtonUI;
import com.sun.java.swing.plaf.windows.WindowsButtonUI;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class PushButtonPeer
extends AbstractButtonPeer {
    private static Border sFactoryBorder = null;

    public PushButtonPeer() {
        this.fType = 0;
    }

    @Override
    public void createComponent() {
        assert (SwingUtilities.isEventDispatchThread());
        this.fAbstractButton = new MJButton(){

            public Insets getInsets() {
                Insets insets = super.getInsets();
                return new Insets(insets.top, 1, insets.bottom, 1);
            }

            public void processEvent(AWTEvent aWTEvent) {
                if (PushButtonPeer.this.fEnable == 1) {
                    super.processEvent(aWTEvent);
                } else {
                    PushButtonPeer.this.doProcessEvent(aWTEvent);
                }
            }

            public void updateUI() {
                String string = UIManager.getLookAndFeel().getClass().getName();
                if (PlafUtils.isMotifLookAndFeel()) {
                    this.setUI(new HGMotifButtonUI());
                } else if (PlafUtils.isPlasticLookAndFeel()) {
                    this.setUI((ButtonUI)((Object)new HGPlasticButtonUI()));
                } else {
                    super.updateUI();
                }
            }

            public void setBackground(Color color) {
                if (PlafUtils.isWindowsLookAndFeel() || PlafUtils.isAquaLookAndFeel()) {
                    if (sFactoryBorder == null) {
                        sFactoryBorder = this.getBorder();
                    }
                    if (color.equals(AbstractButtonPeer.getFactoryColor())) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                this.setBorder(sFactoryBorder);
                                this.setContentAreaFilled(true);
                                if (PlatformInfo.isMacintosh()) {
                                    this.setOpaque(false);
                                }
                            }
                        });
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Border border = BasicBorders.getButtonBorder();
                                this.setContentAreaFilled(false);
                                this.setOpaque(true);
                                this.setBorder(border);
                            }
                        });
                    }
                }
                super.setBackground(color);
            }
        };
        this.fComponent = this.fAbstractButton;
        this.fAbstractButton.setHorizontalAlignment(0);
        this.fAbstractButton.setHorizontalTextPosition(0);
        this.fAbstractButton.setVerticalTextPosition(0);
        ((MJButton)this.fAbstractButton).setDefaultCapable(false);
        ((MJButton)this.fAbstractButton).setAutoMnemonicEnabled(false);
        if (PlatformInfo.isMacintosh()) {
            this.fAbstractButton.setOpaque(false);
        }
        if (PlafUtils.isPlasticLookAndFeel()) {
            this.fAbstractButton.setBorder(new CompoundBorder(new MotifBorders.ButtonBorder(MotifIconFactory.MOTIF_DEFAULTS.getColor("Button.shadow"), MotifIconFactory.MOTIF_DEFAULTS.getColor("Button.highlight"), MotifIconFactory.MOTIF_DEFAULTS.getColor("Button.darkShadow"), MotifIconFactory.MOTIF_DEFAULTS.getColor("activeCaptionBorder")), new BasicBorders.MarginBorder()));
        }
    }

    @Override
    protected double[] doGetValue() {
        double[] dArray = new double[]{1.0};
        return dArray;
    }

    public class HGWindowsButtonUI
    extends WindowsButtonUI {
        public void paint(Graphics graphics, JComponent jComponent) {
            try {
                LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel");
                super.paint(graphics, jComponent);
                UIManager.setLookAndFeel(lookAndFeel);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static class HGPlasticButtonUI
    extends PlasticButtonUI {
        protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        }

        protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            RenderingHints renderingHints = GraphicsUtils.getAntialiasingRenderingHints();
            if (renderingHints != null) {
                graphics2D.addRenderingHints(renderingHints);
            }
            AbstractButton abstractButton = (AbstractButton)jComponent;
            ButtonModel buttonModel = abstractButton.getModel();
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = abstractButton.getDisplayedMnemonicIndex();
            if (buttonModel.isEnabled()) {
                graphics2D.setColor(abstractButton.getForeground());
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics2D, string, n, rectangle.x + this.getTextShiftOffset(), rectangle.y + fontMetrics.getAscent() + this.getTextShiftOffset());
            } else {
                graphics2D.setColor(abstractButton.getBackground().brighter());
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics2D, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics2D.setColor(abstractButton.getBackground().darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics2D, string, n, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
            }
            graphics2D.dispose();
        }

        protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        }
    }

    public static class HGMotifButtonUI
    extends MotifButtonUI {
        @Override
        protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        }
    }
}

