/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.AbstractComponentPeer;
import com.mathworks.hg.util.HGPeerRunnable;
import com.mathworks.hg.util.HGUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;

public class UITabGroupPeer
extends AbstractComponentPeer {
    public static final int ALIGNMENT_TOP = 1;
    public static final int ALIGNMENT_LEFT = 2;
    public static final int ALIGNMENT_BOTTOM = 3;
    public static final int ALIGNMENT_RIGHT = 4;
    protected static final int sAddTab = 10;
    protected static final int sRemoveTab = 11;
    protected static final int sSetTabTitle = 12;
    protected static final int sSetAllTabTitles = 13;
    protected static final int sSetTabForegroundColor = 14;
    protected static final int sSetTabBackgroundColor = 15;
    protected static final int sSetSelectedIndex = 16;
    protected static final int sSetTabPlacement = 17;
    protected static final int sSetTabEditable = 18;
    private static final int sLastMethodIndex = 18;
    private static final String[] sLogMessages = new String[]{"addTab", "removeTab", "setTabTitle", "setAllTabTitles", "setTabForegroundColor", "setTabBackgroundColor", "setSelectedIndex", "setTabPlacement", "setTabPlacement"};

    public UITabGroupPeer() {
        JTabbedPane jTabbedPane = new JTabbedPane(){

            @Override
            public void paintComponent(Graphics graphics) {
                Container container = this.getParent();
                if (container != null) {
                    Dimension dimension = this.getSize();
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Color color = container.getBackground();
                    graphics2D.setColor(color);
                    graphics2D.fillRect(0, 0, dimension.width, dimension.height);
                }
                if (PlatformInfo.isMacintosh()) {
                    super.paintComponent(graphics);
                }
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (PlatformInfo.isMacintosh()) {
                    dimension.height = 30;
                }
                return dimension;
            }
        };
        jTabbedPane.setTabLayoutPolicy(1);
        this.fComponent = jTabbedPane;
    }

    @Override
    public int getUserLastMethodID() {
        return 18;
    }

    @Override
    public String getUserMethodDescription(int n) {
        String string = null;
        if (n >= 0 && n <= 9) {
            string = super.getUserMethodDescription(n);
        } else if (n > 9 && n <= 18) {
            string = sLogMessages[n - 10];
        }
        return string;
    }

    public void addTab(final String string) {
        HGPeerRunnable hGPeerRunnable = new HGPeerRunnable(this, 10, 0, false){

            @Override
            public void run() {
                UITabGroupPeer.this.doAddTab(string);
            }
        };
        if (this.doPreAddTab(string)) {
            HGUtils.invokeLater(hGPeerRunnable);
        }
    }

    protected boolean doPreAddTab(String string) {
        return true;
    }

    protected void doAddTab(String string) {
        if (this.fComponent != null && this.fComponent instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)this.fComponent;
            jTabbedPane.addTab(string, null);
            jTabbedPane.repaint();
        }
    }

    public void removeTab(final int n) {
        HGPeerRunnable hGPeerRunnable = new HGPeerRunnable(this, 11, 1, false){

            @Override
            public void run() {
                UITabGroupPeer.this.doRemoveTab(n);
            }
        };
        if (this.doPreRemoveTab(n)) {
            HGUtils.invokeLater(hGPeerRunnable);
        }
    }

    protected boolean doPreRemoveTab(int n) {
        return true;
    }

    protected void doRemoveTab(int n) {
        if (this.fComponent != null && this.fComponent instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)this.fComponent;
            jTabbedPane.removeTabAt(n);
            jTabbedPane.repaint();
        }
    }

    public void setTabTitle(final int n, final String string) {
        HGPeerRunnable hGPeerRunnable = new HGPeerRunnable(this, 12, 7, false){

            @Override
            public void run() {
                UITabGroupPeer.this.doSetTabTitle(n, string);
            }
        };
        if (this.doPreSetTabTitle(n, string)) {
            HGUtils.invokeLater(hGPeerRunnable);
        }
    }

    protected boolean doPreSetTabTitle(int n, String string) {
        return true;
    }

    protected void doSetTabTitle(int n, String string) {
        if (this.fComponent != null && this.fComponent instanceof JTabbedPane) {
            ((JTabbedPane)this.fComponent).setTitleAt(n, string);
        }
    }

    public void setAllTabTitles(final String[] stringArray) {
        HGPeerRunnable hGPeerRunnable = new HGPeerRunnable(this, 13, 7, true){

            @Override
            public void run() {
                UITabGroupPeer.this.doSetAllTabTitles(stringArray);
            }
        };
        if (this.doPreSetAllTabTitles(stringArray)) {
            HGUtils.invokeLater(hGPeerRunnable);
        }
    }

    protected boolean doPreSetAllTabTitles(String[] stringArray) {
        return true;
    }

    protected void doSetAllTabTitles(String[] stringArray) {
        if (this.fComponent != null && this.fComponent instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)this.fComponent;
            for (int i = 0; i < stringArray.length; ++i) {
                jTabbedPane.setTitleAt(i, stringArray[i]);
            }
        }
    }

    public void setTabForegroundColor(final int n, final Color color) {
        HGPeerRunnable hGPeerRunnable = new HGPeerRunnable(this, 14, 7, false){

            @Override
            public void run() {
                UITabGroupPeer.this.doSetTabForegroundColor(n, color);
            }
        };
        if (this.doPreSetTabForegroundColor(n, color)) {
            HGUtils.invokeLater(hGPeerRunnable);
        }
    }

    protected boolean doPreSetTabForegroundColor(int n, Color color) {
        return true;
    }

    protected void doSetTabForegroundColor(int n, Color color) {
        if (this.fComponent != null && this.fComponent instanceof JTabbedPane) {
            ((JTabbedPane)this.fComponent).setForegroundAt(n, color);
        }
    }

    public void setTabBackgroundColor(final int n, final Color color) {
        HGPeerRunnable hGPeerRunnable = new HGPeerRunnable(this, 15, 7, false){

            @Override
            public void run() {
                UITabGroupPeer.this.doSetTabBackgroundColor(n, color);
            }
        };
        if (this.doPreSetTabBackgroundColor(n, color)) {
            HGUtils.invokeLater(hGPeerRunnable);
        }
    }

    protected boolean doPreSetTabBackgroundColor(int n, Color color) {
        return true;
    }

    protected void doSetTabBackgroundColor(int n, Color color) {
        if (this.fComponent != null && this.fComponent instanceof JTabbedPane) {
            ((JTabbedPane)this.fComponent).setBackgroundAt(n, color);
        }
    }

    @Override
    protected void doSetBackgroundColor(Color color) {
        Container container = this.fComponent.getParent();
        container.setBackground(color);
        Component[] componentArray = this.fComponent.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JViewport)) continue;
            ((JViewport)componentArray[i]).getView().setBackground(color);
        }
    }

    public void setSelectedIndex(final int n) {
        HGPeerRunnable hGPeerRunnable = new HGPeerRunnable(this, 16, 7, true){

            @Override
            public void run() {
                UITabGroupPeer.this.doSetSelectedIndex(n);
            }
        };
        if (this.doPreSetSelectedIndex(n)) {
            HGUtils.invokeLater(hGPeerRunnable);
        }
    }

    protected boolean doPreSetSelectedIndex(int n) {
        return true;
    }

    protected void doSetSelectedIndex(int n) {
        if (this.fComponent != null && this.fComponent instanceof JTabbedPane) {
            ((JTabbedPane)this.fComponent).setSelectedIndex(n);
        }
    }

    public void setTabPlacement(final int n) {
        HGPeerRunnable hGPeerRunnable = new HGPeerRunnable(this, 17, 7, true){

            @Override
            public void run() {
                UITabGroupPeer.this.doSetTabPlacement(n);
            }
        };
        if (this.doPreSetTabPlacement(n)) {
            HGUtils.invokeLater(hGPeerRunnable);
        }
    }

    protected boolean doPreSetTabPlacement(int n) {
        return true;
    }

    protected void doSetTabPlacement(int n) {
        if (this.fComponent != null && this.fComponent instanceof JTabbedPane) {
            ((JTabbedPane)this.fComponent).setTabPlacement(n);
        }
    }

    public void setTabEditable(final int n, final boolean bl) {
        HGPeerRunnable hGPeerRunnable = new HGPeerRunnable(this, 18, 7, false){

            @Override
            public void run() {
                UITabGroupPeer.this.doSetTabEditable(n, bl);
            }
        };
        if (this.doPreSetTabEditable(n, bl)) {
            HGUtils.invokeLater(hGPeerRunnable);
        }
    }

    protected boolean doPreSetTabEditable(int n, boolean bl) {
        return true;
    }

    protected void doSetTabEditable(int n, boolean bl) {
        if (this.fComponent != null && this.fComponent instanceof JTabbedPane) {
            ((JTabbedPane)this.fComponent).setEnabledAt(n, bl);
        }
    }
}

