/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types;

import com.mathworks.beans.editors.ValueValidityEvent;
import com.mathworks.beans.editors.ValueValidityListener;
import com.mathworks.beans.editors.ValueValiditySource;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWListbox;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.table.Style;
import com.mathworks.mwt.table.ValueEvent;
import com.mathworks.mwt.table.ValueListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class EditPanelWithTable
extends MWPanel
implements ValueListener,
ValueValiditySource,
ItemListener,
ActionListener {
    private static ResourceBundle fRes = ResourceBundle.getBundle("com.mathworks.hg.types.resources.RES_Types");
    private static final String APPEND_TEXT = fRes.getString("button.append");
    private static final String INSERT_TXT = fRes.getString("button.insert");
    private static final String DUP_CMD = "AppendInsert";
    private static final String DEL_TXT = fRes.getString("button.delete");
    private static final String DEL_CMD = "Delete";
    private boolean fValid;
    private boolean[] fValidByCell;
    private int fDataLength = 0;
    private int fDataWidth = 0;
    private Style fErrorStyle = new Style(2);
    private Vector fEars = new Vector(2, 5);
    private MWListbox fTable = null;
    private MWButton fDeleteButton = null;
    private MWButton fAppendInsertBtn = null;

    public EditPanelWithTable(int n, int n2) {
        super((LayoutManager)new BorderLayout());
        this.fDataWidth = n2;
        this.fValidByCell = new boolean[n * n2 * 4];
        this.fTable = new MWListbox();
        this.fTable.getData().setWidth(n2);
        this.fValid = true;
        this.fErrorStyle.setForeground(Color.red);
        Style style = new Style(1024);
        style.setEditable(true);
        this.fTable.setColumnStyle(0, style);
        this.fTable.setPreferredTableSize(n, n2);
        this.fTable.getColumnOptions().setHeaderVisible(false);
        this.fTable.addValueListener((ValueListener)this);
        this.fTable.addItemListener((ItemListener)this);
        this.add((Component)this.fTable, "Center");
        this.fAppendInsertBtn = new MWButton(APPEND_TEXT);
        this.fAppendInsertBtn.setActionCommand(DUP_CMD);
        this.fAppendInsertBtn.addActionListener((ActionListener)this);
        this.fDeleteButton = new MWButton(DEL_TXT);
        this.fDeleteButton.setActionCommand(DEL_CMD);
        this.fDeleteButton.addActionListener((ActionListener)this);
        this.fDeleteButton.setEnabled(false);
        MWPanel mWPanel = new MWPanel((LayoutManager)new FlowLayout(0));
        mWPanel.add((Component)this.fAppendInsertBtn);
        mWPanel.add((Component)this.fDeleteButton);
        this.add((Component)mWPanel, "South");
    }

    public void addDataRow(int n, Object[] objectArray) {
        this.ensureSpace((this.fDataLength + 1) * this.fDataWidth);
        if (n < this.fDataLength) {
            System.arraycopy(this.fValidByCell, n * this.fDataWidth, this.fValidByCell, (n + 1) * this.fDataWidth, (this.fDataLength - n) * this.fDataWidth);
        }
        for (int i = 0; i < this.fDataWidth; ++i) {
            this.fValidByCell[this.fDataWidth * n + i] = true;
        }
        ++this.fDataLength;
        this.fTable.addItem(objectArray, n);
        Style style = new Style(1024);
        style.setEditable(true);
        this.fTable.setRowStyle(this.fDataLength - 1, style);
    }

    public void setCellData(int n, int n2, Object object) {
        this.fTable.setCellData(n, n2, object);
        this.fValidByCell[this.fDataWidth * n + n2] = true;
    }

    public void doAppend() {
    }

    public void doInsert(int n) {
    }

    public void doDelete(int n) {
    }

    private synchronized void ensureSpace(int n) {
        if (this.fValidByCell.length < n) {
            boolean[] blArray = new boolean[n * 3 / 2];
            System.arraycopy(this.fValidByCell, 0, blArray, 0, this.fValidByCell.length);
            this.fValidByCell = blArray;
        }
    }

    public void setCellValidity(int n, int n2, boolean bl) {
        int n3 = this.fTable.getData().getWidth();
        if (n * n3 + n2 < this.fValidByCell.length) {
            this.fValidByCell[n * n3 + n2] = bl;
            this.fTable.setCellStyle(n, n2, bl ? null : this.fErrorStyle);
        }
        this.validityChanged();
    }

    public boolean getCellValidity(int n, int n2) {
        boolean bl = false;
        int n3 = this.fTable.getData().getWidth();
        if (n * n3 + n2 < this.fValidByCell.length) {
            bl = this.fValidByCell[n * n3 + n2];
        }
        return bl;
    }

    public int getLastRowIndex() {
        return this.fDataLength - 1;
    }

    protected MWListbox getTable() {
        return this.fTable;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.fTable.getFirstSelectedRow();
        if (DUP_CMD.equals(actionEvent.getActionCommand())) {
            this.doAppend();
        } else if (DEL_CMD.equals(actionEvent.getActionCommand()) && n >= 0) {
            int n2;
            this.fTable.removeItem(n);
            if (n == this.fDataLength - 1) {
                for (n2 = 0; n2 < this.fDataWidth; ++n2) {
                    this.fValidByCell[n * this.fDataWidth + n2] = false;
                }
            } else {
                System.arraycopy(this.fValidByCell, (n + 1) * this.fDataWidth, this.fValidByCell, n * this.fDataWidth, (this.fDataLength - n - 1) * this.fDataWidth);
            }
            --this.fDataLength;
            this.fAppendInsertBtn.setLabel(APPEND_TEXT);
            this.fDeleteButton.setEnabled(false);
            this.doDelete(n);
            n2 = this.fTable.getItemCount();
            if (n2 > 0) {
                this.fTable.setSelectedIndex(Math.min(n2, n));
            }
        }
        this.validityChanged();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.fTable.getFirstSelectedRow();
        this.fAppendInsertBtn.setEnabled(n >= 0);
        this.fDeleteButton.setEnabled(n >= 0);
    }

    public boolean isValueValid() {
        return this.fValid;
    }

    public void addValueValidityListener(ValueValidityListener valueValidityListener) {
        this.fEars.addElement(valueValidityListener);
    }

    public void removeValueValidityListener(ValueValidityListener valueValidityListener) {
        this.fEars.removeElement(valueValidityListener);
    }

    private synchronized void fireValidityEvent(boolean bl) {
        Enumeration enumeration = this.fEars.elements();
        ValueValidityEvent valueValidityEvent = new ValueValidityEvent((ValueValiditySource)this, bl);
        while (enumeration.hasMoreElements()) {
            ((ValueValidityListener)enumeration.nextElement()).valueValidityChanged(valueValidityEvent);
        }
    }

    private void validityChanged() {
        boolean bl = true;
        for (int i = 0; i < this.fDataLength; ++i) {
            for (int j = 0; j < this.fDataWidth; ++j) {
                bl &= this.fValidByCell[i * this.fDataWidth + j];
                this.fTable.setCellStyle(i, j, this.fValidByCell[i * this.fDataWidth + j] ? null : this.fErrorStyle);
            }
        }
        if (bl != this.fValid) {
            this.fValid = bl;
            this.fireValidityEvent(bl);
        }
    }

    public boolean valueChanged(int n, int n2, Object object) {
        return true;
    }

    public void valueChanged(ValueEvent valueEvent) {
        boolean bl = false;
        Object var3_3 = null;
        int n = valueEvent.getRow();
        int n2 = valueEvent.getColumn();
        int n3 = n * this.fDataWidth + n2;
        Object object = this.getTable().getCellData(n, n2);
        if (this.valueChanged(n, n2, object) != this.fValidByCell[n3]) {
            this.fValidByCell[n3] = !this.fValidByCell[n3];
            this.fTable.setCellStyle(n, n2, this.fValidByCell[n3] ? null : this.fErrorStyle);
            this.validityChanged();
        }
    }
}

