/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types;

import com.mathworks.hg.types.HGColorEditor;
import com.mathworks.hg.types.HGMeshColor;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class HGMeshColorEditor
extends HGColorEditor {
    private HGMeshColor fColorValue;

    @Override
    public void updateComponentState() {
        Object object = this.getValue();
        if (object instanceof HGMeshColor) {
            this.fColorValue = (HGMeshColor)object;
        }
    }

    @Override
    protected Color getCurrentColor() {
        return HGMeshColor.getColor(this.fColorValue);
    }

    @Override
    protected String getCurrentText() {
        return this.getAsText();
    }

    @Override
    public boolean isPaintable() {
        return this.fColorValue != null && this.fColorValue.getStyle() == -1;
    }

    @Override
    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        this.fColorValue = (HGMeshColor)this.getValue();
        rectangle2.grow(-3, -2);
        if (rectangle2.width > 60) {
            rectangle2.width = 60;
        }
        if (this.fColorValue != null) {
            int n = (int)(this.fColorValue.getRed() * 255.0);
            int n2 = (int)(this.fColorValue.getGreen() * 255.0);
            int n3 = (int)(this.fColorValue.getBlue() * 255.0);
            if (n < 0) {
                n = 0;
            } else if (n > 255) {
                n = 255;
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > 255) {
                n2 = 255;
            }
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 > 255) {
                n3 = 255;
            }
            if (this.fColorValue.getStyle() == -1) {
                graphics.setColor(new Color(n, n2, n3));
                graphics.fillRect(rectangle2.x + 1, rectangle2.y + 1, rectangle2.width - 2, rectangle2.height - 2);
                graphics.setColor(Color.black);
                graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height - 1);
                graphics.setColor(Color.darkGray);
                graphics.drawLine(rectangle2.x + 1, rectangle2.y + rectangle2.height, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height);
                graphics.drawLine(rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height, rectangle2.x + rectangle2.width, rectangle2.y + 1);
            }
        }
    }

    public String getAsText() {
        String string = null;
        this.fColorValue = (HGMeshColor)this.getValue();
        if (this.fColorValue != null) {
            int n = this.fColorValue.getStyle();
            if (n == 0) {
                string = "none";
            } else if (n == 1) {
                string = "flat";
            } else if (n == 2) {
                string = "interp";
            } else if (n == 3) {
                string = "texturemap";
            } else if (n == 4) {
                string = "auto";
            }
        }
        return string;
    }

    @Override
    public void apply() {
        this.setValue(this.fColorValue);
    }

    @Override
    public void launchColorPicker() {
        Matlab matlab = new Matlab();
        double[] dArray = null;
        if (this.fColorValue != null && this.fColorValue.getStyle() == -1) {
            dArray = new double[]{this.fColorValue.getRed(), this.fColorValue.getGreen(), this.fColorValue.getBlue()};
        }
        try {
            if (dArray == null) {
                matlab.feval("uisetcolor", null, 1, (CompletionObserver)new UISetColorComplete());
            } else {
                matlab.feval("uisetcolor", new Object[]{dArray}, 1, (CompletionObserver)new UISetColorComplete());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class UISetColorComplete
    implements CompletionObserver {
        public void completed(int n, Object object) {
            double[] dArray = (double[])object;
            if (dArray != null && dArray.length > 1) {
                HGMeshColorEditor.this.fColorValue = new HGMeshColor(dArray[0], dArray[1], dArray[2], -1);
                HGMeshColorEditor.this.setValue(new HGMeshColor(dArray[0], dArray[1], dArray[2], -1));
            }
        }
    }
}

