/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types.linestyleeditor;

import com.jidesoft.converter.EnumConverter;
import com.jidesoft.grid.CellStyleTable;
import com.jidesoft.grid.EnumCellEditor;
import com.jidesoft.grid.EnumCellRenderer;
import com.mathworks.hg.types.LineStyleSpecifier;
import com.mathworks.hg.types.MarkerSpecifier;
import com.mathworks.hg.types.linestyleeditor.LineStyleTableModel;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

final class LineStyleTable
extends CellStyleTable {
    private final AncestorListener ancestorListener = new AncestorListener(){

        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            if (LineStyleTable.this.getParent() instanceof JViewport) {
                LineStyleTable.this.getParent().setBackground(UIManager.getColor("Table.background"));
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }
    };

    LineStyleTable(LineStyleTableModel lineStyleTableModel) {
        super((TableModel)lineStyleTableModel);
        if (lineStyleTableModel == null) {
            throw new IllegalArgumentException("Argument tableModel must not be null");
        }
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(1);
        this.getTableHeader().setReorderingAllowed(false);
        this.putClientProperty("terminateEditOnFocusLost", true);
        this.initCustomCellEditorsAndRenderers();
        this.addAncestorListener(this.ancestorListener);
        this.setName("linestyleeditor.table");
    }

    private void initCustomCellEditorsAndRenderers() {
        LineStyleSpecifier[] lineStyleSpecifierArray = LineStyleSpecifier.values();
        String[] stringArray = new String[lineStyleSpecifierArray.length];
        for (int i = 0; i < lineStyleSpecifierArray.length; ++i) {
            stringArray[i] = lineStyleSpecifierArray[i].getSpecifier() + " " + lineStyleSpecifierArray[i].getDescription();
        }
        EnumConverter enumConverter = new EnumConverter("LineStyleSpecifier", LineStyleSpecifier.class, (Object[])LineStyleSpecifier.values(), stringArray);
        this.setDefaultRenderer(LineStyleSpecifier.class, (TableCellRenderer)new EnumCellRenderer(enumConverter));
        this.setDefaultEditor(LineStyleSpecifier.class, (TableCellEditor)new EnumCellEditor(enumConverter));
        MarkerSpecifier[] markerSpecifierArray = MarkerSpecifier.values();
        stringArray = new String[markerSpecifierArray.length];
        for (int i = 0; i < markerSpecifierArray.length; ++i) {
            stringArray[i] = markerSpecifierArray[i].getSpecifier() + " " + markerSpecifierArray[i].getDescription();
        }
        EnumConverter enumConverter2 = new EnumConverter("MarkerSpecifier", MarkerSpecifier.class, (Object[])MarkerSpecifier.values(), stringArray);
        this.setDefaultRenderer(MarkerSpecifier.class, (TableCellRenderer)new EnumCellRenderer(enumConverter2));
        this.setDefaultEditor(MarkerSpecifier.class, (TableCellEditor)new EnumCellEditor(enumConverter2));
    }
}

