/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types.table.format;

import com.jgoodies.forms.factories.Borders;
import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.MultiplePageDialogPane;
import com.jidesoft.dialog.PageList;
import com.mathworks.hg.types.table.ColumnDefinition;
import com.mathworks.hg.types.table.format.AbstractFormatPanel;
import com.mathworks.hg.types.table.format.CurrencyPanel;
import com.mathworks.hg.types.table.format.DateTimePanel;
import com.mathworks.hg.types.table.format.FormatTypeEnum;
import com.mathworks.hg.types.table.format.LogicalPanel;
import com.mathworks.hg.types.table.format.MLFormatPanel;
import com.mathworks.hg.types.table.format.MLFormatTypeEnum;
import com.mathworks.hg.types.table.format.NumberPanel;
import com.mathworks.hg.types.table.format.PercentagePanel;
import com.mathworks.hg.types.table.format.TextPanel;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.UIManager;

public class FormatEditor
extends MultiplePageDialogPane {
    public static final ResourceBundle FORMAT_RESOURCES = ResourceBundle.getBundle("com.mathworks.hg.types.table.format.resources.RES_TableFormat");
    private ColumnDefinition columnDef;
    private boolean matlabFormatOnly;
    private boolean didSave;

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            MJUtilities.initJIDE();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ColumnDefinition columnDefinition = new ColumnDefinition("test");
        columnDefinition.setCustomFormatType(FormatTypeEnum.FORMAT);
        columnDefinition.setCustomFormatString(MLFormatTypeEnum.LONG_E.getName());
        FormatEditor.showFormatEditorDialog(null, columnDefinition, true, true);
        System.exit(0);
    }

    public static void showFormatEditorDialog(Window window, ColumnDefinition columnDefinition, boolean bl, boolean bl2) {
        MJDialog mJDialog;
        if (window == null) {
            mJDialog = new MJDialog();
            mJDialog.setModal(bl);
        } else {
            mJDialog = window instanceof Frame ? new MJDialog((Frame)window, bl) : new MJDialog((Dialog)window, bl);
        }
        FormatEditor formatEditor = new FormatEditor(columnDefinition, bl2);
        formatEditor.setBorder(Borders.DIALOG_BORDER);
        mJDialog.setContentPane((Container)((Object)formatEditor));
        mJDialog.setTitle(FORMAT_RESOURCES.getString("format_editor.title"));
        mJDialog.setName(FORMAT_RESOURCES.getString("format_editor.title"));
        mJDialog.setDefaultCloseOperation(0);
        FormatEditor.attachWindowListener((Window)mJDialog, formatEditor);
        if (!bl2) {
            mJDialog.setFocusTarget((Component)formatEditor.getPagesPanel());
        }
        mJDialog.setResizable(true);
        mJDialog.setCloseOnEscapeEnabled(true);
        if (bl2) {
            mJDialog.setSize(560, 380);
        } else {
            mJDialog.setSize(720, 540);
        }
        mJDialog.setLocationRelativeTo((Component)window);
        mJDialog.show();
        if (formatEditor.didSave()) {
            columnDefinition.setCustomFormatType(formatEditor.getFormatType());
            columnDefinition.setCustomFormatString(formatEditor.getFormatString());
        }
        mJDialog.dispose();
    }

    private static void attachWindowListener(final Window window, final FormatEditor formatEditor) {
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                formatEditor.cleanupPanels();
                window.setVisible(false);
                super.windowClosing(windowEvent);
            }
        });
    }

    public FormatEditor(ColumnDefinition columnDefinition, boolean bl) {
        super(2);
        this.columnDef = columnDefinition;
        this.matlabFormatOnly = bl;
        this.didSave = false;
        this.initializePanels();
    }

    public JComponent createIndexPanel() {
        if (this.matlabFormatOnly) {
            return null;
        }
        return super.createIndexPanel();
    }

    public boolean didSave() {
        return this.didSave;
    }

    public FormatTypeEnum getFormatType() {
        return ((AbstractFormatPanel)this.getCurrentPage()).getFormatType();
    }

    public String getFormatString() {
        return ((AbstractFormatPanel)this.getCurrentPage()).getFormat();
    }

    public ButtonPanel createButtonPanel() {
        MJButton mJButton = new MJButton(FORMAT_RESOURCES.getString("format_editor.btn_ok"));
        mJButton.setToolTipText(FORMAT_RESOURCES.getString("format_editor.tip_ok"));
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ((AbstractFormatPanel)FormatEditor.this.getCurrentPage()).isValidFormat();
                FormatEditor.this.didSave = bl;
                if (bl) {
                    FormatEditor.this.sendWindowClosingEvent((JComponent)((MJButton)actionEvent.getSource()));
                }
            }
        });
        Container container = this.getTopLevelAncestor();
        if (container instanceof JDialog) {
            ((JDialog)container).getRootPane().setDefaultButton((JButton)mJButton);
        }
        MJButton mJButton2 = new MJButton(FORMAT_RESOURCES.getString("format_editor.btn_cancel"));
        mJButton2.setToolTipText(FORMAT_RESOURCES.getString("format_editor.tip_cancel"));
        mJButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FormatEditor.this.sendWindowClosingEvent((JComponent)((MJButton)actionEvent.getSource()));
            }
        });
        ButtonPanel buttonPanel = new ButtonPanel();
        buttonPanel.addButton((AbstractButton)mJButton, (Object)"AFFIRMATIVE");
        buttonPanel.addButton((AbstractButton)mJButton2, (Object)"CANCEL");
        return buttonPanel;
    }

    private void sendWindowClosingEvent(JComponent jComponent) {
        Window window = (Window)jComponent.getTopLevelAncestor();
        window.dispatchEvent(new WindowEvent(window, 201));
    }

    private void cleanupPanels() {
        PageList pageList = this.getPageList();
        for (int i = 0; i < pageList.getPageCount(); ++i) {
            ((AbstractFormatPanel)pageList.getPage(i)).cleanup();
        }
    }

    private void initializePanels() {
        PageList pageList = new PageList();
        if (this.matlabFormatOnly) {
            pageList.append((AbstractDialogPage)this.createEditorPanel(FormatTypeEnum.FORMAT));
        } else {
            for (FormatTypeEnum formatTypeEnum : FormatTypeEnum.values()) {
                AbstractFormatPanel abstractFormatPanel = this.createEditorPanel(formatTypeEnum);
                if (abstractFormatPanel == null) continue;
                pageList.append((AbstractDialogPage)abstractFormatPanel);
            }
        }
        this.setPageList(pageList);
        this.initComponents();
    }

    private AbstractFormatPanel createEditorPanel(FormatTypeEnum formatTypeEnum) {
        String string = this.getInitialValue(formatTypeEnum);
        switch (formatTypeEnum) {
            case FORMAT: {
                return new MLFormatPanel(formatTypeEnum, string, this.matlabFormatOnly);
            }
            case NUMBER: {
                return new NumberPanel(formatTypeEnum);
            }
            case TEXT: {
                return new TextPanel(formatTypeEnum);
            }
            case CURRENCY: {
                return new CurrencyPanel(formatTypeEnum);
            }
            case PERCENTAGE: {
                return new PercentagePanel(formatTypeEnum);
            }
            case LOGICAL: {
                return new LogicalPanel(formatTypeEnum);
            }
            case DATETIME: {
                return new DateTimePanel(formatTypeEnum);
            }
        }
        return null;
    }

    private String getInitialValue(FormatTypeEnum formatTypeEnum) {
        return this.columnDef.getCustomFormatType() == formatTypeEnum ? this.columnDef.getCustomFormatString() : null;
    }
}

