/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlservices.WorkspaceVariableAdaptor;
import com.mathworks.mlwidgets.array.ArrayEditorProvider;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.brushing.BrushingToggleButton;
import com.mathworks.mlwidgets.graphics.IPlotPickerDisplayTrigger;
import com.mathworks.mlwidgets.graphics.PlotPicker;
import com.mathworks.mlwidgets.stack.StackComboBoxPanel;
import com.mathworks.mlwidgets.workspace.graphics.IGraphableInfoProvider;
import com.mathworks.widgets.spreadsheet.IClipboardOpProvider;
import com.mathworks.widgets.spreadsheet.SpreadsheetToolBar;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VariableToolBar
extends SpreadsheetToolBar {
    private PlotPicker fPlotPicker = null;
    private BrushingToggleButton fBrushColorPicker;
    private IGraphableInfoProvider fGIP = null;
    private ListSelectionListener fGraphListener = null;
    private ActionListener fGraphingActionsListener = null;
    public static final String TOOL_BAR_CONTENTS_CHANGED = "TOOL_BAR_CONTENTS_CHANGED";
    private StackComboBoxPanel fStackComboBox;

    public VariableToolBar(Object object, IClipboardOpProvider iClipboardOpProvider, String string) {
        this(object, iClipboardOpProvider, (WorkspaceVariable)new WorkspaceVariableAdaptor(string));
    }

    public VariableToolBar(Object object, IClipboardOpProvider iClipboardOpProvider, WorkspaceVariable workspaceVariable) {
        super(object, iClipboardOpProvider);
        this.fPlotPicker = object instanceof IPlotPickerDisplayTrigger ? new PlotPicker((JComponent)((Object)this), (IPlotPickerDisplayTrigger)object) : new PlotPicker((JComponent)((Object)this));
        this.fPlotPicker.setName("PlotPicker");
        this.fPlotPicker.setShowingSelectedLabel(true);
        if (workspaceVariable != null) {
            this.addSeparator();
            this.fBrushColorPicker = object instanceof ArrayEditorProvider ? new BrushingToggleButton((ArrayEditorProvider)object) : new BrushingToggleButton();
            this.fBrushColorPicker.setName("BrushPicker");
            this.add((Component)((Object)this.fBrushColorPicker));
            this.addSeparator();
            this.add((Action)((Object)new ArrayUtils.UpAction(workspaceVariable.getWorkspaceVariableNameTemp())));
        }
        this.addSeparator();
        this.fStackComboBox = new StackComboBoxPanel();
        this.add((Component)((Object)this.fStackComboBox));
        this.addSeparator();
        this.add((Component)((Object)this.fPlotPicker));
        this.reassociateActions(object, iClipboardOpProvider);
    }

    public void addActionListener(ActionListener actionListener) {
        this.fGraphingActionsListener = AWTEventMulticaster.add(this.fGraphingActionsListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.fGraphingActionsListener = AWTEventMulticaster.remove(this.fGraphingActionsListener, actionListener);
    }

    public void reassociateActions(Object object, IClipboardOpProvider iClipboardOpProvider) {
        if (this.fGraphListener == null) {
            this.fGraphListener = new GraphListener();
        }
        if (this.fGIP != null && object != this.fGIP) {
            this.fGIP.removeGraphableSelectionListener(this.fGraphListener);
        }
        super.reassociateActions(object, iClipboardOpProvider);
        if (object instanceof IGraphableInfoProvider) {
            this.fGIP = (IGraphableInfoProvider)object;
            this.fGIP.addGraphableSelectionListener(this.fGraphListener);
        }
        this.updateComponents();
    }

    public void cleanup() {
        super.cleanup();
        if (this.fGIP != null) {
            this.fGIP.removeGraphableSelectionListener(this.fGraphListener);
            this.fGIP = null;
        }
        if (this.fPlotPicker != null) {
            this.fPlotPicker.cleanup();
            this.fPlotPicker = null;
        }
        this.fGraphListener = null;
        if (this.fBrushColorPicker != null) {
            this.fBrushColorPicker.cleanup();
        }
    }

    private void updateComponents() {
        if (this.fPlotPicker != null && this.fGIP != null) {
            this.fPlotPicker.setPlottedVars(this.fGIP.getGraphableNames());
        }
        this.fireToolBarChangedEvent();
    }

    void fireToolBarChangedEvent() {
        if (this.fGraphingActionsListener != null) {
            this.fGraphingActionsListener.actionPerformed(new ActionEvent((Object)this, 1001, TOOL_BAR_CONTENTS_CHANGED));
        }
    }

    public void setArmed(boolean bl) {
        super.setArmed(bl);
        if (this.fStackComboBox != null) {
            this.fStackComboBox.setArmed(bl);
        }
    }

    private class GraphListener
    implements ListSelectionListener {
        private GraphListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            VariableToolBar.this.updateComponents();
        }
    }
}

