/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array.editors;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.editors.MatlabWorkspaceLikeModel;
import com.mathworks.mlwidgets.workspace.WhosInformation;
import com.mathworks.mlwidgets.workspace.WorkspaceCommands;
import com.mathworks.mlwidgets.workspace.WorkspaceMCRProvider;
import com.mathworks.mlwidgets.workspace.WorkspaceResources;
import com.mathworks.widgets.recordlist.ICreationObserver;
import com.mathworks.widgets.recordlist.IDeletionObserver;
import com.mathworks.widgets.recordlist.IDuplicationObserver;
import com.mathworks.widgets.recordlist.IEditingObserver;
import com.mathworks.widgets.recordlist.IRecordCreator;
import com.mathworks.widgets.recordlist.IRecordDeleter;
import com.mathworks.widgets.recordlist.IRecordDuplicator;
import java.text.MessageFormat;

public class MatlabStructureModel
extends MatlabWorkspaceLikeModel
implements IRecordDeleter,
IRecordDuplicator,
IRecordCreator {
    private static String sRenameErrorMain = WorkspaceResources.getBundle().getString("dialog.badname.pre.message");
    private static String sRenameErrorAddendum = WorkspaceResources.getBundle().getString("dialog.badname.message.addendum");
    private String fInsertBeforeField = null;

    public MatlabStructureModel(WorkspaceVariable workspaceVariable) {
        super(workspaceVariable);
    }

    private void updateDataDefaultWorkspace() {
        Object[] objectArray = new String[]{"arrayviewfunc('structToWhosInformation', " + this.fVariable + ");"};
        WorkspaceMCRProvider.getMCRForWorkspaceRefresh().feval("eval", objectArray, 1, (CompletionObserver)new WhosInformationCO());
    }

    private void updateDataNonDefaultWorkspace() {
        Object[] objectArray = new Object[]{"updateDataForStruct", this.fVariable};
        WorkspaceMCRProvider.getMCRForWorkspaceRefresh().feval("arrayviewfunc", objectArray, 1, (CompletionObserver)new WhosInformationCO());
    }

    @Override
    public void updateData() {
        if (Matlab.isMatlabAvailable()) {
            if (this.fVariable.isDefaultWorkspace()) {
                this.updateDataDefaultWorkspace();
            } else {
                this.updateDataNonDefaultWorkspace();
            }
        }
    }

    @Override
    public String getFieldName(int n) {
        if (n == this.NAME()) {
            return ArrayUtils.getResource("fieldname.field");
        }
        return super.getFieldName(n);
    }

    public boolean areRecordsDeletable(int[] nArray) {
        return nArray.length > 0;
    }

    public void deleteRecords(int[] nArray, IDeletionObserver iDeletionObserver) {
        String[] stringArray = this.getPropertyNamesFromIDs(nArray);
        int n = iDeletionObserver.deletionStarted(nArray);
        if (n == 0) {
            for (int i = 0; i < nArray.length; ++i) {
                WorkspaceCommands.rmField(this.fVariable, stringArray[i]);
            }
        }
        iDeletionObserver.deletionCompleted(n, WorkspaceResources.getBundle().getString("error.delete"));
    }

    public boolean areRecordsCreatable() {
        return true;
    }

    public void createRecord(ICreationObserver iCreationObserver) {
        int n = iCreationObserver.creationStarted();
        WorkspaceCommands.createUniqueField(this.fVariable, this.fInsertBeforeField);
        iCreationObserver.creationCompleted(n, WorkspaceResources.getBundle().getString("error.create"));
        this.fInsertBeforeField = null;
    }

    public void setFieldToInsertAbove(String string) {
        this.fInsertBeforeField = string;
    }

    public boolean areRecordsDuplicatable(int[] nArray) {
        return nArray.length > 0;
    }

    public void duplicateRecords(int[] nArray, IDuplicationObserver iDuplicationObserver) {
        String[] stringArray = this.getPropertyNamesFromIDs(nArray);
        int n = iDuplicationObserver.duplicationStarted(nArray);
        if (n == 0) {
            for (int i = 0; i < nArray.length; ++i) {
                WorkspaceCommands.duplicateField(this.fVariable, stringArray[i], null);
            }
        }
        iDuplicationObserver.duplicationCompleted(n, WorkspaceResources.getBundle().getString("error.duplicate"));
    }

    public boolean areRecordsEditable(int[] nArray, int n) {
        return nArray.length > 0 && (n == this.VALUE() || n == this.NAME());
    }

    public void setRecordValues(int[] nArray, int n, Object[] objectArray, IEditingObserver iEditingObserver) {
        Object object;
        String string;
        iEditingObserver.editingStarted(nArray);
        String[] stringArray = this.getFullNamesFromIDs(nArray);
        if (n == this.NAME()) {
            string = (String)objectArray[0];
            object = new Object[]{string};
            String string2 = MessageFormat.format(sRenameErrorMain, object) + sRenameErrorAddendum;
            RenameObserver renameObserver = new RenameObserver(iEditingObserver, string2);
            WorkspaceCommands.renameField(this.fVariable, this.getPropertyNamesFromIDs(new int[]{nArray[0]})[0], string, (CompletionObserver)renameObserver);
        }
        if (n == this.VALUE()) {
            string = stringArray[0];
            object = (String)objectArray[0];
            if (object != null && object.trim().length() != 0) {
                this.fBufferedValueLists[this.calculatedFieldToHashIndex(n)].putValueForSet(string, object);
            }
            WorkspaceCommands.assignVariable(new WorkspaceVariable(string, this.fVariable.getWorkspaceID()), (String)object, (CompletionObserver)new MatlabWorkspaceLikeModel.ValueObserver(this, iEditingObserver, string));
        }
    }

    public String[] getEditingDescriptions() {
        return new String[]{WorkspaceResources.getBundle().getString("operation.rename"), WorkspaceResources.getBundle().getString("operation.edit")};
    }

    public int[] getEditableFields() {
        int[] nArray = new int[]{this.NAME(), this.VALUE()};
        return nArray;
    }

    private String[] getPropertyNamesFromIDs(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = (String)this.getValueAt(nArray[i], this.NAME());
        }
        return stringArray;
    }

    private static class RenameObserver
    implements CompletionObserver {
        private String fMessage;
        private IEditingObserver fObserver;

        RenameObserver(IEditingObserver iEditingObserver, String string) {
            this.fObserver = iEditingObserver;
            this.fMessage = string;
        }

        public void completed(int n, Object object) {
            int n2 = 0;
            if (Matlab.getExecutionStatus((int)n) != 0) {
                n2 = 2;
            }
            this.fObserver.editingCompleted(n2, this.fMessage);
        }
    }

    private class WhosInformationCO
    implements CompletionObserver {
        private WhosInformationCO() {
        }

        public void completed(int n, Object object) {
            MatlabStructureModel.this.setWhosInformation((WhosInformation)object);
        }
    }
}

