/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.hints.FileIntelliHints;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.dialog.MJFolderChooser;
import com.mathworks.widgets.ButtonFactory;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;

public class FileOrFolderCellRendererAndEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private Type fType;
    private FileIntelliHints fFileTextField = new FileIntelliHints((JTextComponent)new MJTextField());
    private Component fEllipsisButton;
    private MJPanel fPanel = new MJPanel();

    public FileOrFolderCellRendererAndEditor(Type type) {
        this.fType = type;
        this.init();
    }

    private void init() {
        this.fPanel.setOpaque(false);
        this.fFileTextField.getTextComponent().setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fEllipsisButton = ButtonFactory.createTextFieldEmbeddedEllipsisButton((ActionListener)this.createEllipsisListener());
        FormLayout formLayout = new FormLayout("d:grow, 1dlu, d, 1px", "d:grow");
        CellConstraints cellConstraints = new CellConstraints();
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)this.fPanel);
        panelBuilder.add((Component)this.fFileTextField.getTextComponent(), cellConstraints.xy(1, 1, "fill, fill"));
        panelBuilder.add(this.fEllipsisButton, cellConstraints.xy(3, 1, "fill, fill"));
    }

    private ActionListener createEllipsisListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(FileOrFolderCellRendererAndEditor.this.fFileTextField.getTextComponent().getText());
                if (FileOrFolderCellRendererAndEditor.this.fType.equals((Object)Type.FILE)) {
                    FileOrFolderCellRendererAndEditor.this.createAndShowFileChooser(file);
                } else if (FileOrFolderCellRendererAndEditor.this.fType.equals((Object)Type.FOLDER)) {
                    FileOrFolderCellRendererAndEditor.this.createAndShowFolderChooser(file);
                }
            }
        };
    }

    private void doFileChanged(String string) {
        this.fFileTextField.getTextComponent().setText(string);
    }

    private void createAndShowFileChooser(File file) {
        MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform();
        mJFileChooserPerPlatform.setSelectedFile(file);
        mJFileChooserPerPlatform.setFileMustExist(true);
        mJFileChooserPerPlatform.showOpenDialog(SwingUtilities.getRoot(this.fEllipsisButton), this.getChangeListener());
    }

    private void createAndShowFolderChooser(File file) {
        MJFolderChooser mJFolderChooser = new MJFolderChooser(SwingUtilities.getRoot(this.fEllipsisButton), null);
        mJFolderChooser.addActionListener(this.getActionListener());
        mJFolderChooser.setInitialDirectory(file);
        mJFolderChooser.browse();
    }

    public void setFolderOnly(boolean bl) {
        this.fFileTextField.setFolderOnly(true);
    }

    public JTextComponent getTextField() {
        return this.fFileTextField.getTextComponent();
    }

    private ActionListener getActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                FileOrFolderCellRendererAndEditor.this.doFileChanged(string);
            }
        };
    }

    private ChangeListener getChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MJFileChooserPerPlatform mJFileChooserPerPlatform = (MJFileChooserPerPlatform)changeEvent.getSource();
                if (mJFileChooserPerPlatform.getState() == 0) {
                    final File file = mJFileChooserPerPlatform.getSelectedFile();
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            FileOrFolderCellRendererAndEditor.this.doFileChanged(file.getPath());
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }
        };
    }

    @Override
    public Object getCellEditorValue() {
        return this.fFileTextField.getTextComponent().getText().equals("") ? null : new File(this.fFileTextField.getTextComponent().getText());
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (object != null && object instanceof File) {
            File file = (File)object;
            this.fFileTextField.getTextComponent().setText(file.getPath());
        }
        return this.fPanel;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        return this.getTableCellEditorComponent(jTable, object, bl, n, n2);
    }

    public static enum Type {
        FILE,
        FOLDER;

    }
}

