/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.table;

import com.mathworks.matlab.api.explorer.CoreFileDecoration;
import com.mathworks.matlab.api.explorer.ExtensionRegistry;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.table.FileSystemExpansionProvider;
import com.mathworks.mlwidgets.explorer.model.table.SizeGroupingMode;
import com.mathworks.mlwidgets.explorer.model.vfs.VirtualFileSystem;
import com.mathworks.mlwidgets.explorer.util.UiFileSystemUtils;
import com.mathworks.util.Converter;
import com.mathworks.widgets.grouptable.GroupingMode;
import com.mathworks.widgets.grouptable.GroupingTableColumn;
import java.text.MessageFormat;
import java.util.Comparator;

public final class SizeColumn {
    private final GroupingTableColumn<FileSystemEntry> fColumn;
    private final FileSystemExpansionProvider fProvider;
    private final ExtensionRegistry fExtensions;
    public static final String KEY = "size";

    public SizeColumn(FileSystemExpansionProvider fileSystemExpansionProvider) {
        this(fileSystemExpansionProvider, null);
    }

    public SizeColumn(ExtensionRegistry extensionRegistry) {
        this(null, extensionRegistry);
    }

    private SizeColumn(FileSystemExpansionProvider fileSystemExpansionProvider, ExtensionRegistry extensionRegistry) {
        this.fProvider = fileSystemExpansionProvider;
        this.fExtensions = extensionRegistry;
        this.fColumn = new GroupingTableColumn(KEY, ExplorerResources.getString("table.size"), true, String.class, null, (Converter)new ValueConverter(), null, (Comparator)new Comparator<FileSystemEntry>(){

            @Override
            public int compare(FileSystemEntry fileSystemEntry, FileSystemEntry fileSystemEntry2) {
                return Long.valueOf(VirtualFileSystem.getUnderlyingEntryIfMountPoint(fileSystemEntry).getSize()).compareTo(VirtualFileSystem.getUnderlyingEntryIfMountPoint(fileSystemEntry2).getSize());
            }
        }, new GroupingMode[]{new SizeGroupingMode()});
    }

    public GroupingTableColumn<FileSystemEntry> getColumn() {
        return this.fColumn;
    }

    private class ValueConverter
    implements Converter<FileSystemEntry, String> {
        private ValueConverter() {
        }

        public String convert(FileSystemEntry fileSystemEntry) {
            if ((fileSystemEntry = VirtualFileSystem.getUnderlyingEntryIfMountPoint(fileSystemEntry)).isFolder()) {
                return "";
            }
            long l = SizeColumn.this.fProvider != null ? (Long)SizeColumn.this.fProvider.getDecoration(fileSystemEntry, CoreFileDecoration.DISPLAY_SIZE) : (SizeColumn.this.fExtensions != null ? ((Long)UiFileSystemUtils.getDecorationSynchronously(fileSystemEntry, CoreFileDecoration.DISPLAY_SIZE, SizeColumn.this.fExtensions)).longValue() : fileSystemEntry.getSize());
            if (l == 0L) {
                return MessageFormat.format(ExplorerResources.getString("table.size.nKB"), 0);
            }
            if (l < 1024L) {
                return MessageFormat.format(ExplorerResources.getString("table.size.nKB"), 1);
            }
            if (l < 0x100000L) {
                return MessageFormat.format(ExplorerResources.getString("table.size.nKB"), l / 1024L);
            }
            if (l < 0x40000000L) {
                return MessageFormat.format(ExplorerResources.getString("table.size.nMB"), l / 0x100000L);
            }
            return MessageFormat.format(ExplorerResources.getString("table.size.nGB"), l / 0x40000000L);
        }
    }
}

