/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.graphics;

import com.jidesoft.grid.Row;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlwidgets.actionbrowser.AbstractActionTable;
import com.mathworks.mlwidgets.actionbrowser.ActionBrowserUtils;
import com.mathworks.mlwidgets.actionbrowser.FunctionReferenceUtils;
import com.mathworks.mlwidgets.actionbrowser.HelpPopupLauncher;
import com.mathworks.mlwidgets.graphics.AnimationTarget;
import com.mathworks.mlwidgets.graphics.Animator;
import com.mathworks.mlwidgets.graphics.DragWindow;
import com.mathworks.mlwidgets.graphics.IPlotPickerTableListener;
import com.mathworks.mlwidgets.graphics.ModelStateFactory;
import com.mathworks.mlwidgets.graphics.PlotAction;
import com.mathworks.mlwidgets.graphics.PlotPicker;
import com.mathworks.mlwidgets.graphics.PlotPickerCategoryRenderer;
import com.mathworks.mlwidgets.graphics.PlotPickerCellRenderer;
import com.mathworks.mlwidgets.graphics.PlotPickerTableModel;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.util.FileUtils;
import com.mathworks.util.Log;
import com.mathworks.widgets.action.AbstractCopyAction;
import com.mathworks.widgets.action.AbstractPasteAction;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

class PlotPickerTreeTable
extends AbstractActionTable
implements DragGestureListener,
DragSourceMotionListener,
DragSourceListener,
ClipboardOwner {
    private PlotPickerCellRenderer fPlotPickerCellRenderer;
    private PlotPickerCategoryRenderer fPlotPickerCategoryRenderer;
    private DragWindow fDragWindow;
    private static DataFlavor PLOT_ITEM_FLAVOR;
    private Vector<IPlotPickerTableListener> fPlotPickerTableListenerVector = new Vector();
    private int fDragRow = -1;
    private WindowFocusListener fWindowFocusListener;
    private BufferedImage fAnimationImage;
    private Point fAnimationPosition;
    private boolean fMousePressedState = false;
    private boolean fIsClipboardOwner = false;
    private MJAbstractAction fPasteAction;
    private MJAbstractAction fCopyAction;
    private PlotPickerMouseListener fPlotPickerMouseListener;
    static Color TABLE_BACKGROUND_COLOR;
    private static int DRAG_IMAGE_OFFSET;

    public PlotPickerTreeTable(PlotPickerTableModel plotPickerTableModel) {
        super(plotPickerTableModel);
        this.setBackground(new Color(240, 240, 240));
        this.fPlotPickerCellRenderer = new PlotPickerCellRenderer();
        this.fPlotPickerCategoryRenderer = new PlotPickerCategoryRenderer();
        this.setRowAutoResizes(true);
        this.setVariousRowHeights(true);
        this.getColumnModel().getColumn(0).setCellRenderer(new PlotPickerCellRenderer());
        this.calculateRowHeights();
        this.repaint();
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && PlotPickerTreeTable.this.isShowing()) {
                    PlotPickerTreeTable.this.calculateRowHeights();
                }
            }
        });
        DragSource dragSource = new DragSource();
        dragSource.createDefaultDragGestureRecognizer((Component)((Object)this), 1, this);
        dragSource.addDragSourceMotionListener(this);
        this.setDragEnabled(false);
        this.fPlotPickerMouseListener = new PlotPickerMouseListener();
        this.addMouseListener(this.fPlotPickerMouseListener);
        this.addMouseMotionListener(this.fPlotPickerMouseListener);
        this.setOpaque(false);
        this.fCopyAction = new CopyAction();
        this.getInputMap().put(KeyStroke.getKeyStroke(67, 2), "copy");
        this.getActionMap().put("copy", (Action)this.fCopyAction);
        this.fPasteAction = new PasteAction();
        this.getInputMap().put(KeyStroke.getKeyStroke(86, 2), "paste");
        this.getActionMap().put("paste", (Action)this.fPasteAction);
    }

    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        this.removeMouseListener(this.fPlotPickerMouseListener);
        this.removeMouseMotionListener(this.fPlotPickerMouseListener);
        this.addMouseListener(this.fPlotPickerMouseListener);
        this.addMouseMotionListener(this.fPlotPickerMouseListener);
    }

    @Override
    public boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        MJScrollPane mJScrollPane;
        if (keyStroke.getKeyCode() == 40 && n == 0 && this.hasFocus() && bl) {
            if (this.isMouseWheelFocusInTooltip()) {
                return super.processKeyBinding(keyStroke, keyEvent, n, bl);
            }
            for (int i = this.getSelectedRow() + 1; i < this.getRowCount(); ++i) {
                if (this.getRowAt(i) instanceof PlotPickerTableModel.Category) continue;
                this.fPlotPickerCellRenderer.clearButtonEffects((JTable)((Object)this));
                this.changeSelection(i, 0, false, false);
                return true;
            }
            MJScrollPane mJScrollPane2 = (MJScrollPane)SwingUtilities.getAncestorOfClass(MJScrollPane.class, (Component)((Object)this));
            if (mJScrollPane2 != null && mJScrollPane2.getVerticalScrollBar() != null) {
                mJScrollPane2.getVerticalScrollBar().setValue(mJScrollPane2.getVerticalScrollBar().getMaximum());
            }
            return true;
        }
        if (keyStroke.getKeyCode() == 38 && n == 0 && this.hasFocus() && bl) {
            if (this.isMouseWheelFocusInTooltip()) {
                return super.processKeyBinding(keyStroke, keyEvent, n, bl);
            }
            for (int i = this.getSelectedRow() - 1; i >= 0; --i) {
                if (this.getRowAt(i) instanceof PlotPickerTableModel.Category) continue;
                this.fPlotPickerCellRenderer.clearButtonEffects((JTable)((Object)this));
                this.changeSelection(i, 0, false, false);
                return true;
            }
            MJScrollPane mJScrollPane3 = (MJScrollPane)SwingUtilities.getAncestorOfClass(MJScrollPane.class, (Component)((Object)this));
            if (mJScrollPane3 != null && mJScrollPane3.getVerticalScrollBar() != null) {
                mJScrollPane3.getVerticalScrollBar().setValue(mJScrollPane3.getVerticalScrollBar().getMinimum());
            }
            return true;
        }
        if (keyStroke.getKeyCode() == 34 && n == 0 && this.hasFocus() && bl && !(this.getParent().getParent() instanceof JScrollPane)) {
            MJScrollPane mJScrollPane4 = (MJScrollPane)SwingUtilities.getAncestorOfClass(MJScrollPane.class, (Component)((Object)this));
            if (mJScrollPane4 != null && mJScrollPane4.getVerticalScrollBar() != null) {
                mJScrollPane4.getVerticalScrollBar().setValue(mJScrollPane4.getVerticalScrollBar().getValue() + this.getScrollableBlockIncrement(this.getVisibleRect(), 1, 1));
                Rectangle rectangle = this.getVisibleRect();
                int n2 = this.rowAtPoint(new Point(rectangle.x, rectangle.y + rectangle.height));
                this.fPlotPickerCellRenderer.clearButtonEffects((JTable)((Object)this));
                if (n2 >= 0) {
                    this.changeSelection(n2, 0, false, false);
                } else {
                    this.changeSelection(this.getRowCount() - 1, 0, false, false);
                }
            }
        } else if (keyStroke.getKeyCode() == 33 && n == 0 && this.hasFocus() && bl && !(this.getParent().getParent() instanceof JScrollPane) && (mJScrollPane = (MJScrollPane)SwingUtilities.getAncestorOfClass(MJScrollPane.class, (Component)((Object)this))) != null && mJScrollPane.getVerticalScrollBar() != null) {
            mJScrollPane.getVerticalScrollBar().setValue(mJScrollPane.getVerticalScrollBar().getValue() - this.getScrollableBlockIncrement(this.getVisibleRect(), 1, -1));
            Rectangle rectangle = this.getVisibleRect();
            int n3 = this.rowAtPoint(new Point(rectangle.x, rectangle.y));
            this.fPlotPickerCellRenderer.clearButtonEffects((JTable)((Object)this));
            if (n3 >= 0) {
                this.changeSelection(n3, 0, false, false);
            } else {
                this.changeSelection(1, 0, false, false);
            }
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        this.fIsClipboardOwner = false;
    }

    void addPlotPickerTableListener(IPlotPickerTableListener iPlotPickerTableListener) {
        this.fPlotPickerTableListenerVector.add(iPlotPickerTableListener);
    }

    void removePlotPickerTableListener(IPlotPickerTableListener iPlotPickerTableListener) {
        this.fPlotPickerTableListenerVector.remove(iPlotPickerTableListener);
    }

    @Override
    public void showHelpOnSelection(URL uRL, Rectangle rectangle) {
        if (SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof HelpPopupLauncher) {
            ActionBrowserUtils.showHelpOnSelection(uRL, rectangle, (AbstractActionTable)this, (HelpPopupLauncher)((Object)SwingUtilities.getWindowAncestor((Component)((Object)this))));
        } else {
            ActionBrowserUtils.showHelpOnSelection(uRL, rectangle, (AbstractActionTable)this, null);
        }
    }

    @Override
    public void showHelpOnSelection(String string, Rectangle rectangle) {
        if (SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof HelpPopupLauncher) {
            ActionBrowserUtils.showHelpOnSelection(string, rectangle, (AbstractActionTable)this, (HelpPopupLauncher)((Object)SwingUtilities.getWindowAncestor((Component)((Object)this))));
        } else {
            ActionBrowserUtils.showHelpOnSelection(string, rectangle, (AbstractActionTable)this, null);
        }
    }

    @Override
    public boolean isDoubleClickExecutionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() != 2) {
            return false;
        }
        PlotPickerTableModel.ActionRow actionRow = this.getActionRowAt(this.rowAtPoint(mouseEvent.getPoint()));
        return actionRow != null && !this.fPlotPickerCellRenderer.isOverActiveButton();
    }

    PlotPickerTableModel getPlotPickerTableModel() {
        TableModel tableModel = this.getTreeTableModel();
        if (tableModel != null && this.getTreeTableModel() instanceof PlotPickerTableModel) {
            return (PlotPickerTableModel)((Object)tableModel);
        }
        return null;
    }

    @Override
    protected void showActionToolTip(Point point, String string, String string2, String string3, String string4) {
        Point point2 = (Point)point.clone();
        SwingUtilities.convertPointFromScreen(point2, (Component)((Object)this));
        PlotPickerTableModel.ActionRow actionRow = this.getActionRowAt(this.rowAtPoint(point2));
        if (actionRow == null || this.fPlotPickerCellRenderer.isOverActiveButton()) {
            return;
        }
        Window window = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (!window.isActive()) {
            return;
        }
        if (this.getToolTipText() != null && this.getToolTipText().length() > 0) {
            return;
        }
        if (!actionRow.isEnabled()) {
            super.showActionToolTip(point, string, string2, string3, string4, actionRow.getPlotAction().getRuleDescription());
        } else {
            super.showActionToolTip(point, string, string2, string3, string4);
        }
        if (this.fWindowFocusListener == null) {
            this.fWindowFocusListener = new WindowAdapter(){

                @Override
                public void windowDeactivated(WindowEvent windowEvent) {
                    PlotPickerTreeTable.this.hideActionToolTip();
                }

                @Override
                public void windowLostFocus(WindowEvent windowEvent) {
                    PlotPickerTreeTable.this.hideActionToolTip();
                }
            };
            window.addWindowFocusListener(this.fWindowFocusListener);
        }
    }

    @Override
    protected void updatePopup(Row row) {
        if (!(row instanceof PlotPickerTableModel.ActionRow)) {
            return;
        }
        PlotPickerTableModel.ActionRow actionRow = (PlotPickerTableModel.ActionRow)row;
        if (this.fPopup == null) {
            this.fPopup = new MJPopupMenu();
        }
        this.fPopup.removeAll();
        MJMenuItem mJMenuItem = new MJMenuItem((Action)((Object)new ExecuteAction()));
        mJMenuItem.setEnabled(actionRow.isEnabled());
        mJMenuItem.setFont(this.getFont().deriveFont(1));
        this.fPopup.add((JMenuItem)mJMenuItem);
        this.fPopup.add((Action)((Object)new InsertAction()));
        this.fPopup.addSeparator();
        this.fPopup.add((Action)this.fCopyAction);
        MJMenuItem mJMenuItem2 = new MJMenuItem((Action)this.fPasteAction);
        mJMenuItem2.setEnabled(this.isPasteMenuEnabled(actionRow));
        this.fPopup.add((JMenuItem)mJMenuItem2);
        this.fPopup.addSeparator();
        if (!actionRow.isFavorite()) {
            this.fPopup.add((Action)((Object)new FavoriteAction()));
        } else {
            this.fPopup.add((Action)((Object)new DeleteAction()));
        }
        this.fPopup.addSeparator();
        this.fPopup.add((Action)((Object)new RestoreAction()));
    }

    private boolean isPasteMenuEnabled(PlotPickerTableModel.ActionRow actionRow) {
        if (this.fIsClipboardOwner) {
            int n = this.getClipboardRowIndex();
            if (n < 0) {
                return false;
            }
            PlotPickerTableModel.ActionRow actionRow2 = this.getActionRowAt(n);
            return actionRow2 != null && !actionRow2.isFavorite() && this.getPlotPickerTableModel().getMatchingTopLevelFavoriteRow(actionRow) == actionRow;
        }
        return false;
    }

    @Override
    public boolean isCategoryRow(int n) {
        return n >= 0 && this.getRowAt(n) instanceof PlotPickerTableModel.Category;
    }

    @Override
    public boolean isItemRow(int n) {
        return n >= 0 && this.getRowAt(n) instanceof PlotPickerTableModel.ActionRow;
    }

    PlotPickerTableModel.ActionRow getActionRowAt(int n) {
        if (n < 0) {
            return null;
        }
        Row row = this.getRowAt(n);
        if (row instanceof PlotPickerTableModel.ActionRow) {
            return (PlotPickerTableModel.ActionRow)row;
        }
        return null;
    }

    void insertCommand(int n) {
        PlotPickerTableModel.ActionRow actionRow = this.getActionRowAt(n);
        if (actionRow == null || this.getSelectedRow() != n) {
            return;
        }
        actionRow.insertCommand(this.getVarNames());
    }

    @Override
    public void execute(int n, boolean bl) {
        PlotPickerTableModel.ActionRow actionRow = this.getActionRowAt(n);
        if (actionRow == null || this.getSelectedRow() != n) {
            return;
        }
        this.execute(actionRow);
        if (bl) {
            this.getTopLevelAncestor().setVisible(false);
        }
    }

    void execute(PlotPickerTableModel.ActionRow actionRow) {
        if (!actionRow.isEnabled()) {
            return;
        }
        actionRow.execute(this.getVarNames(), this);
        for (IPlotPickerTableListener iPlotPickerTableListener : this.fPlotPickerTableListenerVector) {
            iPlotPickerTableListener.invoked(new TableUpdateEvent((Object)actionRow.getPlotAction()));
        }
    }

    @Override
    public String getActionNameForRow(int n) {
        PlotPickerTableModel.ActionRow actionRow = this.getActionRowAt(n);
        if (actionRow == null) {
            return null;
        }
        return actionRow.getPlotAction().getFunctionName();
    }

    @Override
    public String getH1LineForRow(int n) {
        PlotPickerTableModel.ActionRow actionRow = this.getActionRowAt(n);
        if (actionRow == null) {
            return null;
        }
        return actionRow.getPlotAction().getDescription();
    }

    @Override
    public String getSearchText() {
        return "";
    }

    @Override
    public String getURLForRow(int n) {
        PlotPickerTableModel.ActionRow actionRow = this.getActionRowAt(n);
        if (actionRow == null) {
            return null;
        }
        return PlotPickerTreeTable.getURLForAction(actionRow.getPlotAction());
    }

    static String getURLForAction(PlotAction plotAction) {
        String string;
        String string2;
        String string3 = plotAction.getProductHelp();
        String string4 = plotAction.getRefPagePath();
        if (string3 != null && string4 != null && (string2 = FunctionReferenceUtils.getUrlPrefix(string3)) != null && (string = FunctionReferenceUtils.getLocalizedFilename(string2 + string4)) != null) {
            return string;
        }
        string2 = plotAction.getFunctionName();
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        List<String> list = FunctionReferenceUtils.getAllReferencePageUrls(string2, false);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Point point = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(point, (Component)((Object)this));
        int n = this.getSelectedRow();
        if (n < 0) {
            return;
        }
        this.hideActionToolTip();
        PlotPickerTableModel.ActionRow actionRow = this.getActionRowAt(n);
        if (actionRow == null) {
            return;
        }
        if (this.fPlotPickerCellRenderer.isOverActiveButton()) {
            return;
        }
        dragGestureEvent.startDrag(Cursor.getDefaultCursor(), new BufferedImage(1, 1, 1), new Point(DRAG_IMAGE_OFFSET, DRAG_IMAGE_OFFSET), new PlotItemHandler(n, PlotPickerTreeTable.getExecutionText(actionRow, this.getVarNames())), this);
        this.fDragWindow = new DragWindow((Component)((Object)this), this.createRowImage(n));
        SwingUtilities.convertPointToScreen(point, (Component)((Object)this));
        this.fDragWindow.setLocation(new Point(point.x + DRAG_IMAGE_OFFSET, point.y + DRAG_IMAGE_OFFSET));
        this.fDragWindow.setVisible(true);
        this.repaint();
    }

    @Override
    public void dragMouseMoved(DragSourceDragEvent dragSourceDragEvent) {
        Point point = (Point)dragSourceDragEvent.getLocation().clone();
        this.fDragWindow.setLocation(new Point(point.x + DRAG_IMAGE_OFFSET, point.y + DRAG_IMAGE_OFFSET));
        this.fDragWindow.repaint();
        SwingUtilities.convertPointFromScreen(point, (Component)((Object)this));
        if (point.x < 0 || point.x > this.getSize().width || point.y < 0 || point.y > this.getSize().height) {
            if (this.fDragWindow.isVisible()) {
                dragSourceDragEvent.getDragSourceContext().setCursor(null);
            }
            this.fDragWindow.setVisible(false);
            this.fDragRow = -1;
            this.repaint();
            return;
        }
        int n = this.rowAtPoint(point);
        if (n >= 0) {
            dragSourceDragEvent.getDragSourceContext().setCursor(new Cursor(0));
            this.fDragWindow.setVisible(true);
            Rectangle rectangle = this.getCellRect(n, 0, true);
            this.fDragRow = n >= 0 && rectangle.y + rectangle.height - point.y > point.y - rectangle.y ? n - 1 : n;
            this.scrollRowToVisible(this.fDragRow);
            this.repaint();
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
        if (this.fDragWindow != null && (dragSourceEvent.getLocation().x < 0 || dragSourceEvent.getLocation().x > this.getSize().width || dragSourceEvent.getLocation().y < 0 || dragSourceEvent.getLocation().y > this.getSize().height)) {
            this.fDragWindow.setVisible(false);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        ActionRowTransferData actionRowTransferData;
        try {
            actionRowTransferData = (ActionRowTransferData)dragSourceDropEvent.getDragSourceContext().getTransferable().getTransferData(PLOT_ITEM_FLAVOR);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Log.log((String)unsupportedFlavorException.toString());
            this.fDragRow = -1;
            return;
        }
        catch (IOException iOException) {
            Log.log((String)iOException.toString());
            this.fDragRow = -1;
            return;
        }
        int n = actionRowTransferData.getRow();
        PlotPickerTableModel.ActionRow actionRow = this.getActionRowAt(n);
        if (this.fDragRow >= 0 && this.moveActionRow(actionRow, this.fDragRow)) {
            dragSourceDropEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
            this.fDragWindow.setVisible(false);
            this.fDragRow = -1;
            return;
        }
        this.fDragRow = -1;
        if (!this.fDragWindow.isVisible()) {
            return;
        }
        Rectangle rectangle = this.getCellRect(n, 0, true);
        Point point = new Point(rectangle.x, rectangle.y);
        point.y = point.y < this.getVisibleRect().y ? this.getVisibleRect().y : point.y;
        point.y = point.y > this.getVisibleRect().y + this.getVisibleRect().height ? this.getVisibleRect().y + this.getVisibleRect().height : point.y;
        SwingUtilities.convertPointToScreen(point, (Component)((Object)this));
        Timer timer = new Timer(16, new Animator((Window)((Object)this.fDragWindow), (Point)dragSourceDropEvent.getLocation().clone(), point));
        timer.start();
    }

    int getDragTargetRow() {
        return this.fDragRow;
    }

    public void setAnimationLocation(Point point) {
        this.fAnimationPosition = point;
    }

    public void animationStart() {
        this.repaint();
    }

    BufferedImage createRowImage(int n) {
        Rectangle rectangle = this.getCellRect(n, 0, false);
        BufferedImage bufferedImage = (BufferedImage)this.createImage(rectangle.width, rectangle.height);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.translate(-rectangle.x, -rectangle.y);
        this.print(graphics2D);
        return bufferedImage;
    }

    private void createCategoryImage(int n, int n2) {
        Rectangle rectangle = this.getCellRect(n, 0, false);
        Rectangle rectangle2 = this.getCellRect(n2, 0, false);
        Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle2.height + rectangle2.y - rectangle.y);
        this.fAnimationImage = (BufferedImage)this.createImage(rectangle3.width, rectangle3.height);
        Graphics2D graphics2D = this.fAnimationImage.createGraphics();
        graphics2D.translate(-rectangle3.x, -rectangle3.y);
        this.print(graphics2D);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.fAnimationImage != null && this.fAnimationPosition != null) {
            graphics.drawImage(this.fAnimationImage, this.fAnimationPosition.x, this.fAnimationPosition.y, null);
        }
    }

    void moveCategoryToTop(PlotPickerTableModel.Category category) {
        int n = this.getRowIndex((Row)category);
        Rectangle rectangle = this.getCellRect(n, 0, true);
        Point point = new Point(rectangle.x, rectangle.y);
        Point point2 = new Point(this.getVisibleRect().x, this.getVisibleRect().y);
        this.createCategoryImage(n, n + category.getChildrenCount());
        Timer timer = new Timer(16, new Animator(new CategoryAnimationTarget(category), point, point2));
        timer.start();
    }

    private boolean moveActionRow(PlotPickerTableModel.ActionRow actionRow, int n) {
        PlotPickerTableModel plotPickerTableModel = this.getPlotPickerTableModel();
        Row row = null;
        if (n >= 0) {
            row = this.getRowAt(n);
        }
        if (actionRow == row) {
            return false;
        }
        boolean bl = plotPickerTableModel.moveActionRow(actionRow, row);
        if (bl) {
            this.fIsClipboardOwner = false;
        }
        return bl;
    }

    void removeFavoriteActionRow(PlotPickerTableModel.ActionRow actionRow) {
        if (!actionRow.isFavorite()) {
            return;
        }
        PlotPickerTableModel plotPickerTableModel = this.getPlotPickerTableModel();
        PlotPickerTableModel.ActionRow actionRow2 = plotPickerTableModel.getMatchingTopLevelFavoriteRow(actionRow);
        if (actionRow2 == actionRow || actionRow.isSearchResult()) {
            plotPickerTableModel.removeActionRow(actionRow);
            this.repaint();
            this.fIsClipboardOwner = false;
        } else {
            int n = this.getRowIndex((Row)actionRow2);
            int n2 = this.getRowIndex((Row)actionRow);
            Rectangle rectangle = this.getCellRect(n, 0, true);
            Point point = this.getVisibleRect() != null && rectangle.y < this.getVisibleRect().y ? new Point(rectangle.x, this.getVisibleRect().y) : new Point(rectangle.x, rectangle.y);
            Rectangle rectangle2 = this.getCellRect(n2, 0, true);
            Point point2 = new Point(rectangle2.x, rectangle2.y);
            this.fAnimationImage = this.createRowImage(n);
            Animator animator = new Animator(new ActionRowAnimationTarget(actionRow), point, point2);
            animator.setReverse(true);
            Timer timer = new Timer(16, animator);
            timer.start();
        }
    }

    void copyRowToFavorites(PlotPickerTableModel.ActionRow actionRow) {
        if (actionRow.isFavorite()) {
            return;
        }
        if (!actionRow.isSearchResult()) {
            int n = this.getRowIndex((Row)actionRow);
            Rectangle rectangle = this.getCellRect(n, 0, true);
            Point point = new Point(rectangle.x, rectangle.y);
            Point point2 = new Point(this.getVisibleRect().x, this.getVisibleRect().y);
            this.fAnimationImage = this.createRowImage(n);
            Timer timer = new Timer(33, new Animator(new ActionRowAnimationTarget(actionRow), point, point2));
            timer.start();
        } else {
            this.moveActionRow(actionRow, -1);
        }
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        Row row = this.getRowAt(n);
        if (row instanceof PlotPickerTableModel.ActionRow) {
            return this.fPlotPickerCellRenderer;
        }
        if (row instanceof PlotPickerTableModel.Category) {
            return this.fPlotPickerCategoryRenderer;
        }
        return super.getCellRenderer(n, n2);
    }

    void setVarNames(String[] stringArray) {
        this.fPlotPickerCellRenderer.setVarNames(stringArray);
        this.repaint();
    }

    String[] getVarNames() {
        return this.fPlotPickerCellRenderer.getVarNames();
    }

    void setSearchString(String string) {
        this.fPlotPickerCellRenderer.setFilterString(string);
        this.fPlotPickerCategoryRenderer.setFilterString(string);
    }

    private int getClipboardRowIndex() {
        ActionRowTransferData actionRowTransferData;
        if (!this.fIsClipboardOwner) {
            return -1;
        }
        Transferable transferable = MJClipboard.getMJClipboard().getContents(null);
        try {
            actionRowTransferData = (ActionRowTransferData)transferable.getTransferData(PLOT_ITEM_FLAVOR);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            return -1;
        }
        catch (IOException iOException) {
            return -1;
        }
        return actionRowTransferData.getRow();
    }

    private void removeMatchingFavoriteRow(int n) {
        PlotPickerTableModel plotPickerTableModel = this.getPlotPickerTableModel();
        PlotPickerTableModel.ActionRow actionRow = this.getActionRowAt(n);
        if (actionRow == null) {
            return;
        }
        PlotPickerTableModel.ActionRow actionRow2 = plotPickerTableModel.getMatchingTopLevelFavoriteRow(actionRow);
        plotPickerTableModel.removeActionRow(actionRow2);
    }

    private int getMatchingFavoriteRowIndex(PlotPickerTableModel.ActionRow actionRow) {
        PlotPickerTableModel plotPickerTableModel = this.getPlotPickerTableModel();
        PlotPickerTableModel.ActionRow actionRow2 = plotPickerTableModel.getMatchingTopLevelFavoriteRow(actionRow);
        if (actionRow2 != null) {
            return this.getRowIndex((Row)actionRow2);
        }
        return -1;
    }

    private static String getExecutionText(PlotPickerTableModel.ActionRow actionRow, String[] stringArray) {
        return actionRow.getPlotAction().getExecutionString(stringArray);
    }

    static {
        TABLE_BACKGROUND_COLOR = new Color(240, 240, 240);
        DRAG_IMAGE_OFFSET = 10;
    }

    private class PlotPickerMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private PlotPickerMouseListener() {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Row row = PlotPickerTreeTable.this.getRowAt(PlotPickerTreeTable.this.rowAtPoint(mouseEvent.getPoint()));
            if (row instanceof PlotPickerTableModel.ActionRow) {
                PlotPickerTreeTable.this.fPlotPickerCellRenderer.mouseMovedCallback(PlotPickerTreeTable.this, mouseEvent, (PlotPickerTableModel.ActionRow)row);
            } else {
                PlotPickerTreeTable.this.fPlotPickerCategoryRenderer.mouseMovedCallback(PlotPickerTreeTable.this, mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            PlotPickerTreeTable.this.fMousePressedState = true;
            PlotPickerTreeTable.this.fPlotPickerCellRenderer.mousePressedCallback(PlotPickerTreeTable.this, mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (PlotPickerTreeTable.this.fMousePressedState) {
                PlotPickerTreeTable.this.fMousePressedState = false;
                this.localMouseClicked(mouseEvent);
            }
            PlotPickerTreeTable.this.fPlotPickerCellRenderer.mouseReleasedCallback(PlotPickerTreeTable.this, mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Row row = PlotPickerTreeTable.this.getRowAt(PlotPickerTreeTable.this.rowAtPoint(mouseEvent.getPoint()));
            if (row instanceof PlotPickerTableModel.ActionRow) {
                PlotPickerTreeTable.this.fPlotPickerCellRenderer.mouseMovedCallback(PlotPickerTreeTable.this, mouseEvent, (PlotPickerTableModel.ActionRow)row);
            } else {
                PlotPickerTreeTable.this.fPlotPickerCategoryRenderer.mouseMovedCallback(PlotPickerTreeTable.this, mouseEvent);
            }
        }

        public void localMouseClicked(MouseEvent mouseEvent) {
            int n = PlotPickerTreeTable.this.rowAtPoint(mouseEvent.getPoint());
            if (n < 0) {
                return;
            }
            Row row = PlotPickerTreeTable.this.getRowAt(n);
            if (row instanceof PlotPickerTableModel.ActionRow) {
                PlotPickerTreeTable.this.fPlotPickerCellRenderer.mouseClickedCallback(PlotPickerTreeTable.this, mouseEvent, (PlotPickerTableModel.ActionRow)row);
            } else {
                PlotPickerTreeTable.this.fPlotPickerCategoryRenderer.mouseClickedCallback(PlotPickerTreeTable.this, mouseEvent, (PlotPickerTableModel.Category)row);
            }
        }
    }

    private static class RowHeightAnimatorActionListener
    implements ActionListener {
        private int irowheight = 1;
        private PlotPickerTreeTable iTargetTable;
        private int iStartRowHeight = Integer.MAX_VALUE;
        private int iEndRowHeight = Integer.MIN_VALUE;
        private int iRowPos = -1;

        RowHeightAnimatorActionListener(PlotPickerTreeTable plotPickerTreeTable, int n, int n2, int n3) {
            this.iTargetTable = plotPickerTreeTable;
            this.iStartRowHeight = n2;
            this.iEndRowHeight = n3;
            this.iRowPos = n;
            this.irowheight = n2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.iStartRowHeight > this.iEndRowHeight && this.irowheight <= this.iEndRowHeight) {
                this.iTargetTable.removeMatchingFavoriteRow(this.iRowPos);
                ((Timer)actionEvent.getSource()).stop();
                this.iTargetTable.fIsClipboardOwner = false;
                return;
            }
            if (this.iStartRowHeight < this.iEndRowHeight && this.irowheight >= this.iEndRowHeight) {
                ((Timer)actionEvent.getSource()).stop();
                this.iTargetTable.fIsClipboardOwner = false;
                return;
            }
            this.iTargetTable.setRowHeight(this.iRowPos, this.irowheight);
            this.irowheight += this.iStartRowHeight > this.iEndRowHeight ? -2 : 2;
        }
    }

    private static class TableUpdateEvent
    extends AWTEvent {
        private TableUpdateEvent(Object object) {
            super(object, 0);
        }
    }

    private static class ActionRowTransferData
    implements Serializable {
        private int iRow = -1;
        private String iTransferText;

        private ActionRowTransferData(int n, String string) {
            this.iRow = n;
            this.iTransferText = string;
        }

        public int getRow() {
            return this.iRow;
        }

        public String toString() {
            return this.iTransferText;
        }
    }

    private class CategoryAnimationReplacementTarget
    implements AnimationTarget {
        private PlotPickerTableModel.Category iAnimationCategory;
        private PlotPickerTableModel.Category iNextCategory;

        CategoryAnimationReplacementTarget(PlotPickerTableModel.Category category, PlotPickerTableModel.Category category2) {
            this.iAnimationCategory = category;
            this.iNextCategory = category2;
        }

        @Override
        public void setAnimationLocation(Point point) {
            PlotPickerTreeTable.this.fAnimationPosition = point;
        }

        @Override
        public void animationStart() {
            PlotPickerTreeTable.this.repaint();
        }

        @Override
        public void animationComplete() {
            int n = -1;
            MJScrollPane mJScrollPane = (MJScrollPane)SwingUtilities.getAncestorOfClass(MJScrollPane.class, (Component)((Object)PlotPickerTreeTable.this));
            int n2 = 0;
            if (mJScrollPane != null) {
                n = mJScrollPane.getViewport().getViewPosition().y;
                n2 = -PlotPickerTreeTable.this.getCellRect((int)PlotPickerTreeTable.this.getRowIndex((Row)this.iAnimationCategory), (int)0, (boolean)true).y + PlotPickerTreeTable.this.getCellRect((int)PlotPickerTreeTable.this.getRowIndex((Row)this.iNextCategory), (int)0, (boolean)true).y;
                PlotPickerTreeTable.this.paintImmediately(PlotPickerTreeTable.this.getBounds());
            }
            PlotPickerTableModel plotPickerTableModel = PlotPickerTreeTable.this.getPlotPickerTableModel();
            plotPickerTableModel.moveCategoryToTop((String)this.iAnimationCategory.getValueAt(0));
            PlotPickerTreeTable.this.repaint();
            PlotPickerTreeTable.this.calculateRowHeights();
            if (n >= 0 && mJScrollPane != null && mJScrollPane.getViewport() != null) {
                mJScrollPane.getViewport().setViewPosition(new Point(0, n + n2));
            }
            PlotPickerTreeTable.this.fAnimationImage = null;
            PlotPickerTreeTable.this.repaint();
            PlotPickerTreeTable.this.fIsClipboardOwner = false;
        }
    }

    private class CategoryAnimationTarget
    implements AnimationTarget {
        private PlotPickerTableModel.Category iAnimationCategory;

        CategoryAnimationTarget(PlotPickerTableModel.Category category) {
            this.iAnimationCategory = category;
        }

        @Override
        public void setAnimationLocation(Point point) {
            PlotPickerTreeTable.this.fAnimationPosition = point;
        }

        @Override
        public void animationStart() {
            PlotPickerTreeTable.this.repaint();
        }

        @Override
        public void animationComplete() {
            PlotPickerTreeTable.this.fAnimationImage = null;
            PlotPickerTreeTable.this.repaint();
            PlotPickerTableModel plotPickerTableModel = PlotPickerTreeTable.this.getPlotPickerTableModel();
            PlotPickerTableModel.Category category = plotPickerTableModel.getNextCategory(this.iAnimationCategory);
            if (category == null) {
                plotPickerTableModel.moveCategoryToTop((String)this.iAnimationCategory.getValueAt(0));
                PlotPickerTreeTable.this.repaint();
                return;
            }
            int n = PlotPickerTreeTable.this.getRowIndex((Row)category);
            Rectangle rectangle = PlotPickerTreeTable.this.getCellRect(n, 0, true);
            Point point = new Point(rectangle.x, rectangle.y);
            int n2 = PlotPickerTreeTable.this.getRowIndex((Row)this.iAnimationCategory);
            Rectangle rectangle2 = PlotPickerTreeTable.this.getCellRect(n2, 0, true);
            Point point2 = new Point(rectangle2.x, rectangle2.y);
            PlotPickerTreeTable.this.createCategoryImage(n, n + 12);
            Timer timer = new Timer(16, new Animator(new CategoryAnimationReplacementTarget(this.iAnimationCategory, category), point, point2));
            timer.start();
        }
    }

    private class ActionRowAnimationTarget
    implements AnimationTarget {
        private PlotPickerTableModel.ActionRow iAnimationRow;

        ActionRowAnimationTarget(PlotPickerTableModel.ActionRow actionRow) {
            this.iAnimationRow = actionRow;
        }

        @Override
        public void setAnimationLocation(Point point) {
            PlotPickerTreeTable.this.fAnimationPosition = point;
        }

        @Override
        public void animationStart() {
            PlotPickerTreeTable.this.repaint();
        }

        @Override
        public void animationComplete() {
            RowHeightAnimatorActionListener rowHeightAnimatorActionListener;
            boolean bl;
            PlotPickerTreeTable.this.fAnimationImage = null;
            PlotPickerTreeTable.this.repaint();
            boolean bl2 = bl = !this.iAnimationRow.isFavorite();
            if (bl) {
                PlotPickerTreeTable.this.moveActionRow(this.iAnimationRow, -1);
                rowHeightAnimatorActionListener = new RowHeightAnimatorActionListener(PlotPickerTreeTable.this, 1, 2, PlotPickerTreeTable.this.calculateRowHeight(1));
                PlotPickerTreeTable.this.setRowHeight(1, 0);
            } else {
                int n = PlotPickerTreeTable.this.getMatchingFavoriteRowIndex(this.iAnimationRow);
                rowHeightAnimatorActionListener = new RowHeightAnimatorActionListener(PlotPickerTreeTable.this, n, PlotPickerTreeTable.this.calculateRowHeight(n), 1);
            }
            Timer timer = new Timer(16, rowHeightAnimatorActionListener);
            timer.start();
        }
    }

    private class DeleteAction
    extends MJAbstractAction {
        public DeleteAction() {
            super(PlotPicker.getResourceString("PlotPickerTreeTable", "RemFav"));
            this.setComponentName("Remove Favorite");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = PlotPickerTreeTable.this.getSelectedRow();
            PlotPickerTableModel.ActionRow actionRow = PlotPickerTreeTable.this.getActionRowAt(n);
            if (actionRow == null) {
                return;
            }
            PlotPickerTreeTable.this.removeFavoriteActionRow(actionRow);
        }
    }

    private class InsertAction
    extends MJAbstractAction {
        public InsertAction() {
            super(PlotPicker.getResourceString("PlotPickerTreeTable", "Insert"));
            this.setComponentName("Insert");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = PlotPickerTreeTable.this.getSelectedRow();
            PlotPickerTreeTable.this.insertCommand(n);
        }
    }

    private class ExecuteAction
    extends MJAbstractAction {
        public ExecuteAction() {
            super(PlotPicker.getResourceString("PlotPickerTreeTable", "Execute"));
            this.setComponentName("Execute");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = PlotPickerTreeTable.this.getSelectedRow();
            PlotPickerTreeTable.this.execute(n, false);
        }
    }

    private class FavoriteAction
    extends MJAbstractAction {
        public FavoriteAction() {
            super(PlotPicker.getResourceString("PlotPickerTreeTable", "Add"));
            this.setComponentName("Add to Favorites");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = PlotPickerTreeTable.this.getSelectedRow();
            PlotPickerTableModel.ActionRow actionRow = PlotPickerTreeTable.this.getActionRowAt(n);
            if (actionRow == null) {
                return;
            }
            PlotPickerTreeTable.this.copyRowToFavorites(actionRow);
        }
    }

    private class RestoreAction
    extends MJAbstractAction {
        public RestoreAction() {
            super(PlotPicker.getResourceString("PlotPickerTreeTable", "Restore"));
            this.setComponentName("Restore");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            PlotPickerTreeTable.this.setCursor(new Cursor(3));
            PlotPickerTreeTable.this.removeMouseListener(PlotPickerTreeTable.this.fPlotPickerMouseListener);
            PlotPickerTreeTable.this.removeMouseMotionListener(PlotPickerTreeTable.this.fPlotPickerMouseListener);
            if (!(!FileUtils.fileExists((String)(FileUtils.getPreferencesDirectory() + "/plotpickercache.xml")) || (file = new File(FileUtils.getPreferencesDirectory() + "/plotpickercache.xml")).canWrite() && file.delete())) {
                MJOptionPane.showMessageDialog((Component)((Object)PlotPickerTreeTable.this), (Object)PlotPicker.getResourceString("PlotPickerTreeTable", "MsgAccessPrefFile"), (String)PlotPicker.getResourceString("PlotPickerTreeTable", "MsgTitle"), (int)2);
            }
            ModelStateFactory.restore();
            PlotPickerTreeTable.this.fIsClipboardOwner = false;
            PlotPickerTreeTable.this.setCursor(null);
        }
    }

    private class PasteAction
    extends AbstractPasteAction {
        public PasteAction() {
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = PlotPickerTreeTable.this.getSelectedRow();
            PlotPickerTableModel.ActionRow actionRow = PlotPickerTreeTable.this.getActionRowAt(n);
            if (actionRow == null) {
                return;
            }
            if (!PlotPickerTreeTable.this.isPasteMenuEnabled(actionRow)) {
                return;
            }
            int n2 = PlotPickerTreeTable.this.getClipboardRowIndex();
            if (n < 0 || n2 < 0) {
                return;
            }
            PlotPickerTreeTable.this.moveActionRow(PlotPickerTreeTable.this.getActionRowAt(n2), n);
        }
    }

    private class CopyAction
    extends AbstractCopyAction {
        public CopyAction() {
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final int n = PlotPickerTreeTable.this.getSelectedRow();
            if (n < 0) {
                return;
            }
            final PlotPickerTableModel.ActionRow actionRow = PlotPickerTreeTable.this.getActionRowAt(n);
            PlotPickerTreeTable.this.fIsClipboardOwner = true;
            final PlotAction plotAction = actionRow.getPlotAction();
            if (plotAction.hasCustomExecutionFunction()) {
                MatlabWorker matlabWorker = new MatlabWorker(){

                    public Object runOnMatlabThread() {
                        return plotAction.evalCustomExecutionFunc(PlotPickerTreeTable.this.getVarNames(), actionRow.isSwapped());
                    }

                    public void runOnAWTEventDispatchThread(Object object) {
                        String string = object != null && object instanceof String ? (String)object : (actionRow.isSwapped() ? plotAction.getSwappedExecutionString(PlotPickerTreeTable.this.getVarNames()) : plotAction.getExecutionString(PlotPickerTreeTable.this.getVarNames()));
                        MJClipboard.getMJClipboard().setContents((Transferable)new PlotItemHandler(n, string), (ClipboardOwner)PlotPickerTreeTable.this);
                    }
                };
                matlabWorker.start();
                return;
            }
            MJClipboard.getMJClipboard().setContents((Transferable)new PlotItemHandler(n, PlotPickerTreeTable.getExecutionText(actionRow, PlotPickerTreeTable.this.getVarNames())), (ClipboardOwner)PlotPickerTreeTable.this);
        }
    }

    private static class PlotItemHandler
    implements Transferable {
        private ActionRowTransferData iActionRowTransferData;

        public PlotItemHandler(int n, String string) {
            if (PLOT_ITEM_FLAVOR == null) {
                try {
                    PLOT_ITEM_FLAVOR = new DataFlavor("application/x-matlab-plot-action;class=javax.swing.ImageIcon");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
            }
            this.iActionRowTransferData = new ActionRowTransferData(n, string);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{PLOT_ITEM_FLAVOR, DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.isMimeTypeEqual(PLOT_ITEM_FLAVOR.getMimeType()) || dataFlavor.isMimeTypeEqual(DataFlavor.stringFlavor.getMimeType());
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor.equals(PLOT_ITEM_FLAVOR)) {
                return this.iActionRowTransferData;
            }
            if (dataFlavor.equals(DataFlavor.stringFlavor)) {
                return this.iActionRowTransferData.toString();
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }
}

