/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search;

import com.mathworks.mlwidgets.help.search.BooleanSearchOperator;
import com.mathworks.mlwidgets.help.search.SearchField;
import com.mathworks.mlwidgets.help.search.Visitable;
import com.mathworks.mlwidgets.help.search.WeightedSearchField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class SearchExpression
implements Visitable {
    private List<WeightedSearchField> fSearchFields;
    private BooleanSearchOperator fOperator = BooleanSearchOperator.MUST_OCCUR;

    protected SearchExpression() {
    }

    protected SearchExpression(BooleanSearchOperator booleanSearchOperator) {
        this.fOperator = booleanSearchOperator;
    }

    public SearchExpression addSearchField(SearchField searchField) {
        return this.addSearchField(new WeightedSearchField(searchField, 1.0f));
    }

    public SearchExpression addSearchField(WeightedSearchField weightedSearchField) {
        if (this.fSearchFields == null) {
            this.fSearchFields = new ArrayList<WeightedSearchField>();
        }
        this.fSearchFields.add(weightedSearchField);
        return this;
    }

    public Collection<WeightedSearchField> getSearchFields() {
        if (this.fSearchFields != null) {
            return Collections.unmodifiableCollection(this.fSearchFields);
        }
        return null;
    }

    public void setBooleanOperator(BooleanSearchOperator booleanSearchOperator) {
        this.fOperator = booleanSearchOperator;
    }

    public BooleanSearchOperator getBooleanOperator() {
        return this.fOperator;
    }
}

