/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search;

import com.mathworks.mlwidgets.help.search.BooleanSearchOperator;
import com.mathworks.mlwidgets.help.search.CompoundSearchExpression;
import com.mathworks.mlwidgets.help.search.ExactPhraseSearchExpression;
import com.mathworks.mlwidgets.help.search.PartialWordSearchExpression;
import com.mathworks.mlwidgets.help.search.SearchException;
import com.mathworks.mlwidgets.help.search.SearchExpression;
import com.mathworks.mlwidgets.help.search.SearchVisitor;
import com.mathworks.mlwidgets.help.search.SimpleSearchExpression;
import com.mathworks.mlwidgets.help.search.UnarySearchExpression;
import com.mathworks.mlwidgets.help.search.WildcardSearchExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class SearchKeywordsVisitor
implements SearchVisitor {
    private Collection<String> fSearchKeywords;

    @Override
    public void visit(SimpleSearchExpression simpleSearchExpression) {
        this.visitUnaryExpression(simpleSearchExpression);
    }

    @Override
    public void visit(PartialWordSearchExpression partialWordSearchExpression) {
        this.fSearchKeywords = new ArrayList<String>();
        if (!partialWordSearchExpression.getBooleanOperator().equals((Object)BooleanSearchOperator.MUST_NOT_OCCUR)) {
            this.fSearchKeywords.add(partialWordSearchExpression.getSearchString() + "*");
        }
    }

    @Override
    public void visit(WildcardSearchExpression wildcardSearchExpression) {
        this.visitUnaryExpression(wildcardSearchExpression);
    }

    @Override
    public void visit(ExactPhraseSearchExpression exactPhraseSearchExpression) {
        this.visitUnaryExpression(exactPhraseSearchExpression);
    }

    @Override
    public void visit(CompoundSearchExpression compoundSearchExpression) throws SearchException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SearchExpression searchExpression : compoundSearchExpression.getExpressions()) {
            searchExpression.accept(this);
            arrayList.addAll(this.getSearchKeywords());
        }
        this.fSearchKeywords = arrayList;
    }

    private void visitUnaryExpression(UnarySearchExpression unarySearchExpression) {
        this.fSearchKeywords = new ArrayList<String>();
        if (!unarySearchExpression.getBooleanOperator().equals((Object)BooleanSearchOperator.MUST_NOT_OCCUR)) {
            this.fSearchKeywords.add(unarySearchExpression.getSearchString());
        }
    }

    public Collection<String> getSearchKeywords() {
        return Collections.unmodifiableCollection(this.fSearchKeywords);
    }

    String[] getSearchKeywordsArray() {
        return this.fSearchKeywords.toArray(new String[this.fSearchKeywords.size()]);
    }
}

