/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search.lucene;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.help.ClassicHelpDataAccessor;
import com.mathworks.mlwidgets.help.HelpInfo;
import com.mathworks.mlwidgets.help.HelpInfoItem;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.help.search.DocSearchEngine;
import com.mathworks.mlwidgets.help.search.DocSearchField;
import com.mathworks.mlwidgets.help.search.DocSearchResult;
import com.mathworks.mlwidgets.help.search.EmptySearchResults;
import com.mathworks.mlwidgets.help.search.SearchCompletionObserver;
import com.mathworks.mlwidgets.help.search.SearchCriteria;
import com.mathworks.mlwidgets.help.search.SearchException;
import com.mathworks.mlwidgets.help.search.SearchResults;
import com.mathworks.mlwidgets.help.search.SearchUnavailableException;
import com.mathworks.mlwidgets.help.search.SuggestionObserver;
import com.mathworks.mlwidgets.help.search.lucene.DocIndexSearcher;
import com.mathworks.mlwidgets.help.search.lucene.DocMultiSearcher;
import com.mathworks.mlwidgets.help.search.lucene.LuceneDocSearchResults;
import com.mathworks.mlwidgets.help.search.lucene.LuceneDocSearchVisitor;
import com.mathworks.mlwidgets.help.search.lucene.MWHitCollector;
import com.mathworks.mlwidgets.help.search.lucene.MWSearcher;
import com.mathworks.mlwidgets.help.search.lucene.SuggestionProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class LuceneDocSearchEngine
extends DocSearchEngine {
    private MWSearcher fProdFilterSearcher;
    private MWSearcher fFullDocSearcher;
    private Map<String, DocIndexSearcher> fSearcherMap = new HashMap<String, DocIndexSearcher>();
    private static final String STUDENT_INDEX_DIRECTORY = "helpsearch.student";
    private LuceneDocSearchDependencies fDependencies = new DefaultDependencies();

    public void loadIndexes() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LuceneDocSearchEngine.this.getFullDocSearcher();
            }
        };
        new Thread(runnable).start();
    }

    @Override
    public void search(final SearchCriteria searchCriteria, final SearchCompletionObserver<DocSearchResult> searchCompletionObserver) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    SearchResults searchResults = LuceneDocSearchEngine.doSearch(LuceneDocSearchEngine.getQuery(searchCriteria), LuceneDocSearchEngine.this.getMWSearcher(searchCriteria));
                    searchCompletionObserver.searchComplete(searchResults);
                }
                catch (SearchException searchException) {
                    searchCompletionObserver.searchFailed(searchException);
                }
            }
        };
        new Thread(runnable).start();
    }

    @Override
    protected SearchResults<DocSearchResult> synchronousSearch(SearchCriteria searchCriteria) throws SearchException {
        return LuceneDocSearchEngine.doSearch(LuceneDocSearchEngine.getQuery(searchCriteria), this.getMWSearcher(searchCriteria));
    }

    @Override
    public synchronized void refresh(boolean bl) {
        if (bl) {
            this.cleanup();
        } else {
            this.fProdFilterSearcher = null;
        }
    }

    private MWSearcher getMWSearcher(SearchCriteria searchCriteria) throws SearchException {
        String[] stringArray = searchCriteria.getProducts();
        if (stringArray != null && stringArray.length > 0) {
            try {
                return this.getSearcherForProducts(stringArray);
            }
            catch (IOException iOException) {
                throw new SearchUnavailableException(0);
            }
        }
        if (searchCriteria.getUseProductFilter()) {
            return this.getDefaultSearcher();
        }
        return this.getFullDocSearcher();
    }

    private MWSearcher getDefaultSearcher() {
        if (HelpPrefs.getProductFilterEnabled()) {
            return this.getProdFilterSearcher();
        }
        return this.getFullDocSearcher();
    }

    private static SearchResults<DocSearchResult> doSearch(Query query, MWSearcher mWSearcher) throws SearchException {
        if (mWSearcher == null) {
            return new EmptySearchResults<DocSearchResult>();
        }
        try {
            MWHitCollector mWHitCollector = new MWHitCollector();
            mWSearcher.getSearcher().search(query, (HitCollector)mWHitCollector);
            return new LuceneDocSearchResults(mWHitCollector, mWSearcher.getSearcher());
        }
        catch (IOException iOException) {
            throw new SearchUnavailableException(1);
        }
    }

    private DocIndexSearcher openSearcherForProduct(HelpInfoItem helpInfoItem) throws IOException {
        if (helpInfoItem == null) {
            return null;
        }
        File file = this.getDependencies().getIndexDirectory(helpInfoItem);
        if (file != null) {
            Directory directory = this.getDependencies().getLuceneDirectory(file);
            if (IndexReader.isLocked((Directory)directory)) {
                IndexReader.unlock((Directory)directory);
            }
            String string = helpInfoItem.getProductName();
            return new DocIndexSearcher(directory, string, file.getParent());
        }
        return null;
    }

    private synchronized DocIndexSearcher getSearcherForProduct(String string) throws IOException {
        String string2 = string;
        HelpInfoItem helpInfoItem = this.getDependencies().getHelpInfoItemByShortName(string2);
        if (helpInfoItem != null) {
            string2 = helpInfoItem.getShortName();
        }
        if (this.fSearcherMap.containsKey(string2)) {
            return this.fSearcherMap.get(string2);
        }
        DocIndexSearcher docIndexSearcher = this.openSearcherForProduct(helpInfoItem);
        if (docIndexSearcher != null) {
            this.addProductSearcher(string2, docIndexSearcher);
        }
        return docIndexSearcher;
    }

    private synchronized void addProductSearcher(String string, DocIndexSearcher docIndexSearcher) {
        this.fSearcherMap.put(string, docIndexSearcher);
    }

    private MWSearcher getSearcherForProducts(String[] stringArray) throws IOException {
        if (stringArray.length == 1) {
            return this.getSearcherForProduct(stringArray[0]);
        }
        ArrayList<DocIndexSearcher> arrayList = new ArrayList<DocIndexSearcher>();
        for (String string : stringArray) {
            try {
                DocIndexSearcher docIndexSearcher = this.getSearcherForProduct(string);
                if (docIndexSearcher == null) continue;
                arrayList.add(docIndexSearcher);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return LuceneDocSearchEngine.buildMultiSearcher(arrayList);
    }

    private synchronized MWSearcher getFullDocSearcher() {
        if (this.fFullDocSearcher != null) {
            return this.fFullDocSearcher;
        }
        HelpInfoItem[] helpInfoItemArray = this.getDependencies().getInstalledProductHelpInfo();
        ArrayList<DocIndexSearcher> arrayList = new ArrayList<DocIndexSearcher>();
        for (HelpInfoItem helpInfoItem : helpInfoItemArray) {
            try {
                DocIndexSearcher docIndexSearcher = this.getSearcherForProduct(helpInfoItem.getShortName());
                if (docIndexSearcher == null) continue;
                arrayList.add(docIndexSearcher);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.fFullDocSearcher = LuceneDocSearchEngine.buildMultiSearcher(arrayList);
        return this.fFullDocSearcher;
    }

    private synchronized MWSearcher getProdFilterSearcher() {
        if (this.fProdFilterSearcher != null) {
            return this.fProdFilterSearcher;
        }
        HelpInfoItem[] helpInfoItemArray = this.getDependencies().getInstalledProductHelpInfo();
        ArrayList<DocIndexSearcher> arrayList = new ArrayList<DocIndexSearcher>();
        for (HelpInfoItem helpInfoItem : helpInfoItemArray) {
            if (!helpInfoItem.isSelected()) continue;
            try {
                DocIndexSearcher docIndexSearcher = this.getSearcherForProduct(helpInfoItem.getShortName());
                if (docIndexSearcher == null) continue;
                arrayList.add(docIndexSearcher);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.fProdFilterSearcher = LuceneDocSearchEngine.buildMultiSearcher(arrayList);
        return this.fProdFilterSearcher;
    }

    private static MWSearcher buildMultiSearcher(Collection<DocIndexSearcher> collection) {
        try {
            if (collection.size() > 1) {
                DocIndexSearcher[] docIndexSearcherArray = collection.toArray(new DocIndexSearcher[collection.size()]);
                return new DocMultiSearcher(docIndexSearcherArray);
            }
            if (collection.size() == 1) {
                return collection.iterator().next();
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static Query getQuery(SearchCriteria searchCriteria) throws SearchException {
        LuceneDocSearchVisitor luceneDocSearchVisitor = new LuceneDocSearchVisitor();
        searchCriteria.getExpression().accept(luceneDocSearchVisitor);
        Query query = luceneDocSearchVisitor.getBaseQuery();
        if (query == null) {
            throw new SearchUnavailableException(1);
        }
        if (!Matlab.isMatlabAvailable() || !Matlab.isStudentVersion()) {
            TermQuery termQuery = new TermQuery(new Term(DocSearchField.STUDENT_PAGE.getFieldName(), "1"));
            BooleanQuery booleanQuery = new BooleanQuery();
            booleanQuery.add(query, BooleanClause.Occur.MUST);
            booleanQuery.add((Query)termQuery, BooleanClause.Occur.MUST_NOT);
            query = booleanQuery;
        }
        return query;
    }

    @Override
    public void suggestCommonTerms(final String string, final SuggestionObserver suggestionObserver, final int n) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                MWSearcher mWSearcher = LuceneDocSearchEngine.this.getDefaultSearcher();
                if (mWSearcher != null) {
                    IndexReader indexReader = mWSearcher.getIndexReader();
                    SuggestionProvider suggestionProvider = new SuggestionProvider(indexReader, DocSearchField.BODY);
                    Collection<String> collection = suggestionProvider.getSuggestions(string, n);
                    suggestionObserver.suggestionsFound(string, collection);
                }
            }
        };
        new Thread(runnable).start();
    }

    @Override
    public synchronized void cleanup() {
        if (this.fSearcherMap != null) {
            for (DocIndexSearcher docIndexSearcher : this.fSearcherMap.values()) {
                try {
                    docIndexSearcher.close();
                }
                catch (IOException iOException) {}
            }
            this.fSearcherMap.clear();
            this.fFullDocSearcher = null;
            this.fProdFilterSearcher = null;
        }
    }

    public void explain(SearchCriteria searchCriteria, int n) {
        try {
            Query query = LuceneDocSearchEngine.getQuery(searchCriteria);
            Searcher searcher = this.getMWSearcher(searchCriteria).getSearcher();
            Hits hits = searcher.search(query);
            for (int i = 0; i < Math.min(n, hits.length()); ++i) {
                Explanation explanation = searcher.explain(query, hits.id(i));
                System.out.println("-------------------------");
                Document document = hits.doc(i);
                System.out.println("Title: " + document.get(DocSearchField.TITLE.getFieldName()));
                System.out.println(explanation.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized boolean isCleanedUp() {
        return this.fProdFilterSearcher == null && this.fFullDocSearcher == null && (this.fSearcherMap == null || this.fSearcherMap.isEmpty());
    }

    public synchronized void setDependencies(LuceneDocSearchDependencies luceneDocSearchDependencies) {
        this.fDependencies = luceneDocSearchDependencies;
        this.cleanup();
    }

    public synchronized LuceneDocSearchDependencies getDependencies() {
        return this.fDependencies;
    }

    private static class DefaultDependencies
    implements LuceneDocSearchDependencies {
        private DefaultDependencies() {
        }

        @Override
        public HelpInfoItem[] getInstalledProductHelpInfo() {
            return ClassicHelpDataAccessor.getInstalledProductHelpInfo();
        }

        @Override
        public HelpInfoItem getHelpInfoItemByShortName(String string) {
            return HelpInfo.getHelpInfoItemByShortName(string);
        }

        @Override
        public File getIndexDirectory(HelpInfoItem helpInfoItem) {
            String string;
            String string2 = helpInfoItem.getHelpLoc();
            if (string2 != null && string2.trim().length() > 0 && (string = HelpUtils.getInputFilename(string2, "helpsearch", LuceneDocSearchEngine.STUDENT_INDEX_DIRECTORY)) != null) {
                return new File(string);
            }
            return null;
        }

        @Override
        public Directory getLuceneDirectory(File file) throws IOException {
            return FSDirectory.getDirectory((File)file, (boolean)false);
        }
    }

    public static interface LuceneDocSearchDependencies {
        public HelpInfoItem[] getInstalledProductHelpInfo();

        public HelpInfoItem getHelpInfoItemByShortName(String var1);

        public File getIndexDirectory(HelpInfoItem var1);

        public Directory getLuceneDirectory(File var1) throws IOException;
    }
}

