/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlComponentClient;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.PageChangedEvent;
import com.mathworks.html.PageChangedListener;
import com.mathworks.html.StatusTextChangedEvent;
import com.mathworks.html.StatusTextListener;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.html.HTMLBrowserAddressBox;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mlwidgets.html.HtmlActionsToolBar;
import com.mathworks.mlwidgets.html.HtmlComponentFactory;
import com.mathworks.mlwidgets.html.MatlabHtmlActions;
import com.mathworks.mlwidgets.html.StatusChangedListener;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJStatusBar;
import com.mathworks.util.PostVMInit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class HTMLBrowserPanel
extends MJPanel
implements HtmlComponentClient {
    private HtmlComponent<MatlabHtmlActions> fHtmlComponent;
    private HtmlActionsToolBar<MatlabHtmlActions> fToolbar;
    private HTMLBrowserAddressBox fAddressToolbar;
    private MJStatusBar fStatusBar;
    private static MJFrame fFrame;
    private MyPageChangedListener fPageChangedListener = null;
    private List<StatusChangedListener> fStatusChangedListeners = new ArrayList<StatusChangedListener>();

    public static void main(String[] stringArray) {
        if (!Matlab.isMatlabAvailable()) {
            PostVMInit.perform((boolean)true, (boolean)false);
        }
        fFrame = new MJFrame();
        fFrame.getContentPane().setLayout(new BorderLayout());
        HTMLBrowserPanel hTMLBrowserPanel = new HTMLBrowserPanel("http://www.mathworks.com");
        hTMLBrowserPanel.addAddressBox(false);
        hTMLBrowserPanel.addStatusBar();
        fFrame.getContentPane().add((Component)((Object)hTMLBrowserPanel), "Center");
        fFrame.setSize(800, 600);
        fFrame.setLocation(20, 40);
        fFrame.setVisible(true);
        fFrame.setTitle("HTML Browser Panel");
        fFrame.setDefaultCloseOperation(2);
    }

    public HTMLBrowserPanel() {
        this(null);
    }

    public HTMLBrowserPanel(String string) {
        this(HtmlComponentFactory.buildHtmlComponent(new HtmlComponentFactory.HtmlComponentType[0]), string);
    }

    public HTMLBrowserPanel(HtmlComponent<MatlabHtmlActions> htmlComponent, String string) {
        this.setLayout(new BorderLayout());
        this.fHtmlComponent = htmlComponent;
        this.fPageChangedListener = new MyPageChangedListener();
        this.fHtmlComponent.addPageChangedListener((PageChangedListener)this.fPageChangedListener);
        this.add(this.fHtmlComponent.getComponent(), "Center");
        if (string != null) {
            this.fHtmlComponent.setCurrentLocation(string);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.fHtmlComponent.getComponent().setVisible(bl);
    }

    public void addToolbar() {
        this.fToolbar = new HtmlActionsToolBar<HtmlActions>(this.fHtmlComponent.getActions());
        this.fToolbar.setFloatable(false);
        this.add((Component)((Object)this.fToolbar), "North");
    }

    public void addStatusBar() {
        this.fStatusBar = new MJStatusBar();
        this.fStatusBar.setName("HTML Status Bar");
        this.add((Component)this.fStatusBar, "South");
        this.addStatusTextListener(new MouseOverLinkListener());
    }

    public void dispose() {
        if (this.fPageChangedListener != null) {
            this.fHtmlComponent.removePageChangedListener((PageChangedListener)this.fPageChangedListener);
        }
        this.fHtmlComponent.dispose();
    }

    public void addAddressBox(boolean bl) {
        if (this.fToolbar == null) {
            return;
        }
        this.fAddressToolbar = new HTMLBrowserAddressBox(new AddressBoxActionListener());
        if (bl) {
            this.remove((Component)((Object)this.fToolbar));
            FormLayout formLayout = new FormLayout("default:grow", "pref, pref, 3px");
            MJPanel mJPanel = new MJPanel((LayoutManager)formLayout);
            CellConstraints cellConstraints = new CellConstraints();
            mJPanel.add(this.fToolbar, (Object)cellConstraints.xy(1, 1));
            mJPanel.add((Component)((Object)this.fAddressToolbar), (Object)cellConstraints.xy(1, 2));
            this.add((Component)mJPanel, "North");
        } else {
            this.fToolbar.addSeparator();
            this.fToolbar.add((Component)((Object)this.fAddressToolbar));
        }
    }

    public void addAddressBox(HtmlActionsToolBar<MatlabHtmlActions> htmlActionsToolBar) {
        this.fAddressToolbar = new HTMLBrowserAddressBox(new AddressBoxActionListener());
        htmlActionsToolBar.addSeparator();
        htmlActionsToolBar.add((Component)((Object)this.fAddressToolbar));
    }

    public void addStatusTextListener(StatusTextListener statusTextListener) {
        this.fHtmlComponent.addStatusTextListener(statusTextListener);
    }

    public void removeStatusTextListener(StatusTextListener statusTextListener) {
        this.fHtmlComponent.removeStatusTextListener(statusTextListener);
    }

    public HtmlComponent<MatlabHtmlActions> getHtmlComponent() {
        return this.fHtmlComponent;
    }

    public void setCurrentLocation(String string) {
        this.fHtmlComponent.setCurrentLocation(string);
    }

    public String getCurrentLocation() {
        return this.fHtmlComponent.getCurrentLocation();
    }

    public String getHtmlText() {
        return this.fHtmlComponent.getHtmlText();
    }

    public void setHtmlText(String string) {
        this.fHtmlComponent.setHtmlText(string);
    }

    public boolean placeFocusInBrowser() {
        return this.fHtmlComponent != null && this.fHtmlComponent.getComponent().requestFocusInWindow();
    }

    public void executeScript(String string) {
        this.fHtmlComponent.executeScript(string);
    }

    public void executeScript(String string, HtmlDataListener<String> htmlDataListener) {
        this.fHtmlComponent.executeScript(string, htmlDataListener);
    }

    public void addStatusChangedListener(StatusChangedListener statusChangedListener) {
        this.fStatusChangedListeners.add(statusChangedListener);
    }

    public void removeStatusChangedListener(StatusChangedListener statusChangedListener) {
        for (int i = 0; i < this.fStatusChangedListeners.size(); ++i) {
            StatusChangedListener statusChangedListener2 = this.fStatusChangedListeners.get(i);
            if (!statusChangedListener2.equals(statusChangedListener)) continue;
            this.fStatusChangedListeners.remove(i);
            return;
        }
    }

    void notifyStatusChangedListeners(int n) {
        StatusChangedListener.StatusChangedEvent statusChangedEvent = new StatusChangedListener.StatusChangedEvent(n);
        for (StatusChangedListener statusChangedListener : this.fStatusChangedListeners) {
            statusChangedListener.statusChanged(statusChangedEvent);
        }
    }

    public void setWaitCursor(final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setAllWaitCursors(bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HTMLBrowserPanel.this.setAllWaitCursors(bl);
                }
            });
        }
    }

    private void setAllWaitCursors(boolean bl) {
        if (bl) {
            Cursor cursor = Cursor.getPredefinedCursor(3);
            this.setCursor(cursor);
            this.fHtmlComponent.getComponent().setCursor(cursor);
        } else {
            Cursor cursor = Cursor.getDefaultCursor();
            this.setCursor(cursor);
            this.fHtmlComponent.getComponent().setCursor(cursor);
        }
    }

    private class MyPageChangedListener
    implements PageChangedListener {
        private MyPageChangedListener() {
        }

        public void pageChanged(PageChangedEvent pageChangedEvent) {
            String string = pageChangedEvent.getFullUrl();
            String string2 = pageChangedEvent.getTitle();
            if (HTMLBrowserPanel.this.fAddressToolbar != null) {
                if (string.length() > 0 && string.charAt(string.length() - 1) == '/') {
                    string = string.substring(0, string.length() - 1);
                }
                HTMLBrowserPanel.this.fAddressToolbar.addUrlToCombobox(string2, string);
            }
            if (fFrame != null) {
                if (string.equals(string2) && string2.startsWith("text://")) {
                    fFrame.setTitle(HTMLUtils.sRes.getString("icecontainer.address_box_untitled"));
                } else {
                    fFrame.setTitle(string2);
                }
            }
            HTMLBrowserPanel.this.notifyStatusChangedListeners(0);
        }
    }

    private class MouseOverLinkListener
    implements StatusTextListener {
        private MouseOverLinkListener() {
        }

        public void statusChanged(StatusTextChangedEvent statusTextChangedEvent) {
            if (HTMLBrowserPanel.this.fStatusBar != null) {
                final String string = statusTextChangedEvent.getStatusText();
                if (SwingUtilities.isEventDispatchThread()) {
                    if (string.length() == 0) {
                        HTMLBrowserPanel.this.fStatusBar.clearText();
                    } else {
                        HTMLBrowserPanel.this.fStatusBar.setText(string);
                    }
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (string.length() == 0) {
                                HTMLBrowserPanel.this.fStatusBar.clearText();
                            } else {
                                HTMLBrowserPanel.this.fStatusBar.setText(string);
                            }
                        }
                    });
                }
            }
        }
    }

    private class AddressBoxActionListener
    implements ActionListener {
        private AddressBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            HTMLBrowserPanel.this.notifyStatusChangedListeners(1);
            HTMLBrowserPanel.this.setCurrentLocation(string);
        }
    }
}

