/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.html.EncodingUtils;
import com.mathworks.html.FindOption;
import com.mathworks.html.HtmlActionStateManager;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlContextMenuBuilder;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.HtmlPanel;
import com.mathworks.html.PageChangedListener;
import com.mathworks.html.PopupWindowListener;
import com.mathworks.html.ProxySettings;
import com.mathworks.html.RequestHandler;
import com.mathworks.html.StatusTextListener;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.html.DefaultPopupWindowListener;
import com.mathworks.mlwidgets.html.HTMLAcceleratorHelper;
import com.mathworks.mlwidgets.html.HTMLPrefs;
import com.mathworks.mlwidgets.html.HtmlComponentRegistry;
import com.mathworks.mlwidgets.html.MJHtmlPanelActions;
import com.mathworks.mlwidgets.html.MatlabHtmlActions;
import com.mathworks.mlwidgets.html.MatlabRequestHandler;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.ComponentBuilder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.JComponent;

public class MJHtmlPanel
implements HtmlComponent<MatlabHtmlActions>,
ComponentBuilder {
    private static final EnumSet<MatlabHtmlActions.MatlabActionId> TEXT_SELECTION_ACTIONS = EnumSet.of(MatlabHtmlActions.MatlabActionId.EVALUATE_SELECTION, MatlabHtmlActions.MatlabActionId.HELP_ON_SELECTION, MatlabHtmlActions.MatlabActionId.OPEN_SELECTION);
    private final MJHtmlPanelActions fActions;
    private final HtmlPanel<MJHtmlPanelActions> fHtmlPanel;
    private final int fRegistryId;

    private static void setupProxyListener() {
        MJHtmlPanel.updateProxySettings();
        HTMLPrefs.addProxyListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MJHtmlPanel.updateProxySettings();
            }
        });
    }

    private static void updateProxySettings() {
        if (HTMLPrefs.getUseProxy()) {
            String string = HTMLPrefs.getProxyHost();
            String string2 = HTMLPrefs.getProxyPort();
            String string3 = HTMLPrefs.getProxyUsername();
            String string4 = HTMLPrefs.getProxyPassword();
            int n = string2 != null ? Integer.parseInt(string2) : 0;
            ProxySettings.configureProxy((String)string, (int)n, (String)string3, (String)string4);
        } else {
            ProxySettings.clearProxySettings();
        }
    }

    public static void setupMozillaDirectory() {
        MozillaPlatform mozillaPlatform = MJHtmlPanel.getMozillaPlatform();
        if (mozillaPlatform != null) {
            File file = new File(Matlab.matlabRoot(), "sys/jxbrowser");
            File file2 = new File(file, mozillaPlatform.getMozillaDirUnderJxBrowser());
            System.setProperty("GRE_HOME", file2.getAbsolutePath());
        }
    }

    private static MozillaPlatform getMozillaPlatform() {
        if (PlatformInfo.isWindows() && !PlatformInfo.is64Bit()) {
            return MozillaPlatform.WIN32;
        }
        if (PlatformInfo.isLinux64()) {
            return MozillaPlatform.GLNXA64;
        }
        return null;
    }

    private static File getResourceDirectory() {
        File file;
        String string = Prefs.getPropertyDirectory();
        if (string != null && (file = new File(string)).exists() && file.canWrite()) {
            File file2 = new File(file, "HtmlPanel");
            if (!file2.exists()) {
                file2.mkdir();
            }
            return file2;
        }
        return null;
    }

    private MJHtmlPanel(HtmlPanel<MJHtmlPanelActions> htmlPanel, MJHtmlPanelActions mJHtmlPanelActions) {
        this.fHtmlPanel = htmlPanel;
        this.fActions = mJHtmlPanelActions;
        this.fHtmlPanel.setActions((HtmlActions)mJHtmlPanelActions);
        htmlPanel.addHtmlActionStateManager((HtmlActionStateManager)new HtmlActionStateManager<MJHtmlPanelActions>(){

            public void updateActionStates(MJHtmlPanelActions mJHtmlPanelActions) {
                String string = MJHtmlPanel.this.fHtmlPanel.getSelectedText();
                boolean bl = string != null && string.length() > 0;
                for (MatlabHtmlActions.MatlabActionId matlabActionId : TEXT_SELECTION_ACTIONS) {
                    Action action = MJHtmlPanel.this.getActions().getMatlabAction(matlabActionId);
                    if (action == null) continue;
                    action.setEnabled(bl);
                }
            }
        });
        this.fRegistryId = HtmlComponentRegistry.registerHtmlComponent(this);
    }

    public static MJHtmlPanel createBrowser() {
        HtmlPanel htmlPanel = new HtmlPanel();
        return MJHtmlPanel.createBrowser((HtmlPanel<MJHtmlPanelActions>)htmlPanel);
    }

    static MJHtmlPanel createBrowser(HtmlPanel<MJHtmlPanelActions> htmlPanel) {
        MJHtmlPanelActions mJHtmlPanelActions = new MJHtmlPanelActions(htmlPanel);
        MJHtmlPanel mJHtmlPanel = new MJHtmlPanel(htmlPanel, mJHtmlPanelActions);
        mJHtmlPanel.finishSetup();
        return mJHtmlPanel;
    }

    private void finishSetup() {
        HTMLAcceleratorHelper hTMLAcceleratorHelper = new HTMLAcceleratorHelper(this.getComponent());
        Collection<MJAbstractAction> collection = this.getActions().getAllActions();
        for (MJAbstractAction mJAbstractAction : collection) {
            hTMLAcceleratorHelper.addAction((Action)mJAbstractAction);
        }
        this.addRequestHandler((RequestHandler)new MatlabRequestHandler(this, this.fRegistryId));
        this.getComponent().putClientProperty("mwjavaguitest.instance", this);
        this.fHtmlPanel.setPopupWindowListener((PopupWindowListener)new DefaultPopupWindowListener());
    }

    public void setHtmlContextMenuBuilder(HtmlContextMenuBuilder htmlContextMenuBuilder) {
        this.fHtmlPanel.setHtmlContextMenuBuilder(htmlContextMenuBuilder);
    }

    public JComponent getComponent() {
        return this.fHtmlPanel.getComponent();
    }

    public boolean isInitialized() {
        return this.fHtmlPanel.isInitialized();
    }

    public void setCurrentLocation(String string) {
        if (MJHtmlPanel.decodeUrl(string)) {
            string = EncodingUtils.decodeUrl((String)string);
        }
        this.fHtmlPanel.setCurrentLocation(string);
    }

    private static boolean decodeUrl(String string) {
        return PlatformInfo.isWindows64() && string.startsWith("file:") && Locale.getDefault().getLanguage().equals(Locale.JAPANESE.getLanguage()) && EncodingUtils.needsDecoding((String)string);
    }

    public String getCurrentLocation() {
        return this.fHtmlPanel.getCurrentLocation();
    }

    public void setHtmlText(String string) {
        this.fHtmlPanel.setHtmlText(string);
    }

    public String getTitle() {
        return this.fHtmlPanel.getTitle();
    }

    public void executeScript(String string) {
        this.fHtmlPanel.executeScript(string);
    }

    public void executeScript(String string, HtmlDataListener<String> htmlDataListener) {
        this.fHtmlPanel.executeScript(string, htmlDataListener);
    }

    public String getSelectedText() {
        return this.fHtmlPanel.getSelectedText();
    }

    @Deprecated
    public void getSelectedText(HtmlDataListener<String> htmlDataListener) {
        this.fHtmlPanel.getSelectedText(htmlDataListener);
    }

    public void addSelectedTextListener(HtmlDataListener<String> htmlDataListener) {
        this.fHtmlPanel.addSelectedTextListener(htmlDataListener);
    }

    public void removeSelectedTextListener(HtmlDataListener<String> htmlDataListener) {
        this.fHtmlPanel.removeSelectedTextListener(htmlDataListener);
    }

    public String getHtmlText() {
        return this.fHtmlPanel.getHtmlText();
    }

    public boolean canGoBack() {
        return this.fHtmlPanel.canGoBack();
    }

    public void goBack() {
        this.fHtmlPanel.goBack();
    }

    public boolean canGoForward() {
        return this.fHtmlPanel.canGoForward();
    }

    public void goForward() {
        this.fHtmlPanel.goForward();
    }

    public void reload() {
        this.fHtmlPanel.reload();
    }

    public void setHomeUrl(String string) {
        this.fHtmlPanel.setHomeUrl(string);
    }

    public String getHomeUrl() {
        return this.fHtmlPanel.getHomeUrl();
    }

    public boolean isPrintingSupported() {
        return this.fHtmlPanel.isPrintingSupported();
    }

    public void print() {
        this.fHtmlPanel.print();
    }

    public void saveAs(File file) {
        this.fHtmlPanel.saveAs(file);
    }

    public void addPageChangedListener(PageChangedListener pageChangedListener) {
        this.fHtmlPanel.addPageChangedListener(pageChangedListener);
    }

    public void removePageChangedListener(PageChangedListener pageChangedListener) {
        this.fHtmlPanel.removePageChangedListener(pageChangedListener);
    }

    public void addStatusTextListener(StatusTextListener statusTextListener) {
        this.fHtmlPanel.addStatusTextListener(statusTextListener);
    }

    public void removeStatusTextListener(StatusTextListener statusTextListener) {
        this.fHtmlPanel.removeStatusTextListener(statusTextListener);
    }

    public void disableNavigation() {
        this.fHtmlPanel.disableNavigation();
    }

    public void dispose() {
        HtmlComponentRegistry.removeHtmlComponent(this.fRegistryId);
        this.fHtmlPanel.dispose();
    }

    public void findInPage(String string, Collection<FindOption> collection, HtmlDataListener<Boolean> htmlDataListener) {
        this.fHtmlPanel.findInPage(string, collection, htmlDataListener);
    }

    public MJHtmlPanelActions getActions() {
        return this.fActions;
    }

    public void setPopupWindowListener(PopupWindowListener<MJHtmlPanelActions> popupWindowListener) {
        this.fHtmlPanel.setPopupWindowListener(popupWindowListener);
    }

    public HtmlContextMenuBuilder<MJHtmlPanelActions> getContextMenuBuilder() {
        return this.fHtmlPanel.getContextMenuBuilder();
    }

    public int getRegistryId() {
        return this.fRegistryId;
    }

    public void addRequestHandler(RequestHandler requestHandler) {
        this.fHtmlPanel.addRequestHandler(requestHandler);
    }

    static {
        MJHtmlPanel.setupMozillaDirectory();
        File file = MJHtmlPanel.getResourceDirectory();
        if (file != null) {
            HtmlPanel.setResourceDirectory((File)file);
        }
        MJHtmlPanel.setupProxyListener();
    }

    private static enum MozillaPlatform {
        WIN32("windows"),
        GLNXA64("linux-64");

        private final String iXulRunnerDirName;

        private MozillaPlatform(String string2) {
            this.iXulRunnerDirName = "xulrunner-" + string2;
        }

        private String getMozillaDirUnderJxBrowser() {
            return String.format("%s/xulrunner/%s", this.toString().toLowerCase(Locale.ENGLISH), this.iXulRunnerDirName);
        }
    }
}

