/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.html.DefaultContextMenuBuilder;
import com.mathworks.html.HtmlUtils;
import com.mathworks.html.StandardHtmlActionId;
import com.mathworks.mlwidgets.html.MJHtmlPanel;
import com.mathworks.mlwidgets.html.MJHtmlPanelActions;
import com.mathworks.mlwidgets.html.MatlabHtmlActions;
import com.mathworks.mlwidgets.html.OpenUrlInBrowser;
import com.mathworks.mwswing.MJAbstractAction;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MatlabContextMenuBuilder
extends DefaultContextMenuBuilder<MatlabHtmlActions> {
    private final MatlabActionLabels fMatlabActionLabels;
    private final MJHtmlPanel fHtmlPanel;
    private final OpenUrlInBrowser fOpenUrlInBrowser;
    private MJAbstractAction fCustomEmptyAreaAction;

    public MatlabContextMenuBuilder(MJHtmlPanel mJHtmlPanel, OpenUrlInBrowser openUrlInBrowser) {
        this(mJHtmlPanel, openUrlInBrowser, null);
    }

    public MatlabContextMenuBuilder(MJHtmlPanel mJHtmlPanel, OpenUrlInBrowser openUrlInBrowser, MJAbstractAction mJAbstractAction) {
        this.fHtmlPanel = mJHtmlPanel;
        this.fOpenUrlInBrowser = openUrlInBrowser;
        this.fCustomEmptyAreaAction = mJAbstractAction;
        this.fMatlabActionLabels = new MatlabActionLabels();
    }

    public JPopupMenu buildContextMenu(MatlabHtmlActions matlabHtmlActions, Node node) {
        String string = this.fHtmlPanel.getSelectedText();
        if (string != null && string.length() > 0) {
            JPopupMenu jPopupMenu = this.createEmptyPopupMenu();
            List<Action> list = this.createSelectedTextActions();
            for (Action action : list) {
                jPopupMenu.add(action);
            }
            return jPopupMenu;
        }
        String string2 = this.getHrefFromTarget(node);
        if (string2 != null && string2.length() > 0) {
            JPopupMenu jPopupMenu = this.createEmptyPopupMenu();
            List<MJAbstractAction> list = this.createLinkClickedActions(string2);
            for (MJAbstractAction mJAbstractAction : list) {
                jPopupMenu.add((Action)mJAbstractAction);
            }
            return jPopupMenu;
        }
        JPopupMenu jPopupMenu = this.createEmptyPopupMenu();
        List<MJAbstractAction> list = this.createEmptyAreaActions();
        for (MJAbstractAction mJAbstractAction : list) {
            jPopupMenu.add((Action)mJAbstractAction);
        }
        return jPopupMenu;
    }

    private String getHrefFromTarget(Node node) {
        int n = 0;
        do {
            String string;
            Node node2;
            NamedNodeMap namedNodeMap;
            if (node.hasAttributes() && (namedNodeMap = node.getAttributes()) != null && (node2 = namedNodeMap.getNamedItem("href")) != null && (string = node2.getNodeValue()) != null && !this.isInvalidHref(string)) {
                string = this.correctUrl(string);
                return string;
            }
            node = node.getParentNode();
        } while (++n < 3 && node != null);
        return null;
    }

    private String correctUrl(String string) {
        if (HtmlUtils.isValidUrl((String)string)) {
            return string;
        }
        String string2 = MatlabContextMenuBuilder.getCurrentLocationDir(this.fHtmlPanel.getCurrentLocation());
        return string2 + string;
    }

    private boolean isInvalidHref(String string) {
        return string.startsWith("matlab:") || string.startsWith("javascript:") || string.endsWith("#");
    }

    private static String getCurrentLocationDir(String string) {
        if (string == null) {
            return null;
        }
        String string2 = HelpBrowserUtils.removeAllQueryStringsFromUrl((String)string);
        int n = string2.lastIndexOf(47);
        string2 = string2.substring(0, n + 1);
        return string2;
    }

    private List<Action> createSelectedTextActions() {
        LinkedList<Action> linkedList = new LinkedList<Action>();
        MJHtmlPanelActions mJHtmlPanelActions = this.fHtmlPanel.getActions();
        linkedList.add(mJHtmlPanelActions.getMatlabAction(MatlabHtmlActions.MatlabActionId.EVALUATE_SELECTION));
        linkedList.add(mJHtmlPanelActions.getMatlabAction(MatlabHtmlActions.MatlabActionId.HELP_ON_SELECTION));
        linkedList.add((Action)mJHtmlPanelActions.getBasicActions().get(StandardHtmlActionId.COPY));
        linkedList.add(mJHtmlPanelActions.getMatlabAction(MatlabHtmlActions.MatlabActionId.OPEN_SELECTION));
        return linkedList;
    }

    private List<MJAbstractAction> createLinkClickedActions(String string) {
        LinkedList<MJAbstractAction> linkedList = new LinkedList<MJAbstractAction>();
        linkedList.add(new OpenCurrentTabAction("open-current-tab", string));
        linkedList.add(new OpenNewTabAction("open-new-tab", string));
        return linkedList;
    }

    private List<MJAbstractAction> createEmptyAreaActions() {
        LinkedList<MJAbstractAction> linkedList = new LinkedList<MJAbstractAction>();
        linkedList.add(this.fHtmlPanel.getActions().getBasicActions().get(StandardHtmlActionId.PRINT));
        linkedList.add(this.fHtmlPanel.getActions().getBasicActions().get(StandardHtmlActionId.VIEW_SOURCE));
        linkedList.add(this.fHtmlPanel.getActions().getBasicActions().get(StandardHtmlActionId.SAVE_AS));
        if (this.fCustomEmptyAreaAction != null) {
            linkedList.add(this.fCustomEmptyAreaAction);
        }
        return linkedList;
    }

    private class OpenNewTabAction
    extends LinkClickedAction {
        private OpenNewTabAction(String string, String string2) {
            super(string, string2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MatlabContextMenuBuilder.this.fOpenUrlInBrowser.openInNewTab(this.getUrl());
        }
    }

    private class OpenCurrentTabAction
    extends LinkClickedAction {
        private OpenCurrentTabAction(String string, String string2) {
            super(string, string2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MatlabContextMenuBuilder.this.fOpenUrlInBrowser.openInCurrentTab(this.getUrl());
        }
    }

    private abstract class LinkClickedAction
    extends MJAbstractAction {
        private final String iUrl;

        private LinkClickedAction(String string, String string2) {
            super(MatlabContextMenuBuilder.this.fMatlabActionLabels.getActionLabel(string));
            this.iUrl = string2;
        }

        protected String getUrl() {
            return this.iUrl;
        }
    }

    private class MatlabActionLabels {
        private final ResourceBundle LABEL_BUNDLE = ResourceBundle.getBundle("com.mathworks.mlwidgets.html.resources.RES_HTMLRenderer");

        private MatlabActionLabels() {
        }

        public String getActionLabel(String string) {
            return this.LABEL_BUNDLE.getString("Action." + string);
        }
    }
}

