/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlUtils;
import com.mathworks.html.ProtocolRequestHandler;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mwswing.MJOptionPane;
import java.awt.Component;
import java.awt.Window;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;

public class MatlabRequestHandler
extends ProtocolRequestHandler {
    private static final Pattern MATLAB_FORM_DATA_PATTERN = Pattern.compile("^([\\w.]+)\\?");
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s");
    private static boolean sFromExternalIsOk = false;
    private final HtmlComponent fHtmlComponent;
    private final int fRegistryId;

    public MatlabRequestHandler(HtmlComponent htmlComponent, int n) {
        super(new String[]{"matlab"});
        this.fHtmlComponent = htmlComponent;
        this.fRegistryId = n;
    }

    protected void handleMatchedUrl(String string) {
        new Thread(new MatlabCommandRunnable(string)).start();
    }

    private boolean allowRequest() {
        if (this.isReferrerExternal() && !sFromExternalIsOk) {
            return this.showSecurityDialog();
        }
        return true;
    }

    public boolean isReferrerExternal() {
        String string = this.fHtmlComponent.getCurrentLocation();
        return MatlabRequestHandler.isReferrerExternal(string);
    }

    public static boolean isReferrerExternal(String string) {
        if (string != null && string.trim().length() > 0) {
            if ((string = HtmlUtils.correctUrl((String)string)).matches("^(file|matlab|linkerr|text):.*$") || string.equals("about:blank")) {
                return false;
            }
            return !string.matches("^https?://([^/]+\\.)?mathworks.com.*$");
        }
        return false;
    }

    private boolean showSecurityDialog() {
        String string;
        String string2;
        Window window = SwingUtilities.windowForComponent(this.fHtmlComponent.getComponent());
        int n = MJOptionPane.showConfirmDialog((Component)window, (Object)(string2 = HTMLUtils.sRes.getString("alert.security_warning")), (String)(string = HTMLUtils.sRes.getString("alert.security_warning_title")), (int)2, (int)2);
        if (n == 0) {
            sFromExternalIsOk = true;
            return true;
        }
        return false;
    }

    private String buildMatlabEvalString(String string) {
        string = MatlabRequestHandler.cleanUpMatlabUrl(string);
        int n = MatlabRequestHandler.getMatlabUrlFormDataStart(string = string.replaceAll("\\$browser", "webutils.Browser(" + String.valueOf(this.fRegistryId) + ")"));
        if (n > -1) {
            String string2 = string.substring(n);
            string = string.substring(0, n);
            return MatlabRequestHandler.buildMatlabFormEvalString(string, string2);
        }
        return string;
    }

    private static int getMatlabUrlFormDataStart(String string) {
        Matcher matcher = MATLAB_FORM_DATA_PATTERN.matcher(string);
        if (matcher.find()) {
            return matcher.end(1);
        }
        return -1;
    }

    private static String buildMatlabFormEvalString(String string, String string2) {
        if (SPACE_PATTERN.matcher(string).find()) {
            return string + " " + string2;
        }
        return MatlabRequestHandler.buildFunctionSyntaxEvalString(string, string2);
    }

    private static String buildFunctionSyntaxEvalString(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append("('").append(string2).append("')");
        return stringBuilder.toString();
    }

    private static String cleanUpMatlabUrl(String string) {
        if ((string = HTMLUtils.needsDecoding(string = string.replaceFirst("^(matlab:)?(%20)+", "$1 ")) ? HTMLUtils.decodeUrl(string) : string.replaceAll("%20", " ")).startsWith("matlab:")) {
            string = string.substring("matlab:".length());
        }
        return string;
    }

    private class MatlabCommandRunnable
    implements Runnable {
        private final String iUrl;

        private MatlabCommandRunnable(String string) {
            this.iUrl = string;
        }

        @Override
        public void run() {
            if (MatlabRequestHandler.this.allowRequest()) {
                String string = MatlabRequestHandler.this.buildMatlabEvalString(this.iUrl);
                new Matlab().evalConsoleOutput(string);
            }
        }
    }
}

