/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.GeneratedCode;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import java.util.List;

public class BlankRowExcludeRule
extends WorksheetRule {
    @Override
    public WorksheetRule.RuleType getType() {
        return WorksheetRule.RuleType.ROWEXCLUDE;
    }

    public static WorksheetRule.RuleType getRuleType() {
        return WorksheetRule.RuleType.ROWEXCLUDE;
    }

    @Override
    public Object clone() {
        return new BlankRowExcludeRule();
    }

    @Override
    public String getSummaryComment() {
        return ImportToolUtils.getResourceString("codeGen.blankrowexcludesummary");
    }

    @Override
    public boolean codeGenUsesDates() {
        return false;
    }

    @Override
    public boolean codeGenNeedsNaNConvert() {
        return true;
    }

    @Override
    public void generateMatlabCode(List<WorksheetRule> list, GeneratedCode generatedCode) {
        boolean bl = WorksheetRule.isRuleFollowedByDateRule(list, this);
        generatedCode.addCode("\n%% ");
        generatedCode.addCode(ImportToolUtils.getResourceString("CodeGen.excluderow"));
        generatedCode.addCode("\n");
        generatedCode.addCode(generatedCode.getRowExclusionIndex());
        generatedCode.addCode(" = any(cellfun(@(x) isempty(x) || (ischar(x) && all(x==' ')),");
        generatedCode.addCode(generatedCode.getRawCellArray());
        generatedCode.addCode("),2); % ");
        generatedCode.addCode(ImportToolUtils.getResourceString("CodeGen.findblankcellrow"));
        generatedCode.addCode("\n");
        BlankRowExcludeRule.generateExcludeRows(generatedCode, generatedCode.getRawCellArray());
        if (generatedCode.usesCellVectors()) {
            BlankRowExcludeRule.generateExcludeRows(generatedCode, generatedCode.getCellVectors());
        }
        if (bl) {
            BlankRowExcludeRule.generateExcludeRows(generatedCode, generatedCode.getDateArray());
        }
    }

    private static void generateExcludeRows(GeneratedCode generatedCode, String string) {
        generatedCode.addCode(string);
        generatedCode.addCode("(");
        generatedCode.addCode(generatedCode.getRowExclusionIndex());
        generatedCode.addCode(",:) = [];\n");
    }

    @Override
    public String getApplyFcn() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(AbstractSpreadsheetPath);
        stringBuilder.append(".");
        stringBuilder.append("blankExcludeRowFcn");
        return stringBuilder.toString();
    }

    public String toString() {
        return ImportToolUtils.getResourceString("RuleType.blankcells");
    }
}

