/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabException;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.mlwidgets.importtool.DateParsingRule;
import com.mathworks.mlwidgets.importtool.ImportClient;
import com.mathworks.mlwidgets.importtool.ParseRule;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.util.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class TextscanTextParser {
    public volatile Object fTextFileImporterMCOS;
    public volatile boolean fIsDefaultFixedWidth = false;
    public volatile String fDefaultDelimiter;
    public volatile List<Integer> fDefaultFixedWidths;
    public volatile String fDefaultDecimalSeparator;
    public volatile HashMap<String, Integer> fDefaultDelimitersMap;
    public volatile int fDefaultHeaderRow;
    public volatile int fDefaultSelectionStartRow;
    public volatile int fDefaultSelectionStartColumn;
    public volatile boolean fInitialized = false;
    public volatile boolean fCanRead = true;

    protected TextscanTextParser() {
    }

    public TextscanTextParser(String string) {
        this(new File(string), false);
    }

    public TextscanTextParser(File file) {
        this(file, false);
    }

    void cleanup() {
        if (!Matlab.isMatlabAvailable()) {
            this.fTextFileImporterMCOS = null;
            return;
        }
        Matlab.whenMatlabIdle((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Matlab.mtFeval((String)"delete", (Object[])new Object[]{TextscanTextParser.this.fTextFileImporterMCOS}, (int)0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                TextscanTextParser.this.fTextFileImporterMCOS = null;
            }
        });
    }

    public TextscanTextParser(final File file, final boolean bl) {
        if (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread()) {
            this.createMatlabTextFileImporter(file, bl);
        } else {
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    TextscanTextParser.this.createMatlabTextFileImporter(file, bl);
                }
            });
        }
    }

    public Object feval(String string, Object[] objectArray, int n) throws Exception {
        return Matlab.mtFeval((String)string, (Object[])objectArray, (int)n);
    }

    protected void createMatlabTextFileImporter(File file, boolean bl) {
        try {
            double[] dArray;
            double[] dArray2;
            double[] dArray3;
            this.fTextFileImporterMCOS = this.feval("internal.matlab.importtool.TextFileImporter", new Object[]{file.getAbsoluteFile()}, 1);
            boolean[] blArray = (boolean[])this.feval("isDefaultFixedWidth", new Object[]{this.fTextFileImporterMCOS}, 1);
            this.fIsDefaultFixedWidth = blArray[0];
            this.fDefaultFixedWidths = this.getDefaultFixedWidthColumnPositions();
            this.fDefaultDelimiter = (String)this.feval("getDefaultDelimiter", new Object[]{this.fTextFileImporterMCOS}, 1);
            this.setMultipleDelimsAsOne(" ".equals(this.fDefaultDelimiter));
            this.fDefaultDecimalSeparator = (String)this.feval("getDefaultDecimalSeparator", new Object[]{this.fTextFileImporterMCOS}, 1);
            this.fDefaultDelimitersMap = this.findDelimiters();
            if (this.fIsDefaultFixedWidth) {
                double[] dArray4 = new double[this.fDefaultFixedWidths.size()];
                for (int i = 0; i < dArray4.length; ++i) {
                    dArray4[i] = this.fDefaultFixedWidths.get(i).intValue();
                }
                Object[] objectArray = (Object[])this.feval("getDefaultHeaderRow", new Object[]{this.fTextFileImporterMCOS, null, dArray4}, 3);
                dArray3 = (double[])objectArray[0];
                dArray2 = (double[])objectArray[1];
                dArray = (double[])objectArray[2];
            } else {
                Object[] objectArray = (Object[])this.feval("getDefaultHeaderRow", new Object[]{this.fTextFileImporterMCOS, this.fDefaultDelimiter}, 3);
                dArray3 = (double[])objectArray[0];
                dArray2 = (double[])objectArray[1];
                dArray = (double[])objectArray[2];
            }
            this.fDefaultHeaderRow = (int)dArray3[0] - 1;
            this.fDefaultSelectionStartRow = (int)dArray2[0] - 1;
            this.fDefaultSelectionStartColumn = (int)dArray[0] - 1;
            if (bl) {
                this.setFixedWidth(this.fIsDefaultFixedWidth);
                this.setFixedWidthColumnPositions(this.fDefaultFixedWidths);
                this.setDelimiters(Arrays.asList(this.fDefaultDelimiter));
                this.setDecimalSeparator(this.fDefaultDecimalSeparator);
            }
            this.fInitialized = true;
        }
        catch (MatlabException matlabException) {
            this.fCanRead = false;
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
    }

    public boolean canRead() {
        return this.fCanRead;
    }

    public boolean isIntialized() {
        return this.fInitialized;
    }

    public void close() {
        this.fTextFileImporterMCOS = null;
        this.fIsDefaultFixedWidth = false;
        this.fDefaultDelimiter = null;
        this.fDefaultFixedWidths = null;
        this.fDefaultDecimalSeparator = null;
        this.fInitialized = false;
    }

    public HashMap<String, Integer> findDelimiters() {
        assert (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread());
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (this.fTextFileImporterMCOS != null) {
            try {
                Object[] objectArray = (Object[])this.feval("findDelimiters", new Object[]{this.fTextFileImporterMCOS}, 2);
                String[] stringArray = (String[])objectArray[0];
                double[] dArray = (double[])objectArray[1];
                for (int i = 0; i < stringArray.length; ++i) {
                    hashMap.put(stringArray[i], (int)dArray[i]);
                }
                return hashMap;
            }
            catch (Exception exception) {
                return hashMap;
            }
        }
        return hashMap;
    }

    public int getDefaultHeaderRow() {
        return this.fDefaultHeaderRow;
    }

    public int[] getDefaultSelectionStartCell() {
        return new int[]{this.fDefaultSelectionStartRow, this.fDefaultSelectionStartColumn};
    }

    public HashMap<String, Integer> getDefaultDelimitersMap() {
        return this.fDefaultDelimitersMap;
    }

    public boolean isDefaultFixedWidth() {
        return this.fIsDefaultFixedWidth;
    }

    public String getDefaultDelimiter() {
        return this.fDefaultDelimiter;
    }

    public String getDefaultDecimalSeparator() {
        return this.fDefaultDecimalSeparator;
    }

    public void setFixedWidthColumnPositions(final List<Integer> list) {
        if (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread()) {
            this.setFixedWidthColumnPositionsinMatlab(list);
        } else {
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    TextscanTextParser.this.setFixedWidthColumnPositionsinMatlab(list);
                }
            });
        }
    }

    private void setFixedWidthColumnPositionsinMatlab(List<Integer> list) {
        if (this.fTextFileImporterMCOS != null) {
            try {
                double[] dArray = new double[list.size()];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = list.get(i).intValue();
                }
                this.feval("setFixedWidthColumnPositions", new Object[]{this.fTextFileImporterMCOS, dArray}, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public List<Integer> getFixedWidthColumnPositions() {
        assert (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread());
        if (this.fTextFileImporterMCOS != null) {
            try {
                double[] dArray = (double[])this.feval("getFixedWidthColumnPositions", new Object[]{this.fTextFileImporterMCOS}, 1);
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (double d : dArray) {
                    arrayList.add((int)d);
                }
                return arrayList;
            }
            catch (Exception exception) {
                return new ArrayList<Integer>();
            }
        }
        return new ArrayList<Integer>();
    }

    public List<Integer> getDefaultFixedWidthColumnPositions() {
        if (this.fDefaultFixedWidths != null) {
            return this.fDefaultFixedWidths;
        }
        assert (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread());
        if (this.fTextFileImporterMCOS != null) {
            try {
                double[] dArray = (double[])this.feval("getDefaultFixedWidths", new Object[]{this.fTextFileImporterMCOS}, 1);
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (double d : dArray) {
                    arrayList.add((int)d);
                }
                return arrayList;
            }
            catch (Exception exception) {
                return new ArrayList<Integer>();
            }
        }
        return new ArrayList<Integer>();
    }

    public void addFixedWidthColumnPosition(final int n) {
        if (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread()) {
            this.utAddFixedWidthColumnPosition(n);
        } else {
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    TextscanTextParser.this.utAddFixedWidthColumnPosition(n);
                }
            });
        }
    }

    private void utAddFixedWidthColumnPosition(int n) {
        List<Integer> list = this.getFixedWidthColumnPositions();
        list.add(n);
        this.setFixedWidthColumnPositions(list);
    }

    public void removeFixedWidthColumnPosition(final int n) {
        if (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread()) {
            this.utRemoveFixedWidthColumnPosition(n);
        } else {
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    TextscanTextParser.this.utRemoveFixedWidthColumnPosition(n);
                }
            });
        }
    }

    private void utRemoveFixedWidthColumnPosition(int n) {
        List<Integer> list = this.getFixedWidthColumnPositions();
        list.remove(new Integer(n));
        this.setFixedWidthColumnPositions(list);
    }

    public boolean isFixedWidth() {
        assert (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread());
        if (this.fTextFileImporterMCOS != null) {
            try {
                boolean[] blArray = (boolean[])this.feval("isFixedWidth", new Object[]{this.fTextFileImporterMCOS}, 1);
                return blArray[0];
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public boolean isMultipleDelimsAsOne() {
        assert (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread());
        if (this.fTextFileImporterMCOS != null) {
            try {
                boolean[] blArray = (boolean[])this.feval("isMultipleDelimsAsOne", new Object[]{this.fTextFileImporterMCOS}, 1);
                return blArray[0];
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public void setFixedWidth(final boolean bl) {
        if (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread()) {
            this.setFixedWidthInMatlab(bl);
        } else {
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    TextscanTextParser.this.setFixedWidthInMatlab(bl);
                }
            });
        }
    }

    public void setMultipleDelimsAsOne(final boolean bl) {
        if (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread()) {
            this.setMultipleDelimsAsOneInMatlab(bl);
        } else {
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    TextscanTextParser.this.setMultipleDelimsAsOneInMatlab(bl);
                }
            });
        }
    }

    private void setMultipleDelimsAsOneInMatlab(boolean bl) {
        if (this.fTextFileImporterMCOS != null) {
            try {
                this.feval("setMultipleDelimsAsOne", new Object[]{this.fTextFileImporterMCOS, bl}, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setFixedWidthInMatlab(boolean bl) {
        if (this.fTextFileImporterMCOS != null) {
            try {
                this.feval("setFixedWidth", new Object[]{this.fTextFileImporterMCOS, bl}, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setDecimalSeparator(String string) {
        assert (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread());
        if (this.fTextFileImporterMCOS != null) {
            try {
                this.feval("setDecimalSeparator", new Object[]{this.fTextFileImporterMCOS, string}, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getDecimalSeparator() {
        assert (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread());
        if (this.fTextFileImporterMCOS != null) {
            try {
                return (String)this.feval("getDecimalSeparator", new Object[]{this.fTextFileImporterMCOS}, 1);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public List<String> getDelimiters() {
        assert (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread());
        if (this.fTextFileImporterMCOS != null) {
            try {
                Object[] objectArray = (Object[])this.feval("getDelimiters", new Object[]{this.fTextFileImporterMCOS}, 1);
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Object object : objectArray) {
                    arrayList.add((String)object);
                }
                return arrayList;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public boolean useFastPath(String[][] stringArray, List<ParseRule> list, List<WorksheetRule> list2) {
        assert (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread());
        if (this.fTextFileImporterMCOS != null) {
            try {
                boolean[] blArray = (boolean[])this.feval("UseFastPath", new Object[]{this.fTextFileImporterMCOS, stringArray, list.toArray(new ParseRule[1]), list2.toArray(new WorksheetRule[1])}, 1);
                return blArray[0];
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public String getTextscanFormat(int[] nArray, List<ParseRule> list) {
        assert (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread());
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i] + 1;
        }
        if (this.fTextFileImporterMCOS != null) {
            try {
                return (String)this.feval("generateFormatString", new Object[]{this.fTextFileImporterMCOS, nArray2, list.toArray(new ParseRule[1])}, 1);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public String getSlowPathTextscanFormat(int[] nArray) {
        assert (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread());
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i] + 1;
        }
        if (this.fTextFileImporterMCOS != null) {
            try {
                return (String)this.feval("generateFormatString", new Object[]{this.fTextFileImporterMCOS, nArray2}, 1);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public int getColumnCount() {
        assert (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread());
        if (this.fTextFileImporterMCOS != null) {
            try {
                double[] dArray = (double[])this.feval("getColumnCount", new Object[]{this.fTextFileImporterMCOS}, 1);
                return (int)dArray[0];
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return 0;
    }

    public int getRowCount() {
        assert (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread());
        if (this.fTextFileImporterMCOS != null) {
            try {
                double[] dArray = (double[])this.feval("getRowCount", new Object[]{this.fTextFileImporterMCOS}, 1);
                return (int)dArray[0];
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return 0;
    }

    public int getEmptyRowCount() {
        assert (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread());
        if (this.fTextFileImporterMCOS != null) {
            try {
                double[] dArray = (double[])this.feval("getEmptyRowCount", new Object[]{this.fTextFileImporterMCOS}, 1);
                return (int)dArray[0];
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return 0;
    }

    public void setDelimiters(final List<String> list) {
        if (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread()) {
            this.setDelimitersInMatlab(list);
        } else {
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    TextscanTextParser.this.setDelimitersInMatlab(list);
                }
            });
        }
    }

    private void setDelimitersInMatlab(List<String> list) {
        if (this.fTextFileImporterMCOS != null) {
            try {
                this.feval("setDelimiters", new Object[]{this.fTextFileImporterMCOS, list.toArray()}, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void init() {
        assert (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread());
        if (this.fTextFileImporterMCOS != null) {
            try {
                this.feval("init", new Object[]{this.fTextFileImporterMCOS}, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public List<List<Object>> read(int n, int n2, int n3, int n4) {
        assert (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread());
        if (this.fTextFileImporterMCOS != null) {
            try {
                Object[] objectArray = (Object[])this.feval("Read", new Object[]{this.fTextFileImporterMCOS, n + 1, n2 + 1, n3 + 1, n4 + 1}, 3);
                Object[] objectArray2 = (Object[])objectArray[0];
                double[] dArray = (double[])objectArray[1];
                double[] dArray2 = (double[])objectArray[2];
                int n5 = (int)dArray[0];
                int n6 = (int)dArray2[0];
                ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>();
                for (int i = 0; i < n5; ++i) {
                    ArrayList<Object> arrayList2 = new ArrayList<Object>();
                    for (int j = 0; j < n6 && objectArray2[i + j * n5] != null; ++j) {
                        arrayList2.add(objectArray2[i + j * n5]);
                    }
                    arrayList.add(arrayList2);
                }
                return arrayList;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public static class ColumnMetaData {
        private volatile List<ParseRule> iDefaultRules;
        private volatile List<ParseRule> iRules;
        private volatile List<DateParsingRule[]> iDateRules;
        private volatile ParseRule iDefaultNumericParseRule;
        private volatile String[] iDefaultColumnVariableNames;
        private volatile int[] iColumnCharacterPositions;
        private volatile int iHeaderRow;
        private volatile boolean fIsValid;

        public ColumnMetaData(TextscanTextParser textscanTextParser) {
            this(textscanTextParser, -1);
        }

        ColumnMetaData(TextscanTextParser textscanTextParser, int n) {
            assert (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread());
            try {
                int n2;
                double[] dArray = (double[])this.feval("getColumnCount", new Object[]{textscanTextParser}, 1);
                int n3 = (int)dArray[0];
                Object[] objectArray = (Object[])this.feval("findDefaultParseRules", new Object[]{textscanTextParser.fTextFileImporterMCOS}, 3);
                Object[] objectArray2 = (Object[])objectArray[1];
                this.iDateRules = new ArrayList<DateParsingRule[]>();
                for (int i = 0; i < n3; ++i) {
                    n2 = objectArray2.length / n3;
                    DateParsingRule[] dateParsingRuleArray = new DateParsingRule[n2];
                    for (int j = 0; j < n2; ++j) {
                        dateParsingRuleArray[j] = (DateParsingRule)objectArray2[i * n2 + j];
                    }
                    this.iDateRules.add(dateParsingRuleArray);
                }
                Object[] objectArray3 = (Object[])objectArray[0];
                this.iDefaultRules = new ArrayList<ParseRule>();
                for (n2 = 0; n2 < objectArray3.length; ++n2) {
                    this.iDefaultRules.add((ParseRule)objectArray3[n2]);
                }
                this.iRules = this.iDefaultRules;
                this.iDefaultNumericParseRule = (ParseRule)objectArray[2];
                double[] dArray2 = (double[])this.feval("getCharacterCounts", new Object[]{textscanTextParser.fTextFileImporterMCOS}, 1);
                this.iColumnCharacterPositions = new int[dArray2.length];
                for (int i = 0; i < this.iColumnCharacterPositions.length; ++i) {
                    this.iColumnCharacterPositions[i] = (int)dArray2[i];
                }
                if (n < 0) {
                    n = textscanTextParser.getDefaultHeaderRow();
                }
                this.updateDefaultColumnVariableNames(textscanTextParser, n);
                this.fIsValid = true;
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        }

        protected Object feval(String string, Object[] objectArray, int n) throws Exception {
            return Matlab.mtFeval((String)string, (Object[])objectArray, (int)n);
        }

        public List<ParseRule> getParseRules(ImportClient.TargetType targetType) {
            if (targetType == ImportClient.TargetType.MATRIX) {
                ArrayList<ParseRule> arrayList = new ArrayList<ParseRule>(this.iRules);
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (arrayList.get(i) != null) continue;
                    arrayList.set(i, this.iDefaultNumericParseRule);
                }
                return arrayList;
            }
            return this.iRules;
        }

        public void setParseRules(List<ParseRule> list) {
            this.iRules = list;
        }

        public List<DateParsingRule[]> getDefaultDateParseRules() {
            return this.iDateRules;
        }

        public void setDefaultDateParseRules(List<DateParsingRule[]> list) {
            this.iDateRules = list;
        }

        public String[] getDefaultColumnVariableNames() {
            return this.iDefaultColumnVariableNames;
        }

        public void updateDefaultColumnVariableNames(TextscanTextParser textscanTextParser, int n) {
            assert (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread());
            this.iHeaderRow = n;
            if (this.iHeaderRow >= 0) {
                try {
                    this.iDefaultColumnVariableNames = (String[])this.feval("getDefaultColumnNames", new Object[]{textscanTextParser.fTextFileImporterMCOS, this.iHeaderRow + 1}, 1);
                }
                catch (Exception exception) {
                    this.iDefaultColumnVariableNames = null;
                }
            } else {
                this.iDefaultColumnVariableNames = new String[this.iDefaultRules.size()];
                for (int i = 0; i < this.iDefaultColumnVariableNames.length; ++i) {
                    this.iDefaultColumnVariableNames[i] = "VarName" + Integer.toString(i);
                }
            }
        }

        int[] getColumnCharacterPositions() {
            return this.iColumnCharacterPositions;
        }

        ParseRule getDefaultNumericParseRule() {
            return this.iDefaultNumericParseRule;
        }

        public int getHeaderRow() {
            return this.iHeaderRow;
        }

        public void setHeaderRow(int n) {
            this.iHeaderRow = n;
        }

        public void setValid(boolean bl) {
            this.fIsValid = bl;
        }

        public boolean isValid() {
            return this.fIsValid;
        }
    }
}

