/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.importtool.ImportCellRenderer;
import com.mathworks.mlwidgets.importtool.ImportTable;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.TextTable;
import com.mathworks.mlwidgets.importtool.VariableInfoTab;
import com.mathworks.mlwidgets.importtool.WorksheetRulePanel;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.widgets.spreadsheet.IHeaderRenderer;
import com.mathworks.widgets.spreadsheet.SpreadsheetColor;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.table.TableCellEditor;

public class VariableHeaderRenderer
extends AbstractCellEditor
implements IHeaderRenderer,
TableCellEditor {
    static ImageIcon sWarningIcon = new ImageIcon(VariableInfoTab.class.getResource("/com/mathworks/mlwidgets/importtool/resources/warning_small.gif"));
    private MJPanel fPanel;
    private HighlightLabel fVarNameRendererLabel;
    private JLabel fLabel;
    private Component fGroupVariableFiller;
    private EditorMouseFocusLostListener fEditorMouseFocusLostListener = new EditorMouseFocusLostListener();
    private JLabel fEditorLabel;
    private MJTextField fVarNameEditorTextField;
    private MJPanel fEditorPanel;
    private Component fEditGroupVariableFiller;
    private Font fLabelFont;
    private JTable fTable = null;
    private SpreadsheetColor fSpreadsheetColor;
    private Border fBorderUnselected;
    protected Color fRowHeaderColorSelected = new Color(200, 200, 200);
    protected Color fRowHeaderColorUnselected = new Color(241, 242, 244);
    private int fHoverColumn = -1;
    public static int DEFAULT_HORIZONTAL_GAP = 5;
    public static int DEFAULT_VERTICAL_GAP = 0;
    private ImportDataHeader fLastEditedImportDataHeader;
    private boolean fVariableNamesRowVisible = true;
    private boolean fGroupVariableNamesRowVisible = false;
    public static final int GroupVariableFillerHeight = 20;
    protected final Border fBevelBorder = BorderFactory.createBevelBorder(1);

    public VariableHeaderRenderer(JTable jTable) {
        this.fTable = jTable;
        this.fLabel = new MJLabel("", 0);
        this.fLabel.setAlignmentX(0.5f);
        this.fEditorLabel = new MJLabel("", 0);
        this.fEditorLabel.setAlignmentX(0.5f);
        this.fLabel.setPreferredSize(new Dimension(0, 20));
        this.fLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.fEditorLabel.setPreferredSize(new Dimension(0, 20));
        this.fEditorLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.fGroupVariableFiller = Box.createRigidArea(new Dimension(1, 20));
        this.fGroupVariableFiller.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.fEditGroupVariableFiller = Box.createRigidArea(new Dimension(1, 20));
        this.fEditGroupVariableFiller.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        if (Matlab.isMatlabAvailable()) {
            this.fSpreadsheetColor = new SpreadsheetColor(jTable);
            this.fSpreadsheetColor.registerColorInterests();
            this.fBorderUnselected = BorderFactory.createMatteBorder(0, 0, 0, 1, this.fSpreadsheetColor.getHeaderUnselectedLine());
        } else {
            this.fBorderUnselected = BorderFactory.createMatteBorder(0, 0, 0, 1, Color.GRAY);
        }
        this.fPanel = new MJPanel();
        this.fPanel.setLayout((LayoutManager)new BoxLayout((Container)this.fPanel, 3));
        this.fVarNameRendererLabel = new HighlightLabel();
        this.fVarNameRendererLabel.setAlignmentX(0.5f);
        this.fVarNameRendererLabel.setOpaque(true);
        this.fVarNameRendererLabel.setHorizontalAlignment(0);
        this.fVarNameRendererLabel.setPreferredSize(new Dimension(0, 20));
        this.fVarNameRendererLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.fVarNameRendererLabel.setBorder(null);
        this.fVarNameEditorTextField = new MJTextField();
        this.fVarNameEditorTextField.setAlignmentX(0.5f);
        this.fEditorPanel = new MJPanel(){

            public void requestFocus() {
                VariableHeaderRenderer.this.fVarNameEditorTextField.requestFocus();
                VariableHeaderRenderer.this.fVarNameEditorTextField.selectAll();
            }
        };
        this.fEditorPanel.setLayout((LayoutManager)new BoxLayout((Container)this.fEditorPanel, 3));
        this.fVarNameEditorTextField.setHorizontalAlignment(0);
        this.fVarNameEditorTextField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    VariableHeaderRenderer.this.fireEditingStopped();
                }
            }
        });
        this.fVarNameEditorTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VariableHeaderRenderer.this.fireEditingStopped();
            }
        });
        this.fVarNameEditorTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                super.keyPressed(keyEvent);
                if (keyEvent.getKeyCode() == 27) {
                    VariableHeaderRenderer.this.cancelCellEditing();
                }
            }
        });
        this.fVarNameEditorTextField.setPreferredSize(new Dimension(0, 20));
        this.fVarNameEditorTextField.setBorder(this.fBevelBorder);
        this.fLabel.setHorizontalAlignment(0);
        this.fLabel.setHorizontalTextPosition(0);
        this.fPanel.add((Component)this.fLabel);
        this.fPanel.add(this.fGroupVariableFiller);
        this.fPanel.add((Component)((Object)this.fVarNameRendererLabel));
        this.fEditorPanel.add((Component)this.fEditorLabel);
        this.fEditorPanel.add(this.fEditGroupVariableFiller);
        this.fEditorPanel.add((Component)this.fVarNameEditorTextField);
    }

    protected void updatePanelLayout() {
        this.fPanel.removeAll();
        this.fPanel.add((Component)this.fLabel);
        if (this.fGroupVariableNamesRowVisible) {
            this.fPanel.add(this.fGroupVariableFiller);
        }
        if (this.fVariableNamesRowVisible) {
            this.fPanel.add((Component)((Object)this.fVarNameRendererLabel));
        }
        this.fEditorPanel.removeAll();
        this.fEditorPanel.add((Component)this.fEditorLabel);
        if (this.fGroupVariableNamesRowVisible) {
            this.fEditorPanel.add(this.fEditGroupVariableFiller);
        }
        if (this.fVariableNamesRowVisible) {
            this.fEditorPanel.add((Component)this.fVarNameEditorTextField);
        }
        this.fPanel.validate();
        this.fEditorPanel.validate();
    }

    public void setVariableNamesVisible(boolean bl) {
        this.fVariableNamesRowVisible = bl;
        this.updatePanelLayout();
    }

    public boolean getVariableNamesVisible() {
        return this.fVariableNamesRowVisible;
    }

    public boolean getGroupVariableNamesRowVisible() {
        return this.fGroupVariableNamesRowVisible;
    }

    public void setGroupNamesVisible(boolean bl) {
        this.fGroupVariableNamesRowVisible = bl;
        this.updatePanelLayout();
    }

    public JTable getTable() {
        return this.fTable;
    }

    protected MJPanel getPanel() {
        return this.fPanel;
    }

    protected MJPanel getEditorPanel() {
        return this.fEditorPanel;
    }

    protected HighlightLabel getVarNameLabel() {
        return this.fVarNameRendererLabel;
    }

    protected MJTextField getVarNameEditorTextField() {
        return this.fVarNameEditorTextField;
    }

    public boolean isEditableAtPoint(Point point, int n, Object object) {
        if (this.isHeaderEditing()) {
            return false;
        }
        this.getTableCellEditorComponent(null, object, true, 0, n);
        return point.y > this.fVarNameRendererLabel.getBounds().y && point.y <= this.fVarNameRendererLabel.getBounds().y + this.fVarNameRendererLabel.getBounds().height;
    }

    public Rectangle getGroupVarNameBounds(int n, Object object) {
        if (!this.fGroupVariableNamesRowVisible) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle rectangle = this.fTable.getTableHeader().getHeaderRect(n);
        this.fPanel.setSize(new Dimension(rectangle.width, rectangle.height));
        this.getTableCellRendererComponent(this.fTable, object, false, false, 0, n);
        this.fPanel.getLayout().layoutContainer((Container)this.fPanel);
        return this.fGroupVariableFiller.getBounds();
    }

    public Rectangle getVarNameEditorBounds(int n, Object object) {
        if (!this.fVariableNamesRowVisible) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle rectangle = this.fTable.getTableHeader().getHeaderRect(n);
        this.fPanel.setSize(new Dimension(rectangle.width, rectangle.height));
        this.getTableCellRendererComponent(this.fTable, object, false, false, 0, n);
        this.fPanel.getLayout().layoutContainer((Container)this.fPanel);
        return this.fVarNameRendererLabel.getBounds();
    }

    public int getPreferredHeaderWidth(int n, Object object) {
        if (n < 100) {
            this.getTableCellRendererComponent(this.fTable, object, false, false, 0, n);
            return this.fPanel.getPreferredSize().width;
        }
        return 100;
    }

    public boolean isSelectionArea(Point point, int n, Object object) {
        Rectangle rectangle = this.fTable.getTableHeader().getHeaderRect(n);
        this.fPanel.setSize(new Dimension(rectangle.width, rectangle.height));
        this.getTableCellRendererComponent(this.fTable, object, false, false, 0, n);
        this.fPanel.getLayout().layoutContainer((Container)this.fPanel);
        Rectangle rectangle2 = this.fVarNameRendererLabel.getBounds();
        return !rectangle2.contains(point);
    }

    void setHoverColumn(int n) {
        this.fHoverColumn = n;
    }

    int getHoverColumn() {
        return this.fHoverColumn;
    }

    boolean isHeaderEditing() {
        return SwingUtilities.isDescendingFrom((Component)this.fEditorPanel, this.fTable.getTableHeader());
    }

    @Override
    public void fireEditingStopped() {
        if (!this.isHeaderEditing()) {
            return;
        }
        this.fTable.getTableHeader().remove((Component)this.fEditorPanel);
        this.fTable.getTableHeader().revalidate();
        this.fTable.getTableHeader().repaint();
        if (this.fTable instanceof TextTable) {
            ((TextTable)((Object)this.fTable)).collapseAllFixedWidthColumns();
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.fEditorMouseFocusLostListener);
        super.fireEditingStopped();
    }

    @Override
    public void cancelCellEditing() {
        this.fTable.getTableHeader().remove((Component)this.fEditorPanel);
        this.fTable.getTableHeader().revalidate();
        this.fTable.getTableHeader().repaint();
        if (this.fTable instanceof TextTable) {
            ((TextTable)((Object)this.fTable)).expandAndCollapseFixedWidthColumns(-1);
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.fEditorMouseFocusLostListener);
        super.cancelCellEditing();
    }

    public Component editColumnHeaderCellAt(JTable jTable, int n) {
        Object object = jTable.getColumnModel().getColumn(n).getHeaderValue();
        Component component = this.getTableCellEditorComponent(jTable, object, true, 0, n);
        component.setBounds(jTable.getTableHeader().getHeaderRect(n));
        jTable.getTableHeader().add(component);
        component.validate();
        component.repaint();
        component.requestFocus();
        long l = 16L;
        Toolkit.getDefaultToolkit().addAWTEventListener(this.fEditorMouseFocusLostListener, l);
        return component;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    int[] calculateWarningIconHorizontalPosition(int n, String string) {
        int n2 = this.fVarNameRendererLabel.getFontMetrics(this.fVarNameRendererLabel.getFont()).stringWidth(string);
        int n3 = (n - sWarningIcon.getIconWidth() - n2 - this.fVarNameRendererLabel.getIconTextGap()) / 2;
        return new int[]{n3, n3 + sWarningIcon.getIconWidth()};
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JTable jTable2 = jTable;
        if (this.fTable != null) {
            jTable2 = this.fTable;
        }
        this.setLabelState(jTable2.isColumnSelected(n2));
        this.setBorder(this.fBorderUnselected);
        this.fVarNameRendererLabel.setVariableNameHighlight(false);
        if (jTable instanceof ImportTable) {
            if (((ImportTable)((Object)jTable)).getVariableNamesHighlightRow() != -1) {
                this.fVarNameRendererLabel.setVariableNameHighlight(true);
            }
            if (((ImportTable)((Object)jTable)).showColumnHeaderVariableWarning(n2)) {
                this.fVarNameRendererLabel.setIcon(sWarningIcon);
            } else {
                this.fVarNameRendererLabel.setIcon(null);
            }
        }
        boolean bl3 = object instanceof ImportDataHeader;
        int n3 = -1;
        if (jTable.getSelectedColumnCount() == 1) {
            n3 = jTable.getSelectedColumn();
        }
        if (this.fHoverColumn == n2) {
            this.fVarNameRendererLabel.setBackground(Color.WHITE);
            this.fVarNameRendererLabel.setBorder(this.fBevelBorder);
        } else {
            this.fVarNameRendererLabel.setBorder(null);
        }
        this.fVarNameRendererLabel.setFont(this.fVarNameRendererLabel.getFont().deriveFont(1));
        if (object instanceof ImportDataHeader) {
            ImportDataHeader importDataHeader = (ImportDataHeader)object;
            this.fLabel.setText(importDataHeader.getColumnID());
            this.fVarNameRendererLabel.setText(importDataHeader.getName());
        } else {
            this.fLabel.setText(object.toString());
            this.fVarNameRendererLabel.setText("");
        }
        this.fPanel.revalidate();
        return this.fPanel;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (object instanceof ImportDataHeader) {
            ImportDataHeader importDataHeader = (ImportDataHeader)object;
            this.fVarNameEditorTextField.setText(importDataHeader.getName());
            this.fVarNameEditorTextField.setName("NameEditField" + Integer.toString(n2));
            this.fEditorLabel.setText(importDataHeader.getColumnID());
            this.fEditorPanel.revalidate();
            this.fEditorPanel.repaint();
            this.fVarNameEditorTextField.selectAll();
            this.fLastEditedImportDataHeader = (ImportDataHeader)object;
            return this.fEditorPanel;
        }
        return null;
    }

    @Override
    public Object getCellEditorValue() {
        return new ImportDataHeader(this.fLastEditedImportDataHeader.getColumn(), this.fVarNameEditorTextField.getText());
    }

    void setForeground(Color color) {
        this.fLabel.setBackground(color);
        if (this.fPanel != null) {
            this.fVarNameRendererLabel.setForeground(color);
            this.fPanel.setForeground(color);
        }
    }

    public int getPreferredWidth(FontMetrics fontMetrics, Object object) {
        Component component = this.getTableCellRendererComponent(this.fTable, object, false, false, 0, 0);
        return component.getPreferredSize().width + DEFAULT_HORIZONTAL_GAP;
    }

    public void setFont(Font font) {
        this.fLabel.setFont(font);
        if (this.fPanel != null) {
            this.fPanel.revalidate();
        }
    }

    void setBorder(Border border) {
        if (this.fPanel != null) {
            this.fPanel.setBorder(border);
        }
    }

    protected void setLabelState(boolean bl) {
        Font font = this.fLabel.getFont();
        if (!font.equals(this.fLabelFont)) {
            this.fLabelFont = font;
        }
        if (bl) {
            if (Matlab.isMatlabAvailable()) {
                this.fVarNameRendererLabel.setForeground(this.fSpreadsheetColor.getHeaderSelectedForeground());
                this.fPanel.setForeground(this.fSpreadsheetColor.getHeaderSelectedForeground());
                this.setForeground(this.fSpreadsheetColor.getHeaderSelectedForeground());
            } else {
                this.fVarNameRendererLabel.setForeground(Color.BLACK);
                this.fPanel.setForeground(Color.BLACK);
                this.setForeground(Color.BLACK);
            }
            this.fPanel.setBackground(this.fRowHeaderColorSelected);
            this.fLabel.setBackground(this.fRowHeaderColorSelected);
            this.fVarNameRendererLabel.setBackground(this.fRowHeaderColorSelected);
        } else {
            if (Matlab.isMatlabAvailable()) {
                this.fVarNameRendererLabel.setForeground(this.fSpreadsheetColor.getHeaderUnselectedForeground());
                this.fPanel.setForeground(this.fSpreadsheetColor.getHeaderUnselectedForeground());
                this.setForeground(this.fSpreadsheetColor.getHeaderUnselectedForeground());
            } else {
                this.fVarNameRendererLabel.setForeground(Color.BLACK);
                this.fPanel.setForeground(Color.BLACK);
                this.setForeground(Color.BLACK);
            }
            this.fPanel.setBackground(this.fRowHeaderColorUnselected);
            this.fLabel.setBackground(this.fRowHeaderColorUnselected);
            this.fVarNameRendererLabel.setBackground(this.fRowHeaderColorUnselected);
        }
    }

    public Color getPreferredGridColor() {
        return this.fSpreadsheetColor.getHeaderUnselectedLine();
    }

    public void cleanup() {
        this.fSpreadsheetColor.setBaseTable(null);
        this.fSpreadsheetColor.unregisterColorInterests();
        this.fSpreadsheetColor = null;
    }

    protected static class HighlightLabel
    extends MJLabel {
        private boolean iVariableNameHighlight;

        protected HighlightLabel() {
        }

        public void setVariableNameHighlight(boolean bl) {
            this.iVariableNameHighlight = bl;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.iVariableNameHighlight) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setColor(ImportCellRenderer.getColor("VARIABLE_NAME_HIGHLIGHT_COLOR"));
                graphics2D.fillRect(0, 0, graphics.getClipBounds().width, graphics.getClipBounds().height);
            }
        }
    }

    class EditorMouseFocusLostListener
    implements AWTEventListener {
        EditorMouseFocusLostListener() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            try {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                if (VariableHeaderRenderer.this.isHeaderEditing() && mouseEvent.getClickCount() > 0 && mouseEvent.getID() == 501 && !(mouseEvent.getSource() instanceof MJMenuItem)) {
                    Point point = mouseEvent.getLocationOnScreen();
                    Rectangle rectangle = VariableHeaderRenderer.this.fVarNameEditorTextField.getBounds();
                    Point point2 = VariableHeaderRenderer.this.fVarNameEditorTextField.getLocationOnScreen();
                    rectangle.x = point2.x;
                    rectangle.y = point2.y;
                    if (!rectangle.contains(point)) {
                        VariableHeaderRenderer.this.fireEditingStopped();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class PlainComboBoxUI
    extends BasicComboBoxUI {
        PlainComboBoxUI() {
        }

        public static ComponentUI createUI(JComponent jComponent) {
            PlainComboBoxUI plainComboBoxUI = new PlainComboBoxUI();
            plainComboBoxUI.installUI(jComponent);
            return plainComboBoxUI;
        }

        @Override
        protected JButton createArrowButton() {
            JButton jButton = new JButton(new ImageIcon(WorksheetRulePanel.class.getResource("/com/mathworks/mlwidgets/importtool/resources/downarrow.gif")));
            jButton.setUI(new BasicButtonUI());
            jButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(-1, 0, -1, 0), BorderFactory.createMatteBorder(0, 0, 0, 1, Color.lightGray)));
            jButton.setBorderPainted(true);
            jButton.setOpaque(false);
            return jButton;
        }
    }

    public static class ImportDataHeader {
        private int iColumn;
        private String iName;

        public ImportDataHeader(int n, String string) {
            this.iColumn = n;
            this.iName = string;
        }

        public String getName() {
            return this.iName;
        }

        public int getColumn() {
            return this.iColumn;
        }

        public String getColumnID() {
            return ImportToolUtils.intToColumnString(this.iColumn + 1);
        }

        public void setName(String string) {
            this.iName = string;
        }

        public void setColumn(int n) {
            this.iColumn = n;
        }

        public String toString() {
            return this.getColumnID() + ":" + this.getName();
        }

        public boolean equals(Object object) {
            if (!(object instanceof ImportDataHeader) || object == null || this.iName == null) {
                return false;
            }
            ImportDataHeader importDataHeader = (ImportDataHeader)object;
            return this.iName.equals(importDataHeader.getName()) && this.iColumn == importDataHeader.getColumn();
        }

        public int hashCode() {
            return this.iName.hashCode() + this.iColumn * 1000;
        }
    }
}

