/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.jmi.bean.UDDListener;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.mlwidgets.inspector.AbstractTreeTableNode;
import com.mathworks.mlwidgets.inspector.IPropertyTreeTableNode;
import com.mathworks.mlwidgets.inspector.NamedEditor;
import com.mathworks.mlwidgets.inspector.PropertyCell;
import com.mathworks.mlwidgets.inspector.PropertyGroupNode;
import com.mathworks.mlwidgets.inspector.PropertyItemNode;
import com.mathworks.mlwidgets.inspector.PropertyTarget;
import com.mathworks.mlwidgets.inspector.PropertyTreeTableModel;
import com.mathworks.mlwidgets.inspector.PropertyView;
import com.mathworks.services.ObjectRegistry;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

final class PropertyRootNode
extends AbstractTreeTableNode {
    public static final int NO_ITEM = -1;
    private final Vector fChildrenList = new Vector();
    private Vector fUDDListeners;
    private final Hashtable fPropertyHash = new Hashtable();
    private ObjectRegistry fRegistry;
    private boolean fTargetHasPropertyGroups = false;
    private final JTable view;

    PropertyRootNode(PropertyTreeTableModel propertyTreeTableModel, JTable jTable, ObjectRegistry objectRegistry, Object[] objectArray) {
        assert (jTable != null);
        assert (objectRegistry != null);
        this.view = jTable;
        this.buildPropertyList_MatlabThread(jTable, objectRegistry, objectArray);
        this.fRegistry = objectRegistry;
    }

    private ObjectRegistry getRegistry() {
        return this.fRegistry;
    }

    boolean targetHasPropertyGroups() {
        return this.fTargetHasPropertyGroups;
    }

    public void expand() {
    }

    @Override
    public PropertyCell getPropertyCell() {
        return null;
    }

    private HashMap getGroupName_MatlabThread(UDDObject[] uDDObjectArray) {
        HashMap hashMap = null;
        assert (NativeMatlab.nativeIsMatlabThread());
        try {
            Object object = Matlab.mtFeval((String)"inspect", (Object[])new Object[]{"-getInspectorPropertyGrouping", uDDObjectArray}, (int)1);
            if (object instanceof HashMap) {
                hashMap = (HashMap)object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashMap;
    }

    private PropertyGroupNode getGroupNode(String string, HashMap hashMap, HashMap hashMap2) {
        PropertyGroupNode propertyGroupNode = null;
        Object v = hashMap.get(string);
        if (v instanceof String) {
            String string2 = (String)v;
            if ((v = hashMap2.get(string2)) instanceof PropertyGroupNode) {
                propertyGroupNode = (PropertyGroupNode)v;
            } else {
                propertyGroupNode = new PropertyGroupNode(string2);
                hashMap2.put(string2, propertyGroupNode);
                this.fChildrenList.add(propertyGroupNode);
            }
        }
        return propertyGroupNode;
    }

    private void buildPropertyList_MatlabThread(JTable jTable, ObjectRegistry objectRegistry, Object[] objectArray) {
        assert (NativeMatlab.nativeIsMatlabThread());
        boolean bl = false;
        this.fTargetHasPropertyGroups = false;
        boolean bl2 = false;
        PropertyCell propertyCell = null;
        PropertyItemNode propertyItemNode = null;
        String string = null;
        boolean bl3 = true;
        Vector<UDDObject> vector = new Vector<UDDObject>();
        this.fRegistry = objectRegistry;
        UDDObject[] uDDObjectArray = PropertyRootNode.castObjectToUDDArray(objectArray);
        HashMap hashMap = null;
        HashMap hashMap2 = new HashMap();
        PropertyTarget propertyTarget = new PropertyTarget(objectArray, jTable, this.getRegistry(), bl);
        this.setTarget(propertyTarget);
        propertyTarget.setNode(this);
        this.removeListeners();
        this.fPropertyHash.clear();
        this.fChildrenList.clear();
        if (uDDObjectArray.length > 0) {
            hashMap = this.getGroupName_MatlabThread(uDDObjectArray);
        }
        while (propertyTarget.hasMoreProperties()) {
            PropertyGroupNode propertyGroupNode;
            NamedEditor namedEditor = propertyTarget.nextProperty();
            if (namedEditor == null || namedEditor.getEditor() == null || !namedEditor.isEditable() && !bl3) continue;
            propertyCell = PropertyCell.makePropertyCell(jTable, propertyTarget, -1, 0, namedEditor);
            propertyItemNode = new PropertyItemNode(0, propertyCell, propertyCell.hasChildren());
            string = propertyCell.getName();
            this.fChildrenList.add(propertyItemNode);
            this.fPropertyHash.put(string, propertyItemNode);
            if (hashMap != null && (propertyGroupNode = this.getGroupNode(string, hashMap, hashMap2)) != null) {
                propertyItemNode.setGroupName(propertyGroupNode.getName());
                bl2 = true;
            }
            if (uDDObjectArray == null) continue;
            for (int i = 0; i < uDDObjectArray.length; ++i) {
                UDDObject uDDObject;
                if (uDDObjectArray[i] == null || !(uDDObject = uDDObjectArray[i].findProperty(namedEditor.getName())).isValid()) continue;
                vector.add(uDDObjectArray[i].findProperty(namedEditor.getName()));
            }
        }
        if (bl2) {
            this.fTargetHasPropertyGroups = true;
        }
        this.setChildren(PropertyRootNode.castToAbstractTreeTableNode(this.fChildrenList.toArray()));
        this.setQueriedChildren(true);
        this.registerPropertyListeners(uDDObjectArray, vector);
    }

    private static UDDObject[] castObjectToUDDArray(Object[] objectArray) {
        ArrayList<UDDObject> arrayList = new ArrayList<UDDObject>();
        for (Object object : objectArray) {
            UDDObject uDDObject;
            if (!(object instanceof UDDObject) || !(uDDObject = (UDDObject)object).isValid()) continue;
            arrayList.add(uDDObject);
        }
        Object[] objectArray2 = arrayList.toArray(new UDDObject[0]);
        return objectArray2;
    }

    private void registerPropertyListeners(UDDObject[] uDDObjectArray, Vector vector) {
        if (this.fUDDListeners == null) {
            this.fUDDListeners = new Vector();
        }
        for (int i = 0; i < uDDObjectArray.length; ++i) {
            if (uDDObjectArray[i] == null) continue;
            DestroyListener destroyListener = new DestroyListener(uDDObjectArray[i], uDDObjectArray[i], "ObjectBeingDestroyed");
            this.fUDDListeners.add(destroyListener);
        }
        if (vector != null && vector.size() > 0) {
            int n;
            UDDObject[] uDDObjectArray2 = new UDDObject[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                uDDObjectArray2[n] = (UDDObject)vector.get(n);
            }
            for (n = 0; n < uDDObjectArray.length; ++n) {
                if (!PropertyView.isAutoUpdate()) continue;
                this.fUDDListeners.add(new PropertyListener(uDDObjectArray[n], uDDObjectArray2, "PropertyPostSet"));
            }
        }
    }

    private void removeListeners() {
        if (this.fUDDListeners != null) {
            ListIterator listIterator = this.fUDDListeners.listIterator();
            while (listIterator.hasNext()) {
                Object e = listIterator.next();
                if (!(e instanceof UDDListener)) continue;
                ((UDDListener)e).dispose();
            }
            this.fUDDListeners.clear();
        }
    }

    private void updateProperty_AnyThread(final PropertyItemNode propertyItemNode, final Object object) {
        final PropertyCell propertyCell = propertyItemNode.getPropertyCell();
        if (propertyItemNode != null && object != null) {
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (PropertyRootNode.this.getTarget() != null) {
                        PropertyRootNode.this.getTarget().setPropertyValue(propertyCell.getEditor(), object);
                        if (propertyCell.getChildTarget() != null) {
                            propertyCell.getChildTarget().pullInPropertyValuesFromMatlab_MatlabThread();
                        }
                    }
                    final IPropertyTreeTableNode[] iPropertyTreeTableNodeArray = propertyItemNode.getChildren();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            propertyCell.updateComponent_EventThread();
                            for (int i = 0; iPropertyTreeTableNodeArray != null && i < iPropertyTreeTableNodeArray.length; ++i) {
                                iPropertyTreeTableNodeArray[i].getPropertyCell().updateComponent_EventThread();
                            }
                            TableModel tableModel = PropertyRootNode.this.view.getModel();
                            assert (tableModel instanceof AbstractTableModel);
                            ((AbstractTableModel)tableModel).fireTableDataChanged();
                        }
                    });
                }
            });
        }
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public String getName() {
        return "root";
    }

    @Override
    public JComponent getRendererComponent() {
        return null;
    }

    @Override
    public JComponent getEditorComponent() {
        return null;
    }

    private class PropertyListener
    extends UDDListener {
        Timer fTimer;
        boolean fDoRefresh;
        private boolean fDoIgnoreEvents;
        private Vector fUpdateNodes;
        private Hashtable fNewPropertyValueHash;

        public void setDoIgnoreEvents(boolean bl) {
            this.fDoIgnoreEvents = bl;
        }

        public boolean getDoIgnoreEvents() {
            return this.fDoIgnoreEvents;
        }

        PropertyListener(UDDObject uDDObject, UDDObject[] uDDObjectArray, String string) {
            super(uDDObject, uDDObjectArray, string);
            this.fDoRefresh = true;
            this.fDoIgnoreEvents = false;
            this.fUpdateNodes = new Vector();
            this.fNewPropertyValueHash = new Hashtable();
            int n = 250;
            this.fTimer = new Timer(n, new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Vector vector = PropertyListener.this.fUpdateNodes;
                    synchronized (vector) {
                        Enumeration enumeration = PropertyListener.this.fUpdateNodes.elements();
                        while (enumeration.hasMoreElements()) {
                            PropertyItemNode propertyItemNode = (PropertyItemNode)enumeration.nextElement();
                            Object v = PropertyListener.this.fNewPropertyValueHash.get(propertyItemNode);
                            PropertyRootNode.this.updateProperty_AnyThread(propertyItemNode, v);
                        }
                        PropertyListener.this.fUpdateNodes.clear();
                        PropertyListener.this.fNewPropertyValueHash.clear();
                    }
                }
            });
            this.fTimer.setCoalesce(true);
            this.fTimer.setRepeats(false);
        }

        public void execute(UDDObject uDDObject, UDDObject uDDObject2) {
            if (!NativeMatlab.nativeIsMatlabThread()) {
                System.out.println("Incorrect update thread for Inspector");
                assert (false);
            }
            if (uDDObject != null) {
                Object object;
                Object object2 = null;
                Object object3 = uDDObject2.getPropertyValue("AffectedObject");
                String string = (String)uDDObject.getPropertyValue("Name");
                if (object3 instanceof UDDObject) {
                    object = (UDDObject)object3;
                    object2 = object.getPropertyValue(string);
                }
                if (object2 != null && (object = PropertyRootNode.this.fPropertyHash.get(string)) instanceof PropertyItemNode) {
                    PropertyItemNode propertyItemNode = (PropertyItemNode)object;
                    this.fUpdateNodes.add(propertyItemNode);
                    this.fNewPropertyValueHash.put(propertyItemNode, object2);
                    if (!this.fTimer.isRunning()) {
                        this.fTimer.start();
                        this.setDoIgnoreEvents(false);
                    }
                }
            }
        }
    }

    private class DestroyListener
    extends UDDListener {
        public DestroyListener(UDDObject uDDObject, UDDObject uDDObject2, String string) {
            super(uDDObject, uDDObject2, string);
        }

        public void execute(UDDObject uDDObject, UDDObject uDDObject2) {
            boolean bl = false;
            ObjectRegistry objectRegistry = PropertyRootNode.this.getRegistry();
            if (objectRegistry != null && uDDObject != null) {
                Object[] objectArray = objectRegistry.getSelectedObjects();
                for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
                    if (!uDDObject.equals(objectArray[i])) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    objectRegistry.fireItemEvent(null);
                }
            }
        }
    }
}

