/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.interactivecallbacks;

import com.mathworks.common.icons.ApplicationIcon;
import com.mathworks.jmi.Callback;
import com.mathworks.mlwidgets.interactivecallbacks.InteractiveCallbackEvent;
import com.mathworks.mlwidgets.interactivecallbacks.InteractiveCallbackListener;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.FileExtensionFilter;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.undo.UndoManagerListener;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.SyntaxTextPaneBase;
import com.mathworks.widgets.text.EditorLanguageUtils;
import com.mathworks.widgets.text.mcode.MKit;
import com.mathworks.widgets.text.mcode.MLanguage;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.event.EventListenerList;
import javax.swing.text.EditorKit;

public class InteractiveCallbackEditor
implements UndoManagerListener {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.interactivecallbacks.resources.RES_InteractiveCallbackEditor");
    private MJFrame fDisplayFrame;
    private SyntaxTextPane fEditorPane;
    private boolean fSaveCancelFlag;
    private Callback fCallback;
    private String fTitle;
    private boolean fCloseOnSave;
    private EventListenerList fListenerList;
    private SelfListener fSelfListener;
    private boolean fSaveCancelled = false;
    private SaveActionAccessor fSaveActionAccessor = new SaveActionAccessor();

    public InteractiveCallbackEditor(Rectangle rectangle) {
        this(rectangle, null, null);
    }

    public InteractiveCallbackEditor(Rectangle rectangle, String string) {
        this(rectangle, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InteractiveCallbackEditor(Rectangle rectangle, String string, String string2) {
        File file;
        this.fTitle = sRes.getString("title.name").concat(" - ");
        this.fListenerList = new EventListenerList();
        this.fSelfListener = new SelfListener();
        this.fDisplayFrame = new MJFrame();
        this.fDisplayFrame.setBounds(rectangle);
        this.fDisplayFrame.addWindowListener((WindowListener)this.fSelfListener);
        this.fSaveCancelFlag = false;
        this.fCallback = new Callback();
        this.fEditorPane = new SyntaxTextPane();
        this.fEditorPane.setEditorKit((EditorKit)((Object)new CustomMKit()));
        FileInputStream fileInputStream = null;
        if (string != null) {
            try {
                file = new File(string);
                fileInputStream = new FileInputStream(file);
                this.fEditorPane.read((InputStream)fileInputStream, null, EditorLanguageUtils.getMimeTypeFromFilename((String)string));
                this.fEditorPane.setFilename(string);
                this.fSaveActionAccessor.getSaveAction().setEnabled(false);
            }
            catch (Exception exception) {
                this.showErrorDialog();
                this.fEditorPane.setFilename(null);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (this.fEditorPane.getFilename() != null) {
            this.fDisplayFrame.setTitle(this.fTitle.concat(string));
        } else {
            this.fEditorPane.setContentType(MLanguage.INSTANCE.getMimeType());
            this.fEditorPane.setText(string2);
            if (string2 != null) {
                this.fDisplayFrame.setTitle(this.fTitle.concat(sRes.getString("title.defaultname")).concat("*"));
            } else {
                this.fDisplayFrame.setTitle(this.fTitle.concat(sRes.getString("title.defaultname")));
                this.fSaveActionAccessor.getSaveAction().setEnabled(false);
            }
        }
        this.fDisplayFrame.getContentPane().add((Component)SyntaxTextPane.getDisplayComponent((SyntaxTextPaneBase)this.fEditorPane), "Center");
        this.fEditorPane.addUndoManagerListener((UndoManagerListener)this);
        file = new MJMenuBar();
        MJMenu mJMenu = new MJMenu(sRes.getString("menu.file"));
        mJMenu.add((Action)this.fSaveActionAccessor.getSaveAction());
        mJMenu.add((Action)this.fSaveActionAccessor.getSaveAsAction());
        mJMenu.setName("FileMenu");
        file.add((JMenu)mJMenu);
        MJMenu mJMenu2 = new MJMenu(sRes.getString("menu.edit"));
        mJMenu2.add((Action)this.fEditorPane.getUndoAction());
        mJMenu2.add((Action)this.fEditorPane.getRedoAction());
        mJMenu2.addSeparator();
        mJMenu2.add((Action)this.fEditorPane.getCutAction());
        mJMenu2.add((Action)this.fEditorPane.getCopyAction());
        mJMenu2.add((Action)this.fEditorPane.getPasteAction());
        mJMenu2.addSeparator();
        mJMenu2.add((Action)this.fEditorPane.getDeleteAction());
        mJMenu2.add((Action)this.fEditorPane.getSelectAllAction());
        mJMenu2.setName("EditMenu");
        file.add((JMenu)mJMenu2);
        MJMenu mJMenu3 = new MJMenu(sRes.getString("menu.text"));
        mJMenu3.add((Action)this.fEditorPane.getCommentAction());
        mJMenu3.add((Action)this.fEditorPane.getUncommentAction());
        mJMenu3.addSeparator();
        mJMenu3.add((Action)this.fEditorPane.getUnindentAction());
        mJMenu3.add((Action)this.fEditorPane.getIndentAction());
        mJMenu3.add((Action)this.fEditorPane.getSmartIndentAction());
        mJMenu3.addSeparator();
        mJMenu3.add((Action)this.fEditorPane.getToLowerCaseAction());
        mJMenu3.add((Action)this.fEditorPane.getToUpperCaseAction());
        mJMenu3.setName("TextMenu");
        file.add((JMenu)mJMenu3);
        this.fDisplayFrame.setJMenuBar((JMenuBar)((Object)file));
        this.fDisplayFrame.setIconImage(ApplicationIcon.EDITOR.getIcon().getImage());
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(2));
        MJButton mJButton = new MJButton((Action)((Object)new LocalSaveCloseAction()));
        mJPanel.add((Component)mJButton);
        MJButton mJButton2 = new MJButton((Action)((Object)new LocalCancelAction()));
        mJPanel.add((Component)mJButton2);
        MJButton mJButton3 = new MJButton((Action)this.fSaveActionAccessor.getSaveAction());
        mJButton3.setIcon(null);
        mJPanel.add((Component)mJButton3);
        this.fDisplayFrame.getContentPane().add((Component)mJPanel, "South");
        this.fDisplayFrame.setDefaultCloseOperation(2);
        this.fCloseOnSave = false;
        this.setName("InteractiveCallbackEditor");
    }

    public void setVisible(boolean bl) {
        this.fDisplayFrame.setVisible(bl);
    }

    private void setName(String string) {
        this.fDisplayFrame.setName(string);
    }

    public boolean isVisible() {
        return this.fDisplayFrame.isVisible();
    }

    public void dirtyStateChanged(boolean bl) {
        String string = this.fEditorPane.getFilename();
        this.fSaveActionAccessor.getSaveAction().setEnabled(bl);
        if (string == null) {
            string = sRes.getString("title.defaultname");
        }
        if (bl) {
            this.fDisplayFrame.setTitle(this.fTitle.concat(string).concat("*"));
        } else {
            this.fDisplayFrame.setTitle(this.fTitle.concat(string));
        }
        if (this.fCloseOnSave) {
            if (!this.fSaveCancelled) {
                this.fDisplayFrame.dispose();
            } else {
                this.fCloseOnSave = false;
            }
        }
    }

    public void undoabilityChanged(boolean bl) {
    }

    public void redoabilityChanged(boolean bl) {
    }

    public Callback getCallback() {
        return this.fCallback;
    }

    public void fireCallback(String string) {
        Object[] objectArray = this.fListenerList.getListenerList();
        InteractiveCallbackEvent interactiveCallbackEvent = null;
        if (this.fSaveCancelFlag) {
            this.fCallback.postCallback(new Object[]{new CallbackData(this, string)});
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != InteractiveCallbackListener.class) continue;
                if (interactiveCallbackEvent == null) {
                    interactiveCallbackEvent = new InteractiveCallbackEvent(this, string);
                }
                ((InteractiveCallbackListener)objectArray[i + 1]).editComplete(interactiveCallbackEvent);
            }
        } else {
            this.fCallback.postCallback(new Object[]{new CallbackData(this, null)});
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != InteractiveCallbackListener.class) continue;
                if (interactiveCallbackEvent == null) {
                    interactiveCallbackEvent = new InteractiveCallbackEvent(this, null);
                }
                ((InteractiveCallbackListener)objectArray[i + 1]).editComplete(interactiveCallbackEvent);
            }
        }
    }

    public void addInteractiveCallbackListener(InteractiveCallbackListener interactiveCallbackListener) {
        this.fListenerList.add(InteractiveCallbackListener.class, interactiveCallbackListener);
    }

    public void removeInteractiveCallbackListener(InteractiveCallbackListener interactiveCallbackListener) {
        this.fListenerList.remove(InteractiveCallbackListener.class, interactiveCallbackListener);
    }

    private void showErrorDialog() {
        MJOptionPane.showMessageDialog((Component)this.fEditorPane, (Object)sRes.getString("error.fileaccessmessage"), (String)sRes.getString("error.fileaccesstitle"), (int)0);
    }

    private class SaveActionAccessor {
        private LocalSaveAction fSaveAction = new LocalSaveAction();
        private LocalSaveAsAction fSaveAsAction = new LocalSaveAsAction();
        private MJFileChooserPerPlatform fDialogBox = new MJFileChooserPerPlatform();

        public SaveActionAccessor() {
            this.fDialogBox.addChoosableFileFilter((FilePatternFilter)FileExtensionFilter.getMFileFilter());
        }

        public MJAbstractAction getSaveAction() {
            return this.fSaveAction;
        }

        public MJAbstractAction getSaveAsAction() {
            return this.fSaveAsAction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void showDialog() {
            this.fDialogBox.setSelectedFile(new File("NewCallback.m"));
            this.fDialogBox.showSaveDialog((Component)InteractiveCallbackEditor.this.fEditorPane);
            int n = this.fDialogBox.getState();
            InteractiveCallbackEditor.this.fSaveCancelled = false;
            if (n == 1) {
                InteractiveCallbackEditor.this.fSaveCancelled = true;
                return;
            }
            File file = this.fDialogBox.getSelectedFile();
            String string = file.getAbsolutePath();
            InteractiveCallbackEditor.this.fEditorPane.setFilename(string);
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter(file);
                InteractiveCallbackEditor.this.fEditorPane.write((Writer)fileWriter);
                InteractiveCallbackEditor.this.fEditorPane.setUndoCleanMarker();
            }
            catch (IOException iOException) {
                InteractiveCallbackEditor.this.showErrorDialog();
                InteractiveCallbackEditor.this.fEditorPane.setFilename(null);
            }
            finally {
                if (fileWriter != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        private class LocalSaveAsAction
        extends MJAbstractAction {
            public LocalSaveAsAction() {
                MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABEditor", "save-as", (ExtendedAction)this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                SaveActionAccessor.this.showDialog();
            }
        }

        private class LocalSaveAction
        extends MJAbstractAction {
            public LocalSaveAction() {
                MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABEditor", "save", (ExtendedAction)this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                if (InteractiveCallbackEditor.this.fEditorPane.getFilename() == null) {
                    SaveActionAccessor.this.showDialog();
                } else {
                    File file = new File(InteractiveCallbackEditor.this.fEditorPane.getFilename());
                    FileWriter fileWriter = null;
                    try {
                        fileWriter = new FileWriter(file);
                        InteractiveCallbackEditor.this.fEditorPane.write((Writer)fileWriter);
                        InteractiveCallbackEditor.this.fEditorPane.setUndoCleanMarker();
                    }
                    catch (IOException iOException) {
                        InteractiveCallbackEditor.this.showErrorDialog();
                        InteractiveCallbackEditor.this.fEditorPane.setFilename(null);
                    }
                    finally {
                        if (fileWriter != null) {
                            try {
                                fileWriter.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
        }
    }

    private static class CustomMKit
    extends MKit {
        private CustomMKit() {
        }

        public String getContentType() {
            return MLanguage.INSTANCE.getMimeType();
        }

        protected boolean isFollowingMLintPreference() {
            return true;
        }
    }

    private class SelfListener
    extends WindowAdapter {
        private SelfListener() {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            InteractiveCallbackEditor.this.fireCallback(InteractiveCallbackEditor.this.fEditorPane.getFilename());
            InteractiveCallbackEditor.this.fEditorPane.cleanup();
        }
    }

    static class CallbackData {
        public InteractiveCallbackEditor source;
        public char[] data;

        public CallbackData(InteractiveCallbackEditor interactiveCallbackEditor, String string) {
            this.source = interactiveCallbackEditor;
            this.data = (char[])(string != null ? string.toCharArray() : null);
        }
    }

    private class LocalCancelAction
    extends MJAbstractAction {
        public LocalCancelAction() {
            this.putValue("ActionCommandKey", "Cancel");
            this.setComponentName("intCallback.Cancel");
            this.setName(sRes.getString("action.cancelname"));
            this.setTip(MJUtilities.exciseAmpersand((String)sRes.getString("action.cancelname")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InteractiveCallbackEditor.this.fDisplayFrame.dispose();
        }
    }

    private class LocalSaveCloseAction
    extends MJAbstractAction {
        private static final int SAVE_FLAGS = 1001;

        public LocalSaveCloseAction() {
            this.putValue("ActionCommandKey", "SaveClose");
            this.setComponentName("intCallback.SaveClose");
            this.setName(sRes.getString("action.saveclosename"));
            this.setTip(MJUtilities.exciseAmpersand((String)sRes.getString("action.saveclosename")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InteractiveCallbackEditor.this.fSaveCancelFlag = true;
            if (InteractiveCallbackEditor.this.fEditorPane.isDirty()) {
                InteractiveCallbackEditor.this.fCloseOnSave = true;
                InteractiveCallbackEditor.this.fSaveActionAccessor.getSaveAction().actionPerformed(new ActionEvent(InteractiveCallbackEditor.this.fEditorPane, 1001, "Save"));
            } else {
                InteractiveCallbackEditor.this.fDisplayFrame.dispose();
            }
        }
    }
}

