/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.prefs.binding;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.gui.AbstractTableComparatorChooser;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.matchers.ThreadedMatcherEditor;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import ca.odell.glazedlists.swing.TextComponentMatcherEditor;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.prefs.binding.ConflictPanel;
import com.mathworks.mlwidgets.prefs.binding.FileExchangeEntry;
import com.mathworks.mlwidgets.prefs.binding.KeyBindingPanelUtils;
import com.mathworks.mlwidgets.prefs.binding.KeyBindingSetEntry;
import com.mathworks.mlwidgets.prefs.binding.ShortcutModifierPanel;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.binding.ActionData;
import com.mathworks.mwswing.binding.ActionDataID;
import com.mathworks.mwswing.binding.Context;
import com.mathworks.mwswing.binding.CustomKeyBindingSet;
import com.mathworks.mwswing.binding.CustomKeyBindingSetUtils;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingManagerRegistry;
import com.mathworks.mwswing.binding.KeyBindingSet;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.mwswing.datatransfer.MJTransferable;
import com.mathworks.mwswing.table.AccessibleTextProvider;
import com.mathworks.mwswing.text.TextContextMenu;
import com.mathworks.services.binding.KeyBindingPreferences;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.widgets.Dialogs;
import com.mathworks.widgets.FileComboBox;
import com.mathworks.widgets.KeyEventPreprocessor;
import com.mathworks.widgets.PopupMenuCustomizer;
import com.mathworks.widgets.SearchTextField;
import com.mathworks.widgets.SettingsChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.SystemUtils;

public class KeyboardShortcutsPrefPanel
extends MJPanel {
    private static KeyboardShortcutsPrefPanel sInstance;
    private final FileComboBox fConfigurationCombo;
    private final MJAbstractAction fRestoreDefaults;
    private final MJAbstractAction fDeleteSetAction;
    private final MJTable fTable;
    private final EventSelectionModel<KeybindingData> fSelectionModel;
    private final EventTableModel<KeybindingData> fTableModel;
    private final SearchTextField fFilterText;
    private final SortedList<KeybindingData> fSortedList;
    private final FilterList<KeybindingData> fFilterList;
    private KeyBindingSetEntry fSetInProgress;
    private final KeyBindingManager fManager;
    private final KeyBindingPreferences fPrefSetter;
    private final QueryUserAboutUnsavedSet fAcceptChangeListener;
    private final ErrorHandler fErrorHandler;
    private final ShortcutModifierPanel fShortcutModifierPanel;
    private final ConflictPanel fConflictPanel;
    private final CustomKeyBindingSet.ChangeListener fChangeListener = new SetChangeListener();
    private static final int CONFLICT_COLUMN = 0;
    private static final int ACTION_COLUMN = 1;
    private static final int SHORTCUT_COLUMN = 2;
    private static final String TXT_EXTENSION = ".txt";
    private static final int SHORT_TRUNCATION_LENGTH = 25;
    private static final String UNIT_TEST_DELETE_WITHOUT_PROMPT = "DeleteWithoutPromptingForTest";
    public static final String NAME_RESTORE_DEFAULTS = "RestoreDefaultsAction";
    public static final String NAME_COPY_SET = "CopySetAction";
    public static final String NAME_DELETE_SET = "DeleteSetAction";

    private KeyboardShortcutsPrefPanel(KeyBindingManager keyBindingManager, KeyBindingPreferences keyBindingPreferences, QueryUserAboutUnsavedSet queryUserAboutUnsavedSet, ErrorHandler errorHandler) {
        this.fManager = keyBindingManager;
        this.fPrefSetter = keyBindingPreferences;
        this.fAcceptChangeListener = queryUserAboutUnsavedSet;
        this.fErrorHandler = errorHandler;
        this.fConfigurationCombo = this.buildConfigurationCombo();
        this.fRestoreDefaults = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardShortcutsPrefPanel.this.fSetInProgress.restoreModifiedDefaultSet();
                KeyboardShortcutsPrefPanel.this.updateBottomPanels();
                KeyboardShortcutsPrefPanel.this.updateDisplay(false);
                KeyboardShortcutsPrefPanel.this.fConfigurationCombo.getComboBox().repaint();
                if (KeyboardShortcutsPrefPanel.this.fTable.getSelectedRow() != -1) {
                    KeyboardShortcutsPrefPanel.this.fTable.requestFocusInWindow();
                }
            }
        };
        this.fRestoreDefaults.setComponentName(NAME_RESTORE_DEFAULTS);
        this.fDeleteSetAction = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                assert (!KeyboardShortcutsPrefPanel.this.fSetInProgress.wasCreatedFromDefaultSet()) : "This action should not be displayed for default sets";
                if (KeyboardShortcutsPrefPanel.UNIT_TEST_DELETE_WITHOUT_PROMPT.equals(actionEvent.getActionCommand()) || this.userConfirmedDelete(KeyboardShortcutsPrefPanel.this.fSetInProgress.toString())) {
                    try {
                        KeyboardShortcutsPrefPanel.this.fManager.removeCustomKeyBindingSet(KeyboardShortcutsPrefPanel.this.fSetInProgress.deleteCustomSet());
                        KeyboardShortcutsPrefPanel.this.fConfigurationCombo.getComboBox().removeItem((Object)KeyboardShortcutsPrefPanel.this.fSetInProgress);
                        ((KeyBindingSetEntry)KeyboardShortcutsPrefPanel.this.fConfigurationCombo.getSelectedItem()).setAsCurrentSet();
                    }
                    catch (IOException iOException) {
                        KeyboardShortcutsPrefPanel.this.showErrorMessage(iOException);
                    }
                }
            }

            private boolean userConfirmedDelete(String string) {
                return MJOptionPane.showOptionDialog((Component)((Object)KeyboardShortcutsPrefPanel.this), (Object)MessageFormat.format(KeyBindingPanelUtils.lookup("keybinding.deleteSet.confirmationMessage"), string), (String)KeyBindingPanelUtils.lookup("keybinding.saveChanges.DialogTitle"), (int)0, (int)3, null, (Object[])new String[]{KeyBindingPanelUtils.lookup("keybinding.deleteButton"), MJOptionPane.CANCEL_STRING}, (Object)MJOptionPane.CANCEL_STRING) == 0;
            }
        };
        this.fDeleteSetAction.setComponentName(NAME_DELETE_SET);
        this.fFilterText = new SearchTextField(KeyBindingPanelUtils.lookup("actionPanel.filterHint"), (KeyEventPreprocessor)new ShortcutPromptingFieldProcessor(), (MJPopupMenu)new ContextMenuWithoutShortcuts());
        this.fFilterText.getComponent().getAccessibleContext().setAccessibleName("Action table search field");
        this.fFilterList = this.getData((TextComponentMatcherEditor<KeybindingData>)this.fFilterText.createTextComponentMatcherEditor((TextFilterator)new FilterInfo()));
        this.fSortedList = new SortedList(this.fFilterList, (Comparator)new ActionComparable());
        this.fSelectionModel = new EventSelectionModel(this.fSortedList);
        this.fTableModel = this.createTableModel(this.fSortedList);
        this.fTable = this.createTable(this.fTableModel, this.fSelectionModel, this.fSortedList);
        MJScrollPane mJScrollPane = KeyBindingPanelUtils.setupTable(this.fTable, true);
        this.fSelectionModel.addListSelectionListener((ListSelectionListener)new TableListener());
        this.fTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (Character.isLetterOrDigit(c) || Character.isSpaceChar(c)) {
                    KeyboardShortcutsPrefPanel.this.fFilterText.setSearchText(KeyboardShortcutsPrefPanel.this.fFilterText.getSearchText() + String.valueOf(c));
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 8 && KeyboardShortcutsPrefPanel.this.fFilterText.getSearchText().length() > 0) {
                    KeyboardShortcutsPrefPanel.this.fFilterText.setSearchText(KeyboardShortcutsPrefPanel.this.fFilterText.getSearchText().substring(0, KeyboardShortcutsPrefPanel.this.fFilterText.getSearchText().length() - 1));
                }
            }
        });
        this.fShortcutModifierPanel = new ShortcutModifierPanel(this.fManager);
        this.fConflictPanel = new ConflictPanel(this.fManager);
        this.updateBottomPanels();
        this.setLayout(new BorderLayout());
        this.add(this.layoutPanel(mJScrollPane), "Center");
        this.updateDisplay(true);
        if (this.fTable.getRowCount() > 0) {
            this.fSelectionModel.setSelectionInterval(0, 0);
        }
        this.fTable.requestFocusInWindow();
    }

    private JComponent layoutPanel(MJScrollPane mJScrollPane) {
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("0dlu:grow", "p, 6dlu, p, 1dlu, fill:p:grow(.7), 6dlu, fill:p:grow(.15), 6dlu, fill:p:grow(.15)"));
        CellConstraints cellConstraints = new CellConstraints();
        PopupMenuCustomizer popupMenuCustomizer = new PopupMenuCustomizer(){

            public void customize(JPopupMenu jPopupMenu) {
                jPopupMenu.add((Action)KeyboardShortcutsPrefPanel.this.getCopyAction());
                jPopupMenu.addSeparator();
                jPopupMenu.add((JMenuItem)KeyboardShortcutsPrefPanel.this.getComparisonMenu());
                if (KeyboardShortcutsPrefPanel.this.fSetInProgress.wasCreatedFromDefaultSet()) {
                    KeyboardShortcutsPrefPanel.this.fRestoreDefaults.setName(MessageFormat.format(KeyBindingPanelUtils.lookup("keybinding.restoreDefaults"), KeyboardShortcutsPrefPanel.getAbbreviatedUserVisibleName(KeyboardShortcutsPrefPanel.this.fSetInProgress)));
                    jPopupMenu.add((Action)KeyboardShortcutsPrefPanel.this.fRestoreDefaults);
                } else {
                    KeyboardShortcutsPrefPanel.this.fDeleteSetAction.setName(MessageFormat.format(KeyBindingPanelUtils.lookup("keybinding.deleteSet.menuItem"), KeyboardShortcutsPrefPanel.getAbbreviatedUserVisibleName(KeyboardShortcutsPrefPanel.this.fSetInProgress)));
                    jPopupMenu.add((Action)KeyboardShortcutsPrefPanel.this.fDeleteSetAction);
                }
            }
        };
        panelBuilder.add((Component)new SettingsChooser(this.fConfigurationCombo, popupMenuCustomizer).getPanel(), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.fFilterText.getComponent(), cellConstraints.xy(1, 3));
        panelBuilder.add((Component)mJScrollPane, cellConstraints.xy(1, 5));
        panelBuilder.add((Component)this.fShortcutModifierPanel.getComponent(), cellConstraints.xy(1, 7));
        panelBuilder.add((Component)this.fConflictPanel.getComponent(), cellConstraints.xy(1, 9));
        return panelBuilder.getPanel();
    }

    private FileComboBox buildConfigurationCombo() {
        Object object;
        FileComboBox.FileChosenCallback fileChosenCallback = new FileComboBox.FileChosenCallback(){

            public boolean saveAs(File file) {
                if (file.getName().endsWith(KeyboardShortcutsPrefPanel.TXT_EXTENSION)) {
                    try {
                        KeyboardShortcutsPrefPanel.this.writeSetToTextFile(KeyboardShortcutsPrefPanel.this.fSetInProgress, file);
                    }
                    catch (IOException iOException) {
                        KeyboardShortcutsPrefPanel.this.showErrorMessage(iOException);
                    }
                    return false;
                }
                return KeyboardShortcutsPrefPanel.this.saveAsFromCombo(file);
            }

            public boolean acceptChange(Object object, Object object2) {
                if (object2 instanceof FileExchangeEntry) {
                    ((FileExchangeEntry)((Object)object2)).doSearch();
                    return false;
                }
                boolean bl = true;
                if (KeyboardShortcutsPrefPanel.this.fSetInProgress.setHasBeenModifiedByUser()) {
                    QueryUserAboutUnsavedSet.UserChangeSetResponse userChangeSetResponse = KeyboardShortcutsPrefPanel.this.fAcceptChangeListener.queryUser((Component)((Object)KeyboardShortcutsPrefPanel.this), KeyboardShortcutsPrefPanel.this.fSetInProgress.toString());
                    if (userChangeSetResponse == QueryUserAboutUnsavedSet.UserChangeSetResponse.SAVE_PREVIOUS) {
                        try {
                            KeyboardShortcutsPrefPanel.this.fSetInProgress.saveKeyBindingSet();
                        }
                        catch (Exception exception) {
                            KeyboardShortcutsPrefPanel.this.showErrorMessage(exception);
                            bl = false;
                        }
                    } else if (userChangeSetResponse == QueryUserAboutUnsavedSet.UserChangeSetResponse.DONT_SAVE_PREVIOUS) {
                        KeyboardShortcutsPrefPanel.this.fSetInProgress.discardChangesFromParent();
                        KeyboardShortcutsPrefPanel.this.updateDisplay(true);
                    } else {
                        bl = false;
                    }
                }
                return bl;
            }

            public boolean fileChosen(File file) {
                return KeyboardShortcutsPrefPanel.this.fileChosenFromCombo(file);
            }

            public void otherItemChosen(Object object) {
                if (KeyboardShortcutsPrefPanel.this.fConfigurationCombo != null) {
                    assert (object instanceof KeyBindingSetEntry) : "Item chosen was expected to be an instance of KeyBindingSetEntry";
                    KeyBindingSetEntry keyBindingSetEntry = (KeyBindingSetEntry)object;
                    if (!keyBindingSetEntry.wasCreatedFromDefaultSet() && !keyBindingSetEntry.getFile().exists()) {
                        KeyboardShortcutsPrefPanel.this.showErrorMessage(MessageFormat.format(KeyBindingPanelUtils.lookup("keybindingSet.fileNoLongerExists"), com.mathworks.util.FileUtils.truncatePathname((String)keyBindingSetEntry.getFile().getPath())));
                        KeyboardShortcutsPrefPanel.this.fConfigurationCombo.getComboBox().removeItem(object);
                    } else {
                        KeyboardShortcutsPrefPanel.this.updateSetInProgress(keyBindingSetEntry);
                        KeyboardShortcutsPrefPanel.this.updateBottomPanels();
                        KeyboardShortcutsPrefPanel.this.updateDisplay(true);
                    }
                }
            }
        };
        LinkedList linkedList = new LinkedList(this.fManager.getAllSetsForPlatform());
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        for (KeyBindingSet keyBindingSet : this.fManager.getAllSetsForPlatform()) {
            if (!keyBindingSet.isModifiedDefault()) continue;
            object = CustomKeyBindingSetUtils.getParentSetFromModifiedDefault((KeyBindingSet)keyBindingSet);
            linkedList.remove(object);
            KeyBindingSetEntry keyBindingSetEntry = this.createEntryForModifiedDefaultSet(keyBindingSet);
            linkedList2.add(keyBindingSetEntry);
            linkedList.remove(keyBindingSet);
            if (keyBindingSet != this.fManager.getCurrentKeyBindingSet()) continue;
            this.updateSetInProgress(keyBindingSetEntry);
        }
        for (KeyBindingSet keyBindingSet : linkedList) {
            object = this.fManager.getDefaultKeyBindingSets().contains(keyBindingSet) ? this.createEntryForDefaultSet(keyBindingSet) : this.createEntryForCustomSet(keyBindingSet);
            linkedList2.add(object);
            if (keyBindingSet != this.fManager.getCurrentKeyBindingSet()) continue;
            this.updateSetInProgress((KeyBindingSetEntry)object);
        }
        linkedList2.add((Object)FileExchangeEntry.ALL_SETS);
        assert (this.fSetInProgress != null) : "The currently active keybinding set is not represented in the combo box of all available sets: " + this.fManager.getCurrentKeyBindingSet();
        Iterator iterator = new FileComboBox(fileChosenCallback, linkedList2.toArray()){

            protected void prepareChooser(MJFileChooserPerPlatform mJFileChooserPerPlatform) {
                mJFileChooserPerPlatform.addChoosableFileFilter(new FilePatternFilter(){

                    public String getDescription() {
                        return KeyBindingPanelUtils.lookup("keybinding.filefilter");
                    }

                    public String[] getPatterns() {
                        return new String[]{"*.xml"};
                    }
                });
                mJFileChooserPerPlatform.addChoosableFileFilter(new FilePatternFilter(){

                    public String getDescription() {
                        return KeyBindingPanelUtils.lookup("keybinding.filefilter.txt");
                    }

                    public String[] getPatterns() {
                        return new String[]{"*.txt"};
                    }
                });
            }

            protected File getSelectedFileForChooser() {
                return KeyboardShortcutsPrefPanel.this.fSetInProgress.getFile();
            }
        };
        iterator.getComboBox().setName("KeyBindingFileChooser");
        iterator.getComboBox().getAccessibleContext().setAccessibleName("Active shortcut set");
        iterator.setSelectedItem(this.fSetInProgress);
        return iterator;
    }

    private boolean saveAsFromCombo(File file) {
        try {
            if (this.fPrefSetter.isModifiedDefaultFile(file)) {
                this.showErrorMessage(MessageFormat.format(KeyBindingPanelUtils.lookup("keybindingSet.userTriedToSaveOverModifiedDefault.error"), file.getName()));
                return false;
            }
            CustomKeyBindingSetUtils.writeToFile((File)file, (CustomKeyBindingSet)this.fSetInProgress.getModifiableSet());
            this.fSetInProgress.discardChangesFromParent();
            return true;
        }
        catch (Exception exception) {
            this.showErrorMessage(exception);
            return false;
        }
    }

    private boolean fileChosenFromCombo(File file) {
        try {
            CustomKeyBindingSet customKeyBindingSet = CustomKeyBindingSetUtils.readFromFile((File)file, (KeyBindingManagerRegistry)this.fManager);
            if (customKeyBindingSet.isModifiedDefault()) {
                this.showErrorMessage(MessageFormat.format(KeyBindingPanelUtils.lookup("keybindingSet.userSelectedModifiedDefault.error"), file.getName()));
                return false;
            }
            KeyBindingSetEntry keyBindingSetEntry = this.createEntryForCustomSet((KeyBindingSet)customKeyBindingSet);
            int n = this.fConfigurationCombo.getComboBox().getItemCount() - 2;
            if (this.fManager.containsCustomKeyBindingSet(customKeyBindingSet.getID())) {
                this.fManager.updateCustomKeyBindingSet(customKeyBindingSet);
                for (int i = 0; i != this.fConfigurationCombo.getComboBox().getItemCount(); ++i) {
                    Object object = this.fConfigurationCombo.getComboBox().getItemAt(i);
                    if (!(object instanceof KeyBindingSetEntry) || !object.toString().equals(keyBindingSetEntry.toString())) continue;
                    n = i;
                    this.fConfigurationCombo.getComboBox().removeItem(object);
                    break;
                }
            } else {
                this.fManager.addCustomKeyBindingSet(customKeyBindingSet);
            }
            this.fConfigurationCombo.getComboBox().insertItemAt((Object)keyBindingSetEntry, n);
            this.fConfigurationCombo.setSelectedItem((Object)keyBindingSetEntry);
            this.fPrefSetter.addCustomSetToPrefs(file);
        }
        catch (Exception exception) {
            if (exception.getMessage() != null && exception.getMessage().length() > 0) {
                this.showErrorMessage(exception);
            }
            this.showErrorMessage(KeyBindingPanelUtils.lookup("keybindingSet.userSelectedBadFile.error"));
        }
        return false;
    }

    private void updateDisplay(boolean bl) {
        if (bl) {
            this.fFilterText.setSearchText("");
        }
        this.resetMutableTableData();
        this.updateRestoreDefaultState();
    }

    private void updateRestoreDefaultState() {
        this.fRestoreDefaults.setEnabled(this.fSetInProgress.isModifiedDefaultSetEntry());
    }

    private ActionData getSelectedAction() {
        EventList eventList = this.fSelectionModel.getSelected();
        if (eventList == null || eventList.isEmpty()) {
            return null;
        }
        assert (eventList.size() == 1) : "Only single row selection is allowed";
        return ((KeybindingData)eventList.get(0)).getActionData();
    }

    private MJTable createTable(EventTableModel<KeybindingData> eventTableModel, EventSelectionModel<KeybindingData> eventSelectionModel, SortedList<KeybindingData> sortedList) {
        assert (this.fTable == null) : "createTable should not be called multiple times";
        MJTable mJTable = new MJTable((TableModel)eventTableModel, (EventTableModel)eventTableModel){
            final /* synthetic */ EventTableModel val$model;
            {
                this.val$model = eventTableModel;
                super(tableModel);
            }

            public Dimension getPreferredScrollableViewportSize() {
                Dimension dimension = super.getPreferredScrollableViewportSize();
                return new Dimension((int)dimension.getWidth(), this.getRowHeight() * (KeyBindingPanelUtils.SPACING_IS_TIGHT ? 5 : 6));
            }

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    ActionData actionData = ((KeybindingData)this.val$model.getElementAt(n)).getActionData();
                    String string = n2 == 0 ? KeyBindingPanelUtils.getConflictDescription(KeyboardShortcutsPrefPanel.this.fManager, (KeyBindingSet)KeyboardShortcutsPrefPanel.this.fSetInProgress.getModifiableSet(), actionData) : KeyBindingPanelUtils.getActionDescription(actionData);
                    jComponent.setToolTipText(string);
                }
                return component;
            }

            public JPopupMenu getComponentPopupMenu() {
                MJPopupMenu mJPopupMenu = new MJPopupMenu();
                ActionData actionData = KeyboardShortcutsPrefPanel.this.getSelectedAction();
                if (actionData != null) {
                    final boolean bl = KeyboardShortcutsPrefPanel.this.getAllBindingsForAction(actionData).size() == 0;
                    String string = bl ? MessageFormat.format(KeyBindingPanelUtils.lookup("keybinding.addShortcut"), actionData.getPreferencePanelLabel()) : MessageFormat.format(KeyBindingPanelUtils.lookup("keybinding.editShortcut"), actionData.getPreferencePanelLabel());
                    mJPopupMenu.add((Action)new MJAbstractAction(string){

                        public void actionPerformed(ActionEvent actionEvent) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (bl) {
                                        KeyboardShortcutsPrefPanel.this.fShortcutModifierPanel.addNewShortcut();
                                    } else {
                                        KeyboardShortcutsPrefPanel.this.fShortcutModifierPanel.editFirstShortcut();
                                    }
                                }
                            });
                        }
                    });
                    mJPopupMenu.addSeparator();
                }
                mJPopupMenu.add((Action)KeyboardShortcutsPrefPanel.this.getCopyAction());
                mJPopupMenu.add((JMenuItem)KeyboardShortcutsPrefPanel.this.getComparisonMenu());
                return mJPopupMenu;
            }
        };
        mJTable.setSelectionModel(eventSelectionModel);
        mJTable.setName("ActionTable");
        TableComparatorChooser.install((JTable)mJTable, sortedList, (Object)AbstractTableComparatorChooser.SINGLE_COLUMN);
        mJTable.getColumnModel().getColumn(2).setPreferredWidth(150);
        mJTable.getColumnModel().getColumn(0).setCellRenderer(new ConflictTableRenderer());
        mJTable.getColumnModel().getColumn(0).setMaxWidth(KeyBindingPanelUtils.getConflictColumnWidth());
        mJTable.setAccessibleTextProvider(new AccessibleTextProvider(){

            public String getAccessibleText(int n, int n2) {
                KeybindingData keybindingData = (KeybindingData)KeyboardShortcutsPrefPanel.this.fTableModel.getElementAt(n);
                String string = keybindingData.getName();
                string = keybindingData.getKeybindings().length() > 0 ? string + " assigned " + keybindingData.getKeybindings() : string + " with no assigned shortcuts ";
                if (keybindingData.getConflictType() == KeyBindingPanelUtils.ConflictType.ERROR) {
                    string = string + " and warning message " + KeyBindingPanelUtils.getConflictDescription(KeyboardShortcutsPrefPanel.this.fManager, (KeyBindingSet)KeyboardShortcutsPrefPanel.this.fSetInProgress.getModifiableSet(), keybindingData.getActionData());
                } else if (keybindingData.getConflictType() == KeyBindingPanelUtils.ConflictType.WARNING) {
                    string = string + " and informational message " + KeyBindingPanelUtils.getConflictDescription(KeyboardShortcutsPrefPanel.this.fManager, (KeyBindingSet)KeyboardShortcutsPrefPanel.this.fSetInProgress.getModifiableSet(), keybindingData.getActionData());
                }
                return string;
            }
        });
        return mJTable;
    }

    private MJMenu getComparisonMenu() {
        MJMenu mJMenu = new MJMenu(MessageFormat.format(KeyBindingPanelUtils.lookup("keybinding.compareMenu.compareTo"), KeyboardShortcutsPrefPanel.getAbbreviatedUserVisibleName(this.fSetInProgress)));
        this.maybeCreateDefaultEntryForModifiedDefault(mJMenu, this.fSetInProgress);
        for (int i = 0; i < this.fConfigurationCombo.getComboBox().getItemCount(); ++i) {
            Object object = this.fConfigurationCombo.getComboBox().getItemAt(i);
            if (!(object instanceof KeyBindingSetEntry) || object.equals(this.fSetInProgress)) continue;
            KeyBindingSetEntry keyBindingSetEntry = (KeyBindingSetEntry)object;
            mJMenu.add((Action)((Object)new CompareSetsAction(keyBindingSetEntry)));
            this.maybeCreateDefaultEntryForModifiedDefault(mJMenu, keyBindingSetEntry);
        }
        return mJMenu;
    }

    private void maybeCreateDefaultEntryForModifiedDefault(MJMenu mJMenu, KeyBindingSetEntry keyBindingSetEntry) {
        if (keyBindingSetEntry.isModifiedDefaultSetEntry()) {
            mJMenu.add((Action)((Object)new CompareSetsAction(this.createEntryForDefaultSet((KeyBindingSet)keyBindingSetEntry.getModifiableSet().getParent()))));
        }
    }

    private MJAbstractAction getCopyAction() {
        MJAbstractAction mJAbstractAction = new MJAbstractAction(KeyBindingPanelUtils.lookup("keybinding.copyAction")){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionData[] actionDataArray = new ActionData[KeyboardShortcutsPrefPanel.this.fTable.getRowCount()];
                for (int i = 0; i != actionDataArray.length; ++i) {
                    actionDataArray[i] = ((KeybindingData)KeyboardShortcutsPrefPanel.this.fTableModel.getElementAt(i)).getActionData();
                }
                MJClipboard.getMJClipboard().setContents((Transferable)new MJTransferable((Object)KeyBindingPanelUtils.getStringRepresentation(KeyboardShortcutsPrefPanel.this.fManager, (KeyBindingSet)KeyboardShortcutsPrefPanel.this.fSetInProgress.getModifiableSet(), KeyboardShortcutsPrefPanel.getAbbreviatedUserVisibleName(KeyboardShortcutsPrefPanel.this.fSetInProgress), actionDataArray), DataFlavor.stringFlavor), null);
            }
        };
        mJAbstractAction.setComponentName(NAME_COPY_SET);
        return mJAbstractAction;
    }

    private void writeSetToTextFile(KeyBindingSetEntry keyBindingSetEntry, File file) throws IOException {
        ArrayList arrayList = new ArrayList(this.fManager.getActions());
        Collections.sort(arrayList, new ActionComparator());
        FileUtils.writeStringToFile((File)file, (String)KeyBindingPanelUtils.getStringRepresentation(this.fManager, (KeyBindingSet)keyBindingSetEntry.getModifiableSet(), KeyboardShortcutsPrefPanel.getAbbreviatedUserVisibleName(keyBindingSetEntry), arrayList.toArray(new ActionData[arrayList.size()])));
    }

    private KeyBindingSetEntry createEntryForDefaultSet(KeyBindingSet keyBindingSet) {
        assert (!keyBindingSet.isModifiedDefault()) : "This method should not be called with a modified default set";
        return new KeyBindingSetEntry(this.fManager, this.fPrefSetter, keyBindingSet, true, this.fChangeListener);
    }

    private KeyBindingSetEntry createEntryForModifiedDefaultSet(KeyBindingSet keyBindingSet) {
        assert (keyBindingSet.isModifiedDefault()) : "This method should be called with a modified default set";
        return new KeyBindingSetEntry(this.fManager, this.fPrefSetter, keyBindingSet, true, this.fChangeListener);
    }

    private KeyBindingSetEntry createEntryForCustomSet(KeyBindingSet keyBindingSet) {
        assert (!keyBindingSet.isModifiedDefault()) : "This method should not be called with a modified default set";
        return new KeyBindingSetEntry(this.fManager, this.fPrefSetter, keyBindingSet, false, this.fChangeListener);
    }

    private void updateBottomPanels() {
        ActionData actionData = this.getSelectedAction();
        this.fShortcutModifierPanel.selectedActionChanged(actionData, this.fSetInProgress);
        this.fConflictPanel.selectedActionChanged(actionData, this.fSetInProgress);
    }

    private void updateSetInProgress(KeyBindingSetEntry keyBindingSetEntry) {
        this.fSetInProgress = keyBindingSetEntry;
    }

    private void resetMutableTableData() {
        for (int i = 0; i < this.fTable.getRowCount(); ++i) {
            ((KeybindingData)this.fTableModel.getElementAt(i)).clearConflictType();
            this.fTableModel.fireTableCellUpdated(i, 0);
            this.fTableModel.fireTableCellUpdated(i, 2);
        }
    }

    private void showErrorMessage(Exception exception) {
        String string = exception.getMessage();
        if (exception.getCause() != null && exception.getCause().getMessage() != null) {
            string = string + "\n" + exception.getCause().getMessage();
        } else if (string == null) {
            string = exception.toString() + "\n";
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                string = string + stackTraceElement.toString() + "\n";
            }
        }
        this.showErrorMessage(string);
    }

    private void showErrorMessage(String string) {
        this.fErrorHandler.handleError(string, (Component)((Object)this));
    }

    private FilterList<KeybindingData> getData(TextComponentMatcherEditor<KeybindingData> textComponentMatcherEditor) {
        BasicEventList basicEventList = new BasicEventList();
        for (ActionData actionData : this.fManager.getNonHiddenActions()) {
            basicEventList.add((Object)new KeybindingData(actionData));
        }
        return new FilterList((EventList)basicEventList, (MatcherEditor)new ThreadedMatcherEditor(textComponentMatcherEditor));
    }

    private EventTableModel<KeybindingData> createTableModel(SortedList<KeybindingData> sortedList) {
        assert (this.fTableModel == null) : "createTableModel should not be called multiple times";
        String[] stringArray = new String[]{"conflictType", "name", "keybindings"};
        String[] stringArray2 = new String[]{"", KeyBindingPanelUtils.lookup("keybinding.action"), KeyBindingPanelUtils.lookup("keybinding.shortcutsHeader")};
        TableFormat tableFormat = GlazedLists.tableFormat(KeybindingData.class, (String[])stringArray, (String[])stringArray2);
        return new EventTableModel<KeybindingData>(sortedList, tableFormat){

            public void listChanged(ListEvent<KeybindingData> listEvent) {
                super.listChanged(listEvent);
                for (int i = 0; i < this.getRowCount(); ++i) {
                    ((KeybindingData)this.getElementAt(i)).clearConflictType();
                }
            }
        };
    }

    private List<KeyStrokeList> getAllBindingsForAction(ActionData actionData) {
        KeyBindingSetEntry keyBindingSetEntry = this.fSetInProgress;
        ArrayList<KeyStrokeList> arrayList = new ArrayList<KeyStrokeList>();
        block0: for (KeyStrokeList keyStrokeList : keyBindingSetEntry.getActionGlobalKeyBindings(actionData)) {
            if (arrayList.contains(keyStrokeList)) continue;
            for (Context context : this.fManager.getContextsWithAction((ActionDataID)actionData)) {
                if (!keyBindingSetEntry.followsGlobalContext(context, (ActionDataID)actionData)) continue;
                arrayList.add(keyStrokeList);
                continue block0;
            }
        }
        for (KeyStrokeList keyStrokeList : this.fManager.getContextsWithAction((ActionDataID)actionData)) {
            if (keyBindingSetEntry.getFollowsComponentContext((Context)keyStrokeList, (ActionDataID)actionData)) continue;
            for (KeyStrokeList keyStrokeList2 : keyBindingSetEntry.getNonGlobalKeyBindings((Context)keyStrokeList, (ActionDataID)actionData)) {
                if (arrayList.contains(keyStrokeList2)) continue;
                arrayList.add(keyStrokeList2);
            }
        }
        return arrayList;
    }

    public void addKeybindingFile(File file) {
        this.fileChosenFromCombo(file);
    }

    static KeyboardShortcutsPrefPanel getInstance() {
        return sInstance;
    }

    public static MJPanel createPrefsPanel() {
        return KeyboardShortcutsPrefPanel.createPrefsPanel(MatlabKeyBindings.getManager(), MatlabKeyBindings.getKeyBindingPreferences(), new DefaultQueryImplementor(), new DefaultErrorHandler());
    }

    public static KeyboardShortcutsPrefPanel createPrefsPanel(KeyBindingManager keyBindingManager, KeyBindingPreferences keyBindingPreferences, QueryUserAboutUnsavedSet queryUserAboutUnsavedSet, ErrorHandler errorHandler) {
        assert (SwingUtilities.isEventDispatchThread()) : "Prefs panel must be created on the EDT";
        if (sInstance != null) {
            sInstance.dispose();
        }
        sInstance = new KeyboardShortcutsPrefPanel(keyBindingManager, keyBindingPreferences, queryUserAboutUnsavedSet, errorHandler);
        return sInstance;
    }

    public static String[] getHelpInfo() {
        return new String[]{MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlab_env_shortcuts_prefs"};
    }

    public static void commitPrefsChanges(boolean bl) {
        sInstance.doCommit(bl);
    }

    private void doCommit(boolean bl) {
        if (bl) {
            try {
                ((KeyBindingSetEntry)this.fConfigurationCombo.getSelectedItem()).saveKeyBindingSet();
            }
            catch (Exception exception) {
                this.showErrorMessage(exception);
            }
        }
    }

    private void dispose() {
        this.fSelectionModel.dispose();
        this.fFilterList.dispose();
        this.fSortedList.dispose();
        this.fTableModel.dispose();
    }

    public static boolean validatePrefsPanel() {
        return sInstance.isAbleToSave();
    }

    private boolean isAbleToSave() {
        if (!((KeyBindingSetEntry)this.fConfigurationCombo.getSelectedItem()).setHasBeenModifiedByUser()) {
            return true;
        }
        try {
            ((KeyBindingSetEntry)this.fConfigurationCombo.getSelectedItem()).checkCustomSetCanBeWritten();
            return true;
        }
        catch (Exception exception) {
            this.showErrorMessage(exception);
            return false;
        }
    }

    private static String getAbbreviatedUserVisibleName(KeyBindingSetEntry keyBindingSetEntry) {
        return keyBindingSetEntry.getUserVisibleName(25);
    }

    public CustomKeyBindingSet getSelectedSet() {
        return this.fSetInProgress.getModifiableSet();
    }

    public void setSelectedSet(KeyBindingSet keyBindingSet) {
        for (int i = 0; i != this.fConfigurationCombo.getComboBox().getItemCount(); ++i) {
            KeyBindingSetEntry keyBindingSetEntry;
            if (!(this.fConfigurationCombo.getComboBox().getItemAt(i) instanceof KeyBindingSetEntry) || !(keyBindingSetEntry = (KeyBindingSetEntry)this.fConfigurationCombo.getComboBox().getItemAt(i)).getModifiableSet().isInfoEqual(keyBindingSet)) continue;
            this.fConfigurationCombo.setSelectedItem((Object)keyBindingSetEntry);
            return;
        }
        throw new IllegalArgumentException("Set specified not in combo box " + keyBindingSet);
    }

    public void deleteActiveCustomSet() {
        int n = this.fConfigurationCombo.getComboBox().getItemCount();
        this.fDeleteSetAction.actionPerformed(new ActionEvent((Object)this, 0, UNIT_TEST_DELETE_WITHOUT_PROMPT));
        int n2 = n - 1;
        if (n2 != this.fConfigurationCombo.getComboBox().getItemCount()) {
            throw new IllegalStateException("Wrong number of entries of custom set deletion. Expected " + n2 + " but had " + this.fConfigurationCombo.getComboBox().getItemCount());
        }
    }

    public void saveAs(File file) {
        this.saveAsFromCombo(file);
    }

    public boolean isSelectedSetModified() {
        return this.fConfigurationCombo.getSelectedItem().toString().contains(KeyBindingPanelUtils.markAsModified(""));
    }

    public void selectAction(ActionData actionData) {
        for (int i = 0; i != this.fTable.getRowCount(); ++i) {
            if (!actionData.getID().equals(((KeybindingData)this.fTableModel.getElementAt(i)).getActionData().getID())) continue;
            this.fSelectionModel.setSelectionInterval(i, i);
            break;
        }
    }

    public boolean containsAction(ActionData actionData) {
        for (int i = 0; i != this.fTable.getRowCount(); ++i) {
            if (!actionData.getID().equals(((KeybindingData)this.fTableModel.getElementAt(i)).getActionData().getID())) continue;
            return true;
        }
        return false;
    }

    public void clearSelectedAction() {
        this.fSelectionModel.clearSelection();
    }

    public boolean isRestoreDefaultEnabled() {
        return this.fRestoreDefaults.isEnabled();
    }

    public void restoreDefault() {
        assert (this.isRestoreDefaultEnabled());
        this.fRestoreDefaults.actionPerformed(new ActionEvent("unit test event", 1, ""));
    }

    public boolean isUnassignButtonEnabled() {
        return this.fConflictPanel.isUnassignButtonEnabled();
    }

    public void unassignConflict() {
        this.fConflictPanel.unassignConflict();
    }

    public int getNumberOfConflicts() {
        return this.fConflictPanel.getNumberOfConflicts();
    }

    public void selectConflictByAction(ActionData actionData) {
        this.fConflictPanel.selectConflictByAction(actionData);
    }

    public void clearConflictTableSelection() {
        this.fConflictPanel.clearConflictTableSelection();
    }

    public int getShortcutTableNumRows() {
        return this.fShortcutModifierPanel.getShortcutTableNumRows();
    }

    public boolean isAddButtonEnabled() {
        return this.fShortcutModifierPanel.isAddButtonEnabled();
    }

    public boolean isDeleteButtonEnabled() {
        return this.fShortcutModifierPanel.isDeleteButtonEnabled();
    }

    public void addNewBinding(KeyStrokeList keyStrokeList) {
        assert (!this.fSelectionModel.isSelectionEmpty()) : "Can't add a binding if no action is selected";
        this.fShortcutModifierPanel.addNewBinding(keyStrokeList);
    }

    public void deleteBinding() {
        this.fShortcutModifierPanel.deleteBinding();
    }

    public void selectKeybindingEntry(int n) {
        this.fShortcutModifierPanel.selectKeybindingEntry(n);
    }

    public void setContextSelected(Context context, boolean bl, int n) {
        this.fShortcutModifierPanel.setContextSelected(context, bl, n);
    }

    public void changeBinding(KeyStrokeList keyStrokeList, int n) {
        this.fShortcutModifierPanel.changeBinding(keyStrokeList, n);
    }

    public KeyStrokeList getBinding(int n) {
        return this.fShortcutModifierPanel.getBinding(n);
    }

    public void clearGlobalBinding() {
        this.fShortcutModifierPanel.clearGlobalBinding();
    }

    public void copyCurrentSet() {
        this.getCopyAction().actionPerformed(new ActionEvent("unit test event", 0, ""));
    }

    public void setSearchFieldSelection(int n, int n2) {
        this.fFilterText.setSearchSelection(n, n2);
    }

    private class FilterInfo
    implements TextFilterator<KeybindingData> {
        private FilterInfo() {
        }

        public void getFilterStrings(List<String> list, KeybindingData keybindingData) {
            list.add(keybindingData.getName());
            list.add(keybindingData.getCategory());
            Collection collection = KeyboardShortcutsPrefPanel.this.fManager.getContextsWithAction((ActionDataID)keybindingData.getActionData());
            for (Context context : collection) {
                list.add(context.getName());
            }
            list.add(keybindingData.getKeybindings());
        }
    }

    private static class ActionComparable
    implements Comparator<KeybindingData> {
        private ActionComparable() {
        }

        @Override
        public int compare(KeybindingData keybindingData, KeybindingData keybindingData2) {
            return keybindingData.getName().compareTo(keybindingData2.getName());
        }
    }

    public class KeybindingData {
        private final ActionData fActionData;
        private KeyBindingPanelUtils.ConflictType fConflictType;

        private KeybindingData(ActionData actionData) {
            this.fActionData = actionData;
        }

        public String getName() {
            return this.fActionData.getPreferencePanelLabel();
        }

        public KeyBindingPanelUtils.ConflictType getConflictType() {
            this.calculateConflicts();
            return this.fConflictType;
        }

        public String getKeybindings() {
            List list = KeyboardShortcutsPrefPanel.this.getAllBindingsForAction(this.fActionData);
            return this.printList(list);
        }

        void calculateConflicts() {
            if (this.fConflictType == null) {
                this.fConflictType = KeyBindingPanelUtils.getConflictType(KeyboardShortcutsPrefPanel.this.fManager, (KeyBindingSet)KeyboardShortcutsPrefPanel.this.fSetInProgress.getModifiableSet(), this.getActionData());
            }
        }

        void clearConflictType() {
            this.fConflictType = null;
        }

        String getCategory() {
            return this.fActionData.getCategory();
        }

        ActionData getActionData() {
            return this.fActionData;
        }

        private String printList(Collection<KeyStrokeList> collection) {
            String string = "";
            String string2 = "; ";
            for (KeyStrokeList keyStrokeList : collection) {
                string = string + KeyStrokeUtils.translateKeyStrokes((KeyStrokeList)keyStrokeList) + string2;
            }
            if (string.length() >= 2) {
                string = string.substring(0, string.length() - string2.length());
            }
            return string;
        }
    }

    private class ConflictTableRenderer
    extends KeyBindingPanelUtils.ConflictRenderer {
        private ConflictTableRenderer() {
        }

        @Override
        public KeyBindingPanelUtils.ConflictType getConflictType(int n) {
            return ((KeybindingData)KeyboardShortcutsPrefPanel.this.fTableModel.getElementAt(n)).getConflictType();
        }
    }

    private class SetChangeListener
    implements CustomKeyBindingSet.ChangeListener {
        private SetChangeListener() {
        }

        public void setChanged() {
            KeyboardShortcutsPrefPanel.this.resetMutableTableData();
            KeyboardShortcutsPrefPanel.this.updateRestoreDefaultState();
            KeyboardShortcutsPrefPanel.this.fConfigurationCombo.getComboBox().repaint();
            KeyboardShortcutsPrefPanel.this.fShortcutModifierPanel.setChanged();
            KeyboardShortcutsPrefPanel.this.fConflictPanel.setChanged(KeyboardShortcutsPrefPanel.this.getSelectedAction());
        }
    }

    private static class ShortcutPromptingFieldProcessor
    implements KeyEventPreprocessor {
        private ShortcutPromptingFieldProcessor() {
        }

        public void processComponentKeyEvent(KeyEvent keyEvent, JTextComponent jTextComponent) {
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                return;
            }
            ShortcutPromptingFieldProcessor.convertShortcutsToText(keyEvent, jTextComponent);
        }

        private static void convertShortcutsToText(KeyEvent keyEvent, JTextComponent jTextComponent) {
            if (!(keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8 || keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 39 || keyEvent.getKeyCode() == 27 || keyEvent.getKeyCode() == 524 || keyEvent.getKeyCode() == 525 || (Character.isLetterOrDigit(keyEvent.getKeyChar()) || Character.isSpaceChar(keyEvent.getKeyChar())) && (keyEvent.getModifiers() == 1 || keyEvent.getModifiers() == 0) || (keyEvent.getKeyChar() == ',' || keyEvent.getKeyChar() == '.') && keyEvent.getModifiers() == 0 || keyEvent.getKeyChar() == '+' && (keyEvent.getModifiers() == 0 || keyEvent.getModifiers() == 1) || ShortcutPromptingFieldProcessor.isComposing(jTextComponent) || keyEvent.getKeyCode() >= 240 && keyEvent.getKeyCode() <= 245 || keyEvent.getKeyCode() >= 256 && keyEvent.getKeyCode() <= 263)) {
                keyEvent.consume();
                if (keyEvent.getID() == 401 && !ShortcutPromptingFieldProcessor.isModifierOnly(keyEvent)) {
                    String string = jTextComponent.getText();
                    int n = jTextComponent.getSelectionStart();
                    int n2 = jTextComponent.getSelectionEnd();
                    String string2 = " ";
                    String string3 = string.substring(0, n);
                    string3 = string3 + (n > 0 ? string2 : "");
                    string3 = string3 + KeyStrokeUtils.translateKeyStroke((KeyStroke)KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers()));
                    int n3 = string3.length();
                    string3 = string3 + (n2 < string.length() ? string2 : "");
                    string3 = string3 + string.substring(n2);
                    jTextComponent.setText(string3);
                    jTextComponent.setCaretPosition(n3);
                }
            }
        }

        private static boolean isComposing(JTextComponent jTextComponent) {
            try {
                return jTextComponent.getInputContext() != null && jTextComponent.getInputContext().isCompositionEnabled();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                return false;
            }
        }

        private static boolean isModifierOnly(KeyEvent keyEvent) {
            return keyEvent.getKeyCode() == KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK || keyEvent.getKeyCode() == 157 || keyEvent.getKeyCode() == 18 || keyEvent.getKeyCode() == 17 || keyEvent.getKeyCode() == 16;
        }
    }

    private static class ContextMenuWithoutShortcuts
    extends TextContextMenu {
        private ContextMenuWithoutShortcuts() {
        }

        protected void initializeWithKeybindingManager(MJAbstractAction mJAbstractAction, KeyBindingManager keyBindingManager, String string, String string2) {
            keyBindingManager.addActionInfoOnly(string2, string, (ExtendedAction)mJAbstractAction);
        }
    }

    private class TableListener
    implements ListSelectionListener {
        private TableListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                KeyboardShortcutsPrefPanel.this.updateBottomPanels();
            }
        }
    }

    private static class DefaultErrorHandler
    implements ErrorHandler {
        private DefaultErrorHandler() {
        }

        @Override
        public void handleError(String string, Component component) {
            MJOptionPane.showMessageDialog((Component)component, (Object)string, (String)KeyBindingPanelUtils.lookup("keybinding.saveChanges.DialogTitle"), (int)0);
        }
    }

    private static class DefaultQueryImplementor
    implements QueryUserAboutUnsavedSet {
        private DefaultQueryImplementor() {
        }

        @Override
        public QueryUserAboutUnsavedSet.UserChangeSetResponse queryUser(Component component, String string) {
            int n = Dialogs.showSaveDirtyFile((Component)component, (String)string, (String)KeyBindingPanelUtils.lookup("keybinding.saveChanges.DialogTitle"));
            return n == 0 ? QueryUserAboutUnsavedSet.UserChangeSetResponse.SAVE_PREVIOUS : (n == 1 ? QueryUserAboutUnsavedSet.UserChangeSetResponse.DONT_SAVE_PREVIOUS : QueryUserAboutUnsavedSet.UserChangeSetResponse.CANCEL);
        }
    }

    public static interface ErrorHandler {
        public void handleError(String var1, Component var2);
    }

    public static interface QueryUserAboutUnsavedSet {
        public UserChangeSetResponse queryUser(Component var1, String var2);

        public static enum UserChangeSetResponse {
            SAVE_PREVIOUS,
            DONT_SAVE_PREVIOUS,
            CANCEL;

        }
    }

    private static class ActionComparator
    implements Comparator<ActionData> {
        private ActionComparator() {
        }

        @Override
        public int compare(ActionData actionData, ActionData actionData2) {
            return actionData.getPreferencePanelLabel().compareTo(actionData2.getPreferencePanelLabel());
        }
    }

    private class CompareSetsAction
    extends MJAbstractAction {
        private final KeyBindingSetEntry iComparisonSet;

        CompareSetsAction(KeyBindingSetEntry keyBindingSetEntry) {
            this.iComparisonSet = keyBindingSetEntry;
            this.setName(KeyboardShortcutsPrefPanel.getAbbreviatedUserVisibleName(this.iComparisonSet));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                new MatlabMCR().evalConsoleOutput("visdiff('" + this.writeSetToTempFile(this.iComparisonSet).getPath() + "', '" + this.writeSetToTempFile(KeyboardShortcutsPrefPanel.this.fSetInProgress).getPath() + "');");
            }
            catch (IOException iOException) {
                KeyboardShortcutsPrefPanel.this.showErrorMessage(iOException);
            }
        }

        private File writeSetToTempFile(KeyBindingSetEntry keyBindingSetEntry) throws IOException {
            String string = keyBindingSetEntry.wasCreatedFromDefaultSet() ? keyBindingSetEntry.toString() : FilenameUtils.getBaseName((String)keyBindingSetEntry.getFile().getName());
            File file = com.mathworks.util.FileUtils.getNextNamedFile((File)new File(SystemUtils.JAVA_IO_TMPDIR), (String)(string + " "), (String)KeyboardShortcutsPrefPanel.TXT_EXTENSION, (FileFilter[])new FileFilter[0]);
            KeyboardShortcutsPrefPanel.this.writeSetToTextFile(keyBindingSetEntry, file);
            return file;
        }
    }
}

