/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.tabcompletion;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.mlwidgets.tabcompletion.MatlabTabContext;
import com.mathworks.mlwidgets.tabcompletion.TabCompletionInterface;
import com.mathworks.mlwidgets.tabcompletion.TabCompletionModel;
import com.mathworks.mlwidgets.tabcompletion.TabCompletionResult;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MPopup;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.services.KeyboardPrefs;
import com.mathworks.util.Log;
import com.mathworks.widgets.tooltip.TooltipUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import org.apache.commons.lang.Validate;

public class TabCompletionView {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.mlwidgets.tabcompletion.resources.RES_TabComp");
    public static final String POPUP_WINDOW_NAME = "TabCompletionPopup";
    public static final String POPUP_LIST_NAME = "TabCompletionList";
    private static final int NO_SELECTION = -1;
    static final int CLEANUP = -2;
    static final int NARROW = -3;
    private TabCompletionJList fListComponent = new TabCompletionJList();
    private MJScrollPane fScrollPane;
    private MPopup fPopup;
    private CaretListener fParentCaretListener;
    private DocumentListener fDocListener;
    private ComponentAdapter fComponentAdapter;
    private MouseListener fJListMouseListener;
    private ListSelectionListener fLSL;
    private TabFocusListener fFocusListener;
    private TabCompletionInterface fTabCompletionImpl;
    private int fLastStartIndex;
    private int fLastDot;
    private int fStartOffset;
    private int fWordOffset;
    private int fNarrowDotPos;
    private boolean fWaitingForCompletions = false;
    private MJAbstractAction fTabFinishListener;
    private EnterAction fEnterAction = new EnterAction();
    private NarrowAction fNarrowAction = new NarrowAction();

    public TabCompletionView(TabCompletionInterface tabCompletionInterface) {
        Validate.notNull((Object)tabCompletionInterface, (String)"Need a non-null TabCompletion interface");
        this.fTabCompletionImpl = tabCompletionInterface;
        this.fListComponent.setBackground(TooltipUtils.getTooltipBackground());
        this.fListComponent.setForeground(TooltipUtils.getTooltipFontColor());
        this.fListComponent.setSelectionMode(0);
        this.fListComponent.getAccessibleContext().setAccessibleName(BUNDLE.getString("cwtc.acc.tabcompl"));
        this.fListComponent.setFocusCycleRoot(true);
        this.fListComponent.setCellRenderer(new TabCompletionListRenderer());
        this.fListComponent.setFocusTraversalKeysEnabled(false);
        this.fListComponent.setName(POPUP_LIST_NAME);
        this.fFocusListener = new TabFocusListener();
        this.fScrollPane = new MJScrollPane((Component)((Object)this.fListComponent), 20, 30);
        this.fScrollPane.setViewportBorder(BorderFactory.createLineBorder(this.fListComponent.getBackground(), 4));
        this.fScrollPane.setBorder(UIManager.getBorder("ToolTip.border"));
        this.registerActions();
        this.fJListMouseListener = new JListMouseListener();
        this.fParentCaretListener = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                if (TabCompletionView.this.getModel().hasNoMatches()) {
                    TabCompletionView.this.cleanup();
                } else if (caretEvent.getDot() > 0) {
                    try {
                        TabCompletionView.this.findInList(caretEvent.getDot());
                    }
                    catch (BadLocationException badLocationException) {
                        Log.logException((Exception)badLocationException);
                    }
                } else {
                    TabCompletionView.this.cleanup();
                }
            }
        };
        this.fDocListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                TabCompletionView.this.cleanupIfTextBeforeTabChanged(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                TabCompletionView.this.cleanupIfTextBeforeTabChanged(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.fTabCompletionImpl.getComponent().getDocument().addDocumentListener(this.fDocListener);
    }

    private void cleanupIfTextBeforeTabChanged(DocumentEvent documentEvent) {
        boolean bl;
        boolean bl2 = bl = documentEvent.getOffset() < this.fStartOffset;
        if (bl) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TabCompletionView.this.cleanup();
                }
            });
        }
    }

    void cleanup() {
        this.cleanup(true);
    }

    void cleanup(boolean bl) {
        if (this.fTabCompletionImpl != null && this.fTabCompletionImpl.getComponent() != null) {
            Frame frame;
            this.fListComponent.removeFocusListener(this.fFocusListener);
            if (this.fPopup != null) {
                this.fPopup.hide();
                this.fPopup = null;
            }
            if (bl) {
                this.fTabCompletionImpl.getComponent().requestFocus();
            }
            this.fListComponent.removeMouseListener(this.fJListMouseListener);
            this.fTabCompletionImpl.getComponent().getDocument().removeDocumentListener(this.fDocListener);
            this.fTabCompletionImpl.getComponent().removeCaretListener(this.fParentCaretListener);
            this.fTabCompletionImpl.getComponent().removeComponentListener(this.fComponentAdapter);
            JScrollPane jScrollPane = this.fTabCompletionImpl.getScrollPane();
            if (jScrollPane != null) {
                jScrollPane.removeComponentListener(this.fComponentAdapter);
            }
            if ((frame = WindowUtils.getFrameForComponent((Component)this.fTabCompletionImpl.getComponent())) != null) {
                frame.removeComponentListener(this.fComponentAdapter);
            }
            this.fListComponent.removeListSelectionListener(this.fLSL);
            this.fStartOffset = 0;
            this.fWordOffset = 0;
            this.fTabFinishListener.actionPerformed(new ActionEvent(this, 1001, String.valueOf(-2)));
        }
    }

    private void findInList(int n) throws BadLocationException {
        if (!this.fWaitingForCompletions) {
            this.cleanup();
            return;
        }
        if (n < this.fStartOffset || this.fWordOffset < 0 || n - this.fWordOffset < 0) {
            this.cleanup();
            return;
        }
        this.checkWordOffset();
        this.checkOffset(n);
        if (this.getModel().hasNoMatches()) {
            return;
        }
        Segment segment = this.getSegment(n);
        String string = segment.toString();
        int n2 = this.findIndexInList(string, n);
        if (n2 == -1) {
            this.fListComponent.clearSelection();
        } else if (n2 == -2) {
            this.cleanup();
        } else {
            this.setSelectedIndexOnEventThread(n2);
        }
    }

    private Segment getSegment(int n) {
        Segment segment = new Segment();
        try {
            this.fTabCompletionImpl.getComponent().getDocument().getText(this.fWordOffset, n - this.fWordOffset, segment);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        return segment;
    }

    int findIndexInList(String string, int n) {
        String string2;
        char c;
        int n2;
        int n3 = 0;
        if (n == this.fLastDot + 1) {
            n3 = this.fLastStartIndex;
        }
        this.fLastDot = n;
        String string3 = string.toUpperCase(Locale.US);
        for (n2 = n3; n2 < this.getModel().getSize(); ++n2) {
            String string4 = this.getModel().getUpperCaseString(n2);
            if (!string4.startsWith(string3)) continue;
            this.fLastStartIndex = n2;
            return n2;
        }
        n2 = string3.length();
        if (n2 > 0 && ((c = string3.charAt(n2 - 1)) == ' ' || c == '(' || c == '.' || c == '\'') && (string2 = this.getModel().getUpperCaseString(this.fLastStartIndex)).equals(string3 = string3.substring(0, n2 - 1))) {
            return -2;
        }
        return -1;
    }

    private void setSelectedIndexOnEventThread(final int n) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                TabCompletionView.this.fListComponent.setSelectedIndex(n);
                TabCompletionView.this.fListComponent.ensureIndexIsVisible(n);
            }
        });
    }

    private void registerActions() {
        StopTabComplAction stopTabComplAction = new StopTabComplAction();
        this.fListComponent.getInputMap().put(KeyStroke.getKeyStroke(67, 2), "ctrlc");
        this.fListComponent.getActionMap().put("ctrlc", (Action)((Object)stopTabComplAction));
        this.fListComponent.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "esc");
        this.fListComponent.getActionMap().put("esc", (Action)((Object)stopTabComplAction));
        this.fListComponent.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "return");
        this.fListComponent.getActionMap().put("return", (Action)((Object)this.fEnterAction));
        this.fListComponent.getInputMap().put(KeyStroke.getKeyStroke(37, 0), "left");
        this.fListComponent.getActionMap().put("left", (Action)((Object)stopTabComplAction));
        this.fListComponent.getInputMap().put(KeyStroke.getKeyStroke(39, 0), "right");
        this.fListComponent.getActionMap().put("right", (Action)((Object)stopTabComplAction));
        Action action = (Action)this.fListComponent.getActionForKeyStroke(KeyStroke.getKeyStroke(38, 0));
        this.fListComponent.getInputMap().put(KeyStroke.getKeyStroke(80, 2), "prev");
        this.fListComponent.getActionMap().put("prev", action);
        Action action2 = (Action)this.fListComponent.getActionForKeyStroke(KeyStroke.getKeyStroke(40, 0));
        this.fListComponent.getInputMap().put(KeyStroke.getKeyStroke(78, 2), "next");
        this.fListComponent.getActionMap().put("next", action2);
        MJUtilities.addPageKeyBindingsToMacJList((JList)((Object)this.fListComponent));
        this.fListComponent.getInputMap().put(KeyStroke.getKeyStroke(9, 0), "tab");
        this.setTabKeyAction();
    }

    void setTabKeyAction() {
        if (KeyboardPrefs.isTabCompletionNarrowing()) {
            this.fListComponent.getActionMap().put("tab", (Action)((Object)this.fNarrowAction));
        } else {
            this.fListComponent.getActionMap().put("tab", (Action)((Object)this.fEnterAction));
        }
    }

    public MJAbstractAction addTabFinishListener(MJAbstractAction mJAbstractAction) {
        MJAbstractAction mJAbstractAction2 = this.fTabFinishListener;
        this.fTabFinishListener = mJAbstractAction;
        return mJAbstractAction2;
    }

    void removeTabFinishListenerAndCleanup() {
        this.cleanup();
        this.fDocListener = null;
        this.fParentCaretListener = null;
        this.fTabFinishListener = null;
        this.fScrollPane.removeAll();
        this.fListComponent.getActionMap().remove("ctrlc");
        this.fListComponent.getActionMap().remove("esc");
        this.fListComponent.getActionMap().remove("return");
        this.fListComponent.getActionMap().remove("tab");
        this.fListComponent.removeFocusListener(this.fFocusListener);
        this.fListComponent.removeMouseListener(this.fJListMouseListener);
        this.fJListMouseListener = null;
        this.fListComponent.removeListSelectionListener(this.fLSL);
        this.fListComponent = null;
        this.fScrollPane = null;
        this.fLSL = null;
        this.fFocusListener = null;
        this.fTabCompletionImpl = null;
    }

    TabCompletionModel getModel() {
        return (TabCompletionModel)this.getList().getModel();
    }

    private JList getList() {
        return this.fListComponent;
    }

    private void processCompletionSelection() {
        if (this.getList().isSelectionEmpty() || this.getModel().showingErrorMessage()) {
            this.cleanup();
            return;
        }
        if (this.getModel().hasMoreThanOneMatch()) {
            int n = this.getList().getSelectedIndex();
            assert (n != -1);
            assert (this.fTabCompletionImpl.getComponent() != null);
            this.cleanup();
            this.fTabFinishListener.actionPerformed(new ActionEvent(this, 1001, String.valueOf(n)));
        }
    }

    void setStartOffset(int n) {
        this.fStartOffset = n;
    }

    void setWordOffset(int n) {
        this.checkOffset(n);
        this.fWordOffset = n;
    }

    void showPopup(List<TabCompletionResult> list, List<TabCompletionResult> list2, int n) {
        Serializable serializable;
        Object object;
        int n2 = this.fTabCompletionImpl.getComponent().getDocument().getLength();
        n = Math.min(n, n2);
        this.fWordOffset = Math.min(this.fWordOffset, n2);
        this.checkWordOffset();
        if (!this.fWaitingForCompletions) {
            this.cleanup();
            return;
        }
        TabCompletionModel tabCompletionModel = new TabCompletionModel(list, list2);
        if (tabCompletionModel.allMatchesHaveCommonPrefix()) {
            object = tabCompletionModel.getCommonPrefix();
            assert (((String)object).length() != 0) : "Should only have valid common prefix";
            this.insertStringOnEventThread((String)object);
        }
        if (tabCompletionModel.hasUniqueMatch()) {
            this.cleanup();
            return;
        }
        this.fListComponent.setFont(this.fTabCompletionImpl.getComponent().getFont());
        this.fListComponent.addFocusListener(this.fFocusListener);
        this.fListComponent.setModel(tabCompletionModel);
        this.fScrollPane.getViewport().setView((Component)((Object)this.fListComponent));
        this.fNarrowDotPos = this.fTabCompletionImpl.getComponent().getCaret().getDot();
        object = this.computePopupLocation(this.fScrollPane.getPreferredSize());
        if (this.fPopup == null) {
            this.fPopup = MPopup.getResizablePopup((Component)this.fTabCompletionImpl.getComponent(), (Component)this.fScrollPane, (int)((Point)object).x, (int)((Point)object).y);
            this.fPopup.setName(POPUP_WINDOW_NAME);
        } else {
            try {
                this.fPopup.setSize(this.fScrollPane.getPreferredSize());
                serializable = this.fPopup.getLocation();
                this.fPopup.setLocation(((Point)serializable).x, ((Point)object).y);
            }
            catch (IllegalStateException illegalStateException) {
                Log.logException((Exception)illegalStateException);
            }
        }
        serializable = SwingUtilities.windowForComponent((Component)this.fScrollPane);
        if (serializable != null) {
            ((Window)serializable).setFocusableWindowState(true);
        }
        this.fPopup.show();
        if (tabCompletionModel.hasMoreThanOneMatch()) {
            try {
                this.maybeFixUpTokenBoundary(n);
                this.findInList(n);
            }
            catch (BadLocationException badLocationException) {
                Log.logException((Exception)badLocationException);
                this.cleanup();
                return;
            }
        } else {
            if (this.fLSL == null) {
                this.fLSL = new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        TabCompletionView.this.fListComponent.clearSelection();
                    }
                };
            }
            this.fListComponent.addListSelectionListener(this.fLSL);
        }
        if (this.fComponentAdapter == null) {
            this.fComponentAdapter = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    TabCompletionView.this.cleanup();
                }

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                    TabCompletionView.this.cleanup();
                }

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                    TabCompletionView.this.cleanup();
                }
            };
        }
        JScrollPane jScrollPane = this.fTabCompletionImpl.getScrollPane();
        this.fTabCompletionImpl.getComponent().addCaretListener(this.fParentCaretListener);
        this.fTabCompletionImpl.getComponent().addComponentListener(this.fComponentAdapter);
        Frame frame = WindowUtils.getFrameForComponent((Component)this.fTabCompletionImpl.getComponent());
        if (frame != null) {
            frame.addComponentListener(this.fComponentAdapter);
        }
        if (jScrollPane != null) {
            jScrollPane.addComponentListener(this.fComponentAdapter);
        }
        this.fListComponent.addMouseListener(this.fJListMouseListener);
        this.fListComponent.requestFocus();
    }

    public boolean isWaitingForCompletions() {
        return this.fWaitingForCompletions;
    }

    public void setWaitingForCompletions(boolean bl) {
        this.fWaitingForCompletions = bl;
    }

    private void insertStringOnEventThread(final String string) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                int n = TabCompletionView.this.fTabCompletionImpl.getComponent().getCaret().getDot();
                if (n == TabCompletionView.this.fStartOffset) {
                    try {
                        TabCompletionView.this.fTabCompletionImpl.getComponent().getDocument().insertString(n, string, null);
                    }
                    catch (Exception exception) {
                        TabCompletionView.this.cleanup();
                    }
                } else {
                    TabCompletionView.this.cleanup();
                }
            }
        });
    }

    private Point computePopupLocation(Dimension dimension) {
        Rectangle rectangle = WindowUtils.computeTextPopupBounds((Dimension)dimension, (Dimension)dimension, (JTextComponent)this.fTabCompletionImpl.getComponent(), (WindowUtils.TextPopupLocation)WindowUtils.TextPopupLocation.ABOVE_PREFERRED);
        return rectangle.getLocation();
    }

    private void maybeFixUpTokenBoundary(int n) throws BadLocationException {
        this.checkWordOffset();
        assert (this.fWordOffset <= n) : "fWordOffset " + this.fWordOffset + " is not <= dot " + n;
        while (this.fWordOffset != n) {
            Segment segment = this.getSegment(n);
            if (this.getModel().getUpperCaseString(0).startsWith(segment.toString().toUpperCase(Locale.US))) break;
            ++this.fWordOffset;
        }
        this.checkWordOffset();
    }

    void readySelectionForInsertion(CompletionObserver completionObserver, int n) {
        this.getModel().completeString(completionObserver, n);
    }

    private void checkWordOffset() {
        this.checkOffset(this.fWordOffset);
    }

    private void checkOffset(int n) {
        int n2 = this.fTabCompletionImpl.getComponent().getDocument().getLength();
        assert (n >= 0) : "Offset " + n + " is < zero";
        assert (n <= n2) : " Offset " + n + " is > document length of " + n2;
    }

    private static class TabCompletionListRenderer
    extends DefaultListCellRenderer {
        private TabCompletionListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return super.getListCellRendererComponent((JList<?>)jList, ((TabCompletionResult)object).getString(), n, bl, false);
        }
    }

    private class JListMouseListener
    extends MouseAdapter {
        private JListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1) {
                TabCompletionView.this.processCompletionSelection();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (MatlabTabContext.getNumMatches() < 0) {
                TabCompletionView.this.cleanup();
            }
        }
    }

    private class TabFocusListener
    extends FocusAdapter {
        private TabFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getOppositeComponent() != null) {
                TabCompletionView.this.cleanup(TabCompletionView.this.fTabCompletionImpl.getComponent() == focusEvent.getOppositeComponent());
            }
        }
    }

    private class NarrowAction
    extends MJAbstractAction {
        private NarrowAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (TabCompletionView.this.fTabCompletionImpl.getComponent().getCaret().getDot() != TabCompletionView.this.fNarrowDotPos) {
                TabCompletionView.this.fNarrowDotPos = TabCompletionView.this.fTabCompletionImpl.getComponent().getCaret().getDot();
                TabCompletionView.this.fTabFinishListener.actionPerformed(new ActionEvent((Object)this, 1001, String.valueOf(-3)));
            } else if (TabCompletionView.this.getModel().showingErrorMessage()) {
                TabCompletionView.this.cleanup();
            }
        }
    }

    private class EnterAction
    extends MJAbstractAction {
        private EnterAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TabCompletionView.this.processCompletionSelection();
        }
    }

    private class StopTabComplAction
    extends MJAbstractAction {
        private StopTabComplAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TabCompletionView.this.cleanup();
        }
    }

    public class TabCompletionJList
    extends MJList {
        private static final int MAXIMUM_COMPLETIONS_SHOWN_AT_ONCE = 8;

        public TabCompletionJList() {
            super((ListModel)new TabCompletionModel());
        }

        public int getVisibleRowCount() {
            return Math.min(8, this.getModel().getSize());
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            if (TabCompletionView.this.getModel().hasNoMatches() && (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40)) {
                TabCompletionView.this.fTabCompletionImpl.processKey(keyEvent);
                TabCompletionView.this.cleanup();
            } else {
                super.processKeyEvent(keyEvent);
                if (!keyEvent.isConsumed()) {
                    TabCompletionView.this.fTabCompletionImpl.processKey(keyEvent);
                }
            }
        }
    }
}

