/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.workspace;

import com.mathworks.mlwidgets.workspace.WorkspaceResources;
import com.mathworks.mlwidgets.workspace.util.WorkspaceIcon;
import com.mathworks.widgets.recordlist.AbstractRecordlistModel;
import com.mathworks.widgets.recordlist.ICopyingObserver;
import com.mathworks.widgets.recordlist.IGenericNameSupplier;
import com.mathworks.widgets.recordlist.IRecordIconProvider;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;
import com.mathworks.widgets.spreadsheet.format.Formatter;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.ResourceBundle;
import javax.swing.Icon;

public abstract class VariableRecordlistModel
extends AbstractRecordlistModel
implements IRecordIconProvider,
IGenericNameSupplier {
    private String[] fFieldNames = new String[4];
    protected Object fSemaphore = new Object();
    protected static final Formatter sEditingFormatter = FormatIdentifier.getDefaultInstance().getEditorIdentifier().getFormatter();

    public int NAME() {
        return 0;
    }

    public int SIZE() {
        return 1;
    }

    public int BYTES() {
        return 2;
    }

    public int CLASS() {
        return 3;
    }

    protected VariableRecordlistModel() {
        ResourceBundle resourceBundle = WorkspaceResources.getBundle();
        this.fFieldNames[0] = resourceBundle.getString("fieldname.name");
        this.fFieldNames[1] = resourceBundle.getString("fieldname.size");
        this.fFieldNames[2] = resourceBundle.getString("fieldname.bytes");
        this.fFieldNames[3] = resourceBundle.getString("fieldname.class");
    }

    public Class getFieldClass(int n) {
        if (n == this.BYTES()) {
            return Long.class;
        }
        return String.class;
    }

    public int getFieldCount() {
        return 4;
    }

    public String getFieldName(int n) {
        if (n == this.NAME()) {
            return this.fFieldNames[0];
        }
        if (n == this.SIZE()) {
            return this.fFieldNames[1];
        }
        if (n == this.BYTES()) {
            return this.fFieldNames[2];
        }
        if (n == this.CLASS()) {
            return this.fFieldNames[3];
        }
        return "";
    }

    public int getPrimaryFieldIndex() {
        return this.NAME();
    }

    public Object getSemaphore() {
        return this.fSemaphore;
    }

    public int getPresortFieldIndex() {
        return this.NAME();
    }

    public int getPresortFieldOrder() {
        return 0;
    }

    public Icon getRecordIcon(int n) {
        String string = (String)this.getValueAt(n, this.CLASS());
        return WorkspaceIcon.getIcon(string);
    }

    public int getMaxIconHeight() {
        return WorkspaceIcon.getMaxIconHeight();
    }

    public String getGenericNameSingular() {
        return WorkspaceResources.getBundle().getString("variable.singular");
    }

    public String getGenericNamePlural() {
        return WorkspaceResources.getBundle().getString("variable.plural");
    }

    public boolean areRecordsCopyable(int[] nArray) {
        return nArray.length > 0;
    }

    public void copyRecords(int[] nArray, ICopyingObserver iCopyingObserver) {
        this.copyRecords(nArray, this.NAME(), iCopyingObserver);
    }

    public void copyRecords(int[] nArray, int n, ICopyingObserver iCopyingObserver) {
        int n2;
        int n3 = iCopyingObserver.copyingStarted(nArray);
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = new String[nArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            String string = sEditingFormatter.format(this.getValueAt(nArray[n2], n));
            stringArray[n2] = string != null ? string.toString() : "";
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            stringBuilder.append(stringArray[n2]);
            if (n2 + 1 >= stringArray.length) continue;
            stringBuilder.append(", ");
        }
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(stringBuilder.toString()), null);
        iCopyingObserver.copyingCompleted(n3, WorkspaceResources.getBundle().getString("error.copy"));
    }
}

