/*
 * Decompiled with CFR 0.152.
 */
package ice.util;

import ice.util.Defs;
import ice.util.alg.CharKit;
import ice.util.security.SecurityKit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class JVMCapabilities {
    private static int OEAB = 0;
    private static int getClass = 0;
    private static int getMethod = 0;
    private static int indexOf = 0;
    private static int installDefaultSecurityManager = 0;
    private static int invoke = 0;
    static String jvmVersion = null;
    static int majorVersion = -1;
    static int minorVersion = -1;
    static int microVersion = -1;

    public static String getVersionString() {
        if (jvmVersion == null) {
            JVMCapabilities.getMethod();
        }
        return jvmVersion;
    }

    public static int getMajorVersion() {
        if (majorVersion == -1) {
            JVMCapabilities.getMethod();
        }
        return majorVersion;
    }

    public static int getMinorVersion() {
        if (minorVersion == -1) {
            JVMCapabilities.getMethod();
        }
        return minorVersion;
    }

    public static int getMicroVersion() {
        if (microVersion == -1) {
            JVMCapabilities.getMethod();
        }
        return microVersion;
    }

    public static boolean isScrollbarsPresent() {
        int n = OEAB;
        if (n == 0) {
            OEAB = n = JVMCapabilities.OEAB("java.awt.Scrollbar");
        }
        return n == 1;
    }

    public static boolean isMouseWheelPresent() {
        int n = getClass;
        if (n == 0) {
            getClass = n = JVMCapabilities.OEAB("java.awt.event.MouseWheelEvent");
        }
        return n == 1;
    }

    public static boolean isJMFPresent() {
        int n = getMethod;
        if (n == 0) {
            getMethod = n = JVMCapabilities.OEAB("javax.media.Player");
        }
        return n == 1;
    }

    public static boolean isSwingPresent() {
        int n = indexOf;
        if (n == 0) {
            indexOf = n = JVMCapabilities.OEAB("javax.swing.JComponent");
        }
        return n == 1;
    }

    public static boolean isJarHandlerPresent() {
        int n = installDefaultSecurityManager;
        if (n == 0) {
            n = 2;
            try {
                new URL("jar://test");
                n = 1;
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            installDefaultSecurityManager = n;
        }
        return n == 1;
    }

    public static boolean isMD5Present() {
        int n = invoke;
        if (n == 0) {
            n = 2;
            Class clazz = Defs.getClass("java.security.MessageDigest");
            if (clazz != null) {
                try {
                    Class[] classArray = new Class[]{"".getClass()};
                    Method method = Defs.getMethod(clazz, "getInstance", classArray);
                    if (method != null) {
                        Object[] objectArray = new Object[]{"MD5"};
                        method.invoke(null, objectArray);
                        n = 1;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            invoke = n;
        }
        return n == 1;
    }

    private static int OEAB(String string) {
        return null != Defs.getClass(string) ? 1 : 2;
    }

    public static void installDefaultSecurityManager() {
        SecurityKit.installDefaultSecurityManager();
    }

    private static void getMethod() {
        long l;
        String string;
        jvmVersion = string = Defs.sysProperty("java.version");
        int n = 1;
        int n2 = 1;
        int n3 = 0;
        int n4 = string.length();
        int n5 = string.indexOf(46);
        if (n5 < 0) {
            n5 = n4;
        }
        if ((l = CharKit.parseInt(string, 0, n5)) >= 0L) {
            n = (int)l;
            if (n5 != n4) {
                int n6 = string.indexOf(46, n5 + 1);
                if (n6 < 0) {
                    n6 = n4;
                }
                if ((l = CharKit.parseInt(string, n5 + 1, n6)) >= 0L) {
                    n2 = (int)l;
                    if (n6 != n4 && (l = CharKit.parseInt(string, n6 + 1, n4)) >= 0L) {
                        n3 = (int)l;
                    }
                }
            }
        }
        majorVersion = n;
        minorVersion = n2;
        microVersion = n3;
    }
}

