/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseSettingsInitializer;
import org.netbeans.editor.EditorDebug;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakEventListenerList;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.ExtSettingsInitializer;

public class Settings {
    public static final int CORE_LEVEL = 0;
    public static final int SYSTEM_LEVEL = 1;
    public static final int EXTENSION_LEVEL = 2;
    public static final int OPTION_LEVEL = 3;
    public static final int USER_LEVEL = 4;
    private static final ArrayList initializerLists = new ArrayList();
    private static InitializerSorter currentInitializerSorter;
    private static final ArrayList filterList;
    private static final Map kit2Maps;
    private static final WeakEventListenerList listenerList;
    private static final Map NULL_MAP;
    private static boolean firingEnabled;
    private static boolean TopLevelKitsInitialized;
    private static HashMap emptyMap;
    private static Class ignoreKitClass;
    static final String WIDGETS_TEXT_PACKAGE = "com.mathworks.widgets.text";
    static final String NETBEANS_PACKAGE = "org.netbeans.editor";
    static final String MWKIT_CLASS = "com.mathworks.widgets.text.MWKit";
    static final String MWINITIALIZER = "com.mathworks.widgets.text.MWSettingsInitializer";

    private Settings() {
    }

    private static synchronized void addInitializer(Initializer initializer) {
        Settings.addInitializer(initializer, 1);
    }

    private static synchronized void addInitializer(Initializer initializer, int n) {
        int n2;
        if (!TopLevelKitsInitialized) {
            TopLevelKitsInitialized = true;
            Settings.addInitializer(new BaseSettingsInitializer(), 0);
            Settings.addInitializer(new ExtSettingsInitializer(), 0);
        }
        for (int i = n2 = initializerLists.size(); i <= n; ++i) {
            initializerLists.add(new ArrayList());
        }
        List list = (List)initializerLists.get(n);
        if (!list.contains(initializer)) {
            list.add(initializer);
        }
        if (currentInitializerSorter != null) {
            currentInitializerSorter.sort(initializerLists);
        }
    }

    public static synchronized void removeInitializer(String string) {
        Iterator iterator = initializerLists.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((List)iterator.next()).iterator();
            while (iterator2.hasNext()) {
                if (!string.equals(((Initializer)iterator2.next()).getName())) continue;
                iterator2.remove();
            }
        }
        if (currentInitializerSorter != null) {
            currentInitializerSorter.sort(initializerLists);
        }
    }

    public static synchronized InitializerSorter getInitializerSorter() {
        return currentInitializerSorter;
    }

    public static synchronized void setInitializerSorter(InitializerSorter initializerSorter) {
        currentInitializerSorter = initializerSorter;
    }

    public static synchronized void addFilter(Filter filter) {
        filterList.add(filter);
    }

    public static synchronized void removeFilter(Filter filter) {
        Iterator iterator = filterList.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != filter) continue;
            iterator.remove();
        }
    }

    public static Object getValue(Class clazz, String string) {
        return Settings.getValue(clazz, string, true);
    }

    public static synchronized Object getValue(Class clazz, String string, boolean bl) {
        Object object = null;
        Class clazz2 = clazz;
        while (true) {
            Map map;
            if ((map = Settings.getKitMap(clazz2, false)) != null) {
                object = map.get(string);
                if (bl && object instanceof Evaluator) {
                    object = ((Evaluator)object).getValue(clazz, string);
                }
                if (object != null) break;
            }
            if (clazz2 == null) break;
            clazz2 = clazz2.getSuperclass();
        }
        int n = filterList.size();
        for (int i = 0; i < n; ++i) {
            object = ((Filter)filterList.get(i)).filterValue(clazz, string, object);
        }
        return object;
    }

    public static synchronized void protectSettings(Class clazz, Class clazz2) {
        ArrayList arrayList = new ArrayList();
        Class clazz3 = clazz;
        HashMap hashMap = null;
        Map map = null;
        emptyMap = new HashMap();
        boolean bl = true;
        HashMap hashMap2 = null;
        if (clazz2 != null) {
            ignoreKitClass = clazz2;
        }
        if (ignoreKitClass != null) {
            map = Settings.getKitMap(ignoreKitClass, false);
        }
        hashMap = Settings.getKitMap(clazz, false);
        do {
            bl = true;
            hashMap = null;
            hashMap2 = null;
            if (ignoreKitClass != null) {
                if (clazz3 == ignoreKitClass) {
                    bl = false;
                }
                hashMap = Settings.getKitMap(clazz3, false);
                if (ignoreKitClass != clazz3 && hashMap != null && BaseKit.class.isAssignableFrom(clazz3) && clazz3.isAssignableFrom(ignoreKitClass)) {
                    hashMap2 = new HashMap();
                    for (Map.Entry entry : hashMap.entrySet()) {
                        String string = (String)entry.getKey();
                        if (map.containsKey(string)) continue;
                        hashMap2.put(string, entry.getValue());
                    }
                }
            }
            if (bl && hashMap2 != null) {
                hashMap = hashMap2;
            } else if (bl) {
                hashMap = Settings.getKitMap(clazz3, false);
            }
            if (hashMap == null || !bl) continue;
            arrayList.add(hashMap);
        } while ((clazz3 = clazz3.getSuperclass()) != null);
        if (emptyMap == null) {
            emptyMap = new HashMap();
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            emptyMap.putAll((Map)arrayList.get(i));
        }
        if (emptyMap.size() > 0) {
            hashMap = emptyMap;
            emptyMap = null;
        }
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        kit2Maps.put(clazz, hashMap);
        emptyMap = null;
    }

    public static KitAndValue[] getValueHierarchy(Class clazz, String string) {
        return Settings.getValueHierarchy(clazz, string, true);
    }

    public static synchronized KitAndValue[] getValueHierarchy(Class clazz, String string, boolean bl) {
        KitAndValue[] kitAndValueArray;
        ArrayList<KitAndValue> arrayList = new ArrayList<KitAndValue>();
        Class clazz2 = clazz;
        while (true) {
            if ((kitAndValueArray = Settings.getKitMap(clazz2, false)) != null) {
                Object object = kitAndValueArray.get(string);
                if (bl && object instanceof Evaluator) {
                    object = ((Evaluator)object).getValue(clazz, string);
                }
                if (object != null) {
                    arrayList.add(new KitAndValue(clazz2, object));
                }
            }
            if (clazz2 == null) break;
            clazz2 = clazz2.getSuperclass();
        }
        kitAndValueArray = arrayList.toArray(new KitAndValue[arrayList.size()]);
        int n = filterList.size();
        for (int i = 0; i < n; ++i) {
            kitAndValueArray = ((Filter)filterList.get(i)).filterValueHierarchy(clazz, string, kitAndValueArray);
        }
        return kitAndValueArray;
    }

    static synchronized void setValue(Class clazz, String string, Object object) {
        Map map = Settings.getKitMap(clazz, true);
        Object v = map.get(string);
        if (v == null && object == null || v != null && v.equals(object)) {
            return;
        }
        if (object != null) {
            map.put(string, object);
        } else {
            map.remove(string);
        }
        Settings.fireSettingsChange(clazz, string, v, object);
    }

    public static synchronized void touchValue(Class clazz, String string) {
        Settings.fireSettingsChange(clazz, string, null, null);
    }

    public static synchronized void propagateValue(Class clazz, String string, Object object) {
        Map map = Settings.getKitMap(clazz, true);
        if (object != null) {
            map.put(string, object);
        } else {
            map.remove(string);
        }
        for (Map.Entry entry : kit2Maps.entrySet()) {
            Class clazz2 = (Class)entry.getKey();
            if (clazz == clazz2 || clazz != null && !clazz.isAssignableFrom(clazz2)) continue;
            ((Map)entry.getValue()).remove(string);
        }
        Settings.fireSettingsChange(null, string, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void update(Runnable runnable) {
        boolean bl = firingEnabled;
        firingEnabled = false;
        try {
            runnable.run();
        }
        finally {
            if (bl) {
                firingEnabled = true;
                Settings.fireSettingsChange(null, null, null, null);
            }
        }
    }

    static synchronized void reset() {
    }

    public static synchronized String initializersToString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < initializerLists.size(); ++i) {
            switch (i) {
                case 0: {
                    stringBuffer.append("CORE_LEVEL");
                    break;
                }
                case 1: {
                    stringBuffer.append("SYSTEM_LEVEL");
                    break;
                }
                case 2: {
                    stringBuffer.append("EXTENSION_LEVEL");
                    break;
                }
                case 3: {
                    stringBuffer.append("OPTION_LEVEL");
                    break;
                }
                case 4: {
                    stringBuffer.append("USER_LEVEL");
                    break;
                }
                default: {
                    stringBuffer.append("level " + i);
                }
            }
            stringBuffer.append(":\n");
            stringBuffer.append(EditorDebug.debugList((List)initializerLists.get(i)));
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public static void addSettingsChangeListener(SettingsChangeListener settingsChangeListener) {
        listenerList.add(SettingsChangeListener.class, settingsChangeListener);
    }

    public static void removeSettingsChangeListener(SettingsChangeListener settingsChangeListener) {
        listenerList.remove(SettingsChangeListener.class, settingsChangeListener);
    }

    private static void fireSettingsChange(Class clazz, String string, Object object, Object object2) {
        if (firingEnabled) {
            SettingsChangeListener[] settingsChangeListenerArray = (SettingsChangeListener[])listenerList.getListeners(SettingsChangeListener.class);
            SettingsChangeEvent settingsChangeEvent = new SettingsChangeEvent(Settings.class, clazz, string, object, object2);
            for (int i = 0; i < settingsChangeListenerArray.length; ++i) {
                settingsChangeListenerArray[i].settingsChange(settingsChangeEvent);
            }
        }
    }

    private static Map getKitMap(Class clazz, boolean bl) {
        Map map = (HashMap)kit2Maps.get(clazz);
        if (map == null) {
            Object object;
            if (emptyMap == null) {
                emptyMap = new HashMap();
            }
            try {
                object = clazz.getMethods();
                for (int i = 0; i != ((Method[])object).length; ++i) {
                    if (!((Method)object[i]).getName().equals("getInitializers")) continue;
                    Object object2 = ((Method)object[i]).invoke(null, new Object[0]);
                    if (object2 instanceof List) {
                        List list = (List)object2;
                        for (Initializer initializer : list) {
                            Settings.addInitializer(initializer);
                        }
                    }
                    break;
                }
            }
            catch (Exception exception) {
                Utilities.annotateLoggable(exception);
            }
            object = initializerLists.iterator();
            while (object.hasNext()) {
                for (Object object2 : (List)object.next()) {
                    try {
                        if (clazz == null && (object2.getClass().getPackage().getName().indexOf(WIDGETS_TEXT_PACKAGE) > -1 || object2.getClass().getPackage().getName().indexOf(NETBEANS_PACKAGE) > -1) || clazz != null && (object2.getClass().getPackage().getName().indexOf(WIDGETS_TEXT_PACKAGE) < 0 && clazz.getPackage().getName().indexOf(WIDGETS_TEXT_PACKAGE) < 0 && object2.getClass().getPackage().getName().indexOf(NETBEANS_PACKAGE) < 0 || object2.getClass().getPackage().getName().indexOf(WIDGETS_TEXT_PACKAGE) > -1 && clazz.getPackage().getName().indexOf(WIDGETS_TEXT_PACKAGE) > -1 || object2.getClass().getPackage().getName().indexOf(NETBEANS_PACKAGE) > -1 || clazz.getName().equals(MWKIT_CLASS) && object2.getClass().getName().equals(MWINITIALIZER) || (clazz == BaseKit.class || clazz == ExtKit.class) && object2.getClass().getPackage().getName().indexOf(NETBEANS_PACKAGE) > -1 || !clazz.getName().equals(MWKIT_CLASS))) {
                            object2.updateSettingsMap(clazz, emptyMap);
                            continue;
                        }
                        throw new IllegalArgumentException("Invalid EditorKit");
                    }
                    catch (Throwable throwable) {
                        Utilities.annotateLoggable(throwable);
                    }
                }
            }
            if (emptyMap.size() > 0) {
                map = emptyMap;
                emptyMap = null;
            }
            if (map == null) {
                map = NULL_MAP;
            }
            kit2Maps.put(clazz, map);
        }
        if (map == NULL_MAP) {
            if (!bl) {
                return null;
            }
            map = new HashMap();
            kit2Maps.put(clazz, map);
        }
        return map;
    }

    static {
        filterList = new ArrayList();
        kit2Maps = new HashMap();
        listenerList = new WeakEventListenerList();
        NULL_MAP = new HashMap(1);
        firingEnabled = true;
        TopLevelKitsInitialized = false;
        emptyMap = null;
        ignoreKitClass = null;
    }

    public static interface Filter {
        public Object filterValue(Class var1, String var2, Object var3);

        public KitAndValue[] filterValueHierarchy(Class var1, String var2, KitAndValue[] var3);
    }

    public static interface Evaluator {
        public Object getValue(Class var1, String var2);
    }

    public static abstract class FilterInitializerSorter {
        private InitializerSorter delegate;

        public FilterInitializerSorter(InitializerSorter initializerSorter) {
            this.delegate = initializerSorter;
        }

        public void sort(List list) {
            if (this.delegate != null) {
                this.delegate.sort(list);
            }
        }
    }

    public static interface InitializerSorter {
        public void sort(List var1);
    }

    public static abstract class AbstractInitializer
    implements Initializer {
        private String name;

        public AbstractInitializer(String string) {
            this.name = string;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }

    public static interface Initializer {
        public String getName();

        public void updateSettingsMap(Class var1, Map var2);
    }

    public static class KitAndValue {
        public Class kitClass;
        public Object value;

        public KitAndValue(Class clazz, Object object) {
            this.kitClass = clazz;
            this.value = object;
        }
    }
}

