/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.sun.jini.mahalo.TxnManager;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.admin.Administrable;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.transaction.CannotAbortException;
import net.jini.core.transaction.CannotCommitException;
import net.jini.core.transaction.CannotJoinException;
import net.jini.core.transaction.TimeoutExpiredException;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.CrashCountException;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.core.transaction.server.TransactionParticipant;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;

class TxnMgrProxy
implements TransactionManager,
Administrable,
Serializable,
ReferentUuid {
    private static final long serialVersionUID = 2L;
    final TxnManager backend;
    final Uuid proxyID;

    static TxnMgrProxy create(TxnManager txnManager, Uuid uuid) {
        if (txnManager instanceof RemoteMethodControl) {
            return new ConstrainableTxnMgrProxy(txnManager, uuid, null);
        }
        return new TxnMgrProxy(txnManager, uuid);
    }

    private TxnMgrProxy(TxnManager txnManager, Uuid uuid) {
        if (txnManager == null || uuid == null) {
            throw new IllegalArgumentException("Cannot accept null arguments");
        }
        this.backend = txnManager;
        this.proxyID = uuid;
    }

    public TransactionManager.Created create(long l) throws LeaseDeniedException, RemoteException {
        return this.backend.create(l);
    }

    public void join(long l, TransactionParticipant transactionParticipant, long l2) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        this.backend.join(l, transactionParticipant, l2);
    }

    public int getState(long l) throws UnknownTransactionException, RemoteException {
        return this.backend.getState(l);
    }

    public void commit(long l) throws UnknownTransactionException, CannotCommitException, RemoteException {
        this.backend.commit(l);
    }

    public void commit(long l, long l2) throws UnknownTransactionException, CannotCommitException, TimeoutExpiredException, RemoteException {
        this.backend.commit(l, l2);
    }

    public void abort(long l) throws UnknownTransactionException, CannotAbortException, RemoteException {
        this.backend.abort(l);
    }

    public void abort(long l, long l2) throws UnknownTransactionException, CannotAbortException, TimeoutExpiredException, RemoteException {
        this.backend.abort(l, l2);
    }

    public Object getAdmin() throws RemoteException {
        return this.backend.getAdmin();
    }

    public Uuid getReferentUuid() {
        return this.proxyID;
    }

    public int hashCode() {
        return this.proxyID.hashCode();
    }

    public boolean equals(Object object) {
        return ReferentUuids.compare((Object)this, (Object)object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.backend == null) {
            throw new InvalidObjectException("TxnMgrProxy.readObject failure - backend field is null");
        }
        if (this.proxyID == null) {
            throw new InvalidObjectException("TxnMgrProxy.proxyID failure - proxyID field is null");
        }
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("no data found when attempting to deserialize TxnMgrProxy instance");
    }

    static final class ConstrainableTxnMgrProxy
    extends TxnMgrProxy
    implements RemoteMethodControl {
        private static final long serialVersionUID = 2L;

        private ConstrainableTxnMgrProxy(TxnManager txnManager, Uuid uuid, MethodConstraints methodConstraints) {
            super(ConstrainableTxnMgrProxy.constrainServer(txnManager, methodConstraints), uuid);
        }

        private static TxnManager constrainServer(TxnManager txnManager, MethodConstraints methodConstraints) {
            return (TxnManager)((RemoteMethodControl)txnManager).setConstraints(methodConstraints);
        }

        public RemoteMethodControl setConstraints(MethodConstraints methodConstraints) {
            return new ConstrainableTxnMgrProxy(this.backend, this.proxyID, methodConstraints);
        }

        public MethodConstraints getConstraints() {
            return ((RemoteMethodControl)this.backend).getConstraints();
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator((Object)this.backend);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (!(this.backend instanceof RemoteMethodControl)) {
                throw new InvalidObjectException("ConstrainableTxnMgrProxy.readObject failure - backend does not implement constrainable functionality ");
            }
        }
    }
}

