/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo.log;

import com.sun.jini.mahalo.log.Log;
import com.sun.jini.mahalo.log.LogException;
import com.sun.jini.mahalo.log.LogRecord;
import com.sun.jini.mahalo.log.LogRecovery;
import com.sun.jini.mahalo.log.MultiLogManager;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransientLogFile
implements Log {
    private long cookie;
    private static final Logger persistenceLogger = Logger.getLogger("com.sun.jini.mahalo.persistence");
    private static final Logger operationsLogger = Logger.getLogger("com.sun.jini.mahalo.operations");

    public TransientLogFile(long l) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TransientLogFile.class.getName(), "TransientLogFile", new Long(this.cookie));
        }
        this.cookie = l;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TransientLogFile.class.getName(), "TransientLogFile");
        }
    }

    public long cookie() {
        return this.cookie;
    }

    public void write(LogRecord logRecord) throws LogException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TransientLogFile.class.getName(), "write", logRecord);
        }
        if (persistenceLogger.isLoggable(Level.FINEST)) {
            persistenceLogger.log(Level.FINEST, "(ignored) write called for cookie: {0}", new Long(this.cookie));
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TransientLogFile.class.getName(), "write");
        }
    }

    public void invalidate() throws LogException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TransientLogFile.class.getName(), "invalidate");
        }
        if (persistenceLogger.isLoggable(Level.FINEST)) {
            persistenceLogger.log(Level.FINEST, "(ignored) Invalidating log for cookie: {0}", new Long(this.cookie));
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TransientLogFile.class.getName(), "invalidate");
        }
    }

    public void recover(LogRecovery logRecovery) throws LogException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(MultiLogManager.class.getName(), "recover", logRecovery);
        }
        if (persistenceLogger.isLoggable(Level.FINEST)) {
            persistenceLogger.log(Level.FINEST, "(ignored) Recovering for: {0}", new Long(this.cookie));
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(MultiLogManager.class.getName(), "recover");
        }
    }
}

