/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter;

import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.toolbox.distcomp.admincenter.AboutWindow;
import com.mathworks.util.PlatformInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class MacAppListenerImpl {
    private static Method sAbout;
    private static Method sOpenApplication;
    private static Method sOpenFile;
    private static Method sPreferences;
    private static Method sPrintFile;
    private static Method sQuit;
    private static MacAppListenerImpl sThis;
    private static MJFrame sAdminCenterFrame;

    private void handleAbout(Object object) {
        this.setApplicationEventHandled(object, true);
        new AboutWindow(sAdminCenterFrame).setVisible(true);
    }

    private void handleOpenApplication(Object object) {
    }

    private void handleOpenFile(Object object) {
    }

    private void handlePreferences(Object object) {
    }

    private void handlePrintFile(Object object) {
    }

    private void handleQuit(Object object) {
        this.setApplicationEventHandled(object, false);
        if (sAdminCenterFrame != null) {
            sAdminCenterFrame.dispose();
        }
    }

    static void installMacAppListener(MJFrame mJFrame) {
        if (Matlab.isMatlabAvailable()) {
            return;
        }
        if (!PlatformInfo.isMacintosh()) {
            return;
        }
        sAdminCenterFrame = mJFrame;
        if (sThis == null) {
            sThis = new MacAppListenerImpl();
            try {
                Class<?> clazz = Class.forName("com.apple.eawt.ApplicationListener");
                Class<?> clazz2 = Class.forName("com.apple.eawt.ApplicationEvent");
                Class[] classArray = new Class[]{clazz2};
                sAbout = clazz.getDeclaredMethod("handleAbout", classArray);
                sOpenApplication = clazz.getDeclaredMethod("handleOpenApplication", classArray);
                sOpenFile = clazz.getDeclaredMethod("handleOpenFile", classArray);
                sPreferences = clazz.getDeclaredMethod("handlePreferences", classArray);
                sPrintFile = clazz.getDeclaredMethod("handlePrintFile", classArray);
                sQuit = clazz.getDeclaredMethod("handleQuit", classArray);
                IH iH = sThis.new IH();
                Class[] classArray2 = new Class[]{clazz};
                ClassLoader classLoader = clazz.getClassLoader();
                Object object = Proxy.newProxyInstance(classLoader, classArray2, (InvocationHandler)iH);
                Class<?> clazz3 = Class.forName("com.apple.eawt.Application");
                Constructor<?> constructor = clazz3.getConstructor(new Class[0]);
                Object obj = constructor.newInstance(new Object[0]);
                Method method = clazz3.getMethod("addApplicationListener", clazz);
                method.invoke(obj, object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void setApplicationEventHandled(Object object, boolean bl) {
        try {
            Class<?> clazz = Class.forName("com.apple.eawt.ApplicationEvent");
            Class[] classArray = new Class[]{Boolean.TYPE};
            Method method = clazz.getDeclaredMethod("setHandled", classArray);
            Object[] objectArray = new Boolean[]{bl ? Boolean.TRUE : Boolean.FALSE};
            method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private String getApplicationEventFileName(Object object) {
        String string = new String();
        try {
            Class<?> clazz = Class.forName("com.apple.eawt.ApplicationEvent");
            Object[] objectArray = new Object[]{};
            Class[] classArray = new Class[]{};
            Method method = clazz.getDeclaredMethod("getFilename", classArray);
            string = (String)method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return string;
    }

    class IH
    implements InvocationHandler {
        IH() {
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) {
            if (method.equals(sAbout)) {
                MacAppListenerImpl.this.handleAbout(objectArray[0]);
                return null;
            }
            if (method.equals(sPreferences)) {
                MacAppListenerImpl.this.handlePreferences(objectArray[0]);
                return null;
            }
            if (method.equals(sQuit)) {
                MacAppListenerImpl.this.handleQuit(objectArray[0]);
                return null;
            }
            if (method.equals(sOpenApplication)) {
                MacAppListenerImpl.this.handleOpenApplication(objectArray[0]);
                return null;
            }
            if (method.equals(sOpenFile)) {
                MacAppListenerImpl.this.handleOpenFile(objectArray[0]);
                return null;
            }
            if (method.equals(sPrintFile)) {
                MacAppListenerImpl.this.handlePrintFile(objectArray[0]);
                return null;
            }
            return null;
        }
    }
}

