/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.view;

import com.mathworks.mwswing.GlobalCursor;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.toolbox.distcomp.admincenter.PackageInfo;
import com.mathworks.toolbox.distcomp.admincenter.TimeOutConstants;
import com.mathworks.toolbox.distcomp.admincenter.resources.icons.AdminCenterIcon;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ActionRequest;
import com.mathworks.toolbox.distcomp.admincenter.services.model.SubmissionProgressListener;
import com.mathworks.toolbox.distcomp.control.servicerequest.JobManagerServiceRequest;
import com.mathworks.toolbox.distcomp.control.servicerequest.LookupServiceRequest;
import com.mathworks.toolbox.distcomp.control.servicerequest.ServiceAction;
import com.mathworks.toolbox.distcomp.control.servicerequest.ServiceRequest;
import com.mathworks.toolbox.distcomp.control.servicerequest.ServiceRequestResponse;
import com.mathworks.toolbox.distcomp.control.servicerequest.WorkerServiceRequest;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.util.ResourceBundleUtilities;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ProgressHandler
implements SubmissionProgressListener {
    private static final Map<ActionEvent, ProgressDialog> sDialogs = new HashMap<ActionEvent, ProgressDialog>();
    private static final ResourceBundleUtilities sRes = ResourceBundleUtilities.getInstance(ProgressHandler.class);

    @Override
    public void submissionStarting(ActionEvent actionEvent) {
        ProgressHandler.submit(ProgressHandler.queueSubmissionStarting(actionEvent));
    }

    @Override
    public void serviceRequestStarting(ActionEvent actionEvent, Collection<ServiceRequest> collection) {
        ProgressHandler.submit(ProgressHandler.queueServiceRequestStarting(actionEvent, collection));
    }

    @Override
    public void serviceRequestCompleted(ActionEvent actionEvent, Collection<ServiceRequestResponse> collection) {
        ProgressHandler.submit(ProgressHandler.queueServiceRequestCompleted(actionEvent, collection));
    }

    @Override
    public void submissionCompleted(ActionEvent actionEvent) {
        ProgressHandler.submit(ProgressHandler.queueSubmissionCompleted(actionEvent));
    }

    @Override
    public void updateStarted(ActionEvent actionEvent, ActionRequest.UpdateAction updateAction) {
        ProgressHandler.submit(ProgressHandler.queueUpdateStarted(actionEvent, updateAction));
    }

    @Override
    public void updateCompleted(ActionEvent actionEvent) {
        ProgressHandler.submit(ProgressHandler.queueUpdateCompleted(actionEvent));
    }

    private static void submit(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    private static ProgressDialog getDialog(ActionEvent actionEvent) {
        ProgressDialog progressDialog = sDialogs.get(actionEvent);
        if (progressDialog == null || !progressDialog.isDisplayable()) {
            progressDialog = new ProgressDialog(actionEvent);
            sDialogs.put(actionEvent, progressDialog);
        }
        return progressDialog;
    }

    private static void disposeDialog(ActionEvent actionEvent) {
        ProgressDialog progressDialog = sDialogs.get(actionEvent);
        if (progressDialog != null) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "AdminCenter: Before dialog dispose.");
            progressDialog.dispose();
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "AdminCenter: After dialog dispose.");
            sDialogs.remove(actionEvent);
        }
    }

    private static Runnable queueSubmissionStarting(final ActionEvent actionEvent) {
        return new Runnable(){

            @Override
            public void run() {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "AdminCenter: Queue Submission Starting.");
                GlobalCursor.setWait((Window)MJAbstractAction.getFrame((ActionEvent)actionEvent));
            }
        };
    }

    private static Runnable queueServiceRequestStarting(final ActionEvent actionEvent, final Collection<ServiceRequest> collection) {
        return new Runnable(){

            @Override
            public void run() {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "AdminCenter: Queue Service Request Starting.");
                ProgressHandler.getDialog(actionEvent).serviceRequestStarting(collection);
            }
        };
    }

    private static Runnable queueServiceRequestCompleted(final ActionEvent actionEvent, final Collection<ServiceRequestResponse> collection) {
        return new Runnable(){

            @Override
            public void run() {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "AdminCenter: Queue Service Request Completed.");
                ProgressHandler.getDialog(actionEvent).serviceRequestCompleted(collection);
            }
        };
    }

    private static Runnable queueSubmissionCompleted(final ActionEvent actionEvent) {
        return new Runnable(){

            @Override
            public void run() {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "AdminCenter: Queue Submission Completed.");
                ProgressHandler.disposeDialog(actionEvent);
                GlobalCursor.clear((Window)MJAbstractAction.getFrame((ActionEvent)actionEvent));
            }
        };
    }

    private static Runnable queueUpdateStarted(final ActionEvent actionEvent, final ActionRequest.UpdateAction updateAction) {
        return new Runnable(){

            @Override
            public void run() {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "AdminCenter: Queue Update Started.");
                ProgressHandler.getDialog(actionEvent).updateStarted(updateAction);
            }
        };
    }

    private static Runnable queueUpdateCompleted(final ActionEvent actionEvent) {
        return new Runnable(){

            @Override
            public void run() {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "AdminCenter: Queue Update Completed.");
                ProgressHandler.getDialog(actionEvent).updateCompleted();
            }
        };
    }

    private static class ServiceRequestModel {
        private final List<ServiceRequest> fRequests;
        private String fSummary;

        private ServiceRequestModel(Collection<ServiceRequest> collection) {
            this.fRequests = new ArrayList<ServiceRequest>(collection);
            assert (collection != null && !collection.isEmpty()) : "Request must not be null nor empty.";
        }

        public String getSummary() {
            if (this.fSummary == null) {
                ServiceRequest serviceRequest2;
                int n = 0;
                String string = null;
                String string2 = null;
                HashSet<ServiceAction> hashSet = new HashSet<ServiceAction>();
                HashSet hashSet2 = new HashSet();
                for (ServiceRequest serviceRequest2 : this.fRequests) {
                    if (ServiceRequestModel.isLookupRequest(serviceRequest2)) continue;
                    hashSet.add(serviceRequest2.getAction());
                    hashSet2.add(serviceRequest2.getClass());
                    string = serviceRequest2.getServiceName();
                    string2 = serviceRequest2.getHostName();
                    ++n;
                }
                Iterator<ServiceRequest> iterator = hashSet.size() == 1 ? (ServiceAction)((Object)hashSet.iterator().next()) : null;
                ServiceRequest serviceRequest3 = serviceRequest2 = hashSet2.size() == 1 ? (Class)hashSet2.iterator().next() : null;
                this.fSummary = n == 1 && iterator != null && serviceRequest2 != null ? (string != null && string.trim().length() > 0 ? sRes.getString("progress.dialog.request.single", ServiceRequestModel.getActionString(iterator), ServiceRequestModel.getServiceStrSingle((Class<? extends ServiceRequest>)((Object)serviceRequest2)), string, string2) : sRes.getString("progress.dialog.request.single.noname", ServiceRequestModel.getActionString(iterator), ServiceRequestModel.getServiceStrSingle((Class<? extends ServiceRequest>)((Object)serviceRequest2)), string2)) : (n > 1 && iterator != null && serviceRequest2 != null ? sRes.getString("progress.dialog.request.multiple", ServiceRequestModel.getActionString(iterator), n, ServiceRequestModel.getServiceStrMultiple((Class<? extends ServiceRequest>)((Object)serviceRequest2))) : sRes.getString("progress.dialog.request.unknown", new Object[0]));
            }
            return this.fSummary;
        }

        public boolean serviceRequestCompleted(Collection<ServiceRequestResponse> collection) {
            HashSet<ServiceRequest> hashSet = new HashSet<ServiceRequest>(this.fRequests);
            HashSet<ServiceRequest> hashSet2 = new HashSet<ServiceRequest>(this.fRequests);
            int n = 0;
            for (ServiceRequestResponse serviceRequestResponse : collection) {
                if (!hashSet2.contains(serviceRequestResponse.getServiceRequest())) continue;
                hashSet.remove(serviceRequestResponse.getServiceRequest());
                if (serviceRequestResponse.wasSuccessful()) continue;
                ++n;
            }
            return n == 0 && hashSet.isEmpty();
        }

        private static boolean isLookupRequest(ServiceRequest serviceRequest) {
            return serviceRequest instanceof LookupServiceRequest;
        }

        private static String getServiceStrMultiple(Class<? extends ServiceRequest> clazz) {
            if (JobManagerServiceRequest.class.equals(clazz)) {
                return sRes.getString("progress.dialog.service.multiple.jobmanager", new Object[0]);
            }
            if (WorkerServiceRequest.class.equals(clazz)) {
                return sRes.getString("progress.dialog.service.multiple.worker", new Object[0]);
            }
            return null;
        }

        private static String getServiceStrSingle(Class<? extends ServiceRequest> clazz) {
            if (JobManagerServiceRequest.class.equals(clazz)) {
                return sRes.getString("progress.dialog.service.single.jobmanager", new Object[0]);
            }
            if (WorkerServiceRequest.class.equals(clazz)) {
                return sRes.getString("progress.dialog.service.single.worker", new Object[0]);
            }
            return null;
        }

        private static String getActionString(ServiceAction serviceAction) {
            assert (serviceAction != null) : "action may not be null.";
            return sRes.getString("progress.dialog.action." + (Object)((Object)serviceAction), new Object[0]);
        }
    }

    private static class ProgressDialog
    extends MJDialog {
        private final MJLabel fProgressLabel;
        private final MJLabel fCaveatLabel;
        private ServiceRequestModel fRequestModel;
        private boolean fHasBeenDisposed = false;
        private Timer fShowCaveatTimer;

        ProgressDialog(ActionEvent actionEvent) {
            super(MJAbstractAction.getFrame((ActionEvent)actionEvent), sRes.getString("progress.dialog.title", new Object[0]), true);
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "AdminCenter: Created a new progress dialog.");
            this.fProgressLabel = new MJLabel();
            this.fProgressLabel.setIcon((Icon)AdminCenterIcon.RUNNING.getIcon());
            this.fCaveatLabel = new MJLabel(sRes.getString("progress.dialog.update.caveat", new Object[0]));
            this.fCaveatLabel.setFont(this.fCaveatLabel.getFont().deriveFont(2));
            int n = AdminCenterIcon.SUCCESS.getIcon().getIconWidth();
            int n2 = AdminCenterIcon.SUCCESS.getIcon().getIconHeight();
            this.fCaveatLabel.setIcon((Icon)new ImageIcon(new BufferedImage(n, n2, 3)));
            this.fCaveatLabel.setVisible(false);
            StyleGuidePanel styleGuidePanel = new StyleGuidePanel();
            styleGuidePanel.addLine((JComponent)this.fProgressLabel);
            styleGuidePanel.addLine((JComponent)this.fCaveatLabel);
            styleGuidePanel.setBorder(BorderFactory.createEtchedBorder());
            this.setContentPane((Container)((Object)styleGuidePanel));
            this.setUndecorated(true);
            this.setCloseOnEscapeEnabled(false);
            this.setResizable(false);
            this.pack();
            this.setLocationRelativeTo(MJAbstractAction.getFrame((ActionEvent)actionEvent));
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.setName("ProgressDialog");
        }

        public void dispose() {
            if (!SwingUtilities.isEventDispatchThread()) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Dispose is not being called on EDT thread.");
                assert (false) : "Dispose is not being called on EDT thread.";
            }
            this.fHasBeenDisposed = true;
            super.dispose();
        }

        void serviceRequestStarting(Collection<ServiceRequest> collection) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "AdminCenter: Service Requests Starting. Requests = " + collection.size());
            this.fRequestModel = new ServiceRequestModel(collection);
            this.fProgressLabel.setText(this.fRequestModel.getSummary());
            this.fProgressLabel.setIcon((Icon)AdminCenterIcon.RUNNING.getIcon());
            this.pack();
            this.setLocationRelativeTo(this.getOwner());
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ProgressDialog.this.fCaveatLabel.setVisible(true);
                    ProgressDialog.this.pack();
                    ProgressDialog.this.setLocationRelativeTo(ProgressDialog.this.getOwner());
                }
            };
            this.fShowCaveatTimer = new Timer(TimeOutConstants.UPDATE_CAVEAT_DELAY_MILLIS, actionListener);
            this.fShowCaveatTimer.setRepeats(false);
            this.fShowCaveatTimer.start();
            this.showIfNecessary();
        }

        void serviceRequestCompleted(Collection<ServiceRequestResponse> collection) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "AdminCenter: Service Requests Completed. Responses = " + collection.size());
            this.fShowCaveatTimer.stop();
            this.fCaveatLabel.setVisible(false);
            ImageIcon imageIcon = this.fRequestModel.serviceRequestCompleted(collection) ? AdminCenterIcon.SUCCESS.getIcon() : AdminCenterIcon.WARNING.getIcon();
            this.fProgressLabel.setIcon((Icon)imageIcon);
            this.pack();
            this.setLocationRelativeTo(this.getOwner());
        }

        void updateStarted(ActionRequest.UpdateAction updateAction) {
            String string = sRes.getString("progress.dialog.update.action." + (Object)((Object)updateAction), new Object[0]);
            this.fProgressLabel.setText(string);
            this.fProgressLabel.setIcon((Icon)AdminCenterIcon.RUNNING.getIcon());
            this.pack();
            this.setLocationRelativeTo(this.getOwner());
            this.showIfNecessary();
        }

        private void showIfNecessary() {
            if (!this.isShowing()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!ProgressDialog.this.fHasBeenDisposed) {
                            ProgressDialog.this.show();
                        }
                    }
                });
            }
        }

        void updateCompleted() {
            this.fProgressLabel.setIcon((Icon)AdminCenterIcon.SUCCESS.getIcon());
            this.repaint();
        }
    }
}

