/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.view;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.distcomp.admincenter.services.action.TargetSource;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ClientMonitor;
import com.mathworks.toolbox.distcomp.admincenter.services.view.AdminUserPanel;
import com.mathworks.toolbox.distcomp.admincenter.services.view.HostnameRenderer;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ServiceDialog;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceStatus;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.util.ResourceBundleUtilities;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class StartJMDialog
extends ServiceDialog<Object[]> {
    private static final String HELP = "AC_START_JM";
    private static ResourceBundleUtilities sRes = ResourceBundleUtilities.getInstance(StartJMDialog.class);

    protected StartJMDialog(Frame frame, ClientMonitor clientMonitor, TargetSource targetSource) {
        super(frame, sRes.getString("services.dialog.startjm", new Object[0]), sRes.getString("services.dialog.okay", new Object[0]), HELP, new StartJMContent(clientMonitor, targetSource));
    }

    private static class StartJMContent
    extends StyleGuidePanel
    implements ServiceDialog.FocusableServiceDialogContent<Object[]> {
        private final MJTextField fNameField;
        private final MJComboBox fHostsCombo;
        private final AdminUserPanel fAdminUserPanel;

        StartJMContent(ClientMonitor clientMonitor, TargetSource targetSource) {
            ServiceInfo serviceInfo;
            List list = clientMonitor.getHostTableModel().getInfoList();
            ArrayList<MDCSServiceInfo> arrayList = new ArrayList<MDCSServiceInfo>();
            Object object = list.iterator();
            while (object.hasNext()) {
                serviceInfo = (MDCSServiceInfo)object.next();
                if (serviceInfo.getStatus() != ServiceStatus.RUNNING) continue;
                arrayList.add((MDCSServiceInfo)serviceInfo);
            }
            this.fHostsCombo = new MJComboBox(arrayList.toArray());
            this.fHostsCombo.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    String string = HostnameRenderer.getDisplayHostname((ServiceInfo)object, true);
                    return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
                }
            });
            this.fHostsCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StartJMContent.this.fAdminUserPanel.setSelectedHost((MDCSServiceInfo)StartJMContent.this.fHostsCombo.getSelectedItem());
                    StartJMContent.this.fAdminUserPanel.checkValidity();
                }
            });
            this.fAdminUserPanel = new AdminUserPanel();
            if (targetSource != null && !(object = targetSource.getTargets()).isEmpty() && (serviceInfo = object.toArray(new ServiceInfo[object.size()])[0]) instanceof MDCSServiceInfo) {
                this.fHostsCombo.setSelectedItem((Object)serviceInfo);
            }
            this.fAdminUserPanel.setSelectedHost((MDCSServiceInfo)this.fHostsCombo.getSelectedItem());
            object = new MJLabel(sRes.getString("services.dialog.startjm.entername", new Object[0]));
            serviceInfo = new MJLabel(sRes.getString("services.dialog.startjm.host", new Object[0]));
            this.fNameField = new MJTextField();
            this.fNameField.setDocument((Document)new PlainDocument(){

                @Override
                public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                    super.insertString(n, string.replaceAll("[^\\w\\d-]", ""), attributeSet);
                }
            });
            this.addLine((JComponent[][])new JComponent[][]{{object, this.fNameField}, {serviceInfo, this.fHostsCombo}}, 0, 1);
            this.addLine((JComponent)((Object)this.fAdminUserPanel), 8);
            this.fNameField.setName("StartJobManagerDialog.NameField");
            this.fHostsCombo.setName("StartJobManagerDialog.HostsCombobox");
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        @Override
        public Object[] getValue() {
            return new Object[]{this.fNameField.getText(), ((ServiceInfo)this.fHostsCombo.getSelectedItem()).getHost(), this.fAdminUserPanel.getValue()};
        }

        @Override
        public void registerOkayButton(MJButton mJButton) {
            this.fAdminUserPanel.registerOkayButton(mJButton);
        }

        @Override
        public Component getFocusTarget() {
            return this.fNameField;
        }
    }
}

