/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.view;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.toolbox.distcomp.admincenter.resources.ResourceStatics;
import com.mathworks.toolbox.distcomp.admincenter.resources.icons.AdminCenterIcon;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.TestRunner;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.ClusterData;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.ProgressData;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.ProgressListener;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.TestingMonitor;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.ComputeCluster;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.ComputeNode;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.Scheduler;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestCategory;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestInvoker;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestingToken;
import com.mathworks.toolbox.distcomp.ui.panel.AbstractStyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class TestRunnerUI {
    private final TestInvoker fTestRunner;
    private final Frame fFrame;
    private Map<TestCategory, StatusIndicatorLabel> fStatusIndicatorLabels;

    public TestRunnerUI(Frame frame) {
        this.fFrame = frame;
        this.fTestRunner = new TestRunner();
    }

    public boolean doRun(ClusterData clusterData) {
        long l;
        TestingToken testingToken;
        MJDialog mJDialog = new MJDialog(this.fFrame, ResourceStatics.sRes.getString("run.dialog.title"), true);
        mJDialog.setDefaultCloseOperation(2);
        this.fStatusIndicatorLabels = new EnumMap<TestCategory, StatusIndicatorLabel>(TestCategory.class);
        AbstractStyleGuidePanel abstractStyleGuidePanel = this.createTestPanel(ResourceStatics.sRes.getString("run.client.title"), TestCategory.CLIENT_TEST);
        AbstractStyleGuidePanel abstractStyleGuidePanel2 = this.createTestPanel(ResourceStatics.sRes.getString("run.c2n.title"), TestCategory.CLIENT_HOSTNAMES, TestCategory.MDCE_CONNECT, TestCategory.MDCE_HOSTNAME);
        AbstractStyleGuidePanel abstractStyleGuidePanel3 = this.createTestPanel(ResourceStatics.sRes.getString("run.n2n.title"), TestCategory.MPI_HOSTNAME, TestCategory.INTERNODE_HOSTNAMES, TestCategory.PORTS_AVAILABLE, TestCategory.PORT_CONNECT);
        AbstractStyleGuidePanel abstractStyleGuidePanel4 = this.createTestPanel(ResourceStatics.sRes.getString("run.n2c.title"), TestCategory.POOL2CLIENT);
        TestingMonitor testingMonitor = new TestingMonitor(clusterData);
        testingMonitor.addProgressListener(new ProgressListener((JDialog)mJDialog){
            final /* synthetic */ JDialog val$dialog;
            {
                this.val$dialog = jDialog;
            }

            @Override
            public void progressUpdate(final ProgressData progressData) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (TestCategory testCategory : TestRunnerUI.this.fStatusIndicatorLabels.keySet()) {
                            ((StatusIndicatorLabel)((Object)TestRunnerUI.this.fStatusIndicatorLabels.get((Object)testCategory))).setStatus(progressData.getRunStatus(testCategory));
                        }
                    }
                });
            }

            @Override
            public void testingDone() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        val$dialog.dispose();
                    }
                });
            }
        });
        long l2 = System.currentTimeMillis();
        MouseAdapter mouseAdapter = new MouseAdapter(){};
        Component component = ((RootPaneContainer)((Object)this.fFrame)).getGlassPane();
        component.addMouseListener(mouseAdapter);
        component.setVisible(true);
        component.setCursor(Cursor.getPredefinedCursor(3));
        long l3 = 15000L;
        do {
            testingToken = this.fTestRunner.runTests(TestRunnerUI.getComputeCluster(clusterData), testingMonitor, null);
            l = System.currentTimeMillis();
        } while (testingToken == null && l - l2 < l3);
        component.setCursor(Cursor.getDefaultCursor());
        component.setVisible(false);
        component.removeMouseListener(mouseAdapter);
        final TestingToken testingToken2 = testingToken;
        if (testingToken2 == null) {
            String string = "<html>" + ResourceStatics.sRes.getString("run.busy.dialog") + "</html>";
            String string2 = ResourceStatics.sRes.getString("run.busy.title");
            MJOptionPane.showMessageDialog((Component)this.fFrame, (Object)string, (String)string2, (int)0);
            return false;
        }
        MJButton mJButton = new MJButton(ResourceStatics.sRes.getString("run.dialog.cancel"));
        mJButton.addActionListener(new ActionListener((JDialog)mJDialog){
            final /* synthetic */ JDialog val$dialog;
            {
                this.val$dialog = jDialog;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                testingToken2.cancel();
                this.val$dialog.dispose();
            }
        });
        mJDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (!testingToken2.isDone()) {
                    testingToken2.cancel();
                }
            }
        });
        testingMonitor.startMonitoring(testingToken2, new Date(l));
        StyleGuidePanel styleGuidePanel = new StyleGuidePanel();
        styleGuidePanel.addLine((JComponent)((Object)abstractStyleGuidePanel));
        styleGuidePanel.addLine((JComponent)((Object)abstractStyleGuidePanel2));
        styleGuidePanel.addLine((JComponent)((Object)abstractStyleGuidePanel3));
        styleGuidePanel.addLine((JComponent)((Object)abstractStyleGuidePanel4));
        styleGuidePanel.addLine((JComponent[][])new JComponent[][]{{null, mJButton}}, 0, 0);
        mJDialog.setContentPane((Container)((Object)styleGuidePanel));
        mJDialog.pack();
        mJDialog.setLocationRelativeTo(this.fFrame);
        mJDialog.setVisible(true);
        return testingMonitor.isTestingDone();
    }

    private AbstractStyleGuidePanel createTestPanel(String string, TestCategory ... testCategoryArray) {
        StyleGuidePanel styleGuidePanel = new StyleGuidePanel();
        styleGuidePanel.setBorder(BorderFactory.createTitledBorder(string));
        for (TestCategory testCategory : testCategoryArray) {
            styleGuidePanel.addLine((JComponent)((Object)this.createStatusIndicator(testCategory)));
        }
        return styleGuidePanel;
    }

    private StatusIndicatorLabel createStatusIndicator(TestCategory testCategory) {
        String string = ResourceStatics.sRes.getString("run.test." + (Object)((Object)testCategory));
        StatusIndicatorLabel statusIndicatorLabel = new StatusIndicatorLabel(string);
        this.fStatusIndicatorLabels.put(testCategory, statusIndicatorLabel);
        return statusIndicatorLabel;
    }

    private static ComputeCluster getComputeCluster(final ClusterData clusterData) {
        return new ComputeCluster(){
            private ComputeNode[] iWorkers;
            private ComputeNode iSchedulerNode;
            private Scheduler iScheduler;
            {
                this.iWorkers = clusterData.getWorkerNodes();
                this.iSchedulerNode = clusterData.getSchedulerNode();
                this.iScheduler = clusterData.getSchedulerData();
            }

            @Override
            public ComputeNode[] getAllNodes() {
                if (this.iSchedulerNode == null) {
                    return Arrays.copyOf(this.iWorkers, this.iWorkers.length);
                }
                ComputeNode[] computeNodeArray = new ComputeNode[this.iWorkers.length + 1];
                computeNodeArray[0] = this.iSchedulerNode;
                System.arraycopy(this.iWorkers, 0, computeNodeArray, 1, this.iWorkers.length);
                return computeNodeArray;
            }

            @Override
            public ComputeNode getSchedulerNode() {
                return this.iSchedulerNode;
            }

            @Override
            public ComputeNode[] getWorkerNodes() {
                return Arrays.copyOf(this.iWorkers, this.iWorkers.length);
            }

            @Override
            public Scheduler getScheduler() {
                return this.iScheduler;
            }
        };
    }

    private static class StatusIndicatorLabel
    extends MJLabel {
        private StatusIndicatorLabel(String string) {
            super(string);
            this.setStatus(ProgressData.RunStatus.UNKNOWN);
        }

        public void setStatus(ProgressData.RunStatus runStatus) {
            switch (runStatus) {
                case COMPLETED: {
                    this.setIcon(AdminCenterIcon.SUCCESS.getIcon());
                    break;
                }
                case IN_PROGRESS: {
                    this.setIcon(AdminCenterIcon.RUNNING.getIcon());
                    break;
                }
                case UNKNOWN: {
                    this.setIcon(null);
                }
            }
        }
    }
}

