/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials;

import com.mathworks.toolbox.distcomp.auth.CryptoException;
import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.EncryptedObject;
import com.mathworks.toolbox.distcomp.auth.Erasable;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.EncryptedAuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.NontransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import java.math.BigInteger;

public final class AuthenticationToken
implements NontransferableCredentials {
    public static final AuthenticationToken EMPTY = new AuthenticationToken(new UserIdentity("nobody"), new Erasable());
    private static final String sSeparator = "=";
    private static final int NUM_FIELDS_PER_LINE = 2;
    private UserIdentity fUserIdentity;
    private Erasable fHashedPassword;

    public AuthenticationToken(UserIdentity userIdentity, Erasable erasable) {
        this.setUserIdentity(userIdentity);
        this.setHashedPassword(erasable);
    }

    @Override
    public UserIdentity getUserIdentity() {
        return this.fUserIdentity;
    }

    private void setUserIdentity(UserIdentity userIdentity) {
        this.fUserIdentity = userIdentity;
    }

    @Override
    public EncryptedAuthenticationToken prepare(boolean bl, byte[] byArray, CryptoModule.Encryptor encryptor) throws CredentialCreationException {
        if (!bl) {
            return this.prepare();
        }
        try {
            EncryptedObject encryptedObject = encryptor.encryptWithSalt(this.fHashedPassword, byArray);
            return new EncryptedAuthenticationToken(this.fUserIdentity, encryptedObject, byArray);
        }
        catch (CryptoException cryptoException) {
            throw new CredentialCreationException("Could not encrypt credentials", this.fUserIdentity, cryptoException);
        }
    }

    @Override
    public void erase() {
        this.fHashedPassword.erase();
    }

    public String toString() {
        return "AuthenticationToken{" + this.fUserIdentity + "}";
    }

    public EncryptedAuthenticationToken prepare() {
        return new EncryptedAuthenticationToken(this.fUserIdentity, this.fHashedPassword);
    }

    public String serializeToString() {
        return AuthenticationToken.encode(this.fHashedPassword.get()) + sSeparator + this.fUserIdentity.serializeToString();
    }

    public static AuthenticationToken deserializeFromString(String string) throws CredentialCreationException {
        String[] stringArray = string.split(sSeparator, 2);
        if (stringArray.length < 2) {
            throw new CredentialCreationException("Reading authentication token from file failed: " + string, new UserIdentity("unknown"));
        }
        return new AuthenticationToken(UserIdentity.deserializeFromString(stringArray[1]), new Erasable(AuthenticationToken.decode(stringArray[0])));
    }

    private static String encode(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return "";
        }
        BigInteger bigInteger = new BigInteger(1, byArray);
        return bigInteger.toString(16);
    }

    private static byte[] decode(String string) {
        if (string == null || string.length() == 0) {
            return new byte[0];
        }
        BigInteger bigInteger = new BigInteger(string, 16);
        return bigInteger.toByteArray();
    }

    private void setHashedPassword(Erasable erasable) {
        this.fHashedPassword = erasable;
        if (this.fHashedPassword.get().length > 0) {
            byte[] byArray = this.fHashedPassword.get();
            byArray[0] = (byte)(byArray[0] & 0x7F);
            byte[] byArray2 = this.fHashedPassword.get();
            byArray2[0] = (byte)(byArray2[0] | 0x40);
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AuthenticationToken)) {
            return false;
        }
        AuthenticationToken authenticationToken = (AuthenticationToken)object;
        return this.fUserIdentity.equals(authenticationToken.fUserIdentity) && this.fHashedPassword.equals(authenticationToken.fHashedPassword);
    }

    public int hashCode() {
        return this.fUserIdentity.hashCode() ^ this.fHashedPassword.hashCode();
    }
}

