/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials.consumer.model;

import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.AuthorizationModelFactory;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.Input;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.InputCreator;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.InputField;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.PasswordInput;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.RememberChoice;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.RememberChoiceInput;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.StringInput;
import com.mathworks.toolbox.distcomp.util.ResourceBundleUtilities;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class AuthorizationModel {
    private final AuthorizationModelFactory fFactory;
    private final ResourceBundleUtilities.ResourceBundleMessenger fBlurbMessenger;
    private final boolean fAllowClientPasswordCache;
    private final Map<InputField, InputCreator> fInputCreators;
    private Map<InputField, Input<?>> fInputs;

    public AuthorizationModel(AuthorizationModelFactory authorizationModelFactory, ResourceBundleUtilities.ResourceBundleMessenger resourceBundleMessenger, boolean bl, InputCreator ... inputCreatorArray) {
        assert (authorizationModelFactory != null) : "factory cannot be null.";
        this.fFactory = authorizationModelFactory;
        this.fBlurbMessenger = resourceBundleMessenger;
        this.fAllowClientPasswordCache = bl;
        this.fInputCreators = new LinkedHashMap<InputField, InputCreator>();
        for (InputCreator inputCreator : inputCreatorArray) {
            this.fInputCreators.put(inputCreator.getField(), inputCreator);
        }
    }

    public ResourceBundleUtilities.ResourceBundleMessenger getBlurbMessenger() {
        return this.fBlurbMessenger;
    }

    public Map<InputField, Input<?>> getInputs() {
        if (this.fInputs == null) {
            this.createInputs();
        }
        return Collections.unmodifiableMap(this.fInputs);
    }

    private void createInputs() {
        this.fInputs = new LinkedHashMap();
        for (InputField inputField : this.fInputCreators.keySet()) {
            InputCreator inputCreator = this.fInputCreators.get((Object)inputField);
            this.fInputs.put(inputField, this.createInput(inputCreator));
        }
    }

    public Object getInputValue(InputField inputField) {
        Input<?> input = this.fInputs.get((Object)inputField);
        return input != null ? input.getValue() : null;
    }

    public void commit() {
        this.fFactory.commitModel(this);
    }

    public void validateAllInputs() throws ValidationException {
        if (this.fInputs == null) {
            throw new ValidationException("Message.NoInputs");
        }
        for (InputField inputField : this.getInputFields()) {
            this.validateInputField(inputField);
        }
    }

    public void validateInputField(InputField inputField) throws ValidationException {
        Object object = this.getInputValue(inputField);
        if (object == null || this.isEmptyString(object)) {
            throw new ValidationException("Message.EmptyReply");
        }
        if (inputField == InputField.CONFIRM_NEW) {
            char[] cArray = (char[])object;
            char[] cArray2 = (char[])this.getInputValue(InputField.NEW_PASSWORD);
            if (!Arrays.equals(cArray2, cArray)) {
                throw new ValidationException("Message.InvalidPasswordConfirmation");
            }
        }
    }

    private boolean isEmptyString(Object object) {
        if (object instanceof String) {
            return ((String)object).trim().length() == 0;
        }
        if (object instanceof char[]) {
            return ((char[])object).length == 0;
        }
        return false;
    }

    Input<?> getInput(InputField inputField) {
        return this.fInputs.get((Object)inputField);
    }

    Set<InputField> getInputFields() {
        return this.fInputCreators.keySet();
    }

    private Input<?> createInput(InputCreator inputCreator) {
        InputField inputField = inputCreator.getField();
        Object object = this.fFactory.getDefault(inputField);
        ResourceBundleUtilities.ResourceBundleMessenger resourceBundleMessenger = inputCreator.getResourceMessenger();
        switch (inputField) {
            case CONFIRM_NEW: 
            case CURRENT_PASSWORD: 
            case NEW_PASSWORD: {
                assert (object == null || object instanceof char[]);
                return new PasswordInput((char[])object, resourceBundleMessenger);
            }
            case REMEMBER: {
                assert (object == null || object instanceof RememberChoice);
                return new RememberChoiceInput(this.fAllowClientPasswordCache, (RememberChoice)object, resourceBundleMessenger);
            }
            case USERNAME: {
                assert (object == null || object instanceof String);
                return new StringInput((String)object, resourceBundleMessenger);
            }
        }
        return null;
    }

    public static class ValidationException
    extends Exception {
        private final String fResourceKey;

        ValidationException(String string) {
            this.fResourceKey = string;
        }

        public String getResourceKey() {
            return this.fResourceKey;
        }
    }
}

