/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.modules;

import com.mathworks.toolbox.distcomp.auth.CryptoException;
import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.EncryptedObject;
import com.mathworks.toolbox.distcomp.auth.Erasable;
import com.mathworks.toolbox.distcomp.auth.modules.CryptoModuleKeyPairImplHelper;
import com.mathworks.toolbox.distcomp.auth.modules.KeyPairProvider;
import com.mathworks.toolbox.distcomp.auth.modules.ModuleCreationException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Arrays;

public class CryptoModuleKeyPairImpl
implements CryptoModule {
    private KeyPair fKeyPair;

    public CryptoModuleKeyPairImpl(String string) throws ModuleCreationException {
        this.fKeyPair = KeyPairProvider.getKeyPair(string);
    }

    @Override
    public CryptoModule.Encryptor getEncryptor() {
        return new KeyPairEncryptor(this.fKeyPair.getPublic());
    }

    @Override
    public CryptoModule.Decryptor getDecryptor() {
        return new CryptoModule.Decryptor(){

            @Override
            public Erasable decrypt(EncryptedObject encryptedObject) throws CryptoException {
                return new Erasable(CryptoModuleKeyPairImplHelper.decrypt(encryptedObject.get(), CryptoModuleKeyPairImpl.this.fKeyPair.getPrivate()));
            }

            @Override
            public Erasable decryptWithSalt(EncryptedObject encryptedObject, byte[] byArray) throws CryptoException {
                Erasable erasable = this.decrypt(encryptedObject);
                int n = byArray.length;
                if (n == 0) {
                    return erasable;
                }
                byte[] byArray2 = new byte[n];
                System.arraycopy(erasable.get(), 0, byArray2, 0, n);
                if (!Arrays.equals(byArray, byArray2)) {
                    throw new CryptoException("Salt mismatch", null);
                }
                int n2 = erasable.get().length - n;
                byte[] byArray3 = new byte[n2];
                System.arraycopy(erasable.get(), n, byArray3, 0, n2);
                erasable.erase();
                return new Erasable(byArray3);
            }
        };
    }

    @Override
    public CryptoModule.Hasher getHasher() {
        return new KeyPairHasher();
    }

    @Override
    public byte[] createSalt(int n) {
        return CryptoModuleKeyPairImplHelper.createSalt(n);
    }

    static {
        CryptoModuleKeyPairImplHelper.initialize();
    }

    private static class KeyPairHasher
    implements CryptoModule.Hasher {
        private KeyPairHasher() {
        }

        @Override
        public Erasable createHash(Erasable erasable) {
            return new Erasable(CryptoModuleKeyPairImplHelper.hash(erasable.get()));
        }
    }

    private static class KeyPairEncryptor
    implements CryptoModule.Encryptor {
        private PublicKey iPublicKey;

        public KeyPairEncryptor(PublicKey publicKey) {
            this.iPublicKey = publicKey;
        }

        @Override
        public EncryptedObject encrypt(Erasable erasable) throws CryptoException {
            return new EncryptedObject(CryptoModuleKeyPairImplHelper.encrypt(erasable.get(), this.iPublicKey));
        }

        @Override
        public EncryptedObject encryptWithSalt(Erasable erasable, byte[] byArray) throws CryptoException {
            return this.encrypt(Erasable.concat(byArray, erasable.get()));
        }
    }
}

