/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.server;

import com.mathworks.toolbox.distcomp.PackageInfo;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.Log;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.server.PeerSCExecutorService;
import com.mathworks.toolbox.distcomp.logging.DistcompConsoleHandler;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.RemoteStreamException;
import com.mathworks.toolbox.distcomp.remote.ShellCommand;
import com.mathworks.toolbox.distcomp.remote.SimpleShellCommand;
import com.mathworks.toolbox.distcomp.remote.SimpleShellFuture;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.LocalShellSender;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.ProcessShellFuture;
import com.mathworks.util.PlatformInfo;
import java.util.Arrays;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WindowsRemoteExecutionServiceMain {
    private WindowsRemoteExecutionServiceMain() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        assert (PlatformInfo.isWindows()) : "WindowsRemoteExecutionServiceMain can only be start on Windows";
        Log.LOGGER.fine("Starting " + WindowsRemoteExecutionServiceMain.class.getSimpleName() + " with " + Arrays.toString(stringArray));
        int n = Integer.parseInt(stringArray[0]);
        UUID uUID = UUID.fromString(stringArray[1]);
        long l = 5000L;
        if (stringArray.length > 2) {
            l = Long.parseLong(stringArray[2]);
        }
        Level level = Level.INFO;
        if (stringArray.length > 3) {
            level = Level.parse(stringArray[3]);
        }
        WindowsRemoteExecutionServiceMain.setupLogging(level);
        try {
            Log.LOGGER.fine("Starting PeerSCExecutorService on port " + n + " with group " + uUID);
            PeerSCExecutorService peerSCExecutorService = new PeerSCExecutorService(n, uUID, l);
            peerSCExecutorService.awaitEnd();
            Log.LOGGER.fine("Starting PeerSCExecutorService has finished.");
        }
        catch (PeerSCExecutorService.FailedToStartException failedToStartException) {
            Log.LOGGER.log(Level.SEVERE, "PeerSCExecutorService failed to start.", failedToStartException);
        }
        catch (InterruptedException interruptedException) {
            Log.LOGGER.log(Level.SEVERE, "PeerSCExecutorService interrupted.", interruptedException);
        }
        catch (RuntimeException runtimeException) {
            Log.LOGGER.log(Level.SEVERE, "PeerSCExecutorService errored.", runtimeException);
        }
        finally {
            WindowsRemoteExecutionServiceMain.uninstallService();
        }
    }

    private static void setupLogging(Level level) {
        DistcompConsoleHandler distcompConsoleHandler = new DistcompConsoleHandler(DistcompLevel.getValueFromLevel(level));
        Logger logger = PackageInfo.LOGGER;
        logger.addHandler(distcompConsoleHandler);
        logger.setLevel(level);
    }

    private static void uninstallService() {
        ShellCommand shellCommand = WindowsRemoteExecutionServiceMain.createUninstallCommand();
        LocalShellSender localShellSender = new LocalShellSender();
        ParameterMap parameterMap = new ParameterMap();
        parameterMap.put(LocalShellSender.LocalParameter.COMMAND, LocalShellSender.LocalParameter.COMMAND.getSuggestedValue());
        parameterMap.put(LocalShellSender.LocalParameter.FLAG, LocalShellSender.LocalParameter.FLAG.getSuggestedValue());
        try {
            Log.LOGGER.info("Running uninstall command " + shellCommand);
            ProcessShellFuture processShellFuture = localShellSender.sendAndRun(shellCommand, "localhost", parameterMap);
            SimpleShellFuture simpleShellFuture = new SimpleShellFuture(processShellFuture);
        }
        catch (DispatchException dispatchException) {
            Log.LOGGER.log(Level.SEVERE, dispatchException.getMessage(), dispatchException);
        }
        catch (RemoteStreamException remoteStreamException) {
            Log.LOGGER.log(Level.SEVERE, remoteStreamException.getMessage(), remoteStreamException);
        }
    }

    private static ShellCommand createUninstallCommand() {
        String string = System.getProperty("com.mathworks.toolbox.distcomp.mdced");
        String string2 = System.getProperty("com.mathworks.toolbox.distcomp.configfile");
        String string3 = System.getProperty("com.mathworks.toolbox.distcomp.servicename");
        if (string == null || string2 == null || string3 == null) {
            throw new IllegalStateException("Required system properties have not been set.");
        }
        return new SimpleShellCommand(string, "-r", string2, "set.SERVICENAME=" + string3, "2>&1", ">NUL");
    }
}

