/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.logging;

import com.mathworks.toolbox.distcomp.logging.PackageInfo;
import com.mathworks.toolbox.distcomp.remote.util.DaemonThreadFactory;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public final class SocketLogRecordReceiver
implements Runnable {
    private final ServerSocket fServerSocket;
    private final Handler fHandler;
    private final CountDownLatch fLatch;

    public static int startSocketLogRecordReceiver(Handler handler) throws IOException, InterruptedException {
        int n = 0;
        ServerSocket serverSocket = new ServerSocket(n);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        try {
            SocketLogRecordReceiver socketLogRecordReceiver = new SocketLogRecordReceiver(serverSocket, handler, countDownLatch);
            Thread thread = new DaemonThreadFactory(handler.toString() + " " + SocketLogRecordReceiver.class.getSimpleName()).newThread(socketLogRecordReceiver);
            thread.start();
            countDownLatch.await();
            return serverSocket.getLocalPort();
        }
        catch (InterruptedException interruptedException) {
            serverSocket.close();
            throw interruptedException;
        }
        catch (RuntimeException runtimeException) {
            serverSocket.close();
            throw runtimeException;
        }
    }

    private SocketLogRecordReceiver(ServerSocket serverSocket, Handler handler, CountDownLatch countDownLatch) {
        this.fServerSocket = serverSocket;
        this.fHandler = handler;
        this.fLatch = countDownLatch;
    }

    @Override
    public void run() {
        PackageInfo.LOGGER.finest("Started run() of " + this);
        this.fLatch.countDown();
        try {
            while (true) {
                this.doOneAcceptAndRedirect();
            }
        }
        catch (Throwable throwable) {
            try {
                this.fServerSocket.close();
                PackageInfo.LOGGER.log(Level.FINEST, "Finished run() of " + this);
            }
            catch (IOException iOException) {
                PackageInfo.LOGGER.log(Level.WARNING, "Exception during close() of socket for " + this);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOneAcceptAndRedirect() {
        try {
            Socket socket = this.fServerSocket.accept();
            try {
                PackageInfo.LOGGER.finest("accepted " + socket);
                this.redirect(socket);
            }
            finally {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    PackageInfo.LOGGER.log(Level.WARNING, "Exception while closing " + socket + " for " + this, iOException);
                }
            }
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(Level.WARNING, "Exception during doOneAcceptAndRedirect() for " + this, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void redirect(Socket socket) {
        ObjectInputStream objectInputStream = null;
        try {
            PackageInfo.LOGGER.finest("about to get ObjectInputStream from " + socket);
            objectInputStream = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
            PackageInfo.LOGGER.finest("got ObjectInputStream from " + socket);
            while (true) {
                LogRecord logRecord = (LogRecord)objectInputStream.readObject();
                this.fHandler.publish(logRecord);
            }
        }
        catch (EOFException eOFException) {
            PackageInfo.LOGGER.log(Level.FINEST, "End of file while redirecting for " + this, eOFException);
            if (objectInputStream == null) return;
            try {
                objectInputStream.close();
                return;
            }
            catch (IOException iOException) {
                PackageInfo.LOGGER.log(Level.WARNING, "Exception closing input stream for " + this, iOException);
            }
            return;
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(Level.WARNING, "IOException while redirecting for " + this, iOException);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            PackageInfo.LOGGER.log(Level.WARNING, "Class not found while redirecting for " + this, classNotFoundException);
            if (objectInputStream == null) return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            try {
                objectInputStream.close();
                return;
            }
            catch (IOException iOException) {
                PackageInfo.LOGGER.log(Level.WARNING, "Exception closing input stream for " + this, iOException);
            }
            return;
        }
        {
            finally {
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException) {
                        PackageInfo.LOGGER.log(Level.WARNING, "Exception closing input stream for " + this, iOException);
                    }
                }
            }
        }
    }

    public String toString() {
        return "SocketLogRecordReceiver{fServerSocket=" + this.fServerSocket + ", fHandler=" + this.fHandler + '}';
    }
}

