/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.cwo;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.mjs.cwo.ConcurrentBuffer;
import com.mathworks.toolbox.distcomp.mjs.cwo.Log;
import com.mathworks.toolbox.distcomp.util.concurrent.ReentrantLock;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class ByteArrayConcurrentBuffer
implements ConcurrentBuffer<byte[]> {
    private final Queue<ByteBuffer> fByteBuffers = new LinkedList<ByteBuffer>();
    private final Lock fLock = new ReentrantLock();
    private Condition fReadHappened = this.fLock.newCondition();
    private final int fCapacity;
    private int fSize;

    public ByteArrayConcurrentBuffer(int n) {
        this.fCapacity = n;
        this.fSize = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.fLock.lock();
        try {
            int n = this.fSize;
            return n;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitEmpty() throws InterruptedException {
        this.fLock.lockInterruptibly();
        try {
            while (this.fSize > 0) {
                Log.LOGGER.log(DistcompLevel.FOUR, "Waiting for buffer to become empty");
                this.fReadHappened.await();
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitNotFull(int n) throws InterruptedException {
        this.fLock.lockInterruptibly();
        try {
            int n2 = this.fCapacity - n;
            if (n2 < 0) {
                n2 = 0;
            }
            while (this.fSize > n2) {
                Log.LOGGER.log(DistcompLevel.FOUR, "Waiting for read to remove bytes from buffer. Current size: " + this.fSize + ", capacity: " + this.fCapacity + ", num bytes to write: " + n);
                this.fReadHappened.await();
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n, int n2) {
        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>();
        this.fLock.lock();
        try {
            ByteBuffer byteBuffer;
            int n3 = 0;
            while (n3 < n2 && (byteBuffer = this.fByteBuffers.peek()) != null) {
                int n4 = byteBuffer.remaining();
                if (n3 + n4 <= n2) {
                    arrayList.add(this.fByteBuffers.remove());
                    n3 += n4;
                    continue;
                }
                int n5 = n2 - n3;
                byte[] byArray2 = new byte[n5];
                byteBuffer.get(byArray2);
                arrayList.add(ByteBuffer.wrap(byArray2));
                assert ((n3 += n5) == n2) : "Total bytes should be equal to number of bytes requested";
            }
            this.fSize -= n3;
            Log.LOGGER.log(DistcompLevel.FIVE, "Read " + n3 + " from buffer, new size: " + this.fSize + ".");
            this.fReadHappened.signalAll();
        }
        finally {
            this.fLock.unlock();
        }
        return ByteArrayConcurrentBuffer.readBytesFromByteBuffers(arrayList, byArray, n);
    }

    private static int readBytesFromByteBuffers(Iterable<ByteBuffer> iterable, byte[] byArray, int n) {
        int n2 = 0;
        for (ByteBuffer byteBuffer : iterable) {
            byte[] byArray2 = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray2);
            System.arraycopy(byArray2, 0, byArray, n2 + n, byArray2.length);
            n2 += byArray2.length;
        }
        return n2;
    }

    @Override
    public boolean checkEmptyAndPut(byte[] byArray) throws InterruptedException {
        boolean bl = false;
        this.fLock.lockInterruptibly();
        try {
            this.awaitNotFull(byArray.length);
            if (this.fSize <= 0) {
                bl = true;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            this.fByteBuffers.add(byteBuffer);
            this.fSize += byArray.length;
        }
        catch (InterruptedException interruptedException) {
            Log.LOGGER.log(DistcompLevel.ONE, "Writer interrupted while waiting for buffer to be drained.", interruptedException);
            throw interruptedException;
        }
        finally {
            this.fLock.unlock();
        }
        return bl;
    }
}

