/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.parallelui;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.plaf.PlafUtils;
import com.mathworks.toolbox.distcomp.parallelui.Actions;
import com.mathworks.toolbox.distcomp.parallelui.IntSet;
import com.mathworks.toolbox.distcomp.parallelui.MenuContributor;
import com.mathworks.toolbox.distcomp.parallelui.OutputCollection;
import com.mathworks.toolbox.distcomp.parallelui.OutputComponent;
import com.mathworks.toolbox.distcomp.parallelui.OutputSelector;
import com.mathworks.toolbox.distcomp.parallelui.OutputTextPane;
import com.mathworks.toolbox.distcomp.pmode.Labs;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;

class OutputWindow
extends MJPanel
implements OutputComponent {
    private Labs fLabs;
    private OutputCollection fOutputCollection;
    private TitleBar fTitleBar;
    private OutputTextPane fTextPane;
    private MJScrollPane fScrollPane;
    private IntSet fSources;
    private List<SourcesListener> fListeners;
    private MouseListener fLocalMouseListener = new LocalMouseListener();
    private static final Color LIGHT_TITLE_COLOR = new Color(240, 220, 0);
    private static final Color DARK_TITLE_COLOR = new Color(240, 150, 25);

    OutputWindow(Labs labs, OutputCollection outputCollection, Actions actions) {
        this.fLabs = labs;
        this.fOutputCollection = outputCollection;
        this.setFocusable(false);
        this.fTitleBar = new TitleBar();
        this.add((Component)((Object)this.fTitleBar));
        this.fTextPane = new OutputTextPane(this, actions);
        this.fTextPane.removeContextMenu();
        this.addMouseListener(this.fLocalMouseListener);
        this.fTextPane.addMouseListener(this.fLocalMouseListener);
        this.fScrollPane = new MJScrollPane((Component)((Object)this.fTextPane));
        this.fScrollPane.anchorToBottom();
        Border border = this.fScrollPane.getBorder();
        this.fScrollPane.setBorder(BorderFactory.createEmptyBorder());
        if (PlafUtils.isMetalLookAndFeel()) {
            this.setBorder(BorderFactory.createLineBorder(Color.blue));
        } else {
            this.setBorder(border);
        }
        this.add((Component)this.fScrollPane);
    }

    void addSourcesListener(SourcesListener sourcesListener) {
        if (this.fListeners == null) {
            this.fListeners = new ArrayList<SourcesListener>();
        }
        this.fListeners.add(sourcesListener);
    }

    void removeSourcesListener(SourcesListener sourcesListener) {
        if (this.fListeners != null) {
            this.fListeners.remove(sourcesListener);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.fTextPane != null) {
            this.fTextPane.setBackground(color);
        }
    }

    public void setForeground(Color color) {
        if (this.fTextPane != null) {
            this.fTextPane.setForeground(color);
        }
    }

    public void setFont(Font font) {
        if (this.fTextPane != null) {
            this.fTextPane.setFont(font);
        }
    }

    public boolean requestFocusInWindow() {
        return this.fTextPane.requestFocusInWindow();
    }

    void setSources(IntSet intSet) {
        if (intSet.equals(this.fSources)) {
            return;
        }
        this.fSources = new IntSet(intSet);
        Document document = this.fTextPane.getDocument();
        if (intSet.isEmpty()) {
            this.fTextPane.setDocument(new DefaultStyledDocument());
        } else {
            this.fTextPane.setDocument(this.fOutputCollection.createDocument(intSet));
        }
        this.fOutputCollection.destroyDocument(document);
        if (this.fListeners != null) {
            for (SourcesListener sourcesListener : this.fListeners) {
                sourcesListener.sourcesChanged(this);
            }
        }
    }

    IntSet getSources() {
        return this.fSources == null ? new IntSet() : new IntSet(this.fSources);
    }

    @Override
    public void setShowCommandText(boolean bl) {
        this.fTextPane.setShowCommandText(bl);
    }

    @Override
    public boolean isShowingCommandText() {
        return this.fTextPane.isShowingCommandText();
    }

    @Override
    public void showCorrespondingOutput(OutputCollection.CommandRecord commandRecord) {
        this.fTextPane.showCorrespondingOutput(commandRecord);
    }

    @Override
    public void clear() {
        this.fTextPane.clear();
    }

    @Override
    public void setKeyRedirector(KeyListener keyListener) {
        this.fTextPane.setKeyRedirector(keyListener);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    int getLeftInset() {
        return this.fTextPane.getLeftInset();
    }

    void setTitleBarVisible(boolean bl) {
        this.fTitleBar.setVisible(bl);
    }

    public void doLayout() {
        Insets insets = this.getInsets();
        int n = this.getWidth() - insets.left - insets.right;
        int n2 = this.getHeight() - insets.top - insets.bottom;
        int n3 = 0;
        if (this.fTitleBar.isVisible()) {
            n3 = this.fTitleBar.getPreferredSize().height;
            this.fTitleBar.setBounds(insets.left, insets.top, n, n3);
            n2 -= n3;
        }
        Dimension dimension = this.fTextPane.getPreferredSize();
        int n4 = dimension.height;
        if (n4 < n2) {
            Insets insets2 = this.fScrollPane.getBorder().getBorderInsets((Component)this.fScrollPane);
            JScrollBar jScrollBar = this.fScrollPane.getVerticalScrollBar();
            JScrollBar jScrollBar2 = this.fScrollPane.getHorizontalScrollBar();
            n4 += insets2.top + insets2.bottom;
            if (dimension.width + jScrollBar.getPreferredSize().width > n || PlatformInfo.isMacintosh()) {
                n4 += jScrollBar2.getPreferredSize().height;
            }
        }
        if (n4 < n2) {
            this.fScrollPane.setBounds(insets.left, this.getHeight() - insets.bottom - n4, n, n4);
        } else {
            this.fScrollPane.setBounds(insets.left, insets.top + n3, n, n2);
        }
    }

    class LocalMouseListener
    extends MouseAdapter {
        LocalMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            }
        }

        void showPopup(MouseEvent mouseEvent) {
            MJPopupMenu mJPopupMenu = new MJPopupMenu();
            mJPopupMenu.add(OutputWindow.this.fTextPane.getAction(Actions.Type.COPY));
            mJPopupMenu.add(OutputWindow.this.fTextPane.getAction(Actions.Type.SELECT_ALL));
            mJPopupMenu.add(OutputWindow.this.fTextPane.getAction(Actions.Type.CLEAR_OUTPUT));
            MenuContributor menuContributor = (MenuContributor)((Object)SwingUtilities.getAncestorOfClass(MenuContributor.class, mouseEvent.getComponent()));
            if (menuContributor != null) {
                menuContributor.contributeToMenu((JPopupMenu)mJPopupMenu, mouseEvent);
            }
            mJPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    class TitleBar
    extends MJPanel {
        TitleBar() {
            this.setLayout(new BoxLayout((Container)((Object)this), 0));
            this.add(Box.createHorizontalStrut(10));
            this.add((Component)((Object)new OutputSelector(OutputWindow.this.fLabs, OutputWindow.this)));
            this.add(Box.createHorizontalGlue());
        }

        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (!MJUtilities.isHighContrast()) {
                GradientPaint gradientPaint = new GradientPaint((int)((double)n * 0.1), 0.0f, LIGHT_TITLE_COLOR, (int)((double)n * 0.9), 0.0f, DARK_TITLE_COLOR, true);
                Paint paint = graphics2D.getPaint();
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRect(0, 0, n, n2);
                graphics2D.setPaint(paint);
            } else {
                graphics2D.setColor(this.getBackground());
                graphics2D.fillRect(0, 0, n, n2);
                graphics2D.setColor(ColorUtils.getBlackOrWhiteContrasting((Color)this.getBackground()));
                graphics2D.drawLine(0, n2 - 1, n - 1, n2 - 1);
            }
            this.paintComponents(graphics);
        }
    }

    static interface SourcesListener {
        public void sourcesChanged(OutputWindow var1);
    }
}

