/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.parallelui;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJStartup;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.toolbox.distcomp.parallelui.IntSet;
import com.mathworks.toolbox.distcomp.parallelui.LabsState;
import com.mathworks.toolbox.distcomp.parallelui.OutputCollection;
import com.mathworks.toolbox.distcomp.parallelui.OutputTextPane;
import com.mathworks.toolbox.distcomp.parallelui.ParallelCommandWindow;
import com.mathworks.toolbox.distcomp.parallelui.Prompt;
import com.mathworks.toolbox.distcomp.parallelui.SerialMatlab;
import com.mathworks.toolbox.distcomp.parallelui.SimulatedLabs;
import com.mathworks.toolbox.distcomp.pmode.Labs;
import com.mathworks.toolbox.distcomp.pmode.shared.LabsCompletionObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.ProcessInstance;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ResourceBundle;

public class ParallelUI {
    static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.parallelui.resources.RES_parallelui");
    private static Labs sLabs;
    private static LabsState sLabsState;
    private static OutputCollection sOutputCollection;
    private static LabsCompletionObserver sLabsObserver;
    private static boolean sStartedFromMain;
    private static boolean sIsPromptPadEnabled;
    private static boolean sIsTabCompletionEnabled;
    private static boolean sWasSerialHistoryShowing;
    static boolean sIsSerialMatlab;

    private ParallelUI() {
    }

    public static void start(final Labs labs) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ParallelUI.start(labs);
                }
            });
            return;
        }
        if (ParallelCommandWindow.getInstance() != null) {
            System.out.println(sRes.getString("error.AlreadyRunning"));
            return;
        }
        MJUtilities.initJIDE();
        sLabs = labs;
        if (sLabsState == null) {
            sLabsState = new LabsState(sLabs.getNumLabs());
        }
        if (sOutputCollection == null) {
            sOutputCollection = new OutputCollection(sLabs.getNumLabs());
            sOutputCollection.recallCommands();
            sOutputCollection.injectDateTimeRecord();
        }
        if (ParallelCommandWindow.getInstance() == null) {
            ParallelCommandWindow.createInstance(sLabs, sLabsState, sOutputCollection);
        }
        OutputTextPane.setLongestPrompt(Prompt.getLongestString(sLabs.getNumLabs()));
        if (sLabsObserver == null) {
            sLabsObserver = new LabsObserver();
        }
        if (sStartedFromMain) {
            Desktop desktop = new Desktop("Parallel UI Test", false);
            desktop.initMainFrame(false, false);
            desktop.addClient((Component)((Object)ParallelCommandWindow.getInstance()), "Parallel Command Window");
            desktop.addClient((Component)new MJPanel(), "Labs", true, DTLocation.create((String)"W"), false);
        } else {
            Desktop desktop = MatlabDesktopServices.getDesktop();
            DTLocation dTLocation = null;
            if (!desktop.hadClient("Parallel Command Window")) {
                Serializable serializable;
                if (sIsSerialMatlab && (serializable = desktop.getClient("Command Window")) != null) {
                    dTLocation = desktop.getClientLocation((Component)serializable);
                }
                if (dTLocation == null) {
                    if (desktop.hasMainFrame()) {
                        serializable = desktop.getMainFrame().getBounds();
                        ((Rectangle)serializable).grow(-50, -50);
                    } else {
                        serializable = WindowUtils.getScreenBounds();
                        ((Rectangle)serializable).grow((int)(-0.1 * (double)((Rectangle)serializable).width), (int)(-0.1 * (double)((Rectangle)serializable).height));
                    }
                    dTLocation = DTLocation.createExternal((int)((Rectangle)serializable).x, (int)((Rectangle)serializable).y, (int)((Rectangle)serializable).width, (int)((Rectangle)serializable).height);
                }
            }
            desktop.addClient((Component)((Object)ParallelCommandWindow.getInstance()), "Parallel Command Window", true, dTLocation, true, (DTClientListener)new DTClientAdapter(){

                public void clientClosed(DTClientEvent dTClientEvent) {
                    if (!(sLabs instanceof SimulatedLabs) && !(sLabs instanceof SerialMatlab)) {
                        new Matlab().evalConsoleOutput("pmode exit");
                    }
                    ParallelUI.stop();
                }
            });
            if (sIsSerialMatlab) {
                sWasSerialHistoryShowing = desktop.isClientShowing("Command History");
                desktop.closeClient("Command History");
            }
        }
    }

    public static void stop() {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ParallelUI.stop();
                }
            });
            return;
        }
        if (sOutputCollection != null) {
            sOutputCollection.saveCommands();
        }
        if (sLabs instanceof SimulatedLabs) {
            ((SimulatedLabs)sLabs).cleanup();
        } else if (sLabs instanceof SerialMatlab) {
            ((SerialMatlab)sLabs).cleanup();
            if (sWasSerialHistoryShowing) {
                MatlabDesktopServices.getDesktop().showClient("Command History");
            }
        }
        if (!sStartedFromMain && ParallelCommandWindow.getInstance() != null) {
            Desktop desktop = MatlabDesktopServices.getDesktop();
            desktop.removeClient((Component)((Object)ParallelCommandWindow.getInstance()));
            ParallelCommandWindow.cleanupInstance();
        }
        sLabs = null;
        sLabsState = null;
        sOutputCollection = null;
        sLabsObserver = null;
        sIsSerialMatlab = false;
        if (sStartedFromMain) {
            System.exit(0);
        }
    }

    public static void suspend() {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ParallelUI.suspend();
                }
            });
            return;
        }
        ParallelCommandWindow parallelCommandWindow = ParallelCommandWindow.getInstance();
        if (parallelCommandWindow != null) {
            parallelCommandWindow.suspend();
        }
    }

    public static void resume() {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ParallelUI.resume();
                }
            });
            return;
        }
        ParallelCommandWindow parallelCommandWindow = ParallelCommandWindow.getInstance();
        if (parallelCommandWindow != null) {
            parallelCommandWindow.resume();
        }
    }

    public static void startSimulation(int n) {
        SimulatedLabs simulatedLabs = new SimulatedLabs(n);
        if (sStartedFromMain) {
            simulatedLabs.showUI();
        }
        ParallelUI.start(simulatedLabs);
    }

    public static void stopSimulation() {
        if (sStartedFromMain && sLabs instanceof SimulatedLabs) {
            ((SimulatedLabs)sLabs).hideUI();
        }
        ParallelUI.stop();
    }

    public static void startSerial() {
        sIsSerialMatlab = true;
        ParallelUI.setTabCompletionEnabled(true);
        ParallelUI.setPromptPadEnabled(true);
        ParallelUI.start(new SerialMatlab());
    }

    public static void setTabCompletionEnabled(boolean bl) {
        sIsTabCompletionEnabled = bl;
    }

    public static boolean isTabCompletionEnabled() {
        return sIsTabCompletionEnabled;
    }

    public static void setPromptPadEnabled(boolean bl) {
        sIsPromptPadEnabled = bl;
    }

    public static boolean isPromptPadEnabled() {
        return sIsPromptPadEnabled;
    }

    public static void setState(final int n, final LabsState.State state, final String string) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ParallelUI.setState(n, state, string);
                }
            });
            return;
        }
        sLabsState.setState(n, state, string);
    }

    public static void addOutput(int n, char[] cArray, int n2, int n3, boolean bl) {
        if (sOutputCollection == null) {
            return;
        }
        sOutputCollection.addOutput(n, cArray, n2, n3, bl);
    }

    public static void recordError(int n) {
        if (sOutputCollection == null) {
            return;
        }
        sOutputCollection.recordError(n);
    }

    public static void clearOutput(int n) {
        if (sOutputCollection == null) {
            return;
        }
        sOutputCollection.clearOutput(n);
    }

    public static void clearOutput() {
        if (sOutputCollection == null) {
            return;
        }
        sOutputCollection.clearSession();
    }

    static LabsCompletionObserver getObserver() {
        return sLabsObserver;
    }

    static void setBusy(IntSet intSet) {
        for (Integer n : intSet) {
            ParallelUI.setState(n, LabsState.State.BUSY, null);
        }
    }

    public static void main(String[] stringArray) {
        MJStartup.init();
        int n = 4;
        if (stringArray.length > 0) {
            n = Integer.parseInt(stringArray[0]);
        }
        sStartedFromMain = true;
        ParallelUI.startSimulation(n);
    }

    static {
        sLabsState = null;
        sOutputCollection = null;
        sLabsObserver = null;
        sStartedFromMain = false;
        sIsPromptPadEnabled = false;
        sIsTabCompletionEnabled = false;
    }

    private static class LabsObserver
    implements LabsCompletionObserver {
        private LabsObserver() {
        }

        @Override
        public void handleOutput(String string, ProcessInstance processInstance) {
            boolean bl = false;
            int n = string.indexOf("???");
            if (n >= 0) {
                int n2;
                bl = true;
                char[] cArray = new char[n];
                int n3 = 0;
                for (n2 = 0; n2 < n; ++n2) {
                    char c = string.charAt(n2);
                    if (c == '\b') {
                        if (n3 <= 0) continue;
                        --n3;
                        continue;
                    }
                    cArray[n3++] = c;
                }
                for (n2 = 0; bl && n2 < n3; ++n2) {
                    bl = Character.isWhitespace(cArray[n2]);
                }
            }
            ParallelUI.addOutput(processInstance.getLabIndex(), string.toCharArray(), 0, string.length(), bl);
        }

        @Override
        public void handleExecStatus(int n, ProcessInstance processInstance) {
            int n2 = Matlab.getCodeBlockStatus((int)n);
            int n3 = Matlab.getExecutionStatus((int)n);
            int n4 = processInstance.getLabIndex();
            sOutputCollection.outputDone(n4);
            if (n2 == 0) {
                int n5 = Matlab.getInputRequester((int)n);
                if (n5 == Matlab.DEBUG_PROMPT) {
                    ParallelUI.setState(n4, LabsState.State.STOPPED, null);
                } else {
                    ParallelUI.setState(n4, LabsState.State.IDLE, null);
                }
            }
            if (n3 == 1 || n3 == 2) {
                ParallelUI.recordError(n4);
            }
        }
    }
}

