/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.DependencyCommandResult;
import com.mathworks.toolbox.distcomp.pmode.DependencyElementInfo;
import com.mathworks.toolbox.distcomp.pmode.FileTransferObserver;
import com.mathworks.toolbox.distcomp.pmode.NewDirectoryDependencyCommand;
import com.mathworks.toolbox.distcomp.pmode.NewFileDependencyCommand;
import com.mathworks.toolbox.distcomp.pmode.UnknownDependencyException;
import com.mathworks.toolbox.distcomp.pmode.UpdateFileDependencyCommand;
import com.mathworks.toolbox.distcomp.pmode.shared.OutputGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionService;
import com.mathworks.toolbox.distcomp.util.FileUtils;
import com.mathworks.util.NativeJava;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class FileDependenciesAssistant {
    private final OutputGroup fComms;
    public final ConcurrentMap<File, DependencyElementInfo> fFileDependencyMap;
    private File fDependencyDir;
    private boolean fDependencyDirSet;
    public long fLastCheckTime;

    FileDependenciesAssistant(SessionService sessionService, OutputGroup outputGroup) {
        this.fComms = outputGroup;
        this.fFileDependencyMap = new ConcurrentHashMap<File, DependencyElementInfo>();
        this.fDependencyDirSet = false;
        this.fLastCheckTime = System.currentTimeMillis() / 1000L;
    }

    public FileTransferObserver fileChanged(String string, String string2, String string3) throws IOException {
        File file = new File(string2);
        File file2 = file.isAbsolute() ? file : new File(string, file.getPath());
        return this.fileChanged(file2, file, new File(string3));
    }

    public FileTransferObserver fileChanged(File file, File file2, File file3) throws IOException {
        assert (file != null && file2 != null && file3 != null) : "No null inputs accepted";
        assert (file.isAbsolute()) : "absFile input MUST be absolute";
        FileTransferObserver fileTransferObserver = new FileTransferObserver(file, this.fComms.getNumDestinations());
        UpdateFileDependencyCommand updateFileDependencyCommand = new UpdateFileDependencyCommand(fileTransferObserver.byteBufferHandle, file2, file3);
        this.fComms.sendToAll(updateFileDependencyCommand, fileTransferObserver);
        return fileTransferObserver;
    }

    public FileTransferObserver addNewFileDependency(String string, String string2) throws IOException {
        return this.addNewFileDependency(string, new File(string2));
    }

    public FileTransferObserver addNewFileDependency(String string, File file) throws IOException {
        assert (!file.isDirectory()) : "Use this command to add new files";
        NewTransferObserver newTransferObserver = new NewTransferObserver(file, string, file, this.fComms.getNumDestinations());
        NewFileDependencyCommand newFileDependencyCommand = new NewFileDependencyCommand(newTransferObserver.byteBufferHandle, file);
        this.fComms.sendToAll(newFileDependencyCommand, newTransferObserver);
        return newTransferObserver;
    }

    public FileTransferObserver addNewDirectoryDependency(String string, String string2, String string3) throws IOException {
        return this.addNewDirectoryDependency(new File(string), string2, new File(string3));
    }

    public FileTransferObserver addNewDirectoryDependency(File file, String string, File file2) throws IOException {
        assert (!file.isDirectory()) : "This command expects to receive a zip file";
        assert (file2.isDirectory()) : "This command expects to receive a directory as a dependency";
        NewTransferObserver newTransferObserver = new NewTransferObserver(file, string, file2, this.fComms.getNumDestinations());
        NewDirectoryDependencyCommand newDirectoryDependencyCommand = new NewDirectoryDependencyCommand(newTransferObserver.byteBufferHandle, file2);
        this.fComms.sendToAll(newDirectoryDependencyCommand, newTransferObserver);
        return newTransferObserver;
    }

    public List<FileTransferObserver> sendChangedFiles(Map<File, List<File>> map) throws IOException {
        LinkedList<FileTransferObserver> linkedList = new LinkedList<FileTransferObserver>();
        for (Map.Entry<File, List<File>> entry : map.entrySet()) {
            File file = entry.getKey();
            int n = ((DependencyElementInfo)this.fFileDependencyMap.get(file)).getFile().getPath().length();
            for (File file2 : entry.getValue()) {
                File file3 = new File(file, file2.getPath().substring(n));
                linkedList.add(this.fileChanged(file2, file3, file));
            }
        }
        return linkedList;
    }

    public Map<File, List<File>> findChangedFiles() {
        HashMap<File, List<File>> hashMap = new HashMap<File, List<File>>();
        for (Map.Entry entry : this.fFileDependencyMap.entrySet()) {
            LinkedList<File> linkedList = new LinkedList<File>();
            this.putChangedFilesInList(((DependencyElementInfo)entry.getValue()).getFile(), linkedList);
            if (linkedList.isEmpty()) continue;
            hashMap.put((File)entry.getKey(), (List<File>)linkedList);
        }
        return hashMap;
    }

    private void putChangedFilesInList(File file, List<File> list) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.putChangedFilesInList(file2, list);
            }
        } else {
            NativeJava.StatEntry statEntry = NativeJava.getStat((String)file.getPath());
            if (statEntry == null) {
                return;
            }
            if (statEntry.st_ctime >= this.fLastCheckTime || statEntry.st_mtime >= this.fLastCheckTime) {
                list.add(file);
            }
        }
    }

    public synchronized boolean addClientDependency(String string, String string2) {
        return this.addClientDependency(string, new File(string2));
    }

    public synchronized boolean addClientDependency(String string, File file) {
        return this.addClientDependency(string, file, file);
    }

    public synchronized boolean addClientDependency(String string, File file, File file2) {
        return this.fFileDependencyMap.putIfAbsent(file, new DependencyElementInfo(string, file2)) == null;
    }

    public synchronized boolean addClientDependency(File file, File file2) {
        return this.fFileDependencyMap.putIfAbsent(file, new DependencyElementInfo(file2)) == null;
    }

    public synchronized boolean addDependency(String string, String string2) {
        return this.addDependency(new File(string), new File(string2));
    }

    public synchronized boolean addDependency(File file, File file2) {
        return this.fFileDependencyMap.putIfAbsent(file, new DependencyElementInfo(file2)) == null;
    }

    public synchronized boolean removeFileDependency(File file) {
        return this.fFileDependencyMap.remove(file) != null;
    }

    public synchronized void setDependencyDir(String string) {
        this.setDependencyDir(new File(string));
    }

    public synchronized void setDependencyDir(File file) {
        assert (!this.fDependencyDirSet) : "The DependencyDir on the assistant can only be set once";
        assert (file.isAbsolute()) : "The DependencyDir must be an absolute directory on the local machine";
        assert (this.fFileDependencyMap.isEmpty()) : "You cannot change the dependency dir after entries have been made in the map";
        this.fDependencyDir = file;
        this.fDependencyDirSet = true;
    }

    public synchronized File getDependencyDir() {
        return this.fDependencyDir;
    }

    public synchronized boolean dependencyExists(File file) {
        return this.fFileDependencyMap.containsKey(file);
    }

    public synchronized File getLocalFileFromRemoteFile(File file, File file2) throws IOException {
        File file3;
        assert (this.fDependencyDirSet) : "Unable to deduce a local file if I don't know my own dependency directory";
        assert (file != null) : "Remote file is null";
        assert (file.getPath().startsWith(file2.getPath())) : "Remote file MUST begin with the same string as provided to find it in dependency list";
        DependencyElementInfo dependencyElementInfo = (DependencyElementInfo)this.fFileDependencyMap.get(file2);
        if (dependencyElementInfo == null) {
            throw new UnknownDependencyException("Unable to find dependency in MAP");
        }
        if (dependencyElementInfo.isDirectory()) {
            String string = file.getPath().substring(file2.getPath().length());
            file3 = new File(dependencyElementInfo.getFile(), FileUtils.convertToLocalSeparators(string));
        } else {
            file3 = dependencyElementInfo.getFile();
        }
        return file3;
    }

    private class NewTransferObserver
    extends FileTransferObserver {
        File fDependency;
        File fAbsFile;

        NewTransferObserver(File file, String string, File file2, int n) throws IOException {
            super(file, n);
            this.fDependency = file2;
            this.fAbsFile = this.fDependency.isAbsolute() ? this.fDependency : new File(string, this.fDependency.getPath());
        }

        @Override
        protected void onAllComplete() {
            super.onAllComplete();
            for (DependencyCommandResult dependencyCommandResult : this.getReturnMessages()) {
                if (dependencyCommandResult.commandCompletedSucessfully()) continue;
                return;
            }
            FileDependenciesAssistant.this.addClientDependency(this.fDependency, this.fAbsFile);
        }

        @Override
        public File getFile() {
            return this.fDependency;
        }
    }
}

