/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.DependencyCommandResult;
import com.mathworks.toolbox.distcomp.pmode.MultipleFinalReturnMessageObserver;
import com.mathworks.toolbox.distcomp.pmode.TransferInProgressException;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.util.ByteBufferHandle;
import com.mathworks.toolbox.distcomp.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class FileTransferObserver
extends MultipleFinalReturnMessageObserver<DependencyCommandResult> {
    final ByteBufferHandle byteBufferHandle;
    private final FileInputStream fis;
    private final File fFile;

    FileTransferObserver(File file, int n) throws IOException {
        super(DependencyCommandResult.class, n);
        this.fFile = file;
        this.fis = new FileInputStream(file);
        try {
            int n2;
            long l;
            FileChannel fileChannel = this.fis.getChannel();
            this.byteBufferHandle = ByteBufferHandle.allocateDirect((int)l);
            ByteBuffer byteBuffer = this.byteBufferHandle.get();
            for (l = fileChannel.size(); l > 0L; l -= (long)n2) {
                n2 = fileChannel.read(byteBuffer);
                if (n2 >= 0) continue;
                throw new IOException("End Of Stream reached whilst copying the file channel to local buffer");
            }
            byteBuffer.position(0);
            fileChannel.close();
            this.fis.close();
        }
        catch (IOException iOException) {
            this.fis.close();
            throw iOException;
        }
    }

    @Override
    protected void onAllComplete() {
        this.byteBufferHandle.free();
    }

    public Collection<Throwable> getTransferErrors() throws TransferInProgressException {
        if (!this.allMessagesReceived()) {
            throw new TransferInProgressException();
        }
        LinkedList<Throwable> linkedList = new LinkedList<Throwable>();
        for (DependencyCommandResult dependencyCommandResult : this.getReturnMessages()) {
            if (dependencyCommandResult.commandCompletedSucessfully()) continue;
            linkedList.add(dependencyCommandResult.getException());
        }
        return linkedList;
    }

    public Collection<Pair<Instance, Throwable>> getSourceAndTransferErrors() throws TransferInProgressException {
        if (!this.allMessagesReceived()) {
            throw new TransferInProgressException();
        }
        LinkedList<Pair<Instance, Throwable>> linkedList = new LinkedList<Pair<Instance, Throwable>>();
        for (Map.Entry entry : this.getSourcesAndReturnMessages()) {
            DependencyCommandResult dependencyCommandResult = (DependencyCommandResult)entry.getValue();
            if (dependencyCommandResult.commandCompletedSucessfully()) continue;
            linkedList.add(new Pair<Instance, Throwable>(entry.getKey(), dependencyCommandResult.getException()));
        }
        return linkedList;
    }

    public static boolean waitForCompletionOfObserverList(Collection<FileTransferObserver> collection, Collection<FileTransferObserver> collection2, long l, TimeUnit timeUnit) {
        assert (l >= 0L) : "Wait time must be positive.";
        long l2 = timeUnit.toMillis(l);
        long l3 = System.currentTimeMillis();
        long l4 = 0L;
        Iterator<FileTransferObserver> iterator = collection.iterator();
        while (iterator.hasNext()) {
            long l5;
            FileTransferObserver fileTransferObserver = iterator.next();
            long l6 = l5 = l4 < l2 ? l2 - l4 : 0L;
            if (fileTransferObserver.await(l5, TimeUnit.MILLISECONDS)) {
                collection2.add(fileTransferObserver);
                iterator.remove();
                l4 = System.currentTimeMillis() - l3;
                continue;
            }
            return false;
        }
        return true;
    }

    public File getFile() {
        return this.fFile;
    }
}

