/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.CmdExecResults;
import com.mathworks.toolbox.distcomp.pmode.CmdWinOutput;
import com.mathworks.toolbox.distcomp.pmode.LabsStateTracker;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.RemoteResultsHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.LabsCompletionObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionService;
import com.mathworks.toolbox.distcomp.util.Executor;

class RemoteResultsHandlerImpl
implements RemoteResultsHandler {
    private Executor fListenerExec;
    private ErrorHandler fErrorHandler;
    private final LabsStateTracker fLabsStateTracker;
    private long fSequenceNumber;
    private LabsCompletionObserver fCmdObserver;

    public RemoteResultsHandlerImpl(SessionService sessionService, LabsStateTracker labsStateTracker) {
        this.fListenerExec = sessionService.getListenerExecutor();
        this.fLabsStateTracker = labsStateTracker;
        this.fErrorHandler = sessionService.getErrorHandler();
        this.fSequenceNumber = -1L;
        this.fCmdObserver = null;
    }

    @Override
    public synchronized void handleOutput(final CmdWinOutput cmdWinOutput, final ProcessInstance processInstance) {
        assert (cmdWinOutput != null) : "Command window output object must not be null.";
        final LabsCompletionObserver labsCompletionObserver = this.getObserver(cmdWinOutput.getOriginalSequenceNumber());
        try {
            this.fListenerExec.execute(new Runnable(){

                @Override
                public void run() {
                    PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Command " + cmdWinOutput.getOriginalSequenceNumber() + " on lab " + processInstance + " returned the output:\n" + cmdWinOutput.toString());
                    if (labsCompletionObserver != null && cmdWinOutput.fWinOutput != null) {
                        for (int i = 0; i < cmdWinOutput.fWinOutput.length; ++i) {
                            try {
                                labsCompletionObserver.handleOutput(cmdWinOutput.fWinOutput[i], processInstance);
                                continue;
                            }
                            catch (Throwable throwable) {
                                PackageInfo.LOGGER.log(DistcompLevel.ONE, "LabsCompletionObserver threw a Throwable.", throwable);
                            }
                        }
                    }
                    RemoteResultsHandlerImpl.this.fLabsStateTracker.outputArrived(cmdWinOutput.getOriginalSequenceNumber(), processInstance);
                }
            });
        }
        catch (Executor.ExecutorDestroyedException executorDestroyedException) {
            this.fErrorHandler.executorError(executorDestroyedException);
        }
    }

    @Override
    public synchronized void handleExecStatus(CmdExecResults cmdExecResults, final ProcessInstance processInstance) {
        assert (cmdExecResults != null) : "Command exec results object must not be null.";
        final long l = cmdExecResults.getOriginalSequenceNumber();
        final LabsCompletionObserver labsCompletionObserver = this.getObserver(l);
        final int n = cmdExecResults.getRawStatus();
        try {
            this.fListenerExec.execute(new Runnable(){

                @Override
                public void run() {
                    PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Command " + l + " on lab " + processInstance + " finished with status:\n" + n);
                    if (labsCompletionObserver != null) {
                        try {
                            labsCompletionObserver.handleExecStatus(n, processInstance);
                        }
                        catch (Throwable throwable) {
                            PackageInfo.LOGGER.log(DistcompLevel.ONE, "LabsCompletionObserver threw a Throwable.", throwable);
                        }
                    }
                    RemoteResultsHandlerImpl.this.fLabsStateTracker.statusArrived(n, l, processInstance);
                }
            });
        }
        catch (Executor.ExecutorDestroyedException executorDestroyedException) {
            this.fErrorHandler.executorError(executorDestroyedException);
        }
    }

    @Override
    public synchronized void setCurrentCommand(long l, LabsCompletionObserver labsCompletionObserver) {
        this.fSequenceNumber = l;
        this.fCmdObserver = labsCompletionObserver;
    }

    private LabsCompletionObserver getObserver(long l) {
        if (this.fSequenceNumber == l) {
            return this.fCmdObserver;
        }
        return null;
    }
}

