/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.ResourceManager;
import com.mathworks.toolbox.distcomp.util.concurrent.Predicate;
import com.mathworks.toolbox.distcomp.util.concurrent.ReentrantLock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

class ResourceManagerImpl
implements ResourceManager {
    private Object fCurrentHolder = null;
    private boolean fTokenAcquired = false;
    private final Object fToken = new Object();
    private final ReentrantLock fLock = new ReentrantLock();
    private final Condition fTokenAvailable = this.fLock.newPredicateCondition(new Predicate(){

        @Override
        public boolean test() {
            return ResourceManagerImpl.this.isTokenAvailable();
        }
    });

    ResourceManagerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getCurrentHolder() {
        this.fLock.lock();
        try {
            Object object = this.fCurrentHolder;
            return object;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object acquireCurrentHolderToken(long l) throws InterruptedException {
        this.fLock.lock();
        try {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Waiting to acquire token to become the current holder (current is now: " + this.fCurrentHolder + ")");
            boolean bl = this.fTokenAvailable.await(l, TimeUnit.MILLISECONDS);
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Finished waiting to acquire token with result: " + bl);
            if (bl) {
                this.fTokenAcquired = true;
                Object object = this.fToken;
                return object;
            }
            Object var4_4 = null;
            return var4_4;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentHolder(Object object, Object object2) {
        this.fLock.lock();
        try {
            assert (this.fToken.equals(object2)) : "Token passed in is not equal to the current token object";
            assert (this.fTokenAcquired) : "Token is not currently acquired";
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Current holder set to " + object);
            this.fCurrentHolder = object;
            this.fTokenAcquired = false;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseCurrentHolder(Object object) {
        this.fLock.lock();
        try {
            assert (this.fCurrentHolder != null && this.fCurrentHolder.equals(object) && !this.fTokenAcquired) : "ReleaseCurrentHolder called by another object : " + object;
            this.fCurrentHolder = null;
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Releasing the current holder token");
            this.fTokenAvailable.signal();
        }
        finally {
            this.fLock.unlock();
        }
    }

    private boolean isTokenAvailable() {
        return this.fCurrentHolder == null && !this.fTokenAcquired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this.fLock.lock();
        try {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "RESET called");
            this.fCurrentHolder = null;
            this.fTokenAcquired = false;
            this.fTokenAvailable.signalAll();
        }
        finally {
            this.fLock.unlock();
        }
    }
}

