/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io.broker;

import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokerCompletedRequestReply;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokerMessage;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokerRegisteredAcceptorReply;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredConnectInfoRequest;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredConnectPortReply;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredConnectPortRequest;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredConnectReadyToAcceptMessage;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredConnectReadyToAcceptReply;
import com.mathworks.toolbox.distcomp.pmode.io.broker.Log;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerDispatcher;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnGroup;
import com.mathworks.toolbox.distcomp.util.concurrent.ReentrantLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;

public final class BrokerConnectInfoDispatcher
implements PeerDispatcher<BrokerMessage> {
    private final Lock fLock = new ReentrantLock();
    private ReturnGroup fReturnGroup = null;
    private final Map<UUID, AcceptorRequestRecord> fGroupUuidToRequestRecord = new HashMap<UUID, AcceptorRequestRecord>();
    private final Map<UUID, List<PortRequestRecord>> fConnectorGroupIdsToPortRequestRecords = new HashMap<UUID, List<PortRequestRecord>>();
    private final Map<UUID, UUID> fBrokerPeerIdsToPortRequestGroupIds = new HashMap<UUID, UUID>();
    private static final int EXPECTED_WORKERS_PER_MACHINE = 8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initReturnGroup(ReturnGroup returnGroup) {
        this.fLock.lock();
        try {
            assert (this.fReturnGroup == null) : "fReturnGroup already set.";
            this.fReturnGroup = returnGroup;
        }
        finally {
            this.fLock.unlock();
        }
        Log.LOGGER.finest("BrokerConnectInfoDispatcher returnGroup initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReturnGroup getReturnGroup() {
        this.fLock.lock();
        try {
            ReturnGroup returnGroup = this.fReturnGroup;
            return returnGroup;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AcceptorRequestRecord putInfoRequest(BrokeredConnectInfoRequest brokeredConnectInfoRequest, Instance instance) {
        AcceptorRequestRecord acceptorRequestRecord = new AcceptorRequestRecord(brokeredConnectInfoRequest, instance);
        this.fLock.lock();
        try {
            AcceptorRequestRecord acceptorRequestRecord2 = this.fGroupUuidToRequestRecord.put(brokeredConnectInfoRequest.getGroupUuid(), acceptorRequestRecord);
            return acceptorRequestRecord2;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AcceptorRequestRecord getClientRecord(UUID uUID) {
        this.fLock.lock();
        try {
            AcceptorRequestRecord acceptorRequestRecord = this.fGroupUuidToRequestRecord.get(uUID);
            return acceptorRequestRecord;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AcceptorRequestRecord removeClientRecord(UUID uUID) {
        this.fLock.lock();
        try {
            AcceptorRequestRecord acceptorRequestRecord = this.fGroupUuidToRequestRecord.remove(uUID);
            return acceptorRequestRecord;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UUID findGroupUuidForInstance(Instance instance) {
        this.fLock.lock();
        try {
            for (UUID uUID : this.fGroupUuidToRequestRecord.keySet()) {
                AcceptorRequestRecord acceptorRequestRecord = this.fGroupUuidToRequestRecord.get(uUID);
                if (!instance.equals(acceptorRequestRecord.getInstance())) continue;
                UUID uUID2 = uUID;
                return uUID2;
            }
            Iterator<UUID> iterator = null;
            return iterator;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeGroupOfPeerFromPortRequests(UUID uUID) {
        this.fLock.lock();
        try {
            UUID uUID2 = this.fBrokerPeerIdsToPortRequestGroupIds.remove(uUID);
            if (uUID2 != null) {
                List<PortRequestRecord> list = this.fConnectorGroupIdsToPortRequestRecords.remove(uUID2);
                Log.LOGGER.finest("Removed port request records associated with " + uUID2 + " because peer " + uUID + " disconnected after this collected " + list.size() + " records.");
            }
            this.sendPortRepliesIfComplete();
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInstance(Instance instance) {
        this.fLock.lock();
        try {
            UUID uUID = this.findGroupUuidForInstance(instance);
            this.removeClientRecord(uUID);
            this.removeGroupOfPeerFromPortRequests(instance.getUuid());
        }
        finally {
            this.fLock.unlock();
        }
    }

    private void dispatchBrokeredConnectInfoRequest(BrokeredConnectInfoRequest brokeredConnectInfoRequest, Instance instance) {
        this.putInfoRequest(brokeredConnectInfoRequest, instance);
        Log.LOGGER.finest("BrokerConnectInfoDispatcher received and registered " + brokeredConnectInfoRequest);
        BrokerRegisteredAcceptorReply brokerRegisteredAcceptorReply = new BrokerRegisteredAcceptorReply(brokeredConnectInfoRequest.getGroupUuid(), brokeredConnectInfoRequest.getSequenceNumber());
        this.getReturnGroup().returnTo(instance, brokerRegisteredAcceptorReply);
        Log.LOGGER.finest("BrokerConnectInfoDispatcher acknowledged " + brokeredConnectInfoRequest);
    }

    private void dispatchBrokeredConnectReadyToAcceptMessage(BrokeredConnectReadyToAcceptMessage brokeredConnectReadyToAcceptMessage) {
        UUID uUID = brokeredConnectReadyToAcceptMessage.getGroupUuid();
        AcceptorRequestRecord acceptorRequestRecord = this.getClientRecord(uUID);
        if (null != acceptorRequestRecord) {
            BrokeredConnectReadyToAcceptReply brokeredConnectReadyToAcceptReply = new BrokeredConnectReadyToAcceptReply(brokeredConnectReadyToAcceptMessage, acceptorRequestRecord.getSequenceNumber());
            this.getReturnGroup().returnTo(acceptorRequestRecord.getInstance(), brokeredConnectReadyToAcceptReply);
            Log.LOGGER.fine("BrokerConnectInfoDispatcher forwarded " + brokeredConnectReadyToAcceptReply + " to " + acceptorRequestRecord);
            int n = acceptorRequestRecord.incrementAndGetLabsSent();
            if (n == brokeredConnectReadyToAcceptMessage.getNumberOfLabs()) {
                BrokerCompletedRequestReply brokerCompletedRequestReply = new BrokerCompletedRequestReply(uUID, acceptorRequestRecord.getSequenceNumber());
                this.getReturnGroup().returnTo(acceptorRequestRecord.getInstance(), brokerCompletedRequestReply);
                this.removeClientRecord(uUID);
                Log.LOGGER.fine("BrokerConnectInfoDispatcher sent " + brokerCompletedRequestReply + " and removed " + acceptorRequestRecord);
            }
        } else {
            Log.LOGGER.fine("fGroupUuidToRequestRecord does not contain a record for " + uUID + " . It contains records for " + this.fGroupUuidToRequestRecord.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean arePortRequestsComplete() {
        this.fLock.lock();
        try {
            for (List<PortRequestRecord> list : this.fConnectorGroupIdsToPortRequestRecords.values()) {
                int n = list.get(0).getBrokeredConnectPortRequest().getExpectedRequestCount();
                Log.LOGGER.finest("BrokerConnectInfoDispatcher has heard from " + list.size() + " of " + n + " for " + list.get(0).getBrokeredConnectPortRequest());
                if (n == list.size()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<PortRequestRecord>> createHostnamesToBrokeredConnectPortRequests() {
        this.fLock.lock();
        try {
            HashMap<String, ArrayList<PortRequestRecord>> hashMap = new HashMap<String, ArrayList<PortRequestRecord>>();
            for (List<PortRequestRecord> list : this.fConnectorGroupIdsToPortRequestRecords.values()) {
                for (PortRequestRecord portRequestRecord : list) {
                    String string = portRequestRecord.getBrokeredConnectPortRequest().getHostname();
                    ArrayList<PortRequestRecord> arrayList = (ArrayList<PortRequestRecord>)hashMap.get(string);
                    if (arrayList == null) {
                        arrayList = new ArrayList<PortRequestRecord>(8);
                        hashMap.put(string, arrayList);
                    }
                    arrayList.add(portRequestRecord);
                }
            }
            Log.LOGGER.finest("BrokerConnectInfoDispatcher has sorted connectors by hostname. " + hashMap);
            HashMap<String, ArrayList<PortRequestRecord>> hashMap2 = hashMap;
            return hashMap2;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPortReplies(Map<String, List<PortRequestRecord>> map) {
        this.fLock.lock();
        try {
            for (List<PortRequestRecord> list : map.values()) {
                int n = list.size();
                for (int i = 0; i < list.size(); ++i) {
                    PortRequestRecord portRequestRecord = list.get(i);
                    BrokeredConnectPortReply brokeredConnectPortReply = new BrokeredConnectPortReply(portRequestRecord.getBrokeredConnectPortRequest(), i, n);
                    Log.LOGGER.finest("BrokerConnectInfoDispatcher sending " + brokeredConnectPortReply);
                    this.getReturnGroup().returnTo(portRequestRecord.getInstance(), brokeredConnectPortReply);
                }
            }
            this.fConnectorGroupIdsToPortRequestRecords.clear();
            this.fBrokerPeerIdsToPortRequestGroupIds.clear();
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPortRepliesIfComplete() {
        this.fLock.lock();
        try {
            if (this.arePortRequestsComplete()) {
                Log.LOGGER.finest("BrokerConnectInfoDispatcher has heard from all expected connectors from all " + this.fConnectorGroupIdsToPortRequestRecords.size() + " known groups.");
                Map<String, List<PortRequestRecord>> map = this.createHostnamesToBrokeredConnectPortRequests();
                this.sendPortReplies(map);
            } else {
                Log.LOGGER.finest("BrokerConnectInfoDispatcher is waiting on port requests for " + this.fConnectorGroupIdsToPortRequestRecords.size() + " groups.");
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchBrokeredConnectPortRequest(BrokeredConnectPortRequest brokeredConnectPortRequest, Instance instance) {
        this.fLock.lock();
        try {
            UUID uUID = brokeredConnectPortRequest.getGroupUuid();
            List<PortRequestRecord> list = this.fConnectorGroupIdsToPortRequestRecords.get(uUID);
            if (list == null) {
                list = new ArrayList<PortRequestRecord>(brokeredConnectPortRequest.getExpectedRequestCount());
                this.fConnectorGroupIdsToPortRequestRecords.put(uUID, list);
            }
            list.add(new PortRequestRecord(brokeredConnectPortRequest, instance));
            this.fBrokerPeerIdsToPortRequestGroupIds.put(instance.getUuid(), brokeredConnectPortRequest.getGroupUuid());
            this.sendPortRepliesIfComplete();
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public void dispatch(BrokerMessage brokerMessage, Instance instance) {
        Log.LOGGER.finer("BrokerConnectInfoDispatcher received " + brokerMessage + " from " + instance);
        if (brokerMessage instanceof BrokeredConnectInfoRequest) {
            BrokeredConnectInfoRequest brokeredConnectInfoRequest = (BrokeredConnectInfoRequest)brokerMessage;
            this.dispatchBrokeredConnectInfoRequest(brokeredConnectInfoRequest, instance);
        } else if (brokerMessage instanceof BrokeredConnectReadyToAcceptMessage) {
            BrokeredConnectReadyToAcceptMessage brokeredConnectReadyToAcceptMessage = (BrokeredConnectReadyToAcceptMessage)brokerMessage;
            this.dispatchBrokeredConnectReadyToAcceptMessage(brokeredConnectReadyToAcceptMessage);
        } else if (brokerMessage instanceof BrokeredConnectPortRequest) {
            BrokeredConnectPortRequest brokeredConnectPortRequest = (BrokeredConnectPortRequest)brokerMessage;
            this.dispatchBrokeredConnectPortRequest(brokeredConnectPortRequest, instance);
        } else {
            Log.LOGGER.warning("BrokerConnectInfoDispatcher does not understand messages of type " + brokerMessage.getClass() + " and received a " + brokerMessage);
        }
    }

    private static final class PortRequestRecord {
        private final BrokeredConnectPortRequest fBrokeredConnectPortRequest;
        private final Instance fInstance;

        private PortRequestRecord(BrokeredConnectPortRequest brokeredConnectPortRequest, Instance instance) {
            this.fBrokeredConnectPortRequest = brokeredConnectPortRequest;
            this.fInstance = instance;
        }

        public BrokeredConnectPortRequest getBrokeredConnectPortRequest() {
            return this.fBrokeredConnectPortRequest;
        }

        public Instance getInstance() {
            return this.fInstance;
        }

        public String toString() {
            return "PortRequestRecord{fBrokeredConnectPortRequest=" + this.fBrokeredConnectPortRequest + ", fInstance=" + this.fInstance + '}';
        }
    }

    private static final class AcceptorRequestRecord {
        private final BrokeredConnectInfoRequest fBrokeredConnectInfoRequest;
        private final Instance fInstance;
        private final AtomicInteger fLabsSent = new AtomicInteger(0);

        private AcceptorRequestRecord(BrokeredConnectInfoRequest brokeredConnectInfoRequest, Instance instance) {
            this.fBrokeredConnectInfoRequest = brokeredConnectInfoRequest;
            this.fInstance = instance;
        }

        Instance getInstance() {
            return this.fInstance;
        }

        int incrementAndGetLabsSent() {
            return this.fLabsSent.incrementAndGet();
        }

        long getSequenceNumber() {
            return this.fBrokeredConnectInfoRequest.getSequenceNumber();
        }

        public String toString() {
            return "RequestRecord{fBrokeredConnectInfoRequest=" + this.fBrokeredConnectInfoRequest + ", fInstance=" + this.fInstance + ", fLabsSent=" + this.fLabsSent + '}';
        }
    }
}

